/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.net.driver.DefaultDriverProviderService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.openflow.controller.DefaultOpenFlowPacketContext;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.OpenFlowAgent;
import org.onosproject.openflow.controller.impl.Controller;
import org.osgi.service.component.ComponentContext;
import org.projectfloodlight.openflow.protocol.OFCalientFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.OFCalientFlowStatsReply;
import org.projectfloodlight.openflow.protocol.OFCircuitPortStatus;
import org.projectfloodlight.openflow.protocol.OFExperimenter;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.OFFlowStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupStatsEntry;
import org.projectfloodlight.openflow.protocol.OFGroupStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortStatsEntry;
import org.projectfloodlight.openflow.protocol.OFPortStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionApplyActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OpenFlowControllerImpl
implements OpenFlowController {
    private static final int DEFAULT_OFPORT = 6633;
    private static final int DEFAULT_WORKER_THREADS = 16;
    private static final Logger log = LoggerFactory.getLogger(OpenFlowControllerImpl.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DefaultDriverProviderService defaultDriverProviderService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Property(name="openflowPort", intValue={6633}, label="Port number used by OpenFlow protocol; default is 6633")
    private int openflowPort = 6633;
    @Property(name="workerThreads", intValue={16}, label="Number of controller worker threads; default is 16")
    private int workerThreads = 16;
    private final ExecutorService executorMsgs = Executors.newFixedThreadPool(32, Tools.groupedThreads((String)"onos/of", (String)"event-stats-%d"));
    private final ExecutorService executorBarrier = Executors.newFixedThreadPool(4, Tools.groupedThreads((String)"onos/of", (String)"event-barrier-%d"));
    protected ConcurrentHashMap<Dpid, OpenFlowSwitch> connectedSwitches = new ConcurrentHashMap();
    protected ConcurrentHashMap<Dpid, OpenFlowSwitch> activeMasterSwitches = new ConcurrentHashMap();
    protected ConcurrentHashMap<Dpid, OpenFlowSwitch> activeEqualSwitches = new ConcurrentHashMap();
    protected OpenFlowSwitchAgent agent = new OpenFlowSwitchAgent();
    protected Set<OpenFlowSwitchListener> ofSwitchListener = new CopyOnWriteArraySet<OpenFlowSwitchListener>();
    protected Multimap<Integer, PacketListener> ofPacketListener = ArrayListMultimap.create();
    protected Set<OpenFlowEventListener> ofEventListener = new CopyOnWriteArraySet<OpenFlowEventListener>();
    protected Multimap<Dpid, OFFlowStatsEntry> fullFlowStats = ArrayListMultimap.create();
    protected Multimap<Dpid, OFGroupStatsEntry> fullGroupStats = ArrayListMultimap.create();
    protected Multimap<Dpid, OFGroupDescStatsEntry> fullGroupDescStats = ArrayListMultimap.create();
    protected Multimap<Dpid, OFPortStatsEntry> fullPortStats = ArrayListMultimap.create();
    private final Controller ctrl = new Controller();

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(this.getClass());
        Map<String, String> properties = this.readComponentConfiguration(context);
        this.ctrl.setConfigParams(properties);
        this.ctrl.start(this.agent, this.driverService);
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.ctrl.stop();
    }

    private Map<String, String> readComponentConfiguration(ComponentContext context) {
        String thread;
        Dictionary properties = context.getProperties();
        HashMap<String, String> outProperties = new HashMap<String, String>();
        String port = Tools.get((Dictionary)properties, (String)"openflowPort");
        if (!Strings.isNullOrEmpty((String)port)) {
            outProperties.put("openflowport", port);
        }
        if (!Strings.isNullOrEmpty((String)(thread = Tools.get((Dictionary)properties, (String)"workerThreads")))) {
            outProperties.put("workerthreads", thread);
        }
        return outProperties;
    }

    @Modified
    public void modified(ComponentContext context) {
        Map<String, String> properties = this.readComponentConfiguration(context);
        this.ctrl.stop();
        this.ctrl.setConfigParams(properties);
        this.ctrl.start(this.agent, this.driverService);
    }

    public Iterable<OpenFlowSwitch> getSwitches() {
        return this.connectedSwitches.values();
    }

    public Iterable<OpenFlowSwitch> getMasterSwitches() {
        return this.activeMasterSwitches.values();
    }

    public Iterable<OpenFlowSwitch> getEqualSwitches() {
        return this.activeEqualSwitches.values();
    }

    public OpenFlowSwitch getSwitch(Dpid dpid) {
        return this.connectedSwitches.get(dpid);
    }

    public OpenFlowSwitch getMasterSwitch(Dpid dpid) {
        return this.activeMasterSwitches.get(dpid);
    }

    public OpenFlowSwitch getEqualSwitch(Dpid dpid) {
        return this.activeEqualSwitches.get(dpid);
    }

    public void addListener(OpenFlowSwitchListener listener) {
        if (!this.ofSwitchListener.contains(listener)) {
            this.ofSwitchListener.add(listener);
        }
    }

    public void removeListener(OpenFlowSwitchListener listener) {
        this.ofSwitchListener.remove(listener);
    }

    public void addPacketListener(int priority, PacketListener listener) {
        this.ofPacketListener.put((Object)priority, (Object)listener);
    }

    public void removePacketListener(PacketListener listener) {
        this.ofPacketListener.values().remove(listener);
    }

    public void addEventListener(OpenFlowEventListener listener) {
        this.ofEventListener.add(listener);
    }

    public void removeEventListener(OpenFlowEventListener listener) {
        this.ofEventListener.remove(listener);
    }

    public void write(Dpid dpid, OFMessage msg) {
        this.getSwitch(dpid).sendMsg(msg);
    }

    public void processPacket(Dpid dpid, OFMessage msg) {
        block0 : switch (msg.getType()) {
            case PORT_STATUS: {
                for (OpenFlowSwitchListener l : this.ofSwitchListener) {
                    l.portChanged(dpid, (OFPortStatus)msg);
                }
                break;
            }
            case FEATURES_REPLY: {
                for (OpenFlowSwitchListener l : this.ofSwitchListener) {
                    l.switchChanged(dpid);
                }
                break;
            }
            case PACKET_IN: {
                OpenFlowPacketContext pktCtx = DefaultOpenFlowPacketContext.packetContextFromPacketIn((OpenFlowSwitch)this.getSwitch(dpid), (OFPacketIn)((OFPacketIn)msg));
                for (PacketListener p : this.ofPacketListener.values()) {
                    p.handlePacket(pktCtx);
                }
                break;
            }
            case FLOW_REMOVED: 
            case ERROR: {
                this.executorMsgs.submit(new OFMessageHandler(dpid, msg));
                break;
            }
            case STATS_REPLY: {
                OFStatsReply reply = (OFStatsReply)msg;
                switch (reply.getStatsType()) {
                    case PORT_DESC: {
                        for (OpenFlowSwitchListener l : this.ofSwitchListener) {
                            l.switchChanged(dpid);
                        }
                        break block0;
                    }
                    case FLOW: {
                        Collection<OFFlowStatsEntry> flowStats = this.publishFlowStats(dpid, (OFFlowStatsReply)reply);
                        if (flowStats == null) break block0;
                        OFFlowStatsReply.Builder rep = OFFactories.getFactory((OFVersion)msg.getVersion()).buildFlowStatsReply();
                        rep.setEntries((List)Lists.newLinkedList(flowStats));
                        this.executorMsgs.submit(new OFMessageHandler(dpid, (OFMessage)rep.build()));
                        break;
                    }
                    case GROUP: {
                        Collection<OFGroupStatsEntry> groupStats = this.publishGroupStats(dpid, (OFGroupStatsReply)reply);
                        if (groupStats == null) break block0;
                        OFGroupStatsReply.Builder rep = OFFactories.getFactory((OFVersion)msg.getVersion()).buildGroupStatsReply();
                        rep.setEntries((List)Lists.newLinkedList(groupStats));
                        rep.setXid(reply.getXid());
                        this.executorMsgs.submit(new OFMessageHandler(dpid, (OFMessage)rep.build()));
                        break;
                    }
                    case GROUP_DESC: {
                        Collection<OFGroupDescStatsEntry> groupDescStats = this.publishGroupDescStats(dpid, (OFGroupDescStatsReply)reply);
                        if (groupDescStats == null) break block0;
                        OFGroupDescStatsReply.Builder rep = OFFactories.getFactory((OFVersion)msg.getVersion()).buildGroupDescStatsReply();
                        rep.setEntries((List)Lists.newLinkedList(groupDescStats));
                        rep.setXid(reply.getXid());
                        this.executorMsgs.submit(new OFMessageHandler(dpid, (OFMessage)rep.build()));
                        break;
                    }
                    case PORT: {
                        this.executorMsgs.submit(new OFMessageHandler(dpid, (OFMessage)reply));
                        break;
                    }
                    case METER: {
                        this.executorMsgs.submit(new OFMessageHandler(dpid, (OFMessage)reply));
                        break;
                    }
                    case EXPERIMENTER: {
                        if (reply instanceof OFCalientFlowStatsReply) {
                            OFFlowStatsReply.Builder fsr = this.getSwitch(dpid).factory().buildFlowStatsReply();
                            LinkedList<OFFlowStatsEntry> entries = new LinkedList<OFFlowStatsEntry>();
                            for (OFCalientFlowStatsEntry entry : ((OFCalientFlowStatsReply)msg).getEntries()) {
                                OFActionOutput action = OFFactories.getFactory((OFVersion)msg.getVersion()).actions().buildOutput().setPort(entry.getOutPort()).build();
                                OFInstructionApplyActions instruction = OFFactories.getFactory((OFVersion)msg.getVersion()).instructions().applyActions(Collections.singletonList(action));
                                OFFlowStatsEntry fs = this.getSwitch(dpid).factory().buildFlowStatsEntry().setMatch(entry.getMatch()).setTableId(entry.getTableId()).setDurationSec(entry.getDurationSec()).setDurationNsec(entry.getDurationNsec()).setPriority(entry.getPriority()).setIdleTimeout(entry.getIdleTimeout()).setHardTimeout(entry.getHardTimeout()).setFlags(entry.getFlags()).setCookie(entry.getCookie()).setInstructions(Collections.singletonList(instruction)).build();
                                entries.add(fs);
                            }
                            fsr.setEntries(entries);
                            Collection<OFFlowStatsEntry> flowStats = this.publishFlowStats(dpid, fsr.build());
                            if (flowStats == null) break block0;
                            OFFlowStatsReply.Builder rep = OFFactories.getFactory((OFVersion)msg.getVersion()).buildFlowStatsReply();
                            rep.setEntries((List)Lists.newLinkedList(flowStats));
                            this.executorMsgs.submit(new OFMessageHandler(dpid, (OFMessage)rep.build()));
                            break;
                        }
                        this.executorMsgs.submit(new OFMessageHandler(dpid, (OFMessage)reply));
                        break;
                    }
                    default: {
                        log.warn("Discarding unknown stats reply type {}", (Object)reply.getStatsType());
                        break;
                    }
                }
                break;
            }
            case BARRIER_REPLY: {
                this.executorBarrier.submit(new OFMessageHandler(dpid, msg));
                break;
            }
            case EXPERIMENTER: {
                long experimenter = ((OFExperimenter)msg).getExperimenter();
                if (experimenter == 7636849L) {
                    OFCircuitPortStatus circuitPortStatus = (OFCircuitPortStatus)msg;
                    OFPortStatus.Builder portStatus = this.getSwitch(dpid).factory().buildPortStatus();
                    OFPortDesc.Builder portDesc = this.getSwitch(dpid).factory().buildPortDesc();
                    portDesc.setPortNo(circuitPortStatus.getPortNo()).setHwAddr(circuitPortStatus.getHwAddr()).setName(circuitPortStatus.getName()).setConfig(circuitPortStatus.getConfig()).setState(circuitPortStatus.getState());
                    portStatus.setReason(circuitPortStatus.getReason()).setDesc(portDesc.build());
                    for (OpenFlowSwitchListener l : this.ofSwitchListener) {
                        l.portChanged(dpid, portStatus.build());
                    }
                    break;
                }
                log.warn("Handling experimenter type {} not yet implemented", (Object)((OFExperimenter)msg).getExperimenter(), (Object)msg);
                break;
            }
            default: {
                log.warn("Handling message type {} not yet implemented {}", (Object)msg.getType(), (Object)msg);
            }
        }
    }

    private synchronized Collection<OFFlowStatsEntry> publishFlowStats(Dpid dpid, OFFlowStatsReply reply) {
        this.fullFlowStats.putAll((Object)dpid, (Iterable)reply.getEntries());
        if (!reply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) {
            return this.fullFlowStats.removeAll((Object)dpid);
        }
        return null;
    }

    private synchronized Collection<OFGroupStatsEntry> publishGroupStats(Dpid dpid, OFGroupStatsReply reply) {
        this.fullGroupStats.putAll((Object)dpid, (Iterable)reply.getEntries());
        if (!reply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) {
            return this.fullGroupStats.removeAll((Object)dpid);
        }
        return null;
    }

    private synchronized Collection<OFGroupDescStatsEntry> publishGroupDescStats(Dpid dpid, OFGroupDescStatsReply reply) {
        this.fullGroupDescStats.putAll((Object)dpid, (Iterable)reply.getEntries());
        if (!reply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) {
            return this.fullGroupDescStats.removeAll((Object)dpid);
        }
        return null;
    }

    private synchronized Collection<OFPortStatsEntry> publishPortStats(Dpid dpid, OFPortStatsReply reply) {
        this.fullPortStats.putAll((Object)dpid, (Iterable)reply.getEntries());
        if (!reply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) {
            return this.fullPortStats.removeAll((Object)dpid);
        }
        return null;
    }

    public void setRole(Dpid dpid, RoleState role) {
        OpenFlowSwitch sw = this.getSwitch(dpid);
        if (sw == null) {
            log.debug("Switch not connected. Ignoring setRole({}, {})", (Object)dpid, (Object)role);
            return;
        }
        sw.setRole(role);
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindDefaultDriverProviderService(DefaultDriverProviderService defaultDriverProviderService) {
        this.defaultDriverProviderService = defaultDriverProviderService;
    }

    protected void unbindDefaultDriverProviderService(DefaultDriverProviderService defaultDriverProviderService) {
        if (this.defaultDriverProviderService == defaultDriverProviderService) {
            this.defaultDriverProviderService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private final class OFMessageHandler
    implements Runnable {
        private final OFMessage msg;
        private final Dpid dpid;

        public OFMessageHandler(Dpid dpid, OFMessage msg) {
            this.msg = msg;
            this.dpid = dpid;
        }

        @Override
        public void run() {
            for (OpenFlowEventListener listener : OpenFlowControllerImpl.this.ofEventListener) {
                listener.handleMessage(this.dpid, this.msg);
            }
        }
    }

    public class OpenFlowSwitchAgent
    implements OpenFlowAgent {
        private final Logger log = LoggerFactory.getLogger(OpenFlowSwitchAgent.class);
        private final Lock switchLock = new ReentrantLock();

        public boolean addConnectedSwitch(Dpid dpid, OpenFlowSwitch sw) {
            if (OpenFlowControllerImpl.this.connectedSwitches.get(dpid) != null) {
                this.log.error("Trying to add connectedSwitch but found a previous value for dpid: {}", (Object)dpid);
                return false;
            }
            this.log.info("Added switch {}", (Object)dpid);
            OpenFlowControllerImpl.this.connectedSwitches.put(dpid, sw);
            for (OpenFlowSwitchListener l : OpenFlowControllerImpl.this.ofSwitchListener) {
                l.switchAdded(dpid);
            }
            return true;
        }

        public boolean validActivation(Dpid dpid) {
            if (OpenFlowControllerImpl.this.connectedSwitches.get(dpid) == null) {
                this.log.error("Trying to activate switch but is not in connected switches: dpid {}. Aborting ..", (Object)dpid);
                return false;
            }
            if (OpenFlowControllerImpl.this.activeMasterSwitches.get(dpid) != null || OpenFlowControllerImpl.this.activeEqualSwitches.get(dpid) != null) {
                this.log.error("Trying to activate switch but it is already activated: dpid {}. Found in activeMaster: {} Found in activeEqual: {}. Aborting ..", new Object[]{dpid, Character.valueOf(OpenFlowControllerImpl.this.activeMasterSwitches.get(dpid) == null ? (char)'N' : 'Y'), Character.valueOf(OpenFlowControllerImpl.this.activeEqualSwitches.get(dpid) == null ? (char)'N' : 'Y')});
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addActivatedMasterSwitch(Dpid dpid, OpenFlowSwitch sw) {
            this.switchLock.lock();
            try {
                if (!this.validActivation(dpid)) {
                    boolean bl = false;
                    return bl;
                }
                OpenFlowControllerImpl.this.activeMasterSwitches.put(dpid, sw);
                boolean bl = true;
                return bl;
            }
            finally {
                this.switchLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addActivatedEqualSwitch(Dpid dpid, OpenFlowSwitch sw) {
            this.switchLock.lock();
            try {
                if (!this.validActivation(dpid)) {
                    boolean bl = false;
                    return bl;
                }
                OpenFlowControllerImpl.this.activeEqualSwitches.put(dpid, sw);
                this.log.info("Added Activated EQUAL Switch {}", (Object)dpid);
                boolean bl = true;
                return bl;
            }
            finally {
                this.switchLock.unlock();
            }
        }

        public void transitionToMasterSwitch(Dpid dpid) {
            this.switchLock.lock();
            try {
                if (OpenFlowControllerImpl.this.activeMasterSwitches.containsKey(dpid)) {
                    return;
                }
                OpenFlowSwitch sw = OpenFlowControllerImpl.this.activeEqualSwitches.remove(dpid);
                if (sw == null && (sw = OpenFlowControllerImpl.this.getSwitch(dpid)) == null) {
                    this.log.error("Transition to master called on sw {}, but switch was not found in controller-cache", (Object)dpid);
                    return;
                }
                this.log.info("Transitioned switch {} to MASTER", (Object)dpid);
                OpenFlowControllerImpl.this.activeMasterSwitches.put(dpid, sw);
            }
            finally {
                this.switchLock.unlock();
            }
        }

        public void transitionToEqualSwitch(Dpid dpid) {
            this.switchLock.lock();
            try {
                if (OpenFlowControllerImpl.this.activeEqualSwitches.containsKey(dpid)) {
                    return;
                }
                OpenFlowSwitch sw = OpenFlowControllerImpl.this.activeMasterSwitches.remove(dpid);
                if (sw == null && (sw = OpenFlowControllerImpl.this.getSwitch(dpid)) == null) {
                    this.log.error("Transition to equal called on sw {}, but switch was not found in controller-cache", (Object)dpid);
                    return;
                }
                this.log.info("Transitioned switch {} to EQUAL", (Object)dpid);
                OpenFlowControllerImpl.this.activeEqualSwitches.put(dpid, sw);
            }
            finally {
                this.switchLock.unlock();
            }
        }

        public void removeConnectedSwitch(Dpid dpid) {
            OpenFlowControllerImpl.this.connectedSwitches.remove(dpid);
            OpenFlowSwitch sw = OpenFlowControllerImpl.this.activeMasterSwitches.remove(dpid);
            if (sw == null) {
                this.log.debug("sw was null for {}", (Object)dpid);
                sw = OpenFlowControllerImpl.this.activeEqualSwitches.remove(dpid);
            }
            for (OpenFlowSwitchListener l : OpenFlowControllerImpl.this.ofSwitchListener) {
                l.switchRemoved(dpid);
            }
        }

        public void processMessage(Dpid dpid, OFMessage m) {
            OpenFlowControllerImpl.this.processPacket(dpid, m);
        }

        public void returnRoleReply(Dpid dpid, RoleState requested, RoleState response) {
            for (OpenFlowSwitchListener l : OpenFlowControllerImpl.this.ofSwitchListener) {
                l.receivedRoleReply(dpid, requested, response);
            }
        }
    }
}

