/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.onosproject.openflow.controller.impl.Controller;
import org.onosproject.openflow.controller.impl.HandshakeTimeoutHandler;
import org.onosproject.openflow.controller.impl.OFChannelHandler;
import org.onosproject.openflow.controller.impl.OFMessageDecoder;
import org.onosproject.openflow.controller.impl.OFMessageEncoder;

public class OpenflowPipelineFactory
implements ChannelPipelineFactory,
ExternalResourceReleasable {
    protected Controller controller;
    protected ThreadPoolExecutor pipelineExecutor;
    protected Timer timer;
    protected IdleStateHandler idleHandler;
    protected ReadTimeoutHandler readTimeoutHandler;

    public OpenflowPipelineFactory(Controller controller, ThreadPoolExecutor pipelineExecutor) {
        this.controller = controller;
        this.pipelineExecutor = pipelineExecutor;
        this.timer = new HashedWheelTimer();
        this.idleHandler = new IdleStateHandler(this.timer, 20, 25, 0);
        this.readTimeoutHandler = new ReadTimeoutHandler(this.timer, 30);
    }

    public ChannelPipeline getPipeline() throws Exception {
        OFChannelHandler handler = new OFChannelHandler(this.controller);
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("ofmessagedecoder", (ChannelHandler)new OFMessageDecoder());
        pipeline.addLast("ofmessageencoder", (ChannelHandler)new OFMessageEncoder());
        pipeline.addLast("idle", (ChannelHandler)this.idleHandler);
        pipeline.addLast("timeout", (ChannelHandler)this.readTimeoutHandler);
        pipeline.addLast("handshaketimeout", (ChannelHandler)new HandshakeTimeoutHandler(handler, this.timer, 60L));
        if (this.pipelineExecutor != null) {
            pipeline.addLast("pipelineExecutor", (ChannelHandler)new ExecutionHandler((Executor)this.pipelineExecutor));
        }
        pipeline.addLast("handler", (ChannelHandler)handler);
        return pipeline;
    }

    public void releaseExternalResources() {
        this.timer.stop();
    }
}

