/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.junit.Test;
import org.onosproject.core.netty.ChannelAdapter;
import org.onosproject.openflow.ChannelHandlerContextAdapter;
import org.onosproject.openflow.controller.impl.OFMessageDecoder;
import org.projectfloodlight.openflow.protocol.OFHello;

public class OFMessageDecoderTest {
    private ChannelBuffer getHelloMessageBuffer() {
        byte[] messageData = new byte[]{1, 0, 0, 8, 0, 0, 0, 0};
        ChannelBuffer channelBuffer = ChannelBuffers.dynamicBuffer();
        channelBuffer.writeBytes(messageData);
        return channelBuffer;
    }

    @Test
    public void testDecodeNoChannel() throws Exception {
        OFMessageDecoder decoder = new OFMessageDecoder();
        ChannelBuffer channelBuffer = this.getHelloMessageBuffer();
        Object message = decoder.decode((ChannelHandlerContext)new ChannelHandlerContextAdapter(), (Channel)new ChannelAdapter(), channelBuffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDecode() throws Exception {
        OFMessageDecoder decoder = new OFMessageDecoder();
        ChannelBuffer channelBuffer = this.getHelloMessageBuffer();
        Object message = decoder.decode((ChannelHandlerContext)new ChannelHandlerContextAdapter(), (Channel)new ConnectedChannel(), channelBuffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(OFHello.class));
    }

    static class ConnectedChannel
    extends ChannelAdapter {
        ConnectedChannel() {
        }

        public boolean isConnected() {
            return true;
        }
    }
}

