/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.onlab.junit.TestTools;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverAdapter;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.driver.DriverServiceAdapter;
import org.onosproject.openflow.OFDescStatsReplyAdapter;
import org.onosproject.openflow.OpenflowSwitchDriverAdapter;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.impl.Controller;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerTest {
    @ClassRule
    public static TemporaryFolder testFolder = new TemporaryFolder();
    Controller controller;
    protected static final Logger log = LoggerFactory.getLogger(ControllerTest.class);

    private static File stageTestResource(String name) throws IOException {
        File file = new File(testFolder.newFolder(), name);
        byte[] bytes = ByteStreams.toByteArray((InputStream)ControllerTest.class.getResourceAsStream(name));
        Files.write((byte[])bytes, (File)file);
        return file;
    }

    @Before
    public void setUp() {
        this.controller = new Controller();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("openflowPorts", Integer.toString(TestTools.findAvailablePort((int)0)));
        this.controller.setConfigParams(properties);
    }

    @Test
    public void switchInstanceNotFoundTest() {
        this.controller.start(null, (DriverService)new MockDriverService());
        OpenFlowSwitchDriver driver = this.controller.getOFSwitchInstance(1L, null, null);
        MatcherAssert.assertThat((Object)driver, (Matcher)Matchers.nullValue());
        this.controller.stop();
    }

    @Test
    public void switchItemNotFoundTest() {
        this.controller.start(null, (DriverService)new MockDriverService());
        OFDescStatsReplyAdapter stats = new OFDescStatsReplyAdapter();
        OpenFlowSwitchDriver driver = this.controller.getOFSwitchInstance(2L, (OFDescStatsReply)stats, null);
        MatcherAssert.assertThat((Object)driver, (Matcher)Matchers.nullValue());
        this.controller.stop();
    }

    @Test
    public void driverExistsTest() {
        this.controller.start(null, (DriverService)new MockDriverService());
        OFDescStatsReplyAdapter stats = new OFDescStatsReplyAdapter();
        OpenFlowSwitchDriver driver = this.controller.getOFSwitchInstance(3L, (OFDescStatsReply)stats, null);
        MatcherAssert.assertThat((Object)driver, (Matcher)Matchers.notNullValue());
        this.controller.stop();
    }

    @Test
    public void testConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("openflowPorts", "1,2,3,4,5");
        ((Dictionary)properties).put("workerThreads", "5");
        this.controller.setConfigParams(properties);
        IntStream.rangeClosed(1, 5).forEach(i -> MatcherAssert.assertThat((Object)this.controller.openFlowPorts, (Matcher)Matchers.hasItem((Object)i)));
        MatcherAssert.assertThat((Object)this.controller.workerThreads, (Matcher)Matchers.is((Object)5));
    }

    @Test
    public void testSsl() throws IOException {
        File keystore = ControllerTest.stageTestResource("ControllerTestKeystore.jks");
        String keystoreName = keystore.getAbsolutePath();
        System.setProperty("enableOFTLS", Boolean.toString(Boolean.TRUE));
        System.setProperty("javax.net.ssl.keyStore", keystoreName);
        System.setProperty("javax.net.ssl.trustStore", keystoreName);
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("openflowPorts", Integer.toString(TestTools.findAvailablePort((int)0)));
        ((Dictionary)properties).put("workerThreads", "0");
        this.controller.setConfigParams(properties);
        this.controller.start(null, (DriverService)new MockDriverService());
        MatcherAssert.assertThat((Object)this.controller.sslContext, (Matcher)Matchers.notNullValue());
        this.controller.stop();
        boolean removed = keystore.delete();
        if (!removed) {
            log.warn("Could not remove temporary file");
        }
    }

    @Test
    public void testHealth() {
        Map memory = this.controller.getMemory();
        MatcherAssert.assertThat((Object)memory.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(memory.get("total"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0)));
        MatcherAssert.assertThat(memory.get("free"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0)));
        long startTime = this.controller.getSystemStartTime();
        MatcherAssert.assertThat((Object)startTime, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(System.currentTimeMillis())));
        long upTime = this.controller.getSystemUptime();
        MatcherAssert.assertThat((Object)upTime, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(30000L)));
    }

    class MockDriverService
    extends DriverServiceAdapter {
        static final int NO_SUCH_DRIVER_ID = 1;
        static final int ITEM_NOT_FOUND_DRIVER_ID = 2;
        static final int DRIVER_EXISTS_ID = 3;
        static final String BASE_DRIVER_NAME = "of:000000000000000";
        static final String NO_SUCH_DRIVER = "of:0000000000000001";
        static final String ITEM_NOT_FOUND_DRIVER = "of:0000000000000002";
        static final String DRIVER_EXISTS = "of:0000000000000003";

        MockDriverService() {
        }

        public Driver getDriver(DeviceId deviceId) {
            switch (deviceId.toString()) {
                case "of:0000000000000001": {
                    return null;
                }
                case "of:0000000000000002": {
                    throw new ItemNotFoundException();
                }
                case "of:0000000000000003": {
                    return new TestDriver();
                }
            }
            throw new AssertionError();
        }
    }

    private class TestDriver
    extends DriverAdapter {
        private TestDriver() {
        }

        public <T extends Behaviour> T createBehaviour(DriverHandler handler, Class<T> behaviourClass) {
            if (behaviourClass == OpenFlowSwitchDriver.class) {
                return (T)new OpenflowSwitchDriverAdapter();
            }
            return null;
        }
    }
}

