/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.CoreService;
import org.onosproject.openflow.OpenflowSwitchDriverAdapter;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.impl.OpenFlowControllerImpl;
import org.osgi.service.component.ComponentContext;
import org.projectfloodlight.openflow.protocol.OFPortStatus;

public class OpenFlowControllerImplTest {
    OpenFlowSwitch switch1;
    Dpid dpid1;
    OpenFlowSwitch switch2;
    Dpid dpid2;
    OpenFlowSwitch switch3;
    Dpid dpid3;
    OpenFlowControllerImpl controller;
    OpenFlowControllerImpl.OpenFlowSwitchAgent agent;
    TestSwitchListener switchListener;

    @Before
    public void setUp() {
        CoreService mockCoreService;
        try {
            this.switch1 = new OpenflowSwitchDriverAdapter();
            this.dpid1 = Dpid.dpid((URI)new URI("of:0000000000000111"));
            this.switch2 = new OpenflowSwitchDriverAdapter();
            this.dpid2 = Dpid.dpid((URI)new URI("of:0000000000000222"));
            this.switch3 = new OpenflowSwitchDriverAdapter();
            this.dpid3 = Dpid.dpid((URI)new URI("of:0000000000000333"));
        }
        catch (URISyntaxException ex) {
            TestCase.fail();
        }
        this.controller = new OpenFlowControllerImpl();
        this.agent = this.controller.agent;
        this.switchListener = new TestSwitchListener();
        this.controller.addListener((OpenFlowSwitchListener)this.switchListener);
        this.controller.coreService = mockCoreService = (CoreService)EasyMock.createMock(CoreService.class);
        ComponentConfigService mockConfigService = (ComponentConfigService)EasyMock.createMock(ComponentConfigService.class);
        EasyMock.expect((Object)mockConfigService.getProperties((String)EasyMock.anyObject())).andReturn((Object)ImmutableSet.of());
        mockConfigService.registerProperties(this.controller.getClass());
        EasyMock.expectLastCall();
        mockConfigService.unregisterProperties(this.controller.getClass(), false);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)mockConfigService.getProperties((String)EasyMock.anyObject())).andReturn((Object)ImmutableSet.of());
        this.controller.cfgService = mockConfigService;
        EasyMock.replay((Object[])new Object[]{mockConfigService});
        ComponentContext mockContext = (ComponentContext)EasyMock.createMock(ComponentContext.class);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("openflowPorts", Integer.toString(TestTools.findAvailablePort((int)0)));
        EasyMock.expect((Object)mockContext.getProperties()).andReturn(properties);
        EasyMock.replay((Object[])new Object[]{mockContext});
        this.controller.activate(mockContext);
    }

    @After
    public void tearDown() {
        this.controller.removeListener((OpenFlowSwitchListener)this.switchListener);
        this.controller.deactivate();
    }

    private <T> Stream<T> makeIntoStream(Iterable<T> items) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(items.iterator(), 16), false);
    }

    @Test
    public void testAddRemoveConnectedSwitch() {
        boolean addSwitch1 = this.agent.addConnectedSwitch(this.dpid1, this.switch1);
        MatcherAssert.assertThat((Object)addSwitch1, (Matcher)Matchers.is((Object)true));
        boolean addSwitch2 = this.agent.addConnectedSwitch(this.dpid2, this.switch2);
        MatcherAssert.assertThat((Object)addSwitch2, (Matcher)Matchers.is((Object)true));
        boolean addSwitch3 = this.agent.addConnectedSwitch(this.dpid3, this.switch3);
        MatcherAssert.assertThat((Object)addSwitch3, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(this.switchListener.addedDpids, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(this.switchListener.addedDpids, (Matcher)Matchers.hasItems((Object[])new Dpid[]{this.dpid1, this.dpid2, this.dpid3}));
        boolean addBadSwitch1 = this.agent.addConnectedSwitch(this.dpid1, this.switch1);
        MatcherAssert.assertThat((Object)addBadSwitch1, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.controller.connectedSwitches.size(), (Matcher)Matchers.is((Object)3));
        Stream fetchedSwitches = this.makeIntoStream(this.controller.getSwitches());
        long switchCount = fetchedSwitches.count();
        MatcherAssert.assertThat((Object)switchCount, (Matcher)Matchers.is((Object)3L));
        OpenFlowSwitch queriedSwitch = this.controller.getSwitch(this.dpid1);
        MatcherAssert.assertThat((Object)queriedSwitch, (Matcher)Matchers.is((Object)this.switch1));
        this.agent.removeConnectedSwitch(this.dpid3);
        Stream fetchedSwitchesAfterRemove = this.makeIntoStream(this.controller.getSwitches());
        long switchCountAfterRemove = fetchedSwitchesAfterRemove.count();
        MatcherAssert.assertThat((Object)switchCountAfterRemove, (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat(this.switchListener.removedDpids, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.switchListener.removedDpids, (Matcher)Matchers.hasItems((Object[])new Dpid[]{this.dpid3}));
        OpenFlowSwitch queriedSwitchAfterRemove = this.controller.getSwitch(this.dpid3);
        MatcherAssert.assertThat((Object)queriedSwitchAfterRemove, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testMasterSwitch() {
        this.agent.addConnectedSwitch(this.dpid1, this.switch1);
        this.agent.transitionToMasterSwitch(this.dpid1);
        Stream fetchedMasterSwitches = this.makeIntoStream(this.controller.getMasterSwitches());
        MatcherAssert.assertThat((Object)fetchedMasterSwitches.count(), (Matcher)Matchers.is((Object)1L));
        Stream fetchedActivatedSwitches = this.makeIntoStream(this.controller.getEqualSwitches());
        MatcherAssert.assertThat((Object)fetchedActivatedSwitches.count(), (Matcher)Matchers.is((Object)0L));
        OpenFlowSwitch fetchedSwitch1 = this.controller.getMasterSwitch(this.dpid1);
        MatcherAssert.assertThat((Object)fetchedSwitch1, (Matcher)Matchers.is((Object)this.switch1));
        this.agent.addConnectedSwitch(this.dpid2, this.switch2);
        boolean addSwitch2 = this.agent.addActivatedMasterSwitch(this.dpid2, this.switch2);
        MatcherAssert.assertThat((Object)addSwitch2, (Matcher)Matchers.is((Object)true));
        OpenFlowSwitch fetchedSwitch2 = this.controller.getMasterSwitch(this.dpid2);
        MatcherAssert.assertThat((Object)fetchedSwitch2, (Matcher)Matchers.is((Object)this.switch2));
    }

    @Test
    public void testEqualSwitch() {
        this.agent.addConnectedSwitch(this.dpid1, this.switch1);
        this.agent.transitionToEqualSwitch(this.dpid1);
        Stream fetchedEqualSwitches = this.makeIntoStream(this.controller.getEqualSwitches());
        MatcherAssert.assertThat((Object)fetchedEqualSwitches.count(), (Matcher)Matchers.is((Object)1L));
        Stream fetchedActivatedSwitches = this.makeIntoStream(this.controller.getMasterSwitches());
        MatcherAssert.assertThat((Object)fetchedActivatedSwitches.count(), (Matcher)Matchers.is((Object)0L));
        OpenFlowSwitch fetchedSwitch1 = this.controller.getEqualSwitch(this.dpid1);
        MatcherAssert.assertThat((Object)fetchedSwitch1, (Matcher)Matchers.is((Object)this.switch1));
        this.agent.addConnectedSwitch(this.dpid2, this.switch2);
        boolean addSwitch2 = this.agent.addActivatedEqualSwitch(this.dpid2, this.switch2);
        MatcherAssert.assertThat((Object)addSwitch2, (Matcher)Matchers.is((Object)true));
        OpenFlowSwitch fetchedSwitch2 = this.controller.getEqualSwitch(this.dpid2);
        MatcherAssert.assertThat((Object)fetchedSwitch2, (Matcher)Matchers.is((Object)this.switch2));
    }

    @Test
    public void testRoleSetting() {
        this.agent.addConnectedSwitch(this.dpid2, this.switch2);
        MatcherAssert.assertThat((Object)this.switch2.getRole(), (Matcher)Matchers.is((Object)RoleState.MASTER));
        this.controller.setRole(this.dpid2, RoleState.EQUAL);
        MatcherAssert.assertThat((Object)this.switch2.getRole(), (Matcher)Matchers.is((Object)RoleState.EQUAL));
        this.controller.setRole(this.dpid3, RoleState.SLAVE);
    }

    static class TestSwitchListener
    implements OpenFlowSwitchListener {
        final List<Dpid> removedDpids = new ArrayList<Dpid>();
        final List<Dpid> addedDpids = new ArrayList<Dpid>();
        final List<Dpid> changedDpids = new ArrayList<Dpid>();

        TestSwitchListener() {
        }

        public void switchAdded(Dpid dpid) {
            this.addedDpids.add(dpid);
        }

        public void switchRemoved(Dpid dpid) {
            this.removedDpids.add(dpid);
        }

        public void switchChanged(Dpid dpid) {
            this.changedDpids.add(dpid);
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
        }
    }
}

