/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.junit.Test;
import org.onosproject.openflow.OfMessageAdapter;
import org.onosproject.openflow.controller.impl.OFMessageEncoder;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFType;

public class OFMessageEncoderTest {
    @Test
    public void testNoList() throws Exception {
        OFMessageEncoder encoder = new OFMessageEncoder();
        MockOfMessage message = new MockOfMessage();
        OFMessage returnedMessage = (OFMessage)encoder.encode(null, null, (Object)message);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.is((Object)returnedMessage));
    }

    @Test
    public void testList() throws Exception {
        OFMessageEncoder encoder = new OFMessageEncoder();
        MockOfMessage message1 = new MockOfMessage();
        MockOfMessage message2 = new MockOfMessage();
        MockOfMessage message3 = new MockOfMessage();
        ImmutableList messages = ImmutableList.of((Object)message1, (Object)message2, (Object)message3);
        ChannelBuffer returnedChannel = (ChannelBuffer)encoder.encode(null, null, (Object)messages);
        MatcherAssert.assertThat((Object)returnedChannel, (Matcher)Matchers.notNullValue());
        byte[] channelBytes = returnedChannel.array();
        String expectedListMessage = "message1 message2 message3 ";
        String listMessage = new String(channelBytes, StandardCharsets.UTF_8).substring(0, expectedListMessage.length());
        MatcherAssert.assertThat((Object)listMessage, (Matcher)Matchers.is((Object)expectedListMessage));
    }

    static class MockOfMessage
    extends OfMessageAdapter {
        static int nextId = 1;
        final int id = nextId++;

        MockOfMessage() {
            super(OFType.ERROR);
        }

        @Override
        public void writeTo(ChannelBuffer channelBuffer) {
            String message = "message" + Integer.toString(this.id) + " ";
            channelBuffer.writeBytes(message.getBytes(StandardCharsets.UTF_8));
        }
    }
}

