/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.openflow.ExecutorServiceAdapter;
import org.onosproject.openflow.MockOfFeaturesReply;
import org.onosproject.openflow.MockOfPortStatus;
import org.onosproject.openflow.OfMessageAdapter;
import org.onosproject.openflow.OpenFlowSwitchListenerAdapter;
import org.onosproject.openflow.OpenflowSwitchDriverAdapter;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.openflow.controller.impl.OpenFlowControllerImpl;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFType;

public class OpenFlowControllerImplPacketsTest {
    OpenFlowControllerImpl controller;
    OpenFlowControllerImpl.OpenFlowSwitchAgent agent;
    Dpid dpid1;
    OpenFlowSwitch switch1;
    OpenFlowSwitchListenerAdapter switchListener;
    TestPacketListener packetListener;
    TestExecutorService statsExecutorService;

    @Before
    public void setUp() {
        try {
            this.switch1 = new OpenflowSwitchDriverAdapter();
            this.dpid1 = Dpid.dpid((URI)new URI("of:0000000000000111"));
        }
        catch (URISyntaxException ex) {
            TestCase.fail();
        }
        this.controller = new OpenFlowControllerImpl();
        this.agent = this.controller.agent;
        this.switchListener = new OpenFlowSwitchListenerAdapter();
        this.controller.addListener((OpenFlowSwitchListener)this.switchListener);
        this.packetListener = new TestPacketListener();
        this.controller.addPacketListener(100, (PacketListener)this.packetListener);
        this.statsExecutorService = new TestExecutorService();
        this.controller.executorMsgs = this.statsExecutorService;
    }

    @Test
    public void testPortStatus() {
        MockOfPortStatus portStatusPacket = new MockOfPortStatus();
        this.controller.processPacket(this.dpid1, (OFMessage)portStatusPacket);
        MatcherAssert.assertThat((Object)this.switchListener.portChangedDpids().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.switchListener.portChangedDpids().containsKey(this.dpid1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.switchListener.portChangedDpids().get(this.dpid1), (Matcher)Matchers.equalTo((Object)portStatusPacket));
    }

    @Test
    public void testFeaturesReply() {
        MockOfFeaturesReply ofFeaturesReplyPacket = new MockOfFeaturesReply();
        this.controller.processPacket(this.dpid1, (OFMessage)ofFeaturesReplyPacket);
        MatcherAssert.assertThat(this.switchListener.changedDpids(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.switchListener.changedDpids().get(0), (Matcher)Matchers.equalTo((Object)this.dpid1));
    }

    @Test
    public void testError() {
        this.agent.addConnectedSwitch(this.dpid1, this.switch1);
        OfMessageAdapter errorPacket = new OfMessageAdapter(OFType.ERROR);
        this.controller.processPacket(this.dpid1, (OFMessage)errorPacket);
        MatcherAssert.assertThat(this.statsExecutorService.submittedMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.statsExecutorService.submittedMessages().get(0), (Matcher)Matchers.is((Object)errorPacket));
    }

    static class TestExecutorService
    extends ExecutorServiceAdapter {
        private List<OFMessage> submittedMessages = new ArrayList<OFMessage>();

        TestExecutorService() {
        }

        List<OFMessage> submittedMessages() {
            return this.submittedMessages;
        }

        @Override
        public void execute(Runnable task) {
            OpenFlowControllerImpl.OFMessageHandler handler = (OpenFlowControllerImpl.OFMessageHandler)task;
            this.submittedMessages.add(handler.msg);
        }
    }

    class TestPacketListener
    implements PacketListener {
        List<OpenFlowPacketContext> contexts = new ArrayList<OpenFlowPacketContext>();

        TestPacketListener() {
        }

        public void handlePacket(OpenFlowPacketContext pktCtx) {
            this.contexts.add(pktCtx);
        }

        List<OpenFlowPacketContext> contexts() {
            return this.contexts;
        }
    }
}

