/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller.impl;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.openflow.OpenflowSwitchDriverAdapter;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.RoleRecvStatus;
import org.onosproject.openflow.controller.driver.RoleReplyInfo;
import org.onosproject.openflow.controller.driver.SwitchStateException;
import org.onosproject.openflow.controller.impl.RoleManager;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFeaturesReply;
import org.projectfloodlight.openflow.types.U64;

public class RoleManagerTest {
    private static final U64 GID = U64.of((long)10L);
    private static final long XID = 1L;
    private OpenFlowSwitchDriver sw;
    private RoleManager manager;

    @Before
    public void setUp() {
        this.sw = new TestSwitchDriver();
        this.manager = new RoleManager(this.sw);
    }

    @After
    public void tearDown() {
        this.manager = null;
        this.sw = null;
    }

    @Test
    public void deliverRoleReply() {
        RoleReplyInfo asserted = new RoleReplyInfo(RoleState.MASTER, GID, 1L);
        RoleReplyInfo unasserted = new RoleReplyInfo(RoleState.SLAVE, GID, 1L);
        try {
            RoleRecvStatus status = this.manager.deliverRoleReply(asserted);
            Assert.assertEquals((String)"expectation wrong", (Object)RoleRecvStatus.OTHER_EXPECTATION, (Object)status);
            this.sw.setRole(RoleState.MASTER);
            Assert.assertEquals((String)"expectation wrong", (Object)RoleRecvStatus.OTHER_EXPECTATION, (Object)status);
            this.sw.setRole(RoleState.SLAVE);
            this.manager.sendRoleRequest(RoleState.MASTER, RoleRecvStatus.MATCHED_CURRENT_ROLE);
            status = this.manager.deliverRoleReply(asserted);
            Assert.assertEquals((String)"expectation wrong", (Object)RoleRecvStatus.MATCHED_CURRENT_ROLE, (Object)status);
            status = this.manager.deliverRoleReply(unasserted);
            Assert.assertEquals((String)"expectation wrong", (Object)RoleRecvStatus.OTHER_EXPECTATION, (Object)status);
            Assert.assertEquals((String)"pending role mismatch", (Object)RoleState.MASTER, (Object)((TestSwitchDriver)this.sw).failed);
        }
        catch (IOException | SwitchStateException e) {
            Assert.assertEquals((String)"unexpected error thrown", SwitchStateException.class, e.getClass());
        }
    }

    private class TestSwitchDriver
    extends OpenflowSwitchDriverAdapter {
        RoleState failed = null;
        RoleState current = null;

        private TestSwitchDriver() {
        }

        @Override
        public void setRole(RoleState role) {
            this.current = role;
        }

        @Override
        public RoleState getRole() {
            return this.current;
        }

        @Override
        public void setFeaturesReply(OFFeaturesReply featuresReply) {
        }

        @Override
        public void setSwitchDescription(OFDescStatsReply desc) {
        }

        @Override
        public int getNextTransactionId() {
            return 1;
        }

        @Override
        public void returnRoleReply(RoleState requested, RoleState response) {
            this.failed = requested;
        }

        @Override
        public String channelId() {
            return "1.2.3.4:1";
        }
    }
}

