/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.drivers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFAsyncGetReply;
import org.projectfloodlight.openflow.protocol.OFAsyncGetRequest;
import org.projectfloodlight.openflow.protocol.OFAsyncSet;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFGroupAdd;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFGroupFeaturesStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupFeaturesStatsRequest;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMatchV3;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFOxmList;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFTableFeaturesStatsRequest;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionCopyTtlOut;
import org.projectfloodlight.openflow.protocol.action.OFActionDecMplsTtl;
import org.projectfloodlight.openflow.protocol.action.OFActionDecNwTtl;
import org.projectfloodlight.openflow.protocol.action.OFActionGroup;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.action.OFActionPopMpls;
import org.projectfloodlight.openflow.protocol.action.OFActionPopVlan;
import org.projectfloodlight.openflow.protocol.action.OFActionPushMpls;
import org.projectfloodlight.openflow.protocol.action.OFActionPushVlan;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionApplyActions;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionWriteActions;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionWriteMetadata;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEthDst;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEthSrc;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEthType;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmInPort;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv4DstMasked;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmMetadataMasked;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmMplsLabel;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVid;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFMetadata;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.HexString;

public class OFSwitchImplCPqD13
extends AbstractOpenFlowSwitch {
    private static final int VLAN_ID_OFFSET = 16;
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private OFFactory factory;
    private static final int OFPCML_NO_BUFFER = 65535;
    private static final long SET_FLOW_REMOVED_MASK_MASTER = 15L;
    private static final long SET_PACKET_IN_MASK_MASTER = 7L;
    private static final long SET_PORT_STATUS_MASK_MASTER = 7L;
    private static final long SET_FLOW_REMOVED_MASK_EQUAL = 0L;
    private static final long SET_PACKET_IN_MASK_EQUAL = 0L;
    private static final long SET_PORT_STATUS_MASK_EQUAL = 7L;
    private static final long SET_ALL_SLAVE = 0L;
    private static final long TEST_FLOW_REMOVED_MASK = 15L;
    private static final long TEST_PACKET_IN_MASK = 7L;
    private static final long TEST_PORT_STATUS_MASK = 7L;
    private long barrierXidToWaitFor = -1L;
    private static final int TABLE_VLAN = 0;
    private static final int TABLE_TMAC = 1;
    private static final int TABLE_IPV4_UNICAST = 2;
    private static final int TABLE_MPLS = 3;
    private static final int TABLE_META = 4;
    private static final int TABLE_ACL = 5;
    private static final short MAX_PRIORITY = -1;
    private static final short SLASH_24_PRIORITY = -16;
    private static final short MIN_PRIORITY = 0;
    private static final U64 METADATA_MASK = U64.of((long)-1L);
    private final Map<Integer, OFGroup> l2groups = new ConcurrentHashMap<Integer, OFGroup>();
    private final boolean usePipeline13;

    public OFSwitchImplCPqD13(Dpid dpid, OFDescStatsReply desc, boolean usePipeline13) {
        super(dpid);
        this.setSwitchDescription(desc);
        this.usePipeline13 = usePipeline13;
    }

    public String toString() {
        return "OFSwitchImplCPqD13 [" + (this.channel != null ? this.channel.getRemoteAddress() : "?") + " DPID[" + (this.getStringId() != null ? this.getStringId() : "?") + "]]";
    }

    public void startDriverHandshake() {
        this.log.debug("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        this.factory = this.factory();
        if (!this.usePipeline13) {
            this.populateTableMissEntry(0, true, false, false, 0);
        }
        this.sendBarrier(true);
    }

    public boolean isDriverHandshakeComplete() {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        return this.driverHandshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        switch (m.getType()) {
            case BARRIER_REPLY: {
                if (m.getXid() != this.barrierXidToWaitFor) break;
                this.driverHandshakeComplete.set(true);
                break;
            }
            case ERROR: {
                this.log.error("Switch {} Error {}", (Object)this.getStringId(), (Object)m);
                break;
            }
            case GET_ASYNC_REPLY: {
                OFAsyncGetReply asrep = (OFAsyncGetReply)m;
                this.decodeAsyncGetReply(asrep);
                break;
            }
            case STATS_REPLY: {
                this.processStatsReply((OFStatsReply)m);
                break;
            }
            case PACKET_IN: 
            case PORT_STATUS: 
            case QUEUE_GET_CONFIG_REPLY: 
            case ROLE_REPLY: 
            case FEATURES_REPLY: 
            case FLOW_REMOVED: {
                break;
            }
            default: {
                this.log.debug("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    private void configureSwitch() throws IOException {
        this.sendGroupFeaturesRequest();
        this.setL2Groups();
        this.sendBarrier(false);
        this.setL3Groups();
        this.setL25Groups();
        this.sendGroupDescRequest();
        this.populateTableVlan();
        this.populateTableTMac();
        this.populateIpTable();
        this.populateMplsTable();
        this.populateTableMissEntry(5, false, false, false, -1);
        this.sendBarrier(true);
    }

    private void setAsyncConfig() throws IOException {
        ArrayList<Object> msglist = new ArrayList<Object>(3);
        OFAsyncSet setAC = null;
        if (this.role == RoleState.MASTER) {
            setAC = this.factory.buildAsyncSet().setFlowRemovedMaskEqualMaster(15L).setPacketInMaskEqualMaster(7L).setPortStatusMaskEqualMaster(7L).setFlowRemovedMaskSlave(0L).setPacketInMaskSlave(0L).setPortStatusMaskSlave(0L).setXid((long)this.getNextTransactionId()).build();
        } else if (this.role == RoleState.EQUAL) {
            setAC = this.factory.buildAsyncSet().setFlowRemovedMaskEqualMaster(0L).setPacketInMaskEqualMaster(0L).setPortStatusMaskEqualMaster(7L).setFlowRemovedMaskSlave(0L).setPacketInMaskSlave(0L).setPortStatusMaskSlave(0L).setXid((long)this.getNextTransactionId()).build();
        }
        msglist.add(setAC);
        OFBarrierRequest br = this.factory.buildBarrierRequest().setXid((long)this.getNextTransactionId()).build();
        msglist.add(br);
        OFAsyncGetRequest getAC = this.factory.buildAsyncGetRequest().setXid((long)this.getNextTransactionId()).build();
        msglist.add(getAC);
        this.sendMsg(msglist);
    }

    private void decodeAsyncGetReply(OFAsyncGetReply rep) {
        long frm = rep.getFlowRemovedMaskEqualMaster();
        long pim = rep.getPacketInMaskEqualMaster();
        long psm = rep.getPortStatusMaskEqualMaster();
        if (this.role == RoleState.MASTER || this.role == RoleState.EQUAL) {
            this.log.info("FRM:{}", (Object)HexString.toHexString((long)(frm & 0xFL)));
            this.log.info("PIM:{}", (Object)HexString.toHexString((long)(pim & 7L)));
            this.log.info("PSM:{}", (Object)HexString.toHexString((long)(psm & 7L)));
        }
    }

    private void getTableFeatures() throws IOException {
        OFTableFeaturesStatsRequest gtf = this.factory.buildTableFeaturesStatsRequest().setXid((long)this.getNextTransactionId()).build();
        this.sendMsg((OFMessage)gtf);
    }

    private void sendGroupFeaturesRequest() throws IOException {
        OFGroupFeaturesStatsRequest gfr = this.factory.buildGroupFeaturesStatsRequest().setXid((long)this.getNextTransactionId()).build();
        this.sendMsg((OFMessage)gfr);
    }

    private void sendGroupDescRequest() throws IOException {
        OFGroupDescStatsRequest gdr = this.factory.buildGroupDescStatsRequest().setXid((long)this.getNextTransactionId()).build();
        this.sendMsg((OFMessage)gdr);
    }

    private void setL2Groups() throws IOException {
        ArrayList<OFGroupAdd> msglist = new ArrayList<OFGroupAdd>();
        for (OFPortDesc p : this.getPorts()) {
            int pnum = p.getPortNo().getPortNumber();
            int portVlan = this.getVlanConfig(pnum);
            if (U32.of((long)pnum).compareTo(U32.of((long)OFPort.MAX.getPortNumber())) >= 1) continue;
            OFGroup gl2 = OFGroup.of((int)(pnum | portVlan << 16));
            OFActionOutput out = this.factory.actions().buildOutput().setPort(p.getPortNo()).build();
            OFActionPopVlan popVlan = this.factory.actions().popVlan();
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(popVlan);
            actions.add(out);
            OFBucket bucket = this.factory.buildBucket().setActions(actions).build();
            List<OFBucket> buckets = Collections.singletonList(bucket);
            OFGroupAdd gmAdd = this.factory.buildGroupAdd().setGroup(gl2).setBuckets(buckets).setGroupType(OFGroupType.INDIRECT).setXid((long)this.getNextTransactionId()).build();
            msglist.add(gmAdd);
            this.l2groups.put(pnum, gl2);
        }
        this.log.debug("Creating {} L2 groups in sw {}", (Object)msglist.size(), (Object)this.getStringId());
        this.sendMsg(msglist);
    }

    private int getVlanConfig(int portnum) {
        int portVlan = 10 * portnum;
        if (this.getId() == 1L && portnum == 6 || this.getId() == 2L || this.getId() == 3L && portnum == 2) {
            portVlan = 192;
        }
        return portVlan;
    }

    private MacAddress getRouterMacAddr() {
        if (this.getId() == 3L) {
            return MacAddress.of((String)"00:00:07:07:07:80");
        }
        if (this.getId() == 1L) {
            return MacAddress.of((String)"00:00:01:01:01:80");
        }
        return MacAddress.of((String)"00:00:02:02:02:80");
    }

    private OFAction getDestAction(int portnum) {
        OFActionSetField setDA = null;
        MacAddress dAddr = null;
        if (this.getId() == 1L && portnum == 6) {
            dAddr = MacAddress.of((String)"00:00:02:02:02:80");
        }
        if (this.getId() == 2L) {
            if (portnum == 1) {
                dAddr = MacAddress.of((String)"00:00:01:01:01:80");
            } else if (portnum == 2) {
                dAddr = MacAddress.of((String)"00:00:07:07:07:80");
            }
        }
        if (this.getId() == 3L && portnum == 2) {
            dAddr = MacAddress.of((String)"00:00:02:02:02:80");
        }
        if (dAddr != null) {
            OFOxmEthDst dstAddr = this.factory.oxms().ethDst(dAddr);
            setDA = this.factory.actions().buildSetField().setField((OFOxm)dstAddr).build();
        }
        return setDA;
    }

    private void setL3Groups() throws IOException {
        ArrayList<OFGroupAdd> msglist = new ArrayList<OFGroupAdd>();
        for (OFGroup gl2 : this.l2groups.values()) {
            int gnum = gl2.getGroupNumber();
            int portnum = gnum & 0xFFFF;
            int vlanid = (gnum & 0xFFF0000) >> 16;
            MacAddress sAddr = this.getRouterMacAddr();
            OFGroup gl3 = OFGroup.of((int)(0x20000000 | portnum));
            OFActionGroup group = this.factory.actions().buildGroup().setGroup(gl2).build();
            OFOxmEthSrc srcAddr = this.factory.oxms().ethSrc(sAddr);
            OFActionSetField setSA = this.factory.actions().buildSetField().setField((OFOxm)srcAddr).build();
            OFOxmVlanVid vid = this.factory.oxms().vlanVid(OFVlanVidMatch.ofVlan((int)vlanid));
            OFActionSetField setVlan = this.factory.actions().buildSetField().setField((OFOxm)vid).build();
            OFActionDecNwTtl decTtl = this.factory.actions().decNwTtl();
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(decTtl);
            actions.add(setVlan);
            actions.add(setSA);
            OFAction setDA = this.getDestAction(portnum);
            if (setDA != null) {
                actions.add(setDA);
            }
            actions.add(group);
            OFBucket bucket = this.factory.buildBucket().setActions(actions).build();
            List<OFBucket> buckets = Collections.singletonList(bucket);
            OFGroupAdd gmAdd = this.factory.buildGroupAdd().setGroup(gl3).setBuckets(buckets).setGroupType(OFGroupType.INDIRECT).setXid((long)this.getNextTransactionId()).build();
            msglist.add(gmAdd);
        }
        this.sendMsg(msglist);
        this.log.debug("Creating {} L3 groups in sw {}", (Object)msglist.size(), (Object)this.getStringId());
    }

    private void setL25Groups() throws IOException {
        ArrayList<OFGroupAdd> msglist = new ArrayList<OFGroupAdd>();
        for (OFGroup gl2 : this.l2groups.values()) {
            int gnum = gl2.getGroupNumber();
            int portnum = gnum & 0xFFFF;
            int vlanid = (gnum & 0xFFF0000) >> 16;
            MacAddress sAddr = this.getRouterMacAddr();
            OFAction setDA = this.getDestAction(portnum);
            if (setDA == null) continue;
            OFGroup gl3 = OFGroup.of((int)(0xA0000000 | portnum));
            OFActionGroup group = this.factory.actions().buildGroup().setGroup(gl2).build();
            OFOxmEthSrc srcAddr = this.factory.oxms().ethSrc(sAddr);
            OFActionSetField setSA = this.factory.actions().buildSetField().setField((OFOxm)srcAddr).build();
            OFOxmVlanVid vid = this.factory.oxms().vlanVid(OFVlanVidMatch.ofVlan((int)vlanid));
            OFActionSetField setVlan = this.factory.actions().buildSetField().setField((OFOxm)vid).build();
            OFActionDecMplsTtl decMplsTtl = this.factory.actions().decMplsTtl();
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(decMplsTtl);
            actions.add(setVlan);
            actions.add(setSA);
            actions.add(setDA);
            actions.add(group);
            OFBucket bucket = this.factory.buildBucket().setActions(actions).build();
            List<OFBucket> buckets = Collections.singletonList(bucket);
            OFGroupAdd gmAdd = this.factory.buildGroupAdd().setGroup(gl3).setBuckets(buckets).setGroupType(OFGroupType.INDIRECT).setXid((long)this.getNextTransactionId()).build();
            msglist.add(gmAdd);
        }
        this.sendMsg(msglist);
        this.log.debug("Creating {} MPLS groups in sw {}", (Object)msglist.size(), (Object)this.getStringId());
    }

    private void processStatsReply(OFStatsReply sr) {
        switch (sr.getStatsType()) {
            case AGGREGATE: {
                break;
            }
            case DESC: {
                break;
            }
            case EXPERIMENTER: {
                break;
            }
            case FLOW: {
                break;
            }
            case GROUP_DESC: {
                this.processGroupDesc((OFGroupDescStatsReply)sr);
                break;
            }
            case GROUP_FEATURES: {
                this.processGroupFeatures((OFGroupFeaturesStatsReply)sr);
                break;
            }
            case METER_CONFIG: {
                break;
            }
            case METER_FEATURES: {
                break;
            }
            case PORT_DESC: {
                break;
            }
            case TABLE_FEATURES: {
                break;
            }
        }
    }

    private void processGroupFeatures(OFGroupFeaturesStatsReply gfsr) {
        this.log.info("Sw: {} Group Features {}", (Object)this.getStringId(), (Object)gfsr);
    }

    private void processGroupDesc(OFGroupDescStatsReply gdsr) {
        this.log.info("Sw: {} Group Desc {}", (Object)this.getStringId(), (Object)gdsr);
    }

    private void populateTableVlan() throws IOException {
        ArrayList<OFFlowAdd> msglist = new ArrayList<OFFlowAdd>();
        for (OFPortDesc p : this.getPorts()) {
            int pnum = p.getPortNo().getPortNumber();
            if (U32.of((long)pnum).compareTo(U32.of((long)OFPort.MAX.getPortNumber())) >= 1) continue;
            int vlanid = this.getVlanConfig(pnum);
            OFOxmInPort oxp = this.factory.oxms().inPort(p.getPortNo());
            OFOxmVlanVid oxv = this.factory.oxms().vlanVid(OFVlanVidMatch.UNTAGGED);
            OFOxmList oxmList = OFOxmList.of((OFOxm[])new OFOxm[]{oxp, oxv});
            OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmList).build();
            OFOxmVlanVid vidToSet = this.factory.oxms().vlanVid(OFVlanVidMatch.ofVlan((int)vlanid));
            OFActionPushVlan pushVlan = this.factory.actions().pushVlan(EthType.VLAN_FRAME);
            OFActionSetField setVlan = this.factory.actions().setField((OFOxm)vidToSet);
            ArrayList<Object> actionlist = new ArrayList<Object>();
            actionlist.add(pushVlan);
            actionlist.add(setVlan);
            OFInstructionApplyActions appAction = this.factory.instructions().buildApplyActions().setActions(actionlist).build();
            OFInstructionGotoTable gotoTbl = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)1)).build();
            ArrayList<Object> instructions = new ArrayList<Object>();
            instructions.add(appAction);
            instructions.add(gotoTbl);
            OFFlowAdd flowEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)0)).setMatch((Match)match).setInstructions(instructions).setPriority(1000).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
            msglist.add(flowEntry);
        }
        this.sendMsg(msglist);
        this.log.debug("Adding {} vlan-rules in sw {}", (Object)msglist.size(), (Object)this.getStringId());
    }

    private void populateTableTMac() throws IOException {
        OFOxmEthType oxe = this.factory.oxms().ethType(EthType.IPv4);
        OFOxmList oxmListIp = OFOxmList.of((OFOxm[])new OFOxm[]{oxe});
        OFMatchV3 matchIp = this.factory.buildMatchV3().setOxmList(oxmListIp).build();
        OFInstructionGotoTable gotoTblIp = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)2)).build();
        List<OFInstructionGotoTable> instructionsIp = Collections.singletonList(gotoTblIp);
        OFFlowAdd ipEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)1)).setMatch((Match)matchIp).setInstructions(instructionsIp).setPriority(1000).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
        OFOxmEthType oxmpls = this.factory.oxms().ethType(EthType.MPLS_UNICAST);
        OFOxmList oxmListMpls = OFOxmList.of((OFOxm[])new OFOxm[]{oxmpls});
        OFMatchV3 matchMpls = this.factory.buildMatchV3().setOxmList(oxmListMpls).build();
        OFInstructionGotoTable gotoTblMpls = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)3)).build();
        List<OFInstructionGotoTable> instructionsMpls = Collections.singletonList(gotoTblMpls);
        OFFlowAdd mplsEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)1)).setMatch((Match)matchMpls).setInstructions(instructionsMpls).setPriority(1001).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
        this.populateTableMissEntry(1, true, false, false, -1);
        this.log.debug("Adding termination-mac-rules in sw {}", (Object)this.getStringId());
        ArrayList<OFFlowAdd> msglist = new ArrayList<OFFlowAdd>(2);
        msglist.add(ipEntry);
        msglist.add(mplsEntry);
        this.sendMsg(msglist);
    }

    private List<String> getMyIps() {
        ArrayList<String> myIps = new ArrayList<String>();
        if (this.getId() == 1L) {
            myIps.add("10.0.2.128");
            myIps.add("10.0.3.128");
            myIps.add("10.0.1.128");
            myIps.add("192.168.0.1");
        }
        if (this.getId() == 2L) {
            myIps.add("192.168.0.2");
        }
        if (this.getId() == 3L) {
            myIps.add("192.168.0.3");
            myIps.add("7.7.7.128");
        }
        return myIps;
    }

    private List<String> getMySubnetIps() {
        ArrayList<String> subnetIps = new ArrayList<String>();
        if (this.getId() == 1L) {
            subnetIps.add("10.0.2.0");
            subnetIps.add("10.0.3.0");
            subnetIps.add("10.0.1.0");
        }
        if (this.getId() == 3L) {
            subnetIps.add("7.7.7.0");
        }
        return subnetIps;
    }

    private List<RouteEntry> getRouterNextHopIps() {
        ArrayList<RouteEntry> routerNextHopIps = new ArrayList<RouteEntry>();
        if (this.getId() == 1L) {
            routerNextHopIps.add(new RouteEntry("192.168.0.2", "255.255.255.255", 6, 102));
            routerNextHopIps.add(new RouteEntry("192.168.0.3", "255.255.255.255", 6, 103));
            routerNextHopIps.add(new RouteEntry("7.7.7.0", "255.255.255.0", 6, 103));
        }
        if (this.getId() == 3L) {
            routerNextHopIps.add(new RouteEntry("192.168.0.2", "255.255.255.255", 2, 102));
            routerNextHopIps.add(new RouteEntry("192.168.0.1", "255.255.255.255", 2, 101));
            routerNextHopIps.add(new RouteEntry("10.0.1.0", "255.255.255.0", 2, 101));
            routerNextHopIps.add(new RouteEntry("10.0.2.0", "255.255.255.0", 2, 101));
            routerNextHopIps.add(new RouteEntry("10.0.3.0", "255.255.255.0", 2, 101));
        }
        return routerNextHopIps;
    }

    private List<RouteEntry> getHostNextHopIps() {
        ArrayList<RouteEntry> hostNextHopIps = new ArrayList<RouteEntry>();
        if (this.getId() == 1L) {
            hostNextHopIps.add(new RouteEntry("10.0.2.1", 4, "00:00:00:00:02:01"));
            hostNextHopIps.add(new RouteEntry("10.0.3.1", 5, "00:00:00:00:03:01"));
        }
        if (this.getId() == 3L) {
            hostNextHopIps.add(new RouteEntry("7.7.7.7", 1, "00:00:07:07:07:07"));
        }
        return hostNextHopIps;
    }

    private void populateIpTable() throws IOException {
        this.populateMyIps();
        this.populateMySubnets();
        this.populateRoutes();
        this.populateHostRoutes();
        this.populateTableMissEntry(2, false, true, true, 5);
    }

    private void populateMyIps() throws IOException {
        ArrayList<OFFlowAdd> msglist = new ArrayList<OFFlowAdd>();
        List<String> myIps = this.getMyIps();
        for (int i = 0; i < myIps.size(); ++i) {
            OFOxmEthType ethTypeIp = this.factory.oxms().ethType(EthType.IPv4);
            OFOxmIpv4DstMasked ipPrefix = this.factory.oxms().ipv4DstMasked(IPv4Address.of((String)myIps.get(i)), IPv4Address.NO_MASK);
            OFOxmList oxmListSlash32 = OFOxmList.of((OFOxm[])new OFOxm[]{ethTypeIp, ipPrefix});
            OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmListSlash32).build();
            OFActionOutput outc = this.factory.actions().buildOutput().setPort(OFPort.CONTROLLER).setMaxLen(65535).build();
            OFInstructionWriteActions writeInstr = this.factory.instructions().buildWriteActions().setActions(Collections.singletonList(outc)).build();
            OFInstructionGotoTable gotoInstr = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)5)).build();
            ArrayList<Object> instructions = new ArrayList<Object>();
            instructions.add(writeInstr);
            instructions.add(gotoInstr);
            OFFlowAdd myIpEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)2)).setMatch((Match)match).setInstructions(instructions).setPriority(-1).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
            msglist.add(myIpEntry);
        }
        this.sendMsg(msglist);
        this.log.debug("Adding {} my-ip-rules in sw {}", (Object)msglist.size(), (Object)this.getStringId());
    }

    private void populateMySubnets() throws IOException {
        ArrayList<OFFlowAdd> msglist = new ArrayList<OFFlowAdd>();
        List<String> subnetIps = this.getMySubnetIps();
        for (int i = 0; i < subnetIps.size(); ++i) {
            OFOxmEthType ethTypeIp = this.factory.oxms().ethType(EthType.IPv4);
            OFOxmIpv4DstMasked ipPrefix = this.factory.oxms().ipv4DstMasked(IPv4Address.of((String)subnetIps.get(i)), IPv4Address.of((int)-256));
            OFOxmList oxmListSlash24 = OFOxmList.of((OFOxm[])new OFOxm[]{ethTypeIp, ipPrefix});
            OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmListSlash24).build();
            OFActionOutput outc = this.factory.actions().buildOutput().setPort(OFPort.CONTROLLER).setMaxLen(65535).build();
            OFInstructionWriteActions writeInstr = this.factory.instructions().buildWriteActions().setActions(Collections.singletonList(outc)).build();
            OFInstructionGotoTable gotoInstr = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)5)).build();
            ArrayList<Object> instructions = new ArrayList<Object>();
            instructions.add(writeInstr);
            instructions.add(gotoInstr);
            OFFlowAdd myIpEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)2)).setMatch((Match)match).setInstructions(instructions).setPriority(-16).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
            msglist.add(myIpEntry);
        }
        this.sendMsg(msglist);
        this.log.debug("Adding {} subnet-ip-rules in sw {}", (Object)msglist.size(), (Object)this.getStringId());
        msglist.clear();
    }

    private void populateRoutes() throws IOException {
        ArrayList<OFFlowAdd> msglist = new ArrayList<OFFlowAdd>();
        List<RouteEntry> routerNextHopIps = this.getRouterNextHopIps();
        for (int i = 0; i < routerNextHopIps.size(); ++i) {
            OFOxmEthType ethTypeIp = this.factory.oxms().ethType(EthType.IPv4);
            OFOxmIpv4DstMasked ipPrefix = this.factory.oxms().ipv4DstMasked(IPv4Address.of((String)routerNextHopIps.get((int)i).prefix), IPv4Address.of((String)routerNextHopIps.get((int)i).mask));
            OFOxmList oxmListSlash32 = OFOxmList.of((OFOxm[])new OFOxm[]{ethTypeIp, ipPrefix});
            OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmListSlash32).build();
            OFActionGroup outg = this.factory.actions().buildGroup().setGroup(OFGroup.of((int)(0xA0000000 | routerNextHopIps.get((int)i).nextHopPort))).build();
            OFActionPushMpls pushlabel = this.factory.actions().pushMpls(EthType.MPLS_UNICAST);
            OFOxmMplsLabel l = this.factory.oxms().mplsLabel(U32.of((long)routerNextHopIps.get((int)i).label));
            OFActionSetField setlabelid = this.factory.actions().buildSetField().setField((OFOxm)l).build();
            OFActionCopyTtlOut copyTtlOut = this.factory.actions().copyTtlOut();
            ArrayList<Object> applyActions = new ArrayList<Object>();
            applyActions.add(pushlabel);
            applyActions.add(copyTtlOut);
            OFInstructionApplyActions applyInstr = this.factory.instructions().buildApplyActions().setActions(applyActions).build();
            ArrayList<OFActionGroup> writeActions = new ArrayList<OFActionGroup>();
            writeActions.add(outg);
            OFInstructionWriteActions writeInstr = this.factory.instructions().buildWriteActions().setActions(writeActions).build();
            OFInstructionWriteMetadata writeMeta = this.factory.instructions().buildWriteMetadata().setMetadata(U64.of((long)routerNextHopIps.get((int)i).label)).setMetadataMask(METADATA_MASK).build();
            OFInstructionGotoTable gotoInstr = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)4)).build();
            ArrayList<Object> instructions = new ArrayList<Object>();
            instructions.add(applyInstr);
            instructions.add(writeMeta);
            instructions.add(gotoInstr);
            int priority = -1;
            priority = routerNextHopIps.get((int)i).mask.equals("255.255.255.255") ? -1 : -16;
            OFFlowAdd myIpEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)2)).setMatch((Match)match).setInstructions(instructions).setPriority(priority).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
            msglist.add(myIpEntry);
            OFOxmEthType ethTypeMpls = this.factory.oxms().ethType(EthType.MPLS_UNICAST);
            OFOxmMetadataMasked meta = this.factory.oxms().metadataMasked(OFMetadata.ofRaw((long)routerNextHopIps.get((int)i).label), OFMetadata.NO_MASK);
            OFOxmList oxmListMeta = OFOxmList.of((OFOxm[])new OFOxm[]{ethTypeMpls, meta});
            OFMatchV3 matchMeta = this.factory.buildMatchV3().setOxmList(oxmListMeta).build();
            ArrayList<Object> writeActions2 = new ArrayList<Object>();
            writeActions2.add(setlabelid);
            OFActionGroup outg2 = this.factory.actions().buildGroup().setGroup(OFGroup.of((int)(routerNextHopIps.get((int)i).nextHopPort | 0xC00000))).build();
            writeActions2.add(outg2);
            OFInstructionWriteActions writeInstr2 = this.factory.instructions().buildWriteActions().setActions(writeActions2).build();
            OFInstructionGotoTable gotoInstr2 = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)5)).build();
            ArrayList<OFInstructionApplyActions> instructions2 = new ArrayList<OFInstructionApplyActions>();
            OFInstructionApplyActions applyInstr2 = this.factory.instructions().buildApplyActions().setActions(writeActions2).build();
            instructions2.add(applyInstr2);
            OFFlowAdd myMetaEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)4)).setMatch((Match)matchMeta).setInstructions(instructions2).setPriority(-1).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
            msglist.add(myMetaEntry);
        }
        this.sendMsg(msglist);
        this.log.debug("Adding {} next-hop-router-rules in sw {}", (Object)msglist.size(), (Object)this.getStringId());
    }

    private void populateHostRoutes() throws IOException {
        ArrayList<OFFlowAdd> msglist = new ArrayList<OFFlowAdd>();
        List<RouteEntry> hostNextHopIps = this.getHostNextHopIps();
        for (int i = 0; i < hostNextHopIps.size(); ++i) {
            OFOxmEthType ethTypeIp = this.factory.oxms().ethType(EthType.IPv4);
            OFOxmIpv4DstMasked ipPrefix = this.factory.oxms().ipv4DstMasked(IPv4Address.of((String)hostNextHopIps.get((int)i).prefix), IPv4Address.NO_MASK);
            OFOxmList oxmListSlash32 = OFOxmList.of((OFOxm[])new OFOxm[]{ethTypeIp, ipPrefix});
            OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmListSlash32).build();
            OFActionSetField setDmac = null;
            OFActionGroup outg = null;
            OFOxmEthDst dmac = this.factory.oxms().ethDst(MacAddress.of((String)hostNextHopIps.get((int)i).dstMac));
            setDmac = this.factory.actions().buildSetField().setField((OFOxm)dmac).build();
            outg = this.factory.actions().buildGroup().setGroup(OFGroup.of((int)(0x20000000 | hostNextHopIps.get((int)i).nextHopPort))).build();
            ArrayList<Object> writeActions = new ArrayList<Object>();
            writeActions.add(setDmac);
            writeActions.add(outg);
            OFInstructionWriteActions writeInstr = this.factory.instructions().buildWriteActions().setActions(writeActions).build();
            OFInstructionGotoTable gotoInstr = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)5)).build();
            ArrayList<Object> instructions = new ArrayList<Object>();
            instructions.add(writeInstr);
            instructions.add(gotoInstr);
            OFFlowAdd myIpEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)2)).setMatch((Match)match).setInstructions(instructions).setPriority(-1).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
            msglist.add(myIpEntry);
        }
        this.sendMsg(msglist);
        this.log.debug("Adding {} next-hop-host-rules in sw {}", (Object)msglist.size(), (Object)this.getStringId());
    }

    private List<MplsEntry> getMplsEntries() {
        ArrayList<MplsEntry> myLabels = new ArrayList<MplsEntry>();
        if (this.getId() == 1L) {
            myLabels.add(new MplsEntry(101, OFPort.CONTROLLER.getPortNumber()));
            myLabels.add(new MplsEntry(103, 6));
        }
        if (this.getId() == 2L) {
            myLabels.add(new MplsEntry(103, 2));
            myLabels.add(new MplsEntry(102, OFPort.CONTROLLER.getPortNumber()));
            myLabels.add(new MplsEntry(101, 1));
        }
        if (this.getId() == 3L) {
            myLabels.add(new MplsEntry(103, OFPort.CONTROLLER.getPortNumber()));
            myLabels.add(new MplsEntry(101, 2));
        }
        return myLabels;
    }

    private void populateMplsTable() throws IOException {
        ArrayList<OFFlowAdd> msglist = new ArrayList<OFFlowAdd>();
        List<MplsEntry> lfibEntries = this.getMplsEntries();
        for (int i = 0; i < lfibEntries.size(); ++i) {
            OFOxmEthType ethTypeMpls = this.factory.oxms().ethType(EthType.MPLS_UNICAST);
            OFOxmMplsLabel labelid = this.factory.oxms().mplsLabel(U32.of((long)lfibEntries.get((int)i).labelid));
            OFOxmList oxmList = OFOxmList.of((OFOxm[])new OFOxm[]{ethTypeMpls, labelid});
            OFMatchV3 matchlabel = this.factory.buildMatchV3().setOxmList(oxmList).build();
            OFActionPopMpls poplabel = this.factory.actions().popMpls(EthType.IPv4);
            Object sendTo = null;
            sendTo = lfibEntries.get((int)i).portnum == OFPort.CONTROLLER.getPortNumber() ? this.factory.actions().output(OFPort.CONTROLLER, 65535) : this.factory.actions().group(OFGroup.of((int)(0xA0000000 | lfibEntries.get((int)i).portnum)));
            ArrayList<Object> writeActions = new ArrayList<Object>();
            writeActions.add(poplabel);
            writeActions.add(sendTo);
            OFInstructionWriteActions writeInstr = this.factory.instructions().buildWriteActions().setActions(writeActions).build();
            OFInstructionGotoTable gotoInstr = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)5)).build();
            ArrayList<Object> instructions = new ArrayList<Object>();
            instructions.add(writeInstr);
            instructions.add(gotoInstr);
            OFFlowAdd myMplsEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)3)).setMatch((Match)matchlabel).setInstructions(instructions).setPriority(-1).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
            msglist.add(myMplsEntry);
        }
        this.sendMsg(msglist);
        this.log.debug("Adding {} mpls-forwarding-rules in sw {}", (Object)msglist.size(), (Object)this.getStringId());
        this.populateTableMissEntry(3, false, true, true, 5);
    }

    private void populateTableMissEntry(int tableToAdd, boolean toControllerNow, boolean toControllerWrite, boolean toTable, int tableToSend) {
        OFInstructionApplyActions instr;
        OFOxmList oxmList = OFOxmList.EMPTY;
        OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmList).build();
        OFActionOutput outc = this.factory.actions().buildOutput().setPort(OFPort.CONTROLLER).setMaxLen(65535).build();
        List<Object> instructions = new ArrayList<OFInstructionApplyActions>();
        if (toControllerNow) {
            instr = this.factory.instructions().buildApplyActions().setActions(Collections.singletonList(outc)).build();
            instructions.add(instr);
        }
        if (toControllerWrite) {
            instr = this.factory.instructions().buildWriteActions().setActions(Collections.singletonList(outc)).build();
            instructions.add(instr);
        }
        if (toTable) {
            instr = this.factory.instructions().gotoTable(TableId.of((int)tableToSend));
            instructions.add(instr);
        }
        if (!(toControllerNow || toControllerWrite || toTable)) {
            instructions = Collections.EMPTY_LIST;
        }
        OFFlowAdd tableMissEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)tableToAdd)).setMatch((Match)match).setInstructions(instructions).setPriority(0).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
        this.write((OFMessage)tableMissEntry);
    }

    private void sendBarrier(boolean finalBarrier) {
        int xid = this.getNextTransactionId();
        if (finalBarrier) {
            this.barrierXidToWaitFor = xid;
        }
        OFBarrierRequest br = this.factory.buildBarrierRequest().setXid((long)xid).build();
        this.write((OFMessage)br);
    }

    public Boolean supportNxRole() {
        return false;
    }

    public void write(OFMessage msg) {
        this.channel.write(Collections.singletonList(msg));
    }

    public void write(List<OFMessage> msgs) {
        this.channel.write(msgs);
    }

    private static class MplsEntry {
        int labelid;
        int portnum;

        public MplsEntry(int labelid, int portnum) {
            this.labelid = labelid;
            this.portnum = portnum;
        }
    }

    private static class RouteEntry {
        String prefix;
        String mask;
        int nextHopPort;
        String dstMac;
        int label;

        public RouteEntry(String prefix, String mask, int nextHopPort, int label) {
            this.prefix = prefix;
            this.mask = mask;
            this.nextHopPort = nextHopPort;
            this.label = label;
        }

        public RouteEntry(String prefix, int nextHopPort, String dstMac) {
            this.prefix = prefix;
            this.nextHopPort = nextHopPort;
            this.dstMac = dstMac;
        }
    }
}

