/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.drivers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFMatchV3;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFOxmList;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionApplyActions;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;

public class OFSwitchImplOVS13
extends AbstractOpenFlowSwitch {
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private OFFactory factory;
    private long barrierXidToWaitFor = -1L;
    private static final short MIN_PRIORITY = 0;
    private static final int OFPCML_NO_BUFFER = 65535;

    public OFSwitchImplOVS13(Dpid dpid, OFDescStatsReply desc) {
        super(dpid);
        this.setSwitchDescription(desc);
    }

    public String toString() {
        return "OFSwitchImplOVS13 [" + (this.channel != null ? this.channel.getRemoteAddress() : "?") + " DPID[" + (this.getStringId() != null ? this.getStringId() : "?") + "]]";
    }

    public void startDriverHandshake() {
        this.log.debug("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        this.factory = this.factory();
        this.configureSwitch();
    }

    public boolean isDriverHandshakeComplete() {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        return this.driverHandshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        switch (m.getType()) {
            case BARRIER_REPLY: {
                if (m.getXid() != this.barrierXidToWaitFor) break;
                this.driverHandshakeComplete.set(true);
                break;
            }
            case ERROR: {
                this.log.error("Switch {} Error {}", (Object)this.getStringId(), (Object)m);
                break;
            }
            case FEATURES_REPLY: {
                break;
            }
            case FLOW_REMOVED: {
                break;
            }
            case GET_ASYNC_REPLY: {
                break;
            }
            case PACKET_IN: {
                break;
            }
            case PORT_STATUS: {
                break;
            }
            case QUEUE_GET_CONFIG_REPLY: {
                break;
            }
            case ROLE_REPLY: {
                break;
            }
            case STATS_REPLY: {
                break;
            }
            default: {
                this.log.debug("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    private void configureSwitch() {
        this.populateTableMissEntry(0, true, false, false, 0);
        this.sendBarrier(true);
    }

    private void sendBarrier(boolean finalBarrier) {
        int xid = this.getNextTransactionId();
        if (finalBarrier) {
            this.barrierXidToWaitFor = xid;
        }
        OFBarrierRequest br = this.factory.buildBarrierRequest().setXid((long)xid).build();
        this.write((OFMessage)br);
    }

    public Boolean supportNxRole() {
        return false;
    }

    public void write(OFMessage msg) {
        this.channel.write(Collections.singletonList(msg));
    }

    public void write(List<OFMessage> msgs) {
        this.channel.write(msgs);
    }

    private void populateTableMissEntry(int tableToAdd, boolean toControllerNow, boolean toControllerWrite, boolean toTable, int tableToSend) {
        OFInstructionApplyActions instr;
        OFOxmList oxmList = OFOxmList.EMPTY;
        OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmList).build();
        OFActionOutput outc = this.factory.actions().buildOutput().setPort(OFPort.CONTROLLER).setMaxLen(65535).build();
        List<Object> instructions = new ArrayList<OFInstructionApplyActions>();
        if (toControllerNow) {
            instr = this.factory.instructions().buildApplyActions().setActions(Collections.singletonList(outc)).build();
            instructions.add(instr);
        }
        if (toControllerWrite) {
            instr = this.factory.instructions().buildWriteActions().setActions(Collections.singletonList(outc)).build();
            instructions.add(instr);
        }
        if (toTable) {
            instr = this.factory.instructions().gotoTable(TableId.of((int)tableToSend));
            instructions.add(instr);
        }
        if (!(toControllerNow || toControllerWrite || toTable)) {
            instructions = Collections.EMPTY_LIST;
        }
        OFFlowAdd tableMissEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)tableToAdd)).setMatch((Match)match).setInstructions(instructions).setPriority(0).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
        this.write((OFMessage)tableMissEntry);
    }
}

