/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.drivers;

import java.util.Collections;
import java.util.List;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriver;
import org.onosproject.openflow.controller.driver.OpenFlowSwitchDriverFactory;
import org.onosproject.openflow.drivers.OFCorsaSwitchDriver;
import org.onosproject.openflow.drivers.OFOVSSwitchCorsaTTP;
import org.onosproject.openflow.drivers.OFOpticalSwitchImplLINC13;
import org.onosproject.openflow.drivers.OFSwitchImplCPqD13;
import org.onosproject.openflow.drivers.OFSwitchImplOVS10;
import org.onosproject.openflow.drivers.OFSwitchImplOVS13;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverManager
implements OpenFlowSwitchDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(DriverManager.class);
    private static final int LOWEST_PRIORITY = 0;
    private static Dpid corsaDpid = new Dpid();

    public OpenFlowSwitchDriver getOFSwitchImpl(Dpid dpid, OFDescStatsReply desc, OFVersion ofv) {
        String sw;
        String vendor = desc.getMfrDesc();
        String hw = desc.getHwDesc();
        if (dpid.equals((Object)corsaDpid)) {
            if (hw.startsWith("Open vSwitch")) {
                return new OFOVSSwitchCorsaTTP(dpid, desc);
            }
            return new OFCorsaSwitchDriver(dpid, desc);
        }
        if (vendor.startsWith("Stanford University, Ericsson Research and CPqD Research") && hw.startsWith("OpenFlow 1.3 Reference Userspace Switch")) {
            return new OFSwitchImplCPqD13(dpid, desc);
        }
        if (hw.startsWith("Open vSwitch")) {
            if (ofv == OFVersion.OF_10) {
                return new OFSwitchImplOVS10(dpid, desc);
            }
            if (ofv == OFVersion.OF_13) {
                return new OFSwitchImplOVS13(dpid, desc);
            }
        }
        if ((sw = desc.getSwDesc()).startsWith("LINC-OE")) {
            log.warn("Optical Emulator LINC-OE with DPID:{} found..", (Object)dpid);
            return new OFOpticalSwitchImplLINC13(dpid, desc);
        }
        if (vendor.startsWith("Corsa") && hw.startsWith("Corsa Element") && sw.startsWith("2.3.1")) {
            log.warn("Corsa Switch 2.3.1 found");
            return new OFCorsaSwitchDriver(dpid, desc);
        }
        log.warn("DriverManager could not identify switch desc: {}. Assigning AbstractOpenFlowSwich", (Object)desc);
        return new AbstractOpenFlowSwitch(dpid, desc){

            public void setRole(RoleState state) {
                this.role = RoleState.MASTER;
            }

            public void write(List<OFMessage> msgs) {
                this.channel.write(msgs);
            }

            public void write(OFMessage msg) {
                this.channel.write(Collections.singletonList(msg));
            }

            public Boolean supportNxRole() {
                return false;
            }

            public void startDriverHandshake() {
                if (this.factory().getVersion() == OFVersion.OF_10) {
                    OFFlowAdd.Builder fmBuilder = this.factory().buildFlowAdd();
                    fmBuilder.setPriority(0);
                    this.write((OFMessage)fmBuilder.build());
                }
            }

            public void processDriverHandshakeMessage(OFMessage m) {
            }

            public boolean isDriverHandshakeComplete() {
                return true;
            }

            public List<OFPortDesc> getPorts() {
                if (this.factory().getVersion() == OFVersion.OF_10) {
                    return Collections.unmodifiableList(this.features.getPorts());
                }
                return Collections.unmodifiableList(this.ports.getEntries());
            }

            public OpenFlowSwitch.TableType getTableType(TableId tid) {
                return OpenFlowSwitch.TableType.NONE;
            }

            public void transformAndSendMsg(OFMessage msg, OpenFlowSwitch.TableType tableType) {
            }
        };
    }

    private DriverManager() {
    }

    public static OpenFlowSwitchDriver getSwitch(Dpid dpid, OFDescStatsReply desc, OFVersion ofv) {
        return new DriverManager().getOFSwitchImpl(dpid, desc, ofv);
    }

    public static void setCorsaDpid(Dpid dpid) {
        corsaDpid = dpid;
    }
}

