/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.drivers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFlowDelete;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFMatchV3;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.TableId;

public class OFCorsaSwitchDriver
extends AbstractOpenFlowSwitch {
    protected static final int FIRST_TABLE = 0;
    protected static final int VLAN_MPLS_TABLE = 1;
    protected static final int VLAN_TABLE = 2;
    protected static final int MPLS_TABLE = 3;
    protected static final int ETHER_TABLE = 4;
    protected static final int COS_MAP_TABLE = 5;
    protected static final int FIB_TABLE = 6;
    protected static final int LOCAL_TABLE = 9;
    private AtomicBoolean handShakeComplete = new AtomicBoolean(false);
    private int barrierXid;

    OFCorsaSwitchDriver(Dpid dpid, OFDescStatsReply desc) {
        super(dpid);
        this.setSwitchDescription(desc);
    }

    public void write(OFMessage msg) {
        if (msg.getType() == OFType.FLOW_MOD) {
            OFFlowMod flowMod = (OFFlowMod)msg;
            OFFlowMod.Builder builder = flowMod.createBuilder();
            builder.setTableId(TableId.of((int)9));
            this.channel.write(Collections.singletonList(builder.build()));
        } else {
            this.channel.write(Collections.singletonList(msg));
        }
    }

    public void write(List<OFMessage> msgs) {
        ArrayList<Object> newMsgs = new ArrayList<Object>();
        for (OFMessage msg : msgs) {
            if (msg.getType() == OFType.FLOW_MOD) {
                OFFlowMod flowMod = (OFFlowMod)msg;
                OFFlowMod.Builder builder = flowMod.createBuilder();
                builder.setTableId(TableId.of((int)9));
                newMsgs.add(builder.build());
                continue;
            }
            newMsgs.add(msg);
        }
        this.channel.write(newMsgs);
    }

    public void transformAndSendMsg(OFMessage msg, OpenFlowSwitch.TableType type) {
        this.log.trace("Trying to send {} of TableType {}", (Object)msg, (Object)type);
        if (msg.getType() == OFType.FLOW_MOD) {
            OFFlowMod flowMod = (OFFlowMod)msg;
            OFFlowMod.Builder builder = flowMod.createBuilder();
            List instructions = flowMod.getInstructions();
            ArrayList newInstructions = Lists.newArrayList();
            for (Object i : instructions) {
                if (i instanceof OFInstructionGotoTable) {
                    OFInstructionGotoTable gotoTable = (OFInstructionGotoTable)i;
                    OpenFlowSwitch.TableType tid = OpenFlowSwitch.TableType.values()[gotoTable.getTableId().getValue()];
                    switch (tid) {
                        case VLAN_MPLS: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)1)).build());
                            break;
                        }
                        case VLAN: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)2)).build());
                            break;
                        }
                        case ETHER: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)4)).build());
                            break;
                        }
                        case COS: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)5)).build());
                            break;
                        }
                        case IP: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)6)).build());
                            break;
                        }
                        case MPLS: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)3)).build());
                            break;
                        }
                        case ACL: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)9)).build());
                            break;
                        }
                        case NONE: {
                            this.log.error("Should never have to go to Table 0");
                            break;
                        }
                        default: {
                            this.log.warn("Unknown table type: {}", (Object)tid);
                            break;
                        }
                    }
                    continue;
                }
                newInstructions.add(i);
            }
            switch (type) {
                case VLAN_MPLS: {
                    builder.setTableId(TableId.of((int)1));
                    break;
                }
                case VLAN: {
                    builder.setTableId(TableId.of((int)2));
                    break;
                }
                case ETHER: {
                    builder.setTableId(TableId.of((int)4));
                    break;
                }
                case COS: {
                    builder.setTableId(TableId.of((int)5));
                    break;
                }
                case IP: {
                    builder.setTableId(TableId.of((int)6));
                    break;
                }
                case MPLS: {
                    builder.setTableId(TableId.of((int)3));
                    break;
                }
                case ACL: {
                    builder.setTableId(TableId.of((int)9));
                    break;
                }
                case FIRST: {
                    builder.setTableId(TableId.of((int)0));
                    break;
                }
                case NONE: {
                    builder.setTableId(TableId.of((int)9));
                    break;
                }
                default: {
                    this.log.warn("Unknown table type: {}", (Object)type);
                }
            }
            builder.setInstructions((List)newInstructions);
            OFMatchV3 match = (OFMatchV3)flowMod.getMatch();
            for (OFOxm oxm : match.getOxmList()) {
                if (oxm.getMatchField() != MatchField.VLAN_VID || !oxm.getValue().equals(OFVlanVidMatch.PRESENT)) continue;
                OFMatchV3.Builder mBuilder = this.factory().buildMatchV3();
                mBuilder.setExact(MatchField.ETH_TYPE, (OFValueType)EthType.of((int)-32512));
                builder.setMatch(mBuilder.build());
            }
            OFFlowMod msgnew = builder.build();
            this.channel.write(Collections.singletonList(msgnew));
            this.log.debug("Installed {}", (Object)msgnew);
        } else {
            this.channel.write(Collections.singletonList(msg));
        }
    }

    public OpenFlowSwitch.TableType getTableType(TableId tid) {
        switch (tid.getValue()) {
            case 1: {
                return OpenFlowSwitch.TableType.VLAN_MPLS;
            }
            case 2: {
                return OpenFlowSwitch.TableType.VLAN;
            }
            case 4: {
                return OpenFlowSwitch.TableType.ETHER;
            }
            case 5: {
                return OpenFlowSwitch.TableType.COS;
            }
            case 6: {
                return OpenFlowSwitch.TableType.IP;
            }
            case 3: {
                return OpenFlowSwitch.TableType.MPLS;
            }
            case 9: {
                return OpenFlowSwitch.TableType.NONE;
            }
            case 0: {
                return OpenFlowSwitch.TableType.FIRST;
            }
        }
        this.log.warn("Unknown table type: {}", (Object)tid.getValue());
        return OpenFlowSwitch.TableType.NONE;
    }

    public Boolean supportNxRole() {
        return false;
    }

    public void startDriverHandshake() {
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        OFFlowDelete fm = this.factory().buildFlowDelete().setTableId(TableId.ALL).setOutGroup(OFGroup.ANY).build();
        this.channel.write(Collections.singletonList(fm));
        this.barrierXid = this.getNextTransactionId();
        OFBarrierRequest barrier = this.factory().buildBarrierRequest().setXid((long)this.barrierXid).build();
        this.channel.write(Collections.singletonList(barrier));
    }

    public boolean isDriverHandshakeComplete() {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        return this.handShakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.handShakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        if (m.getType() == OFType.BARRIER_REPLY && m.getXid() == (long)this.barrierXid) {
            this.handShakeComplete.set(true);
        }
    }
}

