/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.drivers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.drivers.OFCorsaSwitchDriver;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.types.TableId;

public class OFOVSSwitchCorsaTTP
extends OFCorsaSwitchDriver {
    OFOVSSwitchCorsaTTP(Dpid dpid, OFDescStatsReply desc) {
        super(dpid, desc);
    }

    @Override
    public void transformAndSendMsg(OFMessage msg, OpenFlowSwitch.TableType type) {
        this.log.trace("Trying to send {} of TableType {}", (Object)msg, (Object)type);
        if (msg.getType() == OFType.FLOW_MOD) {
            OFFlowMod flowMod = (OFFlowMod)msg;
            OFFlowMod.Builder builder = flowMod.createBuilder();
            List instructions = flowMod.getInstructions();
            ArrayList newInstructions = Lists.newArrayList();
            for (OFInstruction i : instructions) {
                if (i instanceof OFInstructionGotoTable) {
                    OFInstructionGotoTable gotoTable = (OFInstructionGotoTable)i;
                    OpenFlowSwitch.TableType tid = OpenFlowSwitch.TableType.values()[gotoTable.getTableId().getValue()];
                    switch (tid) {
                        case VLAN_MPLS: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)1)).build());
                            break;
                        }
                        case VLAN: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)2)).build());
                            break;
                        }
                        case ETHER: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)4)).build());
                            break;
                        }
                        case COS: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)5)).build());
                            break;
                        }
                        case IP: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)6)).build());
                            break;
                        }
                        case MPLS: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)3)).build());
                            break;
                        }
                        case ACL: {
                            newInstructions.add(gotoTable.createBuilder().setTableId(TableId.of((int)9)).build());
                            break;
                        }
                        case NONE: {
                            this.log.error("Should never have to go to Table 0");
                            break;
                        }
                        default: {
                            this.log.warn("Unknown table type: {}", (Object)tid);
                            break;
                        }
                    }
                    continue;
                }
                newInstructions.add(i);
            }
            switch (type) {
                case VLAN_MPLS: {
                    builder.setTableId(TableId.of((int)1));
                    break;
                }
                case VLAN: {
                    builder.setTableId(TableId.of((int)2));
                    break;
                }
                case ETHER: {
                    builder.setTableId(TableId.of((int)4));
                    break;
                }
                case COS: {
                    builder.setTableId(TableId.of((int)5));
                    break;
                }
                case IP: {
                    builder.setTableId(TableId.of((int)6));
                    break;
                }
                case MPLS: {
                    builder.setTableId(TableId.of((int)3));
                    break;
                }
                case ACL: {
                    builder.setTableId(TableId.of((int)9));
                    break;
                }
                case FIRST: {
                    builder.setTableId(TableId.of((int)0));
                    break;
                }
                case NONE: {
                    builder.setTableId(TableId.of((int)9));
                    break;
                }
                default: {
                    this.log.warn("Unknown table type: {}", (Object)type);
                }
            }
            builder.setInstructions((List)newInstructions);
            OFFlowMod msgnew = builder.build();
            this.channel.write(Collections.singletonList(msgnew));
            this.log.debug("Installed {}", (Object)msgnew);
        } else {
            this.channel.write(Collections.singletonList(msg));
        }
    }
}

