/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.drivers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFCircuitPortStatus;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsReply;
import org.projectfloodlight.openflow.protocol.OFCircuitPortsRequest;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortOptical;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.types.TableId;

public class OFOpticalSwitchImplLINC13
extends AbstractOpenFlowSwitch {
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private long barrierXidToWaitFor = -1L;
    private OFPortDescStatsReply wPorts;

    OFOpticalSwitchImplLINC13(Dpid dpid, OFDescStatsReply desc) {
        super(dpid);
        this.setSwitchDescription(desc);
    }

    public String toString() {
        return "OFOpticalSwitchImplLINC13 [" + (this.channel != null ? this.channel.getRemoteAddress() : "?") + " DPID[" + (this.getStringId() != null ? this.getStringId() : "?") + "]]";
    }

    public void startDriverHandshake() {
        this.log.warn("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        try {
            this.sendHandshakeOFExperimenterPortDescRequest();
        }
        catch (IOException e) {
            this.log.error("LINC-OE exception while sending experimenter port desc:", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isDriverHandshakeComplete() {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        return this.driverHandshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        switch (m.getType()) {
            case BARRIER_REPLY: {
                if (m.getXid() != this.barrierXidToWaitFor) break;
                this.log.debug("LINC-OE Received barrier response");
                break;
            }
            case ERROR: {
                this.log.error("Switch {} Error {}", (Object)this.getStringId(), (Object)m);
                break;
            }
            case FEATURES_REPLY: {
                break;
            }
            case FLOW_REMOVED: {
                break;
            }
            case GET_ASYNC_REPLY: {
                break;
            }
            case PACKET_IN: {
                break;
            }
            case PORT_STATUS: {
                this.log.warn("****LINC-OE Port Status {} {}", (Object)this.getStringId(), (Object)m);
                this.processOFPortStatus((OFCircuitPortStatus)m);
                break;
            }
            case QUEUE_GET_CONFIG_REPLY: {
                break;
            }
            case ROLE_REPLY: {
                break;
            }
            case STATS_REPLY: {
                OFStatsReply stats = (OFStatsReply)m;
                if (stats.getStatsType() != OFStatsType.EXPERIMENTER) break;
                this.log.warn("LINC-OE : Received stats reply message {}", (Object)m);
                this.processHandshakeOFExperimenterPortDescRequest((OFCircuitPortsReply)m);
                this.driverHandshakeComplete.set(true);
                break;
            }
            default: {
                this.log.warn("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    public void processOFPortStatus(OFCircuitPortStatus ps) {
        this.log.debug("LINC-OE ..OF Port Status :", (Object)ps);
    }

    private void processHandshakeOFExperimenterPortDescRequest(OFCircuitPortsReply sr) {
        List entries = sr.getEntries();
        ArrayList<OFPortDesc> ofPortDescList = new ArrayList<OFPortDesc>(entries.size());
        for (OFPortOptical entry : entries) {
            this.log.warn("LINC:OE port message {}", (Object)entry.toString());
            ofPortDescList.add(this.factory().buildPortDesc().setPortNo(entry.getPortNo()).setConfig(entry.getConfig()).setState(entry.getState()).setHwAddr(entry.getHwAddr()).setName(entry.getName()).build());
        }
        this.setExperimenterPortDescReply(this.factory().buildPortDescStatsReply().setEntries(ofPortDescList).build());
    }

    private void setExperimenterPortDescReply(OFPortDescStatsReply reply) {
        this.wPorts = reply;
    }

    private void sendHandshakeOFExperimenterPortDescRequest() throws IOException {
        OFCircuitPortsRequest circuitPortsRequest = this.factory().buildCircuitPortsRequest().setXid((long)this.getNextTransactionId()).build();
        this.log.warn("LINC-OE : Sending experimented circuit port stats message {}", (Object)circuitPortsRequest.toString());
        this.write(Collections.singletonList(circuitPortsRequest));
    }

    public List<OFPortDesc> getPorts() {
        ArrayList portEntries = new ArrayList();
        portEntries.addAll(this.ports.getEntries());
        if (this.wPorts != null) {
            portEntries.addAll(this.wPorts.getEntries());
        }
        return Collections.unmodifiableList(portEntries);
    }

    public void write(OFMessage msg) {
        this.channel.write(Collections.singletonList(msg));
    }

    public void write(List<OFMessage> msgs) {
        this.channel.write(msgs);
    }

    public Boolean supportNxRole() {
        return false;
    }

    public boolean isOptical() {
        return true;
    }

    public OpenFlowSwitch.TableType getTableType(TableId tid) {
        return OpenFlowSwitch.TableType.NONE;
    }

    public void transformAndSendMsg(OFMessage msg, OpenFlowSwitch.TableType tableType) {
    }
}

