/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.drivers;

import java.util.Collections;
import java.util.List;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.types.TableId;

public class OFSwitchImplOVS10
extends AbstractOpenFlowSwitch {
    private static final int LOWEST_PRIORITY = 0;

    public OFSwitchImplOVS10(Dpid dpid, OFDescStatsReply desc) {
        super(dpid);
        this.setSwitchDescription(desc);
    }

    public String toString() {
        return "OFSwitchImplOVS10 [" + (this.channel != null ? this.channel.getRemoteAddress() : "?") + " DPID[" + (this.getStringId() != null ? this.getStringId() : "?") + "]]";
    }

    public Boolean supportNxRole() {
        return true;
    }

    public void startDriverHandshake() {
        OFFlowAdd.Builder fmBuilder = this.factory().buildFlowAdd();
        fmBuilder.setPriority(0);
        this.write((OFMessage)fmBuilder.build());
    }

    public boolean isDriverHandshakeComplete() {
        return true;
    }

    public void processDriverHandshakeMessage(OFMessage m) {
    }

    public void write(OFMessage msg) {
        this.channel.write(Collections.singletonList(msg));
    }

    public void write(List<OFMessage> msgs) {
        this.channel.write(msgs);
    }

    public List<OFPortDesc> getPorts() {
        return Collections.unmodifiableList(this.features.getPorts());
    }

    public OpenFlowSwitch.TableType getTableType(TableId tid) {
        return OpenFlowSwitch.TableType.NONE;
    }

    public void transformAndSendMsg(OFMessage msg, OpenFlowSwitch.TableType tableType) {
    }
}

