/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.drivers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.openflow.controller.driver.AbstractOpenFlowSwitch;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeAlreadyStarted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeCompleted;
import org.onosproject.openflow.controller.driver.SwitchDriverSubHandshakeNotStarted;
import org.projectfloodlight.openflow.protocol.OFAsyncGetReply;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFFlowMod;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupFeaturesStatsReply;
import org.projectfloodlight.openflow.protocol.OFMatchV3;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFOxmList;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionApplyActions;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEthType;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmInPort;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVid;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.HexString;

public class OFSwitchImplSpringOpenTTP
extends AbstractOpenFlowSwitch {
    private OFFactory factory;
    private final AtomicBoolean driverHandshakeComplete = new AtomicBoolean(false);
    private AtomicBoolean haltStateMachine = new AtomicBoolean(false);
    private DriverState driverState = DriverState.INIT;
    private static final int TABLE_VLAN = 0;
    private static final int TABLE_TMAC = 1;
    private static final int TABLE_IPV4_UNICAST = 2;
    private static final int TABLE_MPLS = 3;
    private static final int TABLE_ACL = 5;
    private static final long TEST_FLOW_REMOVED_MASK = 15L;
    private static final long TEST_PACKET_IN_MASK = 7L;
    private static final long TEST_PORT_STATUS_MASK = 7L;
    private static final int OFPCML_NO_BUFFER = 65535;
    private long barrierXidToWaitFor = -1L;
    protected int vlanTableId = 0;
    protected int tmacTableId = 1;
    protected int ipv4UnicastTableId = 2;
    protected int mplsTableId = 3;
    protected int aclTableId = 5;
    private static final short MAX_PRIORITY = -1;
    private static final short PRIORITY_MULTIPLIER = 2046;
    private static final short MIN_PRIORITY = 0;

    protected OFSwitchImplSpringOpenTTP(Dpid dpid, OFDescStatsReply desc) {
        super(dpid);
        this.setSwitchDescription(desc);
    }

    public String toString() {
        return "OFSwitchImplSpringOpenTTP [" + (this.channel != null ? this.channel.getRemoteAddress() : "?") + " DPID[" + (this.getStringId() != null ? this.getStringId() : "?") + "]]";
    }

    public Boolean supportNxRole() {
        return null;
    }

    public void startDriverHandshake() {
        this.log.debug("Starting driver handshake for sw {}", (Object)this.getStringId());
        if (this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeAlreadyStarted();
        }
        this.startDriverHandshakeCalled = true;
        this.factory = this.factory();
        try {
            this.nextDriverState();
        }
        catch (IOException e) {
            this.log.error("Error {} during driver handshake for sw {}", (Object)e.getCause(), (Object)this.getStringId());
        }
    }

    public boolean isDriverHandshakeComplete() {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        return this.driverHandshakeComplete.get();
    }

    public void processDriverHandshakeMessage(OFMessage m) {
        if (!this.startDriverHandshakeCalled) {
            throw new SwitchDriverSubHandshakeNotStarted();
        }
        if (this.driverHandshakeComplete.get()) {
            throw new SwitchDriverSubHandshakeCompleted(m);
        }
        try {
            this.processOFMessage(m);
        }
        catch (IOException e) {
            this.log.error("Error generated when processing OFMessage {}", e.getCause());
        }
    }

    public void write(OFMessage msg) {
        this.channel.write(Collections.singletonList(msg));
    }

    public void write(List<OFMessage> msgs) {
        this.channel.write(msgs);
    }

    public void transformAndSendMsg(OFMessage m, OpenFlowSwitch.TableType tableType) {
        if (m.getType() == OFType.FLOW_MOD) {
            OFFlowMod flowMod = (OFFlowMod)m;
            OFFlowMod.Builder builder = flowMod.createBuilder();
            builder.setTableId(this.getTableId(tableType));
            OFFlowMod newFlowMod = builder.build();
            if (this.role == RoleState.MASTER) {
                this.write((OFMessage)newFlowMod);
            }
        } else if (this.role == RoleState.MASTER) {
            this.write(m);
        }
    }

    protected void nextDriverState() throws IOException {
        DriverState currentState = this.driverState;
        if (this.haltStateMachine.get()) {
            return;
        }
        switch (currentState) {
            case INIT: {
                this.driverState = DriverState.SET_TABLE_MISS_ENTRIES;
                this.setTableMissEntries();
                this.sendHandshakeBarrier();
                break;
            }
            case SET_TABLE_MISS_ENTRIES: {
                this.driverState = DriverState.SET_TABLE_VLAN_TMAC;
                this.populateTableVlan();
                this.populateTableTMac();
                this.sendHandshakeBarrier();
                break;
            }
            case SET_TABLE_VLAN_TMAC: {
                this.driverState = DriverState.EXIT;
                this.driverHandshakeComplete.set(true);
                this.log.debug("Driver handshake is complete");
                break;
            }
            default: {
                this.driverState = DriverState.EXIT;
                this.log.error("Driver handshake has exited for sw: {}", (Object)this.getStringId());
            }
        }
    }

    private void processStatsReply(OFStatsReply sr) {
        switch (sr.getStatsType()) {
            case AGGREGATE: {
                break;
            }
            case DESC: {
                break;
            }
            case EXPERIMENTER: {
                break;
            }
            case FLOW: {
                break;
            }
            case GROUP_DESC: {
                this.processGroupDesc((OFGroupDescStatsReply)sr);
                break;
            }
            case GROUP_FEATURES: {
                this.processGroupFeatures((OFGroupFeaturesStatsReply)sr);
                break;
            }
            case METER_CONFIG: {
                break;
            }
            case METER_FEATURES: {
                break;
            }
            case PORT_DESC: {
                break;
            }
            case TABLE_FEATURES: {
                break;
            }
        }
    }

    private void processOFMessage(OFMessage m) throws IOException {
        switch (m.getType()) {
            case BARRIER_REPLY: {
                this.processBarrierReply(m);
                break;
            }
            case ERROR: {
                this.processErrorMessage(m);
                break;
            }
            case GET_ASYNC_REPLY: {
                OFAsyncGetReply asrep = (OFAsyncGetReply)m;
                this.decodeAsyncGetReply(asrep);
                break;
            }
            case PACKET_IN: {
                break;
            }
            case QUEUE_GET_CONFIG_REPLY: {
                break;
            }
            case STATS_REPLY: {
                this.processStatsReply((OFStatsReply)m);
                break;
            }
            default: {
                this.log.debug("Received message {} during switch-driver subhandshake from switch {} ... Ignoring message", (Object)m, (Object)this.getStringId());
            }
        }
    }

    private void processBarrierReply(OFMessage m) throws IOException {
        if (m.getXid() == this.barrierXidToWaitFor) {
            this.nextDriverState();
        } else {
            this.log.error("Received incorrect barrier-message xid {} (expected: {}) in switch-driver state {} for switch {}", new Object[]{m, this.barrierXidToWaitFor, this.driverState, this.getStringId()});
        }
    }

    private void processErrorMessage(OFMessage m) {
        this.log.error("Switch {} Error {} in DriverState", new Object[]{this.getStringId(), (OFErrorMsg)m, this.driverState});
    }

    private void processGroupFeatures(OFGroupFeaturesStatsReply gfsr) {
        this.log.info("Sw: {} Group Features {}", (Object)this.getStringId(), (Object)gfsr);
    }

    private void processGroupDesc(OFGroupDescStatsReply gdsr) {
        this.log.info("Sw: {} Group Desc {}", (Object)this.getStringId(), (Object)gdsr);
    }

    private void decodeAsyncGetReply(OFAsyncGetReply rep) {
        long frm = rep.getFlowRemovedMaskEqualMaster();
        long pim = rep.getPacketInMaskEqualMaster();
        long psm = rep.getPortStatusMaskEqualMaster();
        if (this.role == RoleState.MASTER || this.role == RoleState.EQUAL) {
            this.log.info("FRM:{}", (Object)HexString.toHexString((long)(frm & 0xFL)));
            this.log.info("PIM:{}", (Object)HexString.toHexString((long)(pim & 7L)));
            this.log.info("PSM:{}", (Object)HexString.toHexString((long)(psm & 7L)));
        }
    }

    protected void setTableMissEntries() throws IOException {
        this.populateTableMissEntry(this.vlanTableId, true, false, false, -1);
        this.populateTableMissEntry(this.tmacTableId, true, false, false, -1);
        this.populateTableMissEntry(this.ipv4UnicastTableId, false, true, true, this.aclTableId);
        this.populateTableMissEntry(this.mplsTableId, false, true, true, this.aclTableId);
        this.populateTableMissEntry(this.aclTableId, false, false, false, -1);
        this.log.debug("TableMissEntries are set");
    }

    protected void populateTableMissEntry(int tableToAdd, boolean toControllerNow, boolean toControllerWrite, boolean toTable, int tableToSend) {
        OFInstructionApplyActions instr;
        OFOxmList oxmList = OFOxmList.EMPTY;
        OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmList).build();
        OFActionOutput outc = this.factory.actions().buildOutput().setPort(OFPort.CONTROLLER).setMaxLen(65535).build();
        List<Object> instructions = new ArrayList<OFInstructionApplyActions>();
        if (toControllerNow) {
            instr = this.factory.instructions().buildApplyActions().setActions(Collections.singletonList(outc)).build();
            instructions.add(instr);
        }
        if (toControllerWrite) {
            instr = this.factory.instructions().buildWriteActions().setActions(Collections.singletonList(outc)).build();
            instructions.add(instr);
        }
        if (toTable) {
            instr = this.factory.instructions().gotoTable(TableId.of((int)tableToSend));
            instructions.add(instr);
        }
        if (!(toControllerNow || toControllerWrite || toTable)) {
            instructions = Collections.emptyList();
        }
        OFFlowAdd tableMissEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)tableToAdd)).setMatch((Match)match).setInstructions(instructions).setPriority(0).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
        this.write((OFMessage)tableMissEntry);
    }

    private void populateTableVlan() throws IOException {
        ArrayList<OFMessage> msglist = new ArrayList<OFMessage>();
        for (OFPortDesc p : this.getPorts()) {
            int pnum = p.getPortNo().getPortNumber();
            if (U32.of((long)pnum).compareTo(U32.of((long)OFPort.MAX.getPortNumber())) >= 1) continue;
            OFOxmInPort oxp = this.factory.oxms().inPort(p.getPortNo());
            OFOxmVlanVid oxv = this.factory.oxms().vlanVid(OFVlanVidMatch.UNTAGGED);
            OFOxmList oxmList = OFOxmList.of((OFOxm[])new OFOxm[]{oxp, oxv});
            OFMatchV3 match = this.factory.buildMatchV3().setOxmList(oxmList).build();
            OFInstructionGotoTable gotoTbl = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)this.tmacTableId)).build();
            ArrayList<OFInstructionGotoTable> instructions = new ArrayList<OFInstructionGotoTable>();
            instructions.add(gotoTbl);
            OFFlowAdd flowEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)this.vlanTableId)).setMatch((Match)match).setInstructions(instructions).setPriority(1000).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
            msglist.add((OFMessage)flowEntry);
        }
        this.write(msglist);
        this.log.debug("Adding {} port/vlan-rules in sw {}", (Object)msglist.size(), (Object)this.getStringId());
    }

    private void populateTableTMac() throws IOException {
        OFOxmEthType oxe = this.factory.oxms().ethType(EthType.IPv4);
        OFOxmList oxmList = OFOxmList.EMPTY;
        OFMatchV3 matchIp = this.factory.buildMatchV3().setOxmList(oxmList).build();
        OFInstructionGotoTable gotoTblIp = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)this.ipv4UnicastTableId)).build();
        List<OFInstructionGotoTable> instructionsIp = Collections.singletonList(gotoTblIp);
        OFFlowAdd ipEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)this.tmacTableId)).setMatch((Match)matchIp).setInstructions(instructionsIp).setPriority(1000).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
        OFOxmEthType oxmpls = this.factory.oxms().ethType(EthType.MPLS_UNICAST);
        OFOxmList oxmListMpls = OFOxmList.EMPTY;
        OFMatchV3 matchMpls = this.factory.buildMatchV3().setOxmList(oxmList).build();
        OFInstructionGotoTable gotoTblMpls = this.factory.instructions().buildGotoTable().setTableId(TableId.of((int)this.mplsTableId)).build();
        List<OFInstructionGotoTable> instructionsMpls = Collections.singletonList(gotoTblMpls);
        OFFlowAdd mplsEntry = this.factory.buildFlowAdd().setTableId(TableId.of((int)this.tmacTableId)).setMatch((Match)matchMpls).setInstructions(instructionsMpls).setPriority(1001).setBufferId(OFBufferId.NO_BUFFER).setIdleTimeout(0).setHardTimeout(0).setXid((long)this.getNextTransactionId()).build();
        this.log.debug("Adding termination-mac-rules in sw {}", (Object)this.getStringId());
        ArrayList<OFMessage> msglist = new ArrayList<OFMessage>(2);
        msglist.add((OFMessage)ipEntry);
        msglist.add((OFMessage)mplsEntry);
        this.write(msglist);
    }

    private MacAddress getRouterMacAddr() {
        return MacAddress.of((String)"00:00:00:00:00:00");
    }

    private TableId getTableId(OpenFlowSwitch.TableType tableType) {
        switch (tableType) {
            case IP: {
                return TableId.of((int)this.ipv4UnicastTableId);
            }
            case MPLS: {
                return TableId.of((int)this.mplsTableId);
            }
            case ACL: {
                return TableId.of((int)this.aclTableId);
            }
        }
        this.log.error("Table type {} is not supported in the driver", (Object)tableType);
        return TableId.NONE;
    }

    private void sendHandshakeBarrier() throws IOException {
        long xid;
        this.barrierXidToWaitFor = xid = (long)this.getNextTransactionId();
        OFBarrierRequest br = this.factory().buildBarrierRequest().setXid(xid).build();
        this.write((OFMessage)br);
    }

    public OpenFlowSwitch.TableType getTableType(TableId tid) {
        return OpenFlowSwitch.TableType.NONE;
    }

    static enum DriverState {
        INIT,
        SET_TABLE_MISS_ENTRIES,
        SET_TABLE_VLAN_TMAC,
        AUDIT_GROUPS,
        SET_GROUPS,
        VERIFY_GROUPS,
        SET_ADJACENCY_LABELS,
        EXIT;

    }
}

