/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.device.impl;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.RoleState;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortFeatures;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.PortSpeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenFlowDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFlowDeviceProvider.class);
    private static final long MBPS = 1000000L;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    private DeviceProviderService providerService;
    private final OpenFlowSwitchListener listener = new InternalDeviceProvider();

    public OpenFlowDeviceProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    public void activate() {
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addListener(this.listener);
        for (OpenFlowSwitch sw : this.controller.getSwitches()) {
            try {
                this.listener.switchAdded(new Dpid(sw.getId()));
            }
            catch (Exception e) {
                LOG.warn("Failed initially adding {} : {}", (Object)sw.getStringId(), (Object)e.getMessage());
                LOG.debug("Error details:", (Throwable)e);
                sw.disconnectSwitch();
            }
        }
        LOG.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.controller.removeListener(this.listener);
        this.providerService = null;
        LOG.info("Stopped");
    }

    public boolean isReachable(DeviceId deviceId) {
        OpenFlowSwitch sw = this.controller.getSwitch(Dpid.dpid((URI)deviceId.uri()));
        return sw != null && sw.isConnected();
    }

    public void triggerProbe(DeviceId deviceId) {
        LOG.info("Triggering probe on device {}", (Object)deviceId);
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null || !sw.isConnected()) {
            LOG.error("Failed to probe device {} on sw={}", (Object)deviceId, (Object)sw);
            this.providerService.deviceDisconnected(deviceId);
        } else {
            LOG.trace("Confirmed device {} connection", (Object)deviceId);
        }
        OFFactory fact = sw.factory();
        switch (fact.getVersion()) {
            case OF_10: {
                sw.sendMsg((OFMessage)fact.buildFeaturesRequest().setXid(0L).build());
                break;
            }
            case OF_13: {
                sw.sendMsg((OFMessage)fact.buildPortDescStatsRequest().setXid(0L).build());
                break;
            }
            default: {
                LOG.warn("Unhandled protocol version");
            }
        }
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
        switch (newRole) {
            case MASTER: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.MASTER);
                break;
            }
            case STANDBY: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.EQUAL);
                break;
            }
            case NONE: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.SLAVE);
                break;
            }
            default: {
                LOG.error("Unknown Mastership state : {}", (Object)newRole);
            }
        }
        LOG.info("Accepting mastership role change for device {}", (Object)deviceId);
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    private class InternalDeviceProvider
    implements OpenFlowSwitchListener {
        private InternalDeviceProvider() {
        }

        public void switchAdded(Dpid dpid) {
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            DeviceId did = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            OpenFlowSwitch sw = OpenFlowDeviceProvider.this.controller.getSwitch(dpid);
            Device.Type deviceType = sw.isOptical() ? Device.Type.ROADM : Device.Type.SWITCH;
            ChassisId cId = new ChassisId(dpid.value());
            DefaultAnnotations annotations = DefaultAnnotations.builder().set("protocol", sw.factory().getVersion().toString()).set("channelId", sw.channelId()).build();
            DefaultDeviceDescription description = new DefaultDeviceDescription(did.uri(), deviceType, sw.manfacturerDescription(), sw.hardwareDescription(), sw.softwareDescription(), sw.serialNumber(), cId, new SparseAnnotations[]{annotations});
            OpenFlowDeviceProvider.this.providerService.deviceConnected(did, (DeviceDescription)description);
            OpenFlowDeviceProvider.this.providerService.updatePorts(did, this.buildPortDescriptions(sw.getPorts()));
        }

        public void switchRemoved(Dpid dpid) {
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            OpenFlowDeviceProvider.this.providerService.deviceDisconnected(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)));
        }

        public void switchChanged(Dpid dpid) {
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            DeviceId did = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            OpenFlowSwitch sw = OpenFlowDeviceProvider.this.controller.getSwitch(dpid);
            OpenFlowDeviceProvider.this.providerService.updatePorts(did, this.buildPortDescriptions(sw.getPorts()));
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
            PortDescription portDescription = this.buildPortDescription(status);
            OpenFlowDeviceProvider.this.providerService.portStatusChanged(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)), portDescription);
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
            MastershipRole request = this.roleOf(requested);
            MastershipRole reply = this.roleOf(response);
            OpenFlowDeviceProvider.this.providerService.receivedRoleReply(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)), request, reply);
        }

        private MastershipRole roleOf(RoleState response) {
            switch (response) {
                case MASTER: {
                    return MastershipRole.MASTER;
                }
                case EQUAL: {
                    return MastershipRole.STANDBY;
                }
                case SLAVE: {
                    return MastershipRole.NONE;
                }
            }
            LOG.warn("unknown role {}", (Object)response);
            return null;
        }

        private List<PortDescription> buildPortDescriptions(List<OFPortDesc> ports) {
            ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>(ports.size());
            for (OFPortDesc port : ports) {
                portDescs.add(this.buildPortDescription(port));
            }
            return portDescs;
        }

        private SparseAnnotations makePortNameAnnotation(OFPortDesc port) {
            DefaultAnnotations annotations = null;
            String portName = Strings.emptyToNull((String)port.getName());
            if (portName != null) {
                annotations = DefaultAnnotations.builder().set("portName", portName).build();
            }
            return annotations;
        }

        private PortDescription buildPortDescription(OFPortDesc port) {
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            boolean enabled = !port.getState().contains(OFPortState.LINK_DOWN) && !port.getConfig().contains(OFPortConfig.PORT_DOWN);
            Port.Type type = port.getCurr().contains(OFPortFeatures.PF_FIBER) ? Port.Type.FIBER : Port.Type.COPPER;
            SparseAnnotations annotations = this.makePortNameAnnotation(port);
            return new DefaultPortDescription(portNo, enabled, type, this.portSpeed(port), new SparseAnnotations[]{annotations});
        }

        private PortDescription buildPortDescription(OFPortStatus status) {
            OFPortDesc port = status.getDesc();
            if (status.getReason() != OFPortReason.DELETE) {
                return this.buildPortDescription(port);
            }
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            Port.Type type = port.getCurr().contains(OFPortFeatures.PF_FIBER) ? Port.Type.FIBER : Port.Type.COPPER;
            SparseAnnotations annotations = this.makePortNameAnnotation(port);
            return new DefaultPortDescription(portNo, false, type, this.portSpeed(port), new SparseAnnotations[]{annotations});
        }

        private long portSpeed(OFPortDesc port) {
            if (port.getVersion() == OFVersion.OF_13) {
                return port.getCurrSpeed() / 1000000L;
            }
            PortSpeed portSpeed = PortSpeed.SPEED_NONE;
            for (OFPortFeatures feat : port.getCurr()) {
                portSpeed = PortSpeed.max((PortSpeed)portSpeed, (PortSpeed)feat.getPortSpeed());
            }
            return portSpeed.getSpeedBps() / 1000000L;
        }
    }
}

