/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.device.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DefaultPortStatistics;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.device.impl.PortStatsCollector;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortFeatures;
import org.projectfloodlight.openflow.protocol.OFPortOptical;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFPortStatsEntry;
import org.projectfloodlight.openflow.protocol.OFPortStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.PortSpeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenFlowDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFlowDeviceProvider.class);
    private static final long MBPS = 1000000L;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    private DeviceProviderService providerService;
    private final InternalDeviceProvider listener = new InternalDeviceProvider();
    static final int POLL_INTERVAL = 5;
    private HashMap<Dpid, PortStatsCollector> collectors = Maps.newHashMap();

    public OpenFlowDeviceProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    public void activate() {
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addListener((OpenFlowSwitchListener)this.listener);
        this.controller.addEventListener((OpenFlowEventListener)this.listener);
        for (OpenFlowSwitch sw : this.controller.getSwitches()) {
            try {
                this.listener.switchAdded(new Dpid(sw.getId()));
            }
            catch (Exception e) {
                LOG.warn("Failed initially adding {} : {}", (Object)sw.getStringId(), (Object)e.getMessage());
                LOG.debug("Error details:", (Throwable)e);
                sw.disconnectSwitch();
            }
            PortStatsCollector psc = new PortStatsCollector(sw, 5);
            psc.start();
            this.collectors.put(new Dpid(sw.getId()), psc);
        }
        LOG.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.controller.removeListener((OpenFlowSwitchListener)this.listener);
        this.collectors.values().forEach(PortStatsCollector::stop);
        this.providerService = null;
        LOG.info("Stopped");
    }

    public boolean isReachable(DeviceId deviceId) {
        OpenFlowSwitch sw = this.controller.getSwitch(Dpid.dpid((URI)deviceId.uri()));
        return sw != null && sw.isConnected();
    }

    public void triggerProbe(DeviceId deviceId) {
        LOG.debug("Triggering probe on device {}", (Object)deviceId);
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null || !sw.isConnected()) {
            LOG.error("Failed to probe device {} on sw={}", (Object)deviceId, (Object)sw);
            this.providerService.deviceDisconnected(deviceId);
            return;
        }
        LOG.trace("Confirmed device {} connection", (Object)deviceId);
        OFFactory fact = sw.factory();
        switch (fact.getVersion()) {
            case OF_10: {
                sw.sendMsg((OFMessage)fact.buildFeaturesRequest().setXid(0L).build());
                break;
            }
            case OF_13: {
                sw.sendMsg((OFMessage)fact.buildPortDescStatsRequest().setXid(0L).build());
                break;
            }
            default: {
                LOG.warn("Unhandled protocol version");
            }
        }
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
        switch (newRole) {
            case MASTER: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.MASTER);
                break;
            }
            case STANDBY: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.EQUAL);
                break;
            }
            case NONE: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.SLAVE);
                break;
            }
            default: {
                LOG.error("Unknown Mastership state : {}", (Object)newRole);
            }
        }
        LOG.debug("Accepting mastership role change for device {}", (Object)deviceId);
    }

    private void pushPortMetrics(Dpid dpid, List<OFPortStatsEntry> portStatsEntries) {
        DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
        Collection<PortStatistics> stats = this.buildPortStatistics(deviceId, portStatsEntries);
        this.providerService.updatePortStatistics(deviceId, stats);
    }

    private Collection<PortStatistics> buildPortStatistics(DeviceId deviceId, List<OFPortStatsEntry> entries) {
        HashSet stats = Sets.newHashSet();
        for (OFPortStatsEntry entry : entries) {
            try {
                if (entry == null || entry.getPortNo() == null || entry.getPortNo().getPortNumber() < 0) continue;
                DefaultPortStatistics.Builder builder = DefaultPortStatistics.builder();
                DefaultPortStatistics stat = builder.setDeviceId(deviceId).setPort(entry.getPortNo().getPortNumber()).setPacketsReceived(entry.getRxPackets().getValue()).setPacketsSent(entry.getTxPackets().getValue()).setBytesReceived(entry.getRxBytes().getValue()).setBytesSent(entry.getTxBytes().getValue()).setPacketsRxDropped(entry.getRxDropped().getValue()).setPacketsTxDropped(entry.getTxDropped().getValue()).setPacketsRxErrors(entry.getRxErrors().getValue()).setPacketsTxErrors(entry.getTxErrors().getValue()).setDurationSec(entry.getVersion() == OFVersion.OF_10 ? 0L : entry.getDurationSec()).setDurationNano(entry.getVersion() == OFVersion.OF_10 ? 0L : entry.getDurationNsec()).build();
                stats.add(stat);
            }
            catch (Exception e) {
                LOG.warn("Unable to process port stats", (Throwable)e);
            }
        }
        return Collections.unmodifiableSet(stats);
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    private class InternalDeviceProvider
    implements OpenFlowSwitchListener,
    OpenFlowEventListener {
        private HashMap<Dpid, List<OFPortStatsEntry>> portStatsReplies = new HashMap();

        private InternalDeviceProvider() {
        }

        public void switchAdded(Dpid dpid) {
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            DeviceId did = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            OpenFlowSwitch sw = OpenFlowDeviceProvider.this.controller.getSwitch(dpid);
            Device.Type deviceType = sw.isOptical() ? Device.Type.ROADM : Device.Type.SWITCH;
            ChassisId cId = new ChassisId(dpid.value());
            DefaultAnnotations annotations = DefaultAnnotations.builder().set("protocol", sw.factory().getVersion().toString()).set("channelId", sw.channelId()).build();
            DefaultDeviceDescription description = new DefaultDeviceDescription(did.uri(), deviceType, sw.manufacturerDescription(), sw.hardwareDescription(), sw.softwareDescription(), sw.serialNumber(), cId, new SparseAnnotations[]{annotations});
            OpenFlowDeviceProvider.this.providerService.deviceConnected(did, (DeviceDescription)description);
            OpenFlowDeviceProvider.this.providerService.updatePorts(did, this.buildPortDescriptions(sw));
            PortStatsCollector psc = new PortStatsCollector(OpenFlowDeviceProvider.this.controller.getSwitch(dpid), 5);
            psc.start();
            OpenFlowDeviceProvider.this.collectors.put(dpid, psc);
        }

        public void switchRemoved(Dpid dpid) {
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            OpenFlowDeviceProvider.this.providerService.deviceDisconnected(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)));
            PortStatsCollector collector = (PortStatsCollector)OpenFlowDeviceProvider.this.collectors.remove(dpid);
            if (collector != null) {
                collector.stop();
            }
        }

        public void switchChanged(Dpid dpid) {
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            DeviceId did = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            OpenFlowSwitch sw = OpenFlowDeviceProvider.this.controller.getSwitch(dpid);
            OpenFlowDeviceProvider.this.providerService.updatePorts(did, this.buildPortDescriptions(sw));
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
            PortDescription portDescription = this.buildPortDescription(status);
            OpenFlowDeviceProvider.this.providerService.portStatusChanged(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)), portDescription);
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
            MastershipRole request = this.roleOf(requested);
            MastershipRole reply = this.roleOf(response);
            OpenFlowDeviceProvider.this.providerService.receivedRoleReply(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)), request, reply);
        }

        private MastershipRole roleOf(RoleState response) {
            switch (response) {
                case MASTER: {
                    return MastershipRole.MASTER;
                }
                case EQUAL: {
                    return MastershipRole.STANDBY;
                }
                case SLAVE: {
                    return MastershipRole.NONE;
                }
            }
            LOG.warn("unknown role {}", (Object)response);
            return null;
        }

        private List<PortDescription> buildPortDescriptions(OpenFlowSwitch sw) {
            ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>(sw.getPorts().size());
            sw.getPorts().forEach(port -> portDescs.add(this.buildPortDescription((OFPortDesc)port)));
            if (sw.isOptical()) {
                OpenFlowOpticalSwitch opsw = (OpenFlowOpticalSwitch)sw;
                opsw.getPortTypes().forEach(type -> opsw.getPortsOf(type).forEach(op -> portDescs.add(this.buildPortDescription((PortDescPropertyType)type, (OFPortOptical)op))));
            }
            return portDescs;
        }

        private SparseAnnotations makePortNameAnnotation(String port) {
            DefaultAnnotations annotations = null;
            String portName = Strings.emptyToNull((String)port);
            if (portName != null) {
                annotations = DefaultAnnotations.builder().set("portName", portName).build();
            }
            return annotations;
        }

        private PortDescription buildPortDescription(OFPortDesc port) {
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            boolean enabled = !port.getState().contains(OFPortState.LINK_DOWN) && !port.getConfig().contains(OFPortConfig.PORT_DOWN);
            Port.Type type = port.getCurr().contains(OFPortFeatures.PF_FIBER) ? Port.Type.FIBER : Port.Type.COPPER;
            SparseAnnotations annotations = this.makePortNameAnnotation(port.getName());
            return new DefaultPortDescription(portNo, enabled, type, this.portSpeed(port), new SparseAnnotations[]{annotations});
        }

        private PortDescription buildPortDescription(PortDescPropertyType ptype, OFPortOptical port) {
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            boolean enabled = !port.getState().contains(OFPortState.LINK_DOWN) && !port.getConfig().contains(OFPortConfig.PORT_DOWN);
            SparseAnnotations annotations = this.makePortNameAnnotation(port.getName());
            if (port.getVersion() == OFVersion.OF_13 && ptype == PortDescPropertyType.OPTICAL_TRANSPORT) {
                LOG.debug("Optical transport port message {}", (Object)port.toString());
            } else {
                LOG.debug("Unsupported optical port properties");
            }
            return new DefaultPortDescription(portNo, enabled, Port.Type.FIBER, 0L, new SparseAnnotations[]{annotations});
        }

        private PortDescription buildPortDescription(OFPortStatus status) {
            OFPortDesc port = status.getDesc();
            if (status.getReason() != OFPortReason.DELETE) {
                return this.buildPortDescription(port);
            }
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            Port.Type type = port.getCurr().contains(OFPortFeatures.PF_FIBER) ? Port.Type.FIBER : Port.Type.COPPER;
            SparseAnnotations annotations = this.makePortNameAnnotation(port.getName());
            return new DefaultPortDescription(portNo, false, type, this.portSpeed(port), new SparseAnnotations[]{annotations});
        }

        private long portSpeed(OFPortDesc port) {
            if (port.getVersion() == OFVersion.OF_13) {
                return port.getCurrSpeed() / 1000000L;
            }
            PortSpeed portSpeed = PortSpeed.SPEED_NONE;
            for (OFPortFeatures feat : port.getCurr()) {
                portSpeed = PortSpeed.max((PortSpeed)portSpeed, (PortSpeed)feat.getPortSpeed());
            }
            return portSpeed.getSpeedBps() / 1000000L;
        }

        public void handleMessage(Dpid dpid, OFMessage msg) {
            switch (msg.getType()) {
                case STATS_REPLY: {
                    if (((OFStatsReply)msg).getStatsType() != OFStatsType.PORT) break;
                    OFPortStatsReply portStatsReply = (OFPortStatsReply)msg;
                    ArrayList portStatsReplyList = this.portStatsReplies.get(dpid);
                    if (portStatsReplyList == null) {
                        portStatsReplyList = Lists.newArrayList();
                    }
                    portStatsReplyList.addAll(portStatsReply.getEntries());
                    this.portStatsReplies.put(dpid, portStatsReplyList);
                    if (portStatsReply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE)) break;
                    OpenFlowDeviceProvider.this.pushPortMetrics(dpid, this.portStatsReplies.get(dpid));
                    this.portStatsReplies.get(dpid).clear();
                    break;
                }
            }
        }
    }
}

