/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.device.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.util.Timer;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortStatsRequest;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortStatsCollector
implements TimerTask {
    private final HashedWheelTimer timer = Timer.getTimer();
    private final OpenFlowSwitch sw;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int refreshInterval;
    private final AtomicLong xidAtomic = new AtomicLong(1L);
    private Timeout timeout;
    private volatile boolean stopped;

    public PortStatsCollector(OpenFlowSwitch sw, int interval) {
        this.sw = sw;
        this.refreshInterval = interval;
    }

    public void run(Timeout to) throws Exception {
        if (this.stopped || this.timeout.isCancelled()) {
            return;
        }
        this.log.trace("Collecting stats for {}", (Object)this.sw.getStringId());
        this.sendPortStatistic();
        if (!this.stopped && !this.timeout.isCancelled()) {
            this.log.trace("Scheduling stats collection in {} seconds for {}", (Object)this.refreshInterval, (Object)this.sw.getStringId());
            this.timeout.getTimer().newTimeout((TimerTask)this, (long)this.refreshInterval, TimeUnit.SECONDS);
        }
    }

    private void sendPortStatistic() {
        if (this.sw.getRole() != RoleState.MASTER) {
            return;
        }
        Long statsXid = this.xidAtomic.getAndIncrement();
        OFPortStatsRequest statsRequest = this.sw.factory().buildPortStatsRequest().setPortNo(OFPort.ANY).setXid(statsXid.longValue()).build();
        this.sw.sendMsg((OFMessage)statsRequest);
    }

    public synchronized void start() {
        this.log.info("Starting Port Stats collection thread for {}", (Object)this.sw.getStringId());
        this.stopped = false;
        this.timeout = this.timer.newTimeout((TimerTask)this, 1L, TimeUnit.SECONDS);
    }

    public synchronized void stop() {
        this.log.info("Stopping Port Stats collection thread for {}", (Object)this.sw.getStringId());
        this.stopped = true;
        this.timeout.cancel();
    }
}

