/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.device.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.device.impl.OpenFlowDeviceProvider;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.types.OFPort;

public class OpenFlowDeviceProviderTest {
    private static final ProviderId PID = new ProviderId("of", "test");
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:0000000000000001");
    private static final Dpid DPID1 = Dpid.dpid((URI)DID1.uri());
    private static final OFPortDesc PD1 = OpenFlowDeviceProviderTest.portDesc(1);
    private static final OFPortDesc PD2 = OpenFlowDeviceProviderTest.portDesc(2);
    private static final OFPortDesc PD3 = OpenFlowDeviceProviderTest.portDesc(3);
    private static final List<OFPortDesc> PLIST = Lists.newArrayList((Object[])new OFPortDesc[]{PD1, PD2});
    private static final Device DEV1 = new DefaultDevice(PID, DID1, Device.Type.SWITCH, "", "", "", "", null, new Annotations[0]);
    private static final TestOpenFlowSwitch SW1 = new TestOpenFlowSwitch();
    private final OpenFlowDeviceProvider provider = new OpenFlowDeviceProvider();
    private final TestDeviceRegistry registry = new TestDeviceRegistry();
    private final TestController controller = new TestController();

    @Before
    public void startUp() {
        this.provider.providerRegistry = this.registry;
        this.provider.controller = this.controller;
        this.provider.cfgService = new ComponentConfigAdapter();
        this.controller.switchMap.put(DPID1, SW1);
        this.provider.activate(null);
        Assert.assertNotNull((String)"provider should be registered", (Object)this.registry.provider);
        Assert.assertNotNull((String)"listener should be registered", (Object)this.controller.listener);
        Assert.assertEquals((String)"devices not added", (long)1L, (long)this.registry.connected.size());
        Assert.assertEquals((String)"ports not added", (long)2L, (long)this.registry.ports.get((Object)DID1).size());
    }

    @After
    public void tearDown() {
        this.provider.deactivate(null);
        Assert.assertNull((String)"listener should be removed", (Object)this.controller.listener);
        this.provider.controller = null;
        this.provider.providerRegistry = null;
    }

    @Test
    public void roleChanged() {
        this.provider.roleChanged(DID1, MastershipRole.MASTER);
        Assert.assertEquals((String)"Should be MASTER", (Object)RoleState.MASTER, (Object)this.controller.roleMap.get(DPID1));
        this.provider.roleChanged(DID1, MastershipRole.STANDBY);
        Assert.assertEquals((String)"Should be EQUAL", (Object)RoleState.EQUAL, (Object)this.controller.roleMap.get(DPID1));
        this.provider.roleChanged(DID1, MastershipRole.NONE);
        Assert.assertEquals((String)"Should be SLAVE", (Object)RoleState.SLAVE, (Object)this.controller.roleMap.get(DPID1));
    }

    @Test
    public void triggerProbe() {
    }

    @Test
    public void switchRemoved() {
        this.controller.listener.switchRemoved(DPID1);
        Assert.assertTrue((String)"device not removed", (boolean)this.registry.connected.isEmpty());
    }

    @Test
    public void portChanged() {
        OFPortStatus stat = SW1.factory().buildPortStatus().setReason(OFPortReason.ADD).setDesc(PD3).build();
        this.controller.listener.portChanged(DPID1, stat);
        Assert.assertNotNull((String)"never went throught the provider service", (Object)this.registry.descr);
        Assert.assertEquals((String)"port status unhandled", (long)3L, (long)this.registry.ports.get((Object)DID1).size());
    }

    @Test
    public void receivedRoleReply() {
        this.controller.listener.receivedRoleReply(DPID1, RoleState.MASTER, RoleState.MASTER);
        Assert.assertEquals((String)"wrong role reported", (Object)DPID1, (Object)this.registry.roles.get(MastershipRole.MASTER));
        this.controller.listener.receivedRoleReply(DPID1, RoleState.EQUAL, RoleState.MASTER);
        Assert.assertEquals((String)"wrong role reported", (Object)DPID1, (Object)this.registry.roles.get(MastershipRole.STANDBY));
        this.controller.listener.receivedRoleReply(DPID1, RoleState.SLAVE, RoleState.MASTER);
        Assert.assertEquals((String)"wrong role reported", (Object)DPID1, (Object)this.registry.roles.get(MastershipRole.NONE));
    }

    private static OFPortDesc portDesc(int port) {
        OFPortDesc.Builder builder = OFFactoryVer10.INSTANCE.buildPortDesc();
        builder.setPortNo(OFPort.of((int)port));
        return builder.build();
    }

    private static class TestOpenFlowSwitch
    implements OpenFlowSwitch {
        RoleState state;
        List<OFMessage> sent = new ArrayList<OFMessage>();
        OFFactory factory = OFFactoryVer10.INSTANCE;

        private TestOpenFlowSwitch() {
        }

        public void sendMsg(OFMessage msg) {
            this.sent.add(msg);
        }

        public void sendMsg(List<OFMessage> msgs) {
        }

        public void handleMessage(OFMessage fromSwitch) {
        }

        public void setRole(RoleState role) {
            this.state = role;
        }

        public RoleState getRole() {
            return this.state;
        }

        public List<OFPortDesc> getPorts() {
            return PLIST;
        }

        public OFFactory factory() {
            return this.factory;
        }

        public String getStringId() {
            return null;
        }

        public long getId() {
            return DPID1.value();
        }

        public String manufacturerDescription() {
            return null;
        }

        public String datapathDescription() {
            return null;
        }

        public String hardwareDescription() {
            return null;
        }

        public String softwareDescription() {
            return null;
        }

        public String serialNumber() {
            return null;
        }

        public boolean isConnected() {
            return true;
        }

        public void disconnectSwitch() {
        }

        public Device.Type deviceType() {
            return Device.Type.SWITCH;
        }

        public void returnRoleReply(RoleState requested, RoleState response) {
        }

        public String channelId() {
            return "1.2.3.4:1";
        }
    }

    private class TestController
    implements OpenFlowController {
        OpenFlowSwitchListener listener = null;
        Map<Dpid, RoleState> roleMap = new HashMap<Dpid, RoleState>();
        Map<Dpid, OpenFlowSwitch> switchMap = new HashMap<Dpid, OpenFlowSwitch>();

        private TestController() {
        }

        public Iterable<OpenFlowSwitch> getSwitches() {
            return this.switchMap.values();
        }

        public Iterable<OpenFlowSwitch> getMasterSwitches() {
            return null;
        }

        public Iterable<OpenFlowSwitch> getEqualSwitches() {
            return null;
        }

        public OpenFlowSwitch getSwitch(Dpid dpid) {
            return this.switchMap.get(dpid);
        }

        public OpenFlowSwitch getMasterSwitch(Dpid dpid) {
            return null;
        }

        public OpenFlowSwitch getEqualSwitch(Dpid dpid) {
            return null;
        }

        public void addListener(OpenFlowSwitchListener listener) {
            this.listener = listener;
        }

        public void removeListener(OpenFlowSwitchListener listener) {
            this.listener = null;
        }

        public void addPacketListener(int priority, PacketListener listener) {
        }

        public void removePacketListener(PacketListener listener) {
        }

        public void addEventListener(OpenFlowEventListener listener) {
        }

        public void removeEventListener(OpenFlowEventListener listener) {
        }

        public void write(Dpid dpid, OFMessage msg) {
        }

        public void processPacket(Dpid dpid, OFMessage msg) {
        }

        public void setRole(Dpid dpid, RoleState role) {
            this.roleMap.put(dpid, role);
        }
    }

    private class TestDeviceRegistry
    implements DeviceProviderRegistry {
        DeviceProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();
        Multimap<DeviceId, PortDescription> ports = HashMultimap.create();
        PortDescription descr = null;
        Map<MastershipRole, Dpid> roles = new HashMap<MastershipRole, Dpid>();

        private TestDeviceRegistry() {
        }

        public DeviceProviderService register(DeviceProvider provider) {
            this.provider = provider;
            return new TestProviderService();
        }

        public void unregister(DeviceProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestProviderService
        implements DeviceProviderService {
            private TestProviderService() {
            }

            public DeviceProvider provider() {
                return null;
            }

            public void deviceConnected(DeviceId deviceId, DeviceDescription deviceDescription) {
                TestDeviceRegistry.this.connected.add(deviceId);
            }

            public void deviceDisconnected(DeviceId deviceId) {
                TestDeviceRegistry.this.connected.remove(deviceId);
                TestDeviceRegistry.this.ports.removeAll((Object)deviceId);
            }

            public void updatePorts(DeviceId deviceId, List<PortDescription> portDescriptions) {
                for (PortDescription p : portDescriptions) {
                    TestDeviceRegistry.this.ports.put((Object)deviceId, (Object)p);
                }
            }

            public void portStatusChanged(DeviceId deviceId, PortDescription portDescription) {
                TestDeviceRegistry.this.ports.put((Object)deviceId, (Object)portDescription);
                TestDeviceRegistry.this.descr = portDescription;
            }

            public void receivedRoleReply(DeviceId deviceId, MastershipRole requested, MastershipRole response) {
                TestDeviceRegistry.this.roles.put(requested, Dpid.dpid((URI)deviceId.uri()));
            }

            public void updatePortStatistics(DeviceId deviceId, Collection<PortStatistics> portStatistics) {
            }
        }
    }
}

