/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.host.impl;

import java.net.URI;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.PacketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(immediate=true)
public class OpenFlowHostProvider
extends AbstractProvider
implements HostProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    private HostProviderService providerService;
    private final InternalHostProvider listener = new InternalHostProvider();
    private boolean ipLearn = true;

    public OpenFlowHostProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    public void activate() {
        this.providerService = (HostProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addPacketListener(10, (PacketListener)this.listener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.controller.removePacketListener((PacketListener)this.listener);
        this.providerService = null;
        this.log.info("Stopped");
    }

    public void triggerProbe(Host host) {
        this.log.info("Triggering probe on device {}", (Object)host);
    }

    protected void bindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        this.providerRegistry = hostProviderRegistry;
    }

    protected void unbindProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        if (this.providerRegistry == hostProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    private class InternalHostProvider
    implements PacketListener {
        private InternalHostProvider() {
        }

        public void handlePacket(OpenFlowPacketContext pktCtx) {
            Ethernet eth = pktCtx.parsed();
            VlanId vlan = VlanId.vlanId((short)eth.getVlanID());
            ConnectPoint heardOn = new ConnectPoint((ElementId)DeviceId.deviceId((URI)Dpid.uri((Dpid)pktCtx.dpid())), PortNumber.portNumber((long)pktCtx.inPort().intValue()));
            Topology topology = OpenFlowHostProvider.this.topologyService.currentTopology();
            if (OpenFlowHostProvider.this.topologyService.isInfrastructure(topology, heardOn)) {
                return;
            }
            HostLocation hloc = new HostLocation(DeviceId.deviceId((URI)Dpid.uri((Dpid)pktCtx.dpid())), PortNumber.portNumber((long)pktCtx.inPort().intValue()), System.currentTimeMillis());
            HostId hid = HostId.hostId((MacAddress)eth.getSourceMAC(), (VlanId)vlan);
            if (eth.getEtherType() == 2054) {
                ARP arp = (ARP)eth.getPayload();
                IpAddress ip = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])arp.getSenderProtocolAddress());
                DefaultHostDescription hdescr = new DefaultHostDescription(eth.getSourceMAC(), vlan, hloc, ip, new SparseAnnotations[0]);
                OpenFlowHostProvider.this.providerService.hostDetected(hid, (HostDescription)hdescr);
            } else if (OpenFlowHostProvider.this.ipLearn && eth.getEtherType() == 2048) {
                IPv4 pip = (IPv4)eth.getPayload();
                IpAddress ip = IpAddress.valueOf((int)pip.getSourceAddress());
                DefaultHostDescription hdescr = new DefaultHostDescription(eth.getSourceMAC(), vlan, hloc, ip, new SparseAnnotations[0]);
                OpenFlowHostProvider.this.providerService.hostDetected(hid, (HostDescription)hdescr);
            }
        }
    }
}

