/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.host.impl;

import java.net.URI;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.HostId;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyServiceAdapter;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.OpenflowControllerAdapter;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.provider.of.host.impl.OpenFlowHostProvider;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.types.OFPort;

public class OpenFlowHostProviderTest {
    private static final Integer INPORT = 10;
    private static final Dpid DPID1 = new Dpid(100L);
    private static final Dpid DPID2 = new Dpid(200L);
    private static final Dpid DPID3 = new Dpid(300L);
    private static final VlanId VLAN = VlanId.vlanId();
    private static final MacAddress MAC = MacAddress.valueOf((String)"00:00:11:00:00:01");
    private static final MacAddress BCMAC = MacAddress.valueOf((String)"ff:ff:ff:ff:ff:ff");
    private static final byte[] IP = new byte[]{10, 0, 0, 1};
    private final OpenFlowHostProvider provider = new OpenFlowHostProvider();
    private final TestHostRegistry hostService = new TestHostRegistry();
    private final TestController controller = new TestController();
    private final TestTopologyService topoService = new TestTopologyService();
    private TestHostProviderService providerService;

    @Before
    public void setUp() {
        this.provider.providerRegistry = this.hostService;
        this.provider.controller = this.controller;
        this.provider.topologyService = this.topoService;
        this.provider.activate();
    }

    @Test
    public void basics() {
        Assert.assertNotNull((String)"registration expected", (Object)((Object)this.providerService));
        Assert.assertEquals((String)"incorrect provider", (Object)this.provider, (Object)this.providerService.provider());
    }

    @Test
    public void events() {
        this.controller.processPacket(DPID1, null);
        Assert.assertNotNull((String)"new host expected", (Object)this.providerService.added);
        Assert.assertNull((String)"host motion unexpected", (Object)this.providerService.moved);
        this.controller.processPacket(DPID2, null);
        Assert.assertNotNull((String)"host motion expected", (Object)this.providerService.moved);
        this.controller.processPacket(DPID3, null);
        Assert.assertNull((String)"host misheard on spine switch", (Object)this.providerService.spine);
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.providerRegistry = null;
        this.provider.controller = null;
    }

    private class TestPacketContext
    implements OpenFlowPacketContext {
        protected Dpid swid;

        public TestPacketContext(Dpid dpid) {
            this.swid = dpid;
        }

        public boolean block() {
            return false;
        }

        public void send() {
        }

        public void build(OFPort outPort) {
        }

        public void build(Ethernet ethFrame, OFPort outPort) {
        }

        public Ethernet parsed() {
            ARP arp = new ARP();
            arp.setSenderProtocolAddress(IP).setSenderHardwareAddress(MAC.toBytes()).setTargetHardwareAddress(BCMAC.toBytes()).setTargetProtocolAddress(IP);
            Ethernet eth = new Ethernet();
            eth.setEtherType((short)2054).setVlanID(VLAN.toShort()).setSourceMACAddress(MAC).setDestinationMACAddress(BCMAC).setPayload((IPacket)arp);
            return eth;
        }

        public byte[] unparsed() {
            return null;
        }

        public Dpid dpid() {
            return this.swid;
        }

        public Integer inPort() {
            return INPORT;
        }

        public boolean isHandled() {
            return false;
        }

        public boolean isBuffered() {
            return false;
        }
    }

    private class TestTopologyService
    extends TopologyServiceAdapter {
        private TestTopologyService() {
        }

        public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
            return Dpid.dpid((URI)connectPoint.deviceId().uri()).equals((Object)DPID3);
        }
    }

    private class TestController
    extends OpenflowControllerAdapter {
        PacketListener pktListener;

        private TestController() {
        }

        public void addPacketListener(int priority, PacketListener listener) {
            this.pktListener = listener;
        }

        public void processPacket(Dpid dpid, OFMessage msg) {
            TestPacketContext ctx = new TestPacketContext(dpid);
            this.pktListener.handlePacket((OpenFlowPacketContext)ctx);
        }
    }

    private class TestHostProviderService
    extends AbstractProviderService<HostProvider>
    implements HostProviderService {
        Dpid added;
        Dpid moved;
        Dpid spine;

        protected TestHostProviderService(HostProvider provider) {
            super((Provider)provider);
            this.added = null;
            this.moved = null;
            this.spine = null;
        }

        public void hostDetected(HostId hostId, HostDescription hostDescription) {
            Dpid descr = Dpid.dpid((URI)hostDescription.location().deviceId().uri());
            if (this.added == null) {
                this.added = descr;
            } else if (this.moved == null && !descr.equals((Object)this.added)) {
                this.moved = descr;
            } else {
                this.spine = descr;
            }
        }

        public void hostVanished(HostId hostId) {
        }
    }

    private class TestHostRegistry
    implements HostProviderRegistry {
        private TestHostRegistry() {
        }

        public HostProviderService register(HostProvider provider) {
            OpenFlowHostProviderTest.this.providerService = new TestHostProviderService(provider);
            return OpenFlowHostProviderTest.this.providerService;
        }

        public void unregister(HostProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }
    }
}

