/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.link.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.DeviceId;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.link.impl.LinkDiscovery;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(immediate=true)
public class OpenFlowLinkProvider
extends AbstractProvider
implements LinkProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    private LinkProviderService providerService;
    private final boolean useBDDP = true;
    private final InternalLinkProvider listener = new InternalLinkProvider();
    protected final Map<Dpid, LinkDiscovery> discoverers = new ConcurrentHashMap<Dpid, LinkDiscovery>();

    public OpenFlowLinkProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    public void activate() {
        this.providerService = (LinkProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addListener((OpenFlowSwitchListener)this.listener);
        this.controller.addPacketListener(0, (PacketListener)this.listener);
        for (OpenFlowSwitch sw : this.controller.getSwitches()) {
            this.listener.switchAdded(new Dpid(sw.getId()));
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        for (LinkDiscovery ld : this.discoverers.values()) {
            ld.stop();
        }
        this.providerRegistry.unregister((Provider)this);
        this.controller.removeListener((OpenFlowSwitchListener)this.listener);
        this.controller.removePacketListener((PacketListener)this.listener);
        this.providerService = null;
        this.log.info("Stopped");
    }

    protected void bindProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.providerRegistry = linkProviderRegistry;
    }

    protected void unbindProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.providerRegistry == linkProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    private class InternalLinkProvider
    implements PacketListener,
    OpenFlowSwitchListener {
        private InternalLinkProvider() {
        }

        public void handlePacket(OpenFlowPacketContext pktCtx) {
            LinkDiscovery ld = OpenFlowLinkProvider.this.discoverers.get(pktCtx.dpid());
            if (ld == null) {
                return;
            }
            if (ld.handleLLDP(pktCtx.unparsed(), pktCtx.inPort())) {
                pktCtx.block();
            }
        }

        public void switchAdded(Dpid dpid) {
            OpenFlowLinkProvider.this.discoverers.put(dpid, new LinkDiscovery(OpenFlowLinkProvider.this.controller.getSwitch(dpid), OpenFlowLinkProvider.this.controller, OpenFlowLinkProvider.this.providerService, true));
        }

        public void switchRemoved(Dpid dpid) {
            LinkDiscovery ld = OpenFlowLinkProvider.this.discoverers.remove(dpid);
            if (ld != null) {
                ld.removeAllPorts();
            }
            OpenFlowLinkProvider.this.providerService.linksVanished(DeviceId.deviceId((String)("of:" + Long.toHexString(dpid.value()))));
        }

        public void switchChanged(Dpid dpid) {
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
            boolean enabled;
            LinkDiscovery ld = OpenFlowLinkProvider.this.discoverers.get(dpid);
            if (ld == null) {
                return;
            }
            OFPortDesc port = status.getDesc();
            boolean bl = enabled = !port.getState().contains(OFPortState.LINK_DOWN) && !port.getConfig().contains(OFPortConfig.PORT_DOWN);
            if (enabled) {
                ld.addPort(port);
            } else {
                ld.removePort(port);
            }
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
        }
    }
}

