/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.link.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.ONLabLddp;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.OpenflowControllerAdapter;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.link.impl.LinkDiscovery;
import org.onosproject.provider.of.link.impl.OpenFlowLinkProvider;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.types.OFPort;

public class OpenFlowLinkProviderTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:0000000000000001");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:0000000000000002");
    private static final Dpid DPID2 = Dpid.dpid((URI)DID2.uri());
    private static final Dpid DPID1 = Dpid.dpid((URI)DID1.uri());
    private static final OFPortDesc PD1 = OpenFlowLinkProviderTest.portDesc(1, true);
    private static final OFPortDesc PD2 = OpenFlowLinkProviderTest.portDesc(2, true);
    private static final OFPortDesc PD3 = OpenFlowLinkProviderTest.portDesc(1, true);
    private static final OFPortDesc PD4 = OpenFlowLinkProviderTest.portDesc(2, true);
    private static final List<OFPortDesc> PLIST1 = Lists.newArrayList((Object[])new OFPortDesc[]{PD1, PD2});
    private static final List<OFPortDesc> PLIST2 = Lists.newArrayList((Object[])new OFPortDesc[]{PD3, PD4});
    private static final TestOpenFlowSwitch SW1 = new TestOpenFlowSwitch(DPID1, PLIST1);
    private static final TestOpenFlowSwitch SW2 = new TestOpenFlowSwitch(DPID2, PLIST2);
    private final OpenFlowLinkProvider provider = new OpenFlowLinkProvider();
    private final TestLinkRegistry linkService = new TestLinkRegistry();
    private final TestController controller = new TestController();
    private TestLinkProviderService providerService;
    private TestPacketContext pktCtx;

    @Before
    public void setUp() {
        this.pktCtx = new TestPacketContext(DPID2);
        this.provider.providerRegistry = this.linkService;
        this.controller.switchMap.put(DPID1, SW1);
        this.controller.switchMap.put(DPID2, SW2);
        this.provider.controller = this.controller;
        this.provider.activate();
    }

    @Test
    public void basics() {
        Assert.assertNotNull((String)"registration expected", (Object)((Object)this.providerService));
        Assert.assertEquals((String)"incorrect provider", (Object)this.provider, (Object)this.providerService.provider());
    }

    @Test
    public void switchAdd() {
        this.controller.listener.switchAdded(DPID1);
        Assert.assertFalse((String)"Device not added", (boolean)this.provider.discoverers.isEmpty());
    }

    @Test
    public void switchRemove() {
        this.controller.listener.switchAdded(DPID1);
        this.controller.listener.switchRemoved(DPID1);
        Assert.assertTrue((String)"Discoverer is not gone", (boolean)this.provider.discoverers.isEmpty());
        Assert.assertTrue((String)"Device is not gone.", (boolean)this.vanishedDpid(DPID1));
    }

    @Test
    public void portUp() {
        this.controller.listener.switchAdded(DPID1);
        this.controller.listener.portChanged(DPID1, this.portStatus(true, 3));
        Assert.assertTrue((String)"Port not added to discoverer", (boolean)((LinkDiscovery)this.provider.discoverers.get((Object)OpenFlowLinkProviderTest.DPID1)).ports.containsKey(3));
    }

    @Test
    public void portDown() {
        this.controller.listener.switchAdded(DPID1);
        this.controller.listener.portChanged(DPID1, this.portStatus(false, 1));
        Assert.assertFalse((String)"Port added to discoverer", (boolean)((LinkDiscovery)this.provider.discoverers.get((Object)OpenFlowLinkProviderTest.DPID1)).ports.containsKey(1));
        Assert.assertTrue((String)"Port is not gone.", (boolean)this.vanishedPort(1L));
    }

    @Test
    public void portUnknown() {
        this.controller.listener.switchAdded(DPID1);
        this.controller.listener.portChanged(DPID2, this.portStatus(false, 1));
        Assert.assertNull((String)"DPID exists", this.provider.discoverers.get(DPID2));
    }

    @Test
    public void unknownPktCtx() {
        this.controller.pktListener.handlePacket((OpenFlowPacketContext)this.pktCtx);
        Assert.assertFalse((String)"Context should still be free", (boolean)this.pktCtx.isHandled());
    }

    @Test
    public void knownPktCtx() {
        this.controller.listener.switchAdded(DPID1);
        this.controller.listener.switchAdded(DPID2);
        this.controller.pktListener.handlePacket((OpenFlowPacketContext)this.pktCtx);
        Assert.assertTrue((String)"Link not detected", (boolean)this.detectedLink(DPID1, DPID2));
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.providerRegistry = null;
        this.provider.controller = null;
    }

    private OFPortStatus portStatus(boolean up, int port) {
        OFPortDesc desc = OpenFlowLinkProviderTest.portDesc(port, up);
        OFPortStatus status = OFFactoryVer10.INSTANCE.buildPortStatus().setDesc(desc).setReason(up ? OFPortReason.ADD : OFPortReason.DELETE).build();
        return status;
    }

    private static OFPortDesc portDesc(int port, boolean up) {
        OFPortDesc.Builder builder = OFFactoryVer10.INSTANCE.buildPortDesc();
        builder.setPortNo(OFPort.of((int)port));
        if (!up) {
            builder.setConfig(Collections.singleton(OFPortConfig.PORT_DOWN));
        }
        return builder.build();
    }

    private boolean vanishedDpid(Dpid ... dpids) {
        for (int i = 0; i < dpids.length; ++i) {
            if (this.providerService.vanishedDpid.contains(dpids[i])) continue;
            return false;
        }
        return true;
    }

    private boolean vanishedPort(Long ... ports) {
        for (int i = 0; i < ports.length; ++i) {
            if (this.providerService.vanishedPort.contains(ports[i])) continue;
            return false;
        }
        return true;
    }

    private boolean detectedLink(Dpid src, Dpid dst) {
        for (Dpid key : this.providerService.discoveredLinks.keySet()) {
            if (!key.equals((Object)src)) continue;
            return this.providerService.discoveredLinks.get(src).equals((Object)dst);
        }
        return false;
    }

    private static class TestOpenFlowSwitch
    implements OpenFlowSwitch {
        private final List<OFPortDesc> ports;
        private final Dpid dpid;
        RoleState state;
        List<OFMessage> sent = new ArrayList<OFMessage>();
        OFFactory factory = OFFactoryVer10.INSTANCE;

        public TestOpenFlowSwitch(Dpid dpid, List<OFPortDesc> ports) {
            this.ports = ports;
            this.dpid = dpid;
        }

        public void sendMsg(OFMessage msg) {
            this.sent.add(msg);
        }

        public void sendMsg(List<OFMessage> msgs) {
        }

        public void handleMessage(OFMessage fromSwitch) {
        }

        public void setRole(RoleState role) {
            this.state = role;
        }

        public RoleState getRole() {
            return this.state;
        }

        public List<OFPortDesc> getPorts() {
            return this.ports;
        }

        public OFFactory factory() {
            return this.factory;
        }

        public String getStringId() {
            return null;
        }

        public long getId() {
            return this.dpid.value();
        }

        public String manfacturerDescription() {
            return null;
        }

        public String datapathDescription() {
            return null;
        }

        public String hardwareDescription() {
            return null;
        }

        public String softwareDescription() {
            return null;
        }

        public String serialNumber() {
            return null;
        }

        public boolean isConnected() {
            return true;
        }

        public void disconnectSwitch() {
        }

        public boolean isOptical() {
            return false;
        }

        public void returnRoleReply(RoleState requested, RoleState reponse) {
        }

        public String channelId() {
            return "1.2.3.4:1";
        }
    }

    private class TestPacketContext
    implements OpenFlowPacketContext {
        protected Dpid swid;
        protected boolean blocked = false;

        public TestPacketContext(Dpid dpid) {
            this.swid = dpid;
        }

        public boolean block() {
            this.blocked = true;
            return this.blocked;
        }

        public void send() {
        }

        public void build(OFPort outPort) {
        }

        public void build(Ethernet ethFrame, OFPort outPort) {
        }

        public Ethernet parsed() {
            return null;
        }

        public byte[] unparsed() {
            ONLabLddp lldp = new ONLabLddp();
            lldp.setSwitch(DPID1.value());
            Ethernet ethPacket = new Ethernet();
            ethPacket.setEtherType((short)-30516);
            ethPacket.setDestinationMACAddress(ONLabLddp.LLDP_NICIRA);
            ethPacket.setPayload((IPacket)lldp);
            ethPacket.setPad(true);
            lldp.setPort(PD1.getPortNo().getPortNumber());
            ethPacket.setSourceMACAddress(PD1.getHwAddr().getBytes());
            return ethPacket.serialize();
        }

        public Dpid dpid() {
            return this.swid;
        }

        public Integer inPort() {
            return PD3.getPortNo().getPortNumber();
        }

        public boolean isHandled() {
            return this.blocked;
        }

        public boolean isBuffered() {
            return false;
        }
    }

    private class TestController
    extends OpenflowControllerAdapter {
        PacketListener pktListener;
        OpenFlowSwitchListener listener;
        Map<Dpid, OpenFlowSwitch> switchMap = new HashMap<Dpid, OpenFlowSwitch>();

        private TestController() {
        }

        public void addPacketListener(int priority, PacketListener listener) {
            this.pktListener = listener;
        }

        public void removePacketListener(PacketListener listener) {
            this.pktListener = null;
        }

        public void addListener(OpenFlowSwitchListener listener) {
            this.listener = listener;
        }

        public void removeListener(OpenFlowSwitchListener listener) {
            this.listener = null;
        }

        public void processPacket(Dpid dpid, OFMessage msg) {
            TestPacketContext ctx = new TestPacketContext(dpid);
            this.pktListener.handlePacket((OpenFlowPacketContext)ctx);
        }

        public Iterable<OpenFlowSwitch> getSwitches() {
            return Collections.emptyList();
        }

        public OpenFlowSwitch getSwitch(Dpid dpid) {
            return this.switchMap.get(dpid);
        }
    }

    private class TestLinkProviderService
    extends AbstractProviderService<LinkProvider>
    implements LinkProviderService {
        List<Dpid> vanishedDpid;
        List<Long> vanishedPort;
        Map<Dpid, Dpid> discoveredLinks;

        protected TestLinkProviderService(LinkProvider provider) {
            super((Provider)provider);
            this.vanishedDpid = Lists.newLinkedList();
            this.vanishedPort = Lists.newLinkedList();
            this.discoveredLinks = Maps.newHashMap();
        }

        public void linkDetected(LinkDescription linkDescription) {
            Dpid sDpid = Dpid.dpid((URI)linkDescription.src().deviceId().uri());
            Dpid dDpid = Dpid.dpid((URI)linkDescription.dst().deviceId().uri());
            this.discoveredLinks.put(sDpid, dDpid);
        }

        public void linkVanished(LinkDescription linkDescription) {
        }

        public void linksVanished(ConnectPoint connectPoint) {
            this.vanishedPort.add(connectPoint.port().toLong());
        }

        public void linksVanished(DeviceId deviceId) {
            this.vanishedDpid.add(Dpid.dpid((URI)deviceId.uri()));
        }
    }

    private class TestLinkRegistry
    implements LinkProviderRegistry {
        private TestLinkRegistry() {
        }

        public LinkProviderService register(LinkProvider provider) {
            OpenFlowLinkProviderTest.this.providerService = new TestLinkProviderService(provider);
            return OpenFlowLinkProviderTest.this.providerService;
        }

        public void unregister(LinkProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }
    }
}

