/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.link.impl;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.ONLabLddp;
import org.onlab.util.Timer;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPacketOut;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LinkDiscovery
implements TimerTask {
    private final OpenFlowSwitch sw;
    private final long probeRate;
    private final Set<Integer> slowPorts;
    private final Set<Integer> fastPorts;
    private final Map<Integer, AtomicInteger> portProbeCount;
    private static final short MAX_PROBE_COUNT = 3;
    private Iterator<Integer> slowIterator;
    private final OFFactory ofFactory;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ONLabLddp lldpPacket;
    private final Ethernet ethPacket;
    private Ethernet bddpEth;
    private final boolean useBDDP;
    private final OpenFlowController ctrl;
    private final LinkProviderService linkProvider;
    protected final Map<Integer, OFPortDesc> ports;
    private Timeout timeout;

    public LinkDiscovery(OpenFlowSwitch sw, OpenFlowController ctrl, LinkProviderService providerService, Boolean ... useBDDP) {
        this.sw = sw;
        this.ofFactory = sw.factory();
        this.ctrl = ctrl;
        this.probeRate = 3000L;
        this.linkProvider = providerService;
        this.slowPorts = Collections.synchronizedSet(new HashSet());
        this.fastPorts = Collections.synchronizedSet(new HashSet());
        this.ports = new ConcurrentHashMap<Integer, OFPortDesc>();
        this.portProbeCount = new HashMap<Integer, AtomicInteger>();
        this.lldpPacket = new ONLabLddp();
        this.lldpPacket.setSwitch(this.sw.getId());
        this.ethPacket = new Ethernet();
        this.ethPacket.setEtherType((short)-30516);
        this.ethPacket.setDestinationMACAddress(ONLabLddp.LLDP_NICIRA);
        this.ethPacket.setPayload((IPacket)this.lldpPacket);
        this.ethPacket.setPad(true);
        boolean bl = this.useBDDP = useBDDP.length > 0 ? useBDDP[0] : false;
        if (this.useBDDP) {
            this.bddpEth = new Ethernet();
            this.bddpEth.setPayload((IPacket)this.lldpPacket);
            this.bddpEth.setEtherType((short)-30398);
            this.bddpEth.setDestinationMACAddress(ONLabLddp.BDDP_MULTICAST);
            this.bddpEth.setPad(true);
            this.log.info("Using BDDP to discover network");
        }
        for (OFPortDesc port : sw.getPorts()) {
            if (port.getPortNo() == OFPort.LOCAL) continue;
            this.addPort(port);
        }
        this.timeout = Timer.getTimer().newTimeout((TimerTask)this, 0L, TimeUnit.MILLISECONDS);
        this.log.info("Started discovery manager for switch {}", (Object)sw.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPort(OFPortDesc port) {
        this.ports.put(port.getPortNo().getPortNumber(), port);
        LinkDiscovery linkDiscovery = this;
        synchronized (linkDiscovery) {
            this.log.debug("sending init probe to port {}", (Object)port.getPortNo().getPortNumber());
            OFPacketOut pkt = this.createLLDPPacketOut(port);
            this.sw.sendMsg((OFMessage)pkt);
            if (this.useBDDP) {
                OFPacketOut bpkt = this.createBDDPPacketOut(port);
                this.sw.sendMsg((OFMessage)bpkt);
            }
            this.slowPorts.add(port.getPortNo().getPortNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePort(OFPortDesc port) {
        int portnum = port.getPortNo().getPortNumber();
        this.ports.remove(portnum);
        LinkDiscovery linkDiscovery = this;
        synchronized (linkDiscovery) {
            if (this.slowPorts.contains(portnum)) {
                this.slowPorts.remove(portnum);
            } else if (this.fastPorts.contains(portnum)) {
                this.fastPorts.remove(portnum);
                this.portProbeCount.remove(portnum);
            } else {
                this.log.warn("tried to dynamically remove non-existing port {}", (Object)portnum);
            }
        }
        ConnectPoint cp = new ConnectPoint((ElementId)DeviceId.deviceId((URI)Dpid.uri((long)this.sw.getId())), PortNumber.portNumber((long)port.getPortNo().getPortNumber()));
        this.linkProvider.linksVanished(cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackProbe(Integer port) {
        int portNumber = port;
        LinkDiscovery linkDiscovery = this;
        synchronized (linkDiscovery) {
            if (this.slowPorts.contains(portNumber)) {
                this.log.debug("Setting slow port to fast: {}:{}", (Object)this.sw.getId(), (Object)portNumber);
                this.slowPorts.remove(portNumber);
                this.fastPorts.add(portNumber);
                this.portProbeCount.put(portNumber, new AtomicInteger(0));
            } else if (this.fastPorts.contains(portNumber)) {
                this.portProbeCount.get(portNumber).set(0);
            } else {
                this.log.debug("Got ackProbe for non-existing port: {}", (Object)portNumber);
            }
        }
    }

    private OFPacketOut createLLDPPacketOut(OFPortDesc port) {
        if (port == null) {
            return null;
        }
        OFPacketOut.Builder packetOut = this.ofFactory.buildPacketOut();
        packetOut.setBufferId(OFBufferId.NO_BUFFER);
        OFActionOutput act = this.ofFactory.actions().buildOutput().setPort(port.getPortNo()).build();
        packetOut.setActions(Collections.singletonList(act));
        this.lldpPacket.setPort(port.getPortNo().getPortNumber());
        this.ethPacket.setSourceMACAddress(port.getHwAddr().getBytes());
        byte[] lldp = this.ethPacket.serialize();
        packetOut.setData(lldp);
        return packetOut.build();
    }

    private OFPacketOut createBDDPPacketOut(OFPortDesc port) {
        if (port == null) {
            return null;
        }
        OFPacketOut.Builder packetOut = this.sw.factory().buildPacketOut();
        packetOut.setBufferId(OFBufferId.NO_BUFFER);
        OFActionOutput.Builder act = this.sw.factory().actions().buildOutput().setPort(port.getPortNo());
        OFActionOutput out = act.build();
        packetOut.setActions(Collections.singletonList(out));
        this.lldpPacket.setPort(port.getPortNo().getPortNumber());
        this.bddpEth.setSourceMACAddress(port.getHwAddr().getBytes());
        byte[] bddp = this.bddpEth.serialize();
        packetOut.setData(bddp);
        return packetOut.build();
    }

    private void sendMsg(OFMessage msg) {
        if (msg == null) {
            return;
        }
        this.sw.sendMsg(msg);
    }

    public String getName() {
        return "LinkDiscovery " + this.sw.getStringId();
    }

    public boolean handleLLDP(byte[] pkt, Integer inPort) {
        short ethType = ONLabLddp.isOVXLLDP((byte[])pkt);
        if (ethType == -30516 || ethType == -30398) {
            Integer dstPort = inPort;
            ONLabLddp.DPIDandPort dp = ONLabLddp.parseLLDP((byte[])pkt);
            OpenFlowSwitch srcSwitch = this.ctrl.getSwitch(new Dpid(dp.getDpid()));
            Integer srcPort = dp.getPort();
            if (srcSwitch == null) {
                return true;
            }
            this.ackProbe(srcPort);
            ConnectPoint src = new ConnectPoint((ElementId)DeviceId.deviceId((URI)Dpid.uri((long)srcSwitch.getId())), PortNumber.portNumber((long)srcPort.intValue()));
            ConnectPoint dst = new ConnectPoint((ElementId)DeviceId.deviceId((URI)Dpid.uri((long)this.sw.getId())), PortNumber.portNumber((long)dstPort.intValue()));
            DefaultLinkDescription ld = ethType == -30398 ? new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[0]) : new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[0]);
            this.linkProvider.linkDetected((LinkDescription)ld);
            return true;
        }
        this.log.debug("Ignoring unknown LLDP");
        return false;
    }

    private OFPortDesc findPort(Integer inPort) {
        return this.ports.get(inPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout t) {
        this.log.debug("sending probes");
        LinkDiscovery linkDiscovery = this;
        synchronized (linkDiscovery) {
            OFPortDesc port;
            Iterator<Integer> fastIterator = this.fastPorts.iterator();
            while (fastIterator.hasNext()) {
                Integer portNumber = fastIterator.next();
                port = this.findPort(portNumber);
                if (port == null) continue;
                int probeCount = this.portProbeCount.get(portNumber).getAndIncrement();
                if (probeCount < 3) {
                    this.log.debug("sending fast probe to port");
                    OFPacketOut pkt = this.createLLDPPacketOut(port);
                    this.sendMsg((OFMessage)pkt);
                    if (!this.useBDDP) continue;
                    OFPacketOut bpkt = this.createBDDPPacketOut(port);
                    this.sendMsg((OFMessage)bpkt);
                    continue;
                }
                fastIterator.remove();
                this.slowPorts.add(portNumber);
                this.portProbeCount.remove(portNumber);
                OFPortDesc srcPort = port;
                ConnectPoint cp = new ConnectPoint((ElementId)DeviceId.deviceId((URI)Dpid.uri((long)this.sw.getId())), PortNumber.portNumber((long)srcPort.getPortNo().getPortNumber()));
                this.linkProvider.linksVanished(cp);
            }
            if (!this.slowPorts.isEmpty()) {
                for (int portNumber : this.slowPorts) {
                    this.log.debug("sending slow probe to port {}", (Object)portNumber);
                    port = this.findPort(portNumber);
                    OFPacketOut pkt = this.createLLDPPacketOut(port);
                    this.sendMsg((OFMessage)pkt);
                    if (!this.useBDDP) continue;
                    OFPacketOut bpkt = this.createBDDPPacketOut(port);
                    this.sendMsg((OFMessage)bpkt);
                }
            }
        }
        this.timeout = Timer.getTimer().newTimeout((TimerTask)this, this.probeRate, TimeUnit.MILLISECONDS);
    }

    public void removeAllPorts() {
        for (OFPortDesc port : this.ports.values()) {
            this.removePort(port);
        }
    }

    public void stop() {
        this.timeout.cancel();
        this.removeAllPorts();
    }
}

