/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.message.impl;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.metrics.MetricsService;
import org.onlab.util.SharedScheduledExecutors;
import org.onosproject.cpman.message.ControlMessageProvider;
import org.onosproject.cpman.message.ControlMessageProviderRegistry;
import org.onosproject.cpman.message.ControlMessageProviderService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.message.impl.OpenFlowControlMessageAggregator;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenFlowControlMessageProvider
extends AbstractProvider
implements ControlMessageProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ControlMessageProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    private ControlMessageProviderService providerService;
    private final InternalDeviceProvider listener = new InternalDeviceProvider();
    private final InternalIncomingMessageProvider inMsgListener = new InternalIncomingMessageProvider();
    private final InternalOutgoingMessageProvider outMsgListener = new InternalOutgoingMessageProvider();
    private HashMap<Dpid, OpenFlowControlMessageAggregator> aggregators = Maps.newHashMap();
    private ScheduledExecutorService executor;
    private static final int AGGR_INIT_DELAY = 1;
    private static final int AGGR_PERIOD = 1;
    private static final TimeUnit AGGR_TIME_UNIT = TimeUnit.MINUTES;
    private HashMap<Dpid, ScheduledFuture<?>> executorResults = Maps.newHashMap();

    public OpenFlowControlMessageProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    protected void activate() {
        this.providerService = (ControlMessageProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addListener((OpenFlowSwitchListener)this.listener);
        this.controller.addEventListener((OpenFlowEventListener)this.inMsgListener);
        this.controller.monitorAllEvents(true);
        this.controller.getSwitches().forEach(sw -> sw.addEventListener((OpenFlowEventListener)this.outMsgListener));
        this.executor = SharedScheduledExecutors.getSingleThreadExecutor();
        this.connectInitialDevices();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.controller.removeListener((OpenFlowSwitchListener)this.listener);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.controller.monitorAllEvents(false);
        this.controller.removeEventListener((OpenFlowEventListener)this.inMsgListener);
        this.controller.getSwitches().forEach(sw -> sw.removeEventListener((OpenFlowEventListener)this.outMsgListener));
        this.log.info("Stopped");
    }

    private void connectInitialDevices() {
        for (OpenFlowSwitch sw : this.controller.getSwitches()) {
            try {
                this.listener.switchAdded(new Dpid(sw.getId()));
            }
            catch (Exception e) {
                this.log.warn("Failed initially adding {} : {}", (Object)sw.getStringId(), (Object)e.getMessage());
                this.log.debug("Error details:", (Throwable)e);
            }
        }
    }

    protected void bindProviderRegistry(ControlMessageProviderRegistry controlMessageProviderRegistry) {
        this.providerRegistry = controlMessageProviderRegistry;
    }

    protected void unbindProviderRegistry(ControlMessageProviderRegistry controlMessageProviderRegistry) {
        if (this.providerRegistry == controlMessageProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    private class InternalOutgoingMessageProvider
    implements OpenFlowEventListener {
        private InternalOutgoingMessageProvider() {
        }

        public void handleMessage(Dpid dpid, OFMessage msg) {
            ((OpenFlowControlMessageAggregator)OpenFlowControlMessageProvider.this.aggregators.get(dpid)).increment(msg);
        }
    }

    private class InternalIncomingMessageProvider
    implements OpenFlowEventListener {
        private InternalIncomingMessageProvider() {
        }

        public void handleMessage(Dpid dpid, OFMessage msg) {
            ((OpenFlowControlMessageAggregator)OpenFlowControlMessageProvider.this.aggregators.get(dpid)).increment(msg);
        }
    }

    private class InternalDeviceProvider
    implements OpenFlowSwitchListener {
        private InternalDeviceProvider() {
        }

        public void switchAdded(Dpid dpid) {
            if (OpenFlowControlMessageProvider.this.providerService == null) {
                return;
            }
            OpenFlowSwitch sw = OpenFlowControlMessageProvider.this.controller.getSwitch(dpid);
            if (sw != null) {
                sw.addEventListener((OpenFlowEventListener)OpenFlowControlMessageProvider.this.outMsgListener);
            }
            DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            OpenFlowControlMessageAggregator ofcma = new OpenFlowControlMessageAggregator(OpenFlowControlMessageProvider.this.metricsService, OpenFlowControlMessageProvider.this.providerService, deviceId);
            ScheduledFuture<?> result = OpenFlowControlMessageProvider.this.executor.scheduleAtFixedRate(ofcma, 1L, 1L, AGGR_TIME_UNIT);
            OpenFlowControlMessageProvider.this.aggregators.put(dpid, ofcma);
            OpenFlowControlMessageProvider.this.executorResults.put(dpid, result);
        }

        public void switchRemoved(Dpid dpid) {
            OpenFlowControlMessageAggregator aggregator;
            if (OpenFlowControlMessageProvider.this.providerService == null) {
                return;
            }
            OpenFlowSwitch sw = OpenFlowControlMessageProvider.this.controller.getSwitch(dpid);
            if (sw != null) {
                sw.removeEventListener((OpenFlowEventListener)OpenFlowControlMessageProvider.this.outMsgListener);
            }
            if ((aggregator = (OpenFlowControlMessageAggregator)OpenFlowControlMessageProvider.this.aggregators.remove(dpid)) != null) {
                ((ScheduledFuture)OpenFlowControlMessageProvider.this.executorResults.get(dpid)).cancel(true);
                OpenFlowControlMessageProvider.this.executorResults.remove(dpid);
            }
        }

        public void switchChanged(Dpid dpid) {
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
        }
    }
}

