/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.message.impl;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.metrics.MetricsService;
import org.onlab.util.SharedScheduledExecutorService;
import org.onlab.util.SharedScheduledExecutors;
import org.onosproject.cpman.message.ControlMessageProvider;
import org.onosproject.cpman.message.ControlMessageProviderRegistry;
import org.onosproject.cpman.message.ControlMessageProviderService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowMessageListener;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.message.impl.OpenFlowControlMessageAggregator;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenFlowControlMessageProvider
extends AbstractProvider
implements ControlMessageProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ControlMessageProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    private ControlMessageProviderService providerService;
    private final InternalDeviceProvider listener = new InternalDeviceProvider();
    private final InternalControlMessageListener messageListener = new InternalControlMessageListener();
    private HashMap<Dpid, OpenFlowControlMessageAggregator> aggregators = Maps.newHashMap();
    private SharedScheduledExecutorService executor;
    private static final int AGGR_INIT_DELAY = 1;
    private static final int AGGR_PERIOD = 1;
    private static final TimeUnit AGGR_TIME_UNIT = TimeUnit.MINUTES;
    private HashMap<Dpid, ScheduledFuture<?>> executorResults = Maps.newHashMap();

    public OpenFlowControlMessageProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    protected void activate() {
        this.providerService = (ControlMessageProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addListener((OpenFlowSwitchListener)this.listener);
        this.controller.addMessageListener((OpenFlowMessageListener)this.messageListener);
        this.executor = SharedScheduledExecutors.getSingleThreadExecutor();
        this.connectInitialDevices();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.controller.removeListener((OpenFlowSwitchListener)this.listener);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.controller.removeMessageListener((OpenFlowMessageListener)this.messageListener);
        this.log.info("Stopped");
    }

    private void connectInitialDevices() {
        for (OpenFlowSwitch sw : this.controller.getSwitches()) {
            try {
                this.listener.switchAdded(new Dpid(sw.getId()));
            }
            catch (Exception e) {
                this.log.warn("Failed initially adding {} : {}", (Object)sw.getStringId(), (Object)e.getMessage());
                this.log.debug("Error details:", (Throwable)e);
            }
        }
    }

    protected void bindProviderRegistry(ControlMessageProviderRegistry controlMessageProviderRegistry) {
        this.providerRegistry = controlMessageProviderRegistry;
    }

    protected void unbindProviderRegistry(ControlMessageProviderRegistry controlMessageProviderRegistry) {
        if (this.providerRegistry == controlMessageProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    private class InternalControlMessageListener
    implements OpenFlowMessageListener {
        private InternalControlMessageListener() {
        }

        public void handleIncomingMessage(Dpid dpid, OFMessage msg) {
            if (msg.getType() == OFType.PACKET_IN || msg.getType() == OFType.FLOW_MOD || msg.getType() == OFType.STATS_REPLY) {
                OpenFlowControlMessageProvider.this.aggregators.computeIfPresent(dpid, (k, v) -> {
                    v.increment(msg);
                    return v;
                });
            }
        }

        public void handleOutgoingMessage(Dpid dpid, List<OFMessage> msgs) {
            for (OFMessage msg : msgs) {
                if (msg.getType() != OFType.PACKET_OUT && msg.getType() != OFType.FLOW_MOD && msg.getType() != OFType.STATS_REQUEST) continue;
                OpenFlowControlMessageProvider.this.aggregators.computeIfPresent(dpid, (k, v) -> {
                    v.increment(msg);
                    return v;
                });
            }
        }
    }

    private class InternalDeviceProvider
    implements OpenFlowSwitchListener {
        private InternalDeviceProvider() {
        }

        public void switchAdded(Dpid dpid) {
            if (OpenFlowControlMessageProvider.this.providerService == null) {
                return;
            }
            DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            OpenFlowControlMessageAggregator ofcma = new OpenFlowControlMessageAggregator(OpenFlowControlMessageProvider.this.metricsService, OpenFlowControlMessageProvider.this.providerService, deviceId);
            ScheduledFuture result = OpenFlowControlMessageProvider.this.executor.scheduleAtFixedRate((Runnable)ofcma, 1L, 1L, AGGR_TIME_UNIT, true);
            OpenFlowControlMessageProvider.this.aggregators.put(dpid, ofcma);
            OpenFlowControlMessageProvider.this.executorResults.put(dpid, result);
        }

        public void switchRemoved(Dpid dpid) {
            if (OpenFlowControlMessageProvider.this.providerService == null) {
                return;
            }
            OpenFlowControlMessageAggregator aggregator = (OpenFlowControlMessageAggregator)OpenFlowControlMessageProvider.this.aggregators.remove(dpid);
            if (aggregator != null) {
                ((ScheduledFuture)OpenFlowControlMessageProvider.this.executorResults.get(dpid)).cancel(true);
                OpenFlowControlMessageProvider.this.executorResults.remove(dpid);
            }
        }

        public void switchChanged(Dpid dpid) {
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
        }
    }
}

