/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.area;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfAreaAddressRange;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfNbr;
import org.onosproject.ospf.controller.OspfNeighborState;
import org.onosproject.ospf.controller.TopologyForDeviceAndLink;
import org.onosproject.ospf.controller.area.OspfAreaAddressRangeImpl;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.Controller;
import org.onosproject.ospf.controller.impl.OspfInterfaceChannelHandler;
import org.onosproject.ospf.controller.impl.OspfNbrImpl;
import org.onosproject.ospf.controller.impl.TopologyForDeviceAndLinkImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;

public class OspfAreaImplTest {
    private OspfAreaImpl ospfArea;
    private int result;
    private OspfInterfaceImpl ospfInterface;
    private HashMap<String, OspfNbr> ospfNbrList;
    private List<OspfInterface> ospfInterfaces;
    private OspfInterfaceImpl ospfInterface1;
    private OspfInterfaceImpl ospfInterface2;
    private OspfInterfaceImpl ospfInterface3;
    private OspfInterfaceImpl ospfInterface4;
    private OspfInterfaceImpl ospfInterface5;
    private OspfInterfaceImpl ospfInterface6;
    private NetworkLsa networkLsa;
    private OspfNbrImpl ospfNbr;
    private RouterLsa routerLsa;
    private List<OspfAreaAddressRange> ospfAreaAddressRanges;
    private LsaHeader lsaHeader;
    private TopologyForDeviceAndLink topologyForDeviceAndLink;

    @Before
    public void setUp() throws Exception {
        this.ospfArea = new OspfAreaImpl();
        this.topologyForDeviceAndLink = new TopologyForDeviceAndLinkImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.ospfArea = null;
        this.ospfInterface = null;
        this.ospfNbrList = null;
        this.ospfInterfaces = null;
        this.ospfAreaAddressRanges = null;
        this.lsaHeader = null;
        this.routerLsa = null;
        this.ospfNbr = null;
        this.networkLsa = null;
        this.ospfInterface1 = null;
        this.ospfInterface2 = null;
        this.ospfInterface3 = null;
        this.ospfInterface4 = null;
        this.ospfInterface5 = null;
        this.ospfInterface6 = null;
    }

    @Test
    public void testEquals() throws Exception {
        this.ospfArea = new OspfAreaImpl();
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfArea.setTransitCapability(true);
        this.ospfArea.setExternalRoutingCapability(true);
        this.ospfArea.setStubCost(100);
        this.ospfArea.initializeDb();
        this.ospfArea.setAddressRanges(this.ospfAreaAddressRanges);
        MatcherAssert.assertThat((Object)this.ospfArea.equals((Object)this.ospfArea), (Matcher)Matchers.is((Object)true));
        this.ospfArea = (OspfAreaImpl)EasyMock.createMock(OspfAreaImpl.class);
        MatcherAssert.assertThat((Object)this.ospfArea.equals((Object)this.ospfArea), (Matcher)Matchers.is((Object)true));
        OspfAreaImpl ospfArea = new OspfAreaImpl();
        MatcherAssert.assertThat((Object)ospfArea.equals(ospfArea), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        this.result = this.ospfArea.hashCode();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetRouterId() throws Exception {
        this.ospfArea.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfArea.routerId(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetRouterId() throws Exception {
        this.ospfArea.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfArea.routerId(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetisOpaqueEnabled() throws Exception {
        this.ospfArea.setIsOpaqueEnabled(true);
        MatcherAssert.assertThat((Object)this.ospfArea.isOpaqueEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsOpaqueEnabled() throws Exception {
        this.ospfArea.setIsOpaqueEnabled(true);
        MatcherAssert.assertThat((Object)this.ospfArea.isOpaqueEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testInitializeDb() throws Exception {
        this.ospfArea.initializeDb();
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testRefreshArea() throws Exception {
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterface.setState(OspfInterfaceState.DR);
        this.ospfNbrList = new HashMap();
        this.ospfNbrList.put("1.1.1.1", (OspfNbr)new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink));
        this.ospfNbrList.put("2.2.2.2", (OspfNbr)new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink));
        this.ospfNbrList.put("3.3.3.3", (OspfNbr)new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink));
        this.ospfNbrList.put("4.4.4.4", (OspfNbr)new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink));
        this.ospfInterface.setListOfNeighbors(this.ospfNbrList);
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfInterface2 = new OspfInterfaceImpl();
        this.ospfInterface2.setIpAddress(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface2);
        this.ospfInterface3 = new OspfInterfaceImpl();
        this.ospfInterface3.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface3);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfArea.setRouterId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.networkLsa = this.ospfArea.buildNetworkLsa(Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfArea.refreshArea((OspfInterface)this.ospfInterface);
        MatcherAssert.assertThat((Object)this.ospfNbrList.size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)this.networkLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testBuildNetworkLsa() throws Exception {
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfInterface2 = new OspfInterfaceImpl();
        this.ospfInterface2.setIpAddress(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface2);
        this.ospfInterface3 = new OspfInterfaceImpl();
        this.ospfInterface3.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface3);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfArea.setRouterId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.networkLsa = this.ospfArea.buildNetworkLsa(Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"255.255.255.255"));
        MatcherAssert.assertThat((Object)this.ospfInterfaces.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.networkLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testBuildNetworkLsa1() throws Exception {
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterface1.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface1.setState(OspfInterfaceState.POINT2POINT);
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfInterface1.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfArea.setRouterId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.networkLsa = this.ospfArea.buildNetworkLsa(Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"255.255.255.255"));
        MatcherAssert.assertThat((Object)this.ospfInterfaces.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.networkLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testBuildRouterLsa() throws Exception {
        this.ospfNbrList = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterface1.setState(OspfInterfaceState.DOWN);
        this.ospfInterface1.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfInterface2 = new OspfInterfaceImpl();
        this.ospfInterface2.setState(OspfInterfaceState.LOOPBACK);
        this.ospfInterface2.setIpAddress(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfInterface2.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface2);
        this.ospfInterface3 = new OspfInterfaceImpl();
        this.ospfInterface3.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterface3.setState(OspfInterfaceState.POINT2POINT);
        this.ospfInterface3.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface3.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterface3.setListOfNeighbors(this.ospfNbrList);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface3);
        this.ospfInterface4 = new OspfInterfaceImpl();
        this.ospfInterface4.setState(OspfInterfaceState.WAITING);
        this.ospfInterface4.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterface4.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface4);
        this.ospfInterface5 = new OspfInterfaceImpl();
        this.ospfInterface5.setState(OspfInterfaceState.DR);
        this.ospfInterface5.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface5);
        this.ospfInterface6 = new OspfInterfaceImpl();
        this.ospfInterface6.setState(OspfInterfaceState.BDR);
        this.ospfInterface6.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterface6.setDr(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface6);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfArea.setRouterId(Ip4Address.valueOf((String)"111.111.111.111"));
        MatcherAssert.assertThat((Object)this.ospfInterfaces.size(), (Matcher)Matchers.is((Object)6));
        this.routerLsa = this.ospfArea.buildRouterLsa((OspfInterface)this.ospfInterface1);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.routerLsa = this.ospfArea.buildRouterLsa((OspfInterface)this.ospfInterface2);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.routerLsa = this.ospfArea.buildRouterLsa((OspfInterface)this.ospfInterface3);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testBuildRouterLsa1() throws Exception {
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterface1.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface1.setState(OspfInterfaceState.POINT2POINT);
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfInterface1.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfArea.setRouterId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.routerLsa = this.ospfArea.buildRouterLsa((OspfInterface)this.ospfInterface1);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetAreaId() throws Exception {
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfArea.areaId(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetAreaId() throws Exception {
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfArea.areaId(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testGetAddressRanges() throws Exception {
        this.ospfAreaAddressRanges = new ArrayList<OspfAreaAddressRange>();
        this.ospfAreaAddressRanges.add((OspfAreaAddressRange)new OspfAreaAddressRangeImpl());
        this.ospfAreaAddressRanges.add((OspfAreaAddressRange)new OspfAreaAddressRangeImpl());
        this.ospfAreaAddressRanges.add((OspfAreaAddressRange)new OspfAreaAddressRangeImpl());
        this.ospfAreaAddressRanges.add((OspfAreaAddressRange)new OspfAreaAddressRangeImpl());
        this.ospfArea.setAddressRanges(this.ospfAreaAddressRanges);
        MatcherAssert.assertThat((Object)this.ospfArea.addressRanges().size(), (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testSetAddressRanges() throws Exception {
        this.ospfAreaAddressRanges = new ArrayList<OspfAreaAddressRange>();
        this.ospfAreaAddressRanges.add((OspfAreaAddressRange)new OspfAreaAddressRangeImpl());
        this.ospfAreaAddressRanges.add((OspfAreaAddressRange)new OspfAreaAddressRangeImpl());
        this.ospfAreaAddressRanges.add((OspfAreaAddressRange)new OspfAreaAddressRangeImpl());
        this.ospfAreaAddressRanges.add((OspfAreaAddressRange)new OspfAreaAddressRangeImpl());
        this.ospfArea.setAddressRanges(this.ospfAreaAddressRanges);
        MatcherAssert.assertThat((Object)this.ospfArea.addressRanges().size(), (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testIsTransitCapability() throws Exception {
        this.ospfArea.setTransitCapability(true);
        MatcherAssert.assertThat((Object)this.ospfArea.isTransitCapability(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testSetTransitCapability() throws Exception {
        this.ospfArea.setTransitCapability(true);
        MatcherAssert.assertThat((Object)this.ospfArea.isTransitCapability(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsExternalRoutingCapability() throws Exception {
        this.ospfArea.setExternalRoutingCapability(true);
        MatcherAssert.assertThat((Object)this.ospfArea.isExternalRoutingCapability(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testSetExternalRoutingCapability() throws Exception {
        this.ospfArea.setExternalRoutingCapability(true);
        MatcherAssert.assertThat((Object)this.ospfArea.isExternalRoutingCapability(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetStubCost() throws Exception {
        this.ospfArea.setStubCost(100);
        MatcherAssert.assertThat((Object)this.ospfArea.stubCost(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testSetStubCost() throws Exception {
        this.ospfArea.setStubCost(100);
        MatcherAssert.assertThat((Object)this.ospfArea.stubCost(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testGetInterfacesLst() throws Exception {
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfInterface2 = new OspfInterfaceImpl();
        this.ospfInterface2.setIpAddress(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface2);
        this.ospfInterface3 = new OspfInterfaceImpl();
        this.ospfInterface3.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface3);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        MatcherAssert.assertThat((Object)this.ospfInterfaces.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.ospfArea.getInterfacesLst(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testSetInterfacesLst() throws Exception {
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfInterface2 = new OspfInterfaceImpl();
        this.ospfInterface2.setIpAddress(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface2);
        this.ospfInterface3 = new OspfInterfaceImpl();
        this.ospfInterface3.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface3);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        MatcherAssert.assertThat((Object)this.ospfInterfaces.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.ospfArea.getInterfacesLst(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testNoNeighborInLsaExchangeProcess() throws Exception {
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        this.ospfInterface1.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        MatcherAssert.assertThat((Object)this.ospfArea.noNeighborInLsaExchangeProcess(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetLsaHeaders() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfArea.getLsaHeaders(true, true).size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testGetLsa() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfArea.getLsa(1, "1.1.1.1", "1.1.1.1"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)this.ospfArea.getLsa(10, "1.1.1.1", "1.1.1.1"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testLsaLookup() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfArea.lsaLookup((OspfLsa)new RouterLsa()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testIsNewerOrSameLsa() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfArea.isNewerOrSameLsa((OspfLsa)new RouterLsa(), (OspfLsa)new RouterLsa()), (Matcher)Matchers.is((Object)"same"));
    }

    @Test
    public void testAddLsa() throws Exception {
        this.ospfArea.addLsa((OspfLsa)new RouterLsa(), (OspfInterface)new OspfInterfaceImpl());
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddLsa1() throws Exception {
        this.ospfArea.addLsa((OspfLsa)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddLsaToMaxAgeBin() throws Exception {
        this.ospfArea.addLsaToMaxAgeBin("111", (LsaWrapper)new LsaWrapperImpl());
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testSetDbRouterSequenceNumber() throws Exception {
        this.ospfArea.setDbRouterSequenceNumber(123456L);
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testDeleteLsa() throws Exception {
        this.ospfArea.deleteLsa(new LsaHeader());
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testRemoveLsaFromBin() throws Exception {
        this.ospfArea.removeLsaFromBin((LsaWrapper)new LsaWrapperImpl());
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfArea.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetNeighborsinFullState() throws Exception {
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfInterface1.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        MatcherAssert.assertThat((Object)this.ospfArea.getNeighborsInFullState((OspfInterface)this.ospfInterface1).size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGetLsaKey() throws Exception {
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfArea.getLsaKey(this.lsaHeader), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddToOtherNeighborLsaTxList() throws Exception {
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfInterface1.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfArea.addToOtherNeighborLsaTxList(this.lsaHeader);
        MatcherAssert.assertThat((Object)this.ospfArea, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOptions() throws Exception {
        this.ospfArea.setOptions(2);
        MatcherAssert.assertThat((Object)this.ospfArea.options(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testSetOptions() throws Exception {
        this.ospfArea.setOptions(2);
        MatcherAssert.assertThat((Object)this.ospfArea.options(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetOpaqueEnabledOptions() throws Exception {
        this.ospfArea.setIsOpaqueEnabled(true);
        MatcherAssert.assertThat((Object)this.ospfArea.isOpaqueEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetDatabase() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfArea.database(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testOpaqueEnabledOptionsa() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfArea.opaqueEnabledOptions(), (Matcher)Matchers.is((Object)66));
    }
}

