/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.area;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfNbr;
import org.onosproject.ospf.controller.TopologyForDeviceAndLink;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.Controller;
import org.onosproject.ospf.controller.impl.OspfInterfaceChannelHandler;
import org.onosproject.ospf.controller.impl.OspfNbrImpl;
import org.onosproject.ospf.controller.impl.TopologyForDeviceAndLinkImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;

public class OspfInterfaceImplTest {
    private OspfInterfaceImpl ospfInterface;
    private OspfNbrImpl ospfNbr;
    private OpaqueLsaHeader opaqueLsaHeader;
    private int result;
    private HashMap<String, OspfNbr> ospfNbrHashMap;
    private TopologyForDeviceAndLink topologyForDeviceAndLink;

    @Before
    public void setUp() throws Exception {
        this.ospfInterface = new OspfInterfaceImpl();
        this.topologyForDeviceAndLink = new TopologyForDeviceAndLinkImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.ospfInterface = null;
        this.ospfNbr = null;
        this.opaqueLsaHeader = null;
        this.ospfNbrHashMap = null;
    }

    @Test
    public void testGetState() throws Exception {
        this.ospfInterface.setState(OspfInterfaceState.DROTHER);
        MatcherAssert.assertThat((Object)this.ospfInterface.state(), (Matcher)Matchers.is((Object)OspfInterfaceState.DROTHER));
    }

    @Test
    public void testSetState() throws Exception {
        this.ospfInterface.setState(OspfInterfaceState.DROTHER);
        MatcherAssert.assertThat((Object)this.ospfInterface.state(), (Matcher)Matchers.is((Object)OspfInterfaceState.DROTHER));
    }

    @Test
    public void testGetLinkStateHeaders() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfInterface.linkStateHeaders().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testGetIpNetworkMask() throws Exception {
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfInterface.ipNetworkMask(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetIpNetworkMask() throws Exception {
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfInterface.ipNetworkMask(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testAddNeighbouringRouter() throws Exception {
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        MatcherAssert.assertThat((Object)this.ospfInterface, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetNeighbouringRouter() throws Exception {
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        MatcherAssert.assertThat((Object)this.ospfInterface.neighbouringRouter("111.111.111.111"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddLsaHeaderForDelayAck() throws Exception {
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(10);
        this.ospfInterface.addLsaHeaderForDelayAck((LsaHeader)this.opaqueLsaHeader);
        MatcherAssert.assertThat((Object)this.ospfInterface, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testRemoveLsaFromNeighborMap() throws Exception {
        this.ospfInterface.removeLsaFromNeighborMap("lsa10");
        MatcherAssert.assertThat((Object)this.ospfInterface, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testIsNeighborinList() throws Exception {
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        MatcherAssert.assertThat((Object)this.ospfInterface.isNeighborInList("111.111.111.111"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetListOfNeighbors() throws Exception {
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfNbrHashMap.put("111.111.111.111", (OspfNbr)this.ospfNbr);
        this.ospfInterface.setListOfNeighbors(this.ospfNbrHashMap);
        MatcherAssert.assertThat((Object)this.ospfInterface.listOfNeighbors().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetListOfNeighbors() throws Exception {
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfNbrHashMap.put("111.111.111.111", (OspfNbr)this.ospfNbr);
        this.ospfInterface.setListOfNeighbors(this.ospfNbrHashMap);
        MatcherAssert.assertThat((Object)this.ospfInterface.listOfNeighbors().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGetIpAddress() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfInterface.ipAddress(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetIpAddress() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfInterface.ipAddress(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testGetRouterPriority() throws Exception {
        this.ospfInterface.setRouterPriority(1);
        Assert.assertEquals((long)1L, (long)this.ospfInterface.routerPriority());
    }

    @Test
    public void testSetRouterPriority() throws Exception {
        this.ospfInterface.setRouterPriority(1);
        MatcherAssert.assertThat((Object)this.ospfInterface.routerPriority(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGetAreaId() throws Exception {
        this.ospfInterface.setAreaId(1);
        MatcherAssert.assertThat((Object)this.ospfInterface.areaId(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetAreaId() throws Exception {
        this.ospfInterface.setAreaId(1);
        MatcherAssert.assertThat((Object)this.ospfInterface.areaId(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGetHelloIntervalTime() throws Exception {
        this.ospfInterface.setHelloIntervalTime(10);
        MatcherAssert.assertThat((Object)this.ospfInterface.helloIntervalTime(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testSetHelloIntervalTime() throws Exception {
        this.ospfInterface.setHelloIntervalTime(10);
        MatcherAssert.assertThat((Object)this.ospfInterface.helloIntervalTime(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testGetRouterDeadIntervalTime() throws Exception {
        this.ospfInterface.setRouterDeadIntervalTime(10);
        MatcherAssert.assertThat((Object)this.ospfInterface.routerDeadIntervalTime(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testSetRouterDeadIntervalTime() throws Exception {
        this.ospfInterface.setRouterDeadIntervalTime(10);
        MatcherAssert.assertThat((Object)this.ospfInterface.routerDeadIntervalTime(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testGetInterfaceType() throws Exception {
        this.ospfInterface.setInterfaceType(1);
        MatcherAssert.assertThat((Object)this.ospfInterface.interfaceType(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetInterfaceType() throws Exception {
        this.ospfInterface.setInterfaceType(1);
        MatcherAssert.assertThat((Object)this.ospfInterface.interfaceType(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGetInterfaceCost() throws Exception {
        this.ospfInterface.setInterfaceCost(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.interfaceCost(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testSetInterfaceCost() throws Exception {
        this.ospfInterface.setInterfaceCost(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.interfaceCost(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testGetAuthType() throws Exception {
        this.ospfInterface.setAuthType("00");
        MatcherAssert.assertThat((Object)this.ospfInterface.authType(), (Matcher)Matchers.is((Object)"00"));
    }

    @Test
    public void testSetAuthType() throws Exception {
        this.ospfInterface.setAuthType("00");
        MatcherAssert.assertThat((Object)this.ospfInterface.authType(), (Matcher)Matchers.is((Object)"00"));
    }

    @Test
    public void testGetAuthKey() throws Exception {
        this.ospfInterface.setAuthKey("00");
        MatcherAssert.assertThat((Object)this.ospfInterface.authKey(), (Matcher)Matchers.is((Object)"00"));
    }

    @Test
    public void testSetAuthKey() throws Exception {
        this.ospfInterface.setAuthKey("00");
        MatcherAssert.assertThat((Object)this.ospfInterface.authKey(), (Matcher)Matchers.is((Object)"00"));
    }

    @Test
    public void testGetPollInterval() throws Exception {
        this.ospfInterface.setPollInterval(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.pollInterval(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testSetPollInterval() throws Exception {
        this.ospfInterface.setPollInterval(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.pollInterval(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testGetMtu() throws Exception {
        this.ospfInterface.setMtu(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.mtu(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testSetMtu() throws Exception {
        this.ospfInterface.setMtu(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.mtu(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testGetReTransmitInterval() throws Exception {
        this.ospfInterface.setReTransmitInterval(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.reTransmitInterval(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testSetReTransmitInterval() throws Exception {
        this.ospfInterface.setReTransmitInterval(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.reTransmitInterval(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testGetDr() throws Exception {
        this.ospfInterface.setDr(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfInterface.dr(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetDr() throws Exception {
        this.ospfInterface.setDr(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfInterface.dr(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testGetBdr() throws Exception {
        this.ospfInterface.setBdr(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfInterface.bdr(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetBdr() throws Exception {
        this.ospfInterface.setBdr(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfInterface.bdr(), (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testGetTransmitDelay() throws Exception {
        this.ospfInterface.setTransmitDelay(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.transmitDelay(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testSetTransmitDelay() throws Exception {
        this.ospfInterface.setTransmitDelay(100);
        MatcherAssert.assertThat((Object)this.ospfInterface.transmitDelay(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfInterface.equals((Object)new OspfInterfaceImpl()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        this.result = this.ospfInterface.hashCode();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfInterface.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

