/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.driver.DriverService;
import org.onosproject.ospf.controller.OspfAgent;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfProcess;
import org.onosproject.ospf.controller.OspfRouter;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.area.OspfProcessImpl;
import org.onosproject.ospf.controller.impl.Controller;
import org.onosproject.ospf.controller.impl.OspfLinkTedImpl;
import org.onosproject.ospf.controller.impl.OspfRouterImpl;

public class ControllerTest {
    private Controller controller;
    private Map<String, Long> maps;
    private OspfAgent ospfAgent;
    private DriverService driverService;
    private List<Channel> connectedChannels;
    private List<OspfProcess> process;
    private OspfProcess ospfProcess;
    private OspfArea ospfArea;
    private OspfInterface ospfInterface;
    private List<OspfInterface> ospfInterfaces;
    private List<OspfArea> ospfAreas;
    private List<OspfProcess> ospfProcesses;
    private OspfProcess ospfProcess1;
    private OspfArea ospfArea1;
    private OspfRouter ospfRouter;

    @Before
    public void setUp() throws Exception {
        this.controller = new Controller();
        this.maps = new HashMap<String, Long>();
        this.ospfProcess = new OspfProcessImpl();
        this.ospfArea = new OspfAreaImpl();
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterfaces.add(this.ospfInterface);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfProcess.setProcessId("10.10.10.10");
        this.ospfAreas = new ArrayList<OspfArea>();
        this.ospfAreas.add(this.ospfArea);
        this.ospfProcess.setAreas(this.ospfAreas);
        this.ospfProcesses = new ArrayList<OspfProcess>();
        this.ospfProcesses.add(this.ospfProcess);
        this.ospfProcess1 = new OspfProcessImpl();
        this.ospfProcess1.setProcessId("11.11.11.11");
        this.ospfArea1 = new OspfAreaImpl();
        this.ospfArea1.setAreaId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfArea1.setInterfacesLst(this.ospfInterfaces);
        this.ospfAreas.add(this.ospfArea1);
        this.ospfProcess1.setAreas(this.ospfAreas);
        this.ospfProcesses.add(this.ospfProcess1);
        this.connectedChannels = new ArrayList<Channel>();
    }

    @After
    public void tearDown() throws Exception {
        this.controller = null;
        this.maps.clear();
        this.connectedChannels.clear();
        this.controller = null;
        this.maps = null;
        this.ospfAgent = null;
        this.driverService = null;
        this.connectedChannels = null;
        this.process = null;
        this.ospfProcess = null;
        this.ospfArea = null;
        this.ospfInterface = null;
        this.ospfInterfaces = null;
        this.ospfAreas = null;
        this.ospfProcesses = null;
        this.ospfProcess1 = null;
        this.ospfArea1 = null;
    }

    @Test
    public void testGetAllConfiguredProcesses() throws Exception {
        this.process = this.controller.getAllConfiguredProcesses();
        MatcherAssert.assertThat(this.process, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test(expected=Exception.class)
    public void testAddDeviceDetails() throws Exception {
        this.controller.addDeviceDetails((OspfRouter)new OspfRouterImpl());
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testRemoveDeviceDetails() throws Exception {
        this.controller.removeDeviceDetails((OspfRouter)new OspfRouterImpl());
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInit() throws Exception {
        this.controller.init();
        MatcherAssert.assertThat((Object)this.controller.systemStartTime, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testStart() throws Exception {
        this.ospfAgent = (OspfAgent)EasyMock.createMock(OspfAgent.class);
        this.controller.start(this.ospfAgent, this.driverService);
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testStop() throws Exception {
        this.controller.start(this.ospfAgent, this.driverService);
        this.controller.stop();
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDeleteInterfaceFromArea() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller.deleteInterfaceFromArea("10.10.10.10", "2.2.2.2", "1.1.1.1"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.controller.deleteInterfaceFromArea("10.10.10.10", "2.2.2.2", "5.5.5.5"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCheckArea() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller.checkArea("10.10.10.10", "2.2.2.2"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCheckArea1() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller.checkArea("10.10.10.10", "111.111.111.111"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCheckProcess() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller.checkProcess("3.3.3.3"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.controller.checkProcess("1.1.1.1"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCheckInterface() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller.checkInterface("10.10.10.10", "2.2.2.2", "1.1.1.1"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testUpdateAreaInProcess() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.updateAreaInProcess("10.10.10.10", "2.2.2.2", this.ospfArea);
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testUpdateConfig() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testUpdateConfig2() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testUpdateConfig1() throws Exception {
        this.ospfProcess = new OspfProcessImpl();
        this.ospfArea = new OspfAreaImpl();
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"10.10.10.5"));
        this.ospfInterfaces.add(this.ospfInterface);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfProcess.setProcessId("10.10.10.10");
        this.ospfAreas = new ArrayList<OspfArea>();
        this.ospfAreas.add(this.ospfArea);
        this.ospfProcess.setAreas(this.ospfAreas);
        this.ospfProcesses = new ArrayList<OspfProcess>();
        this.ospfProcesses.add(this.ospfProcess);
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testDeleteConfig() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.deleteConfig(this.ospfProcesses, "INTERFACE");
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testDeleteConfig1() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.deleteConfig(this.ospfProcesses, "AREA");
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDeleteConfig2() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.deleteConfig(this.ospfProcesses, "PROCESS");
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDeleteConfig3() throws Exception {
        this.ospfProcesses = new ArrayList<OspfProcess>();
        this.controller.deleteConfig(this.ospfProcesses, "PROCESS");
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDeleteConfig4() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.deleteConfig(this.ospfProcesses, "PROCESS");
        this.controller.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDeleteProcessWhenExists() throws Exception {
        this.controller.updateConfig(this.ospfProcesses);
        this.controller.deleteProcessWhenExists(this.ospfProcesses, "PROCESS");
    }

    @Test
    public void testAddLinkDetails() throws Exception {
        this.ospfAgent = (OspfAgent)EasyMock.createMock(OspfAgent.class);
        this.controller.start(this.ospfAgent, this.driverService);
        this.ospfRouter = new OspfRouterImpl();
        this.controller.addLinkDetails(this.ospfRouter, (OspfLinkTed)new OspfLinkTedImpl());
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemoveLinkDetails() throws Exception {
        this.ospfAgent = (OspfAgent)EasyMock.createMock(OspfAgent.class);
        this.controller.start(this.ospfAgent, this.driverService);
        this.ospfRouter = new OspfRouterImpl();
        this.controller.addLinkDetails(this.ospfRouter, (OspfLinkTed)new OspfLinkTedImpl());
        this.controller.removeLinkDetails(this.ospfRouter);
        MatcherAssert.assertThat((Object)this.controller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

