/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLinkListener;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfProcess;
import org.onosproject.ospf.controller.OspfRouter;
import org.onosproject.ospf.controller.OspfRouterListener;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.area.OspfProcessImpl;
import org.onosproject.ospf.controller.impl.Controller;
import org.onosproject.ospf.controller.impl.OspfControllerImpl;
import org.onosproject.ospf.controller.impl.OspfLinkTedImpl;
import org.onosproject.ospf.controller.impl.OspfRouterImpl;

public class OspfControllerImplTest {
    private OspfControllerImpl ospfController;
    private OspfRouterListener ospfRouterListener;
    private OspfLinkListener ospfLinkListener;
    private Controller controller;
    private List<OspfProcess> ospfProcesses;
    private OspfProcess process1;
    private OspfProcess process2;
    private List<OspfArea> areas;
    private OspfAreaImpl ospfArea;
    private List<OspfInterface> ospfInterfaces;
    private OspfInterfaceImpl ospfInterface;
    private OspfProcess ospfProcess;
    private OspfArea ospfArea1;
    private OspfRouter ospfRouter;

    @Before
    public void setUp() throws Exception {
        this.ospfController = new OspfControllerImpl();
        this.controller = new Controller();
    }

    @After
    public void tearDown() throws Exception {
        this.ospfController = null;
        this.ospfRouterListener = null;
        this.ospfLinkListener = null;
        this.controller = null;
        this.ospfProcesses = null;
        this.areas = null;
        this.ospfArea = null;
        this.ospfInterfaces = null;
        this.ospfInterface = null;
        this.ospfProcess = null;
        this.ospfProcess = null;
        this.ospfArea1 = null;
        this.ospfRouter = null;
    }

    @Test
    public void testActivate() throws Exception {
        this.ospfController.activate();
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testDeactivate() throws Exception {
        this.ospfController.activate();
        this.ospfController.deactivate();
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAddRouterListener() throws Exception {
        this.ospfRouterListener = (OspfRouterListener)EasyMock.createMock(OspfRouterListener.class);
        this.ospfController.addRouterListener(this.ospfRouterListener);
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemoveRouterListener() throws Exception {
        this.ospfRouterListener = (OspfRouterListener)EasyMock.createMock(OspfRouterListener.class);
        this.ospfController.addRouterListener(this.ospfRouterListener);
        this.ospfController.removeRouterListener(this.ospfRouterListener);
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAddLinkListener() throws Exception {
        this.ospfLinkListener = (OspfLinkListener)EasyMock.createMock(OspfLinkListener.class);
        this.ospfController.addLinkListener(this.ospfLinkListener);
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemoveLinkListener() throws Exception {
        this.ospfLinkListener = (OspfLinkListener)EasyMock.createMock(OspfLinkListener.class);
        this.ospfController.addLinkListener(this.ospfLinkListener);
        this.ospfController.removeLinkListener(this.ospfLinkListener);
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testUpdateConfig() throws Exception {
        this.ospfProcess = new OspfProcessImpl();
        this.ospfArea = new OspfAreaImpl();
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfProcess.setProcessId("10.10.10.10");
        this.areas = new ArrayList<OspfArea>();
        this.areas.add((OspfArea)this.ospfArea);
        this.ospfProcess.setAreas(this.areas);
        this.ospfProcesses = new ArrayList<OspfProcess>();
        this.ospfProcesses.add(this.ospfProcess);
        this.process1 = new OspfProcessImpl();
        this.process1.setProcessId("11.11.11.11");
        this.ospfArea1 = new OspfAreaImpl();
        this.ospfArea1.setAreaId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfArea1.setInterfacesLst(this.ospfInterfaces);
        this.areas.add(this.ospfArea1);
        this.process1.setAreas(this.areas);
        this.ospfProcesses.add(this.process1);
        this.ospfController.updateConfig(this.ospfProcesses);
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDeleteConfig() throws Exception {
        this.ospfProcess = new OspfProcessImpl();
        this.ospfArea = new OspfAreaImpl();
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"10.10.10.5"));
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfProcess.setProcessId("10.10.10.10");
        this.areas = new ArrayList<OspfArea>();
        this.areas.add((OspfArea)this.ospfArea);
        this.ospfProcess.setAreas(this.areas);
        this.ospfProcesses = new ArrayList<OspfProcess>();
        this.ospfProcesses.add(this.ospfProcess);
        this.process1 = new OspfProcessImpl();
        this.process1.setProcessId("11.11.11.11");
        this.ospfArea1 = new OspfAreaImpl();
        this.ospfArea1.setAreaId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfArea1.setInterfacesLst(this.ospfInterfaces);
        this.areas.add(this.ospfArea1);
        this.process1.setAreas(this.areas);
        this.ospfProcesses.add(this.process1);
        this.ospfController.deleteConfig(this.ospfProcesses, "INTERFACE");
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAddLink() throws Exception {
        this.ospfRouter = new OspfRouterImpl();
        this.ospfController.agent.addLink(this.ospfRouter, (OspfLinkTed)new OspfLinkTedImpl());
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDeleteLink() throws Exception {
        this.ospfRouter = new OspfRouterImpl();
        this.ospfController.agent.addLink(this.ospfRouter, (OspfLinkTed)new OspfLinkTedImpl());
        this.ospfController.agent.deleteLink(this.ospfRouter);
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testListener() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfController.listener().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testLinkListener() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfController.linkListener().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testaddConnectedRouter() throws Exception {
        this.ospfRouter = new OspfRouterImpl();
        this.ospfController.agent.addConnectedRouter(this.ospfRouter);
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemoveConnectedRouter() throws Exception {
        this.ospfRouter = new OspfRouterImpl();
        this.ospfController.agent.addConnectedRouter(this.ospfRouter);
        this.ospfController.agent.removeConnectedRouter(this.ospfRouter);
        MatcherAssert.assertThat((Object)this.ospfController, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testGetAllConfiguredProcesses() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfController.getAllConfiguredProcesses().size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

