/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfAreaAddressRange;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfNbr;
import org.onosproject.ospf.controller.OspfNeighborState;
import org.onosproject.ospf.controller.OspfRouter;
import org.onosproject.ospf.controller.TopologyForDeviceAndLink;
import org.onosproject.ospf.controller.area.OspfAreaAddressRangeImpl;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.Controller;
import org.onosproject.ospf.controller.impl.OspfInterfaceChannelHandler;
import org.onosproject.ospf.controller.impl.OspfLinkTedImpl;
import org.onosproject.ospf.controller.impl.OspfNbrImpl;
import org.onosproject.ospf.controller.impl.OspfRouterImpl;
import org.onosproject.ospf.controller.impl.TopologyForDeviceAndLinkImpl;
import org.onosproject.ospf.controller.util.OspfEligibleRouter;
import org.onosproject.ospf.exceptions.OspfParseException;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.tlvtypes.RouterTlv;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessage;
import org.onosproject.ospf.protocol.ospfpacket.subtype.LsRequestPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.DdPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.HelloPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.LsAcknowledge;
import org.onosproject.ospf.protocol.ospfpacket.types.LsRequest;
import org.onosproject.ospf.protocol.ospfpacket.types.LsUpdate;
import org.onosproject.ospf.protocol.util.ChecksumCalculator;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;

public class OspfInterfaceChannelHandlerTest {
    private List<OspfAreaAddressRange> addressRanges;
    private List<OspfInterface> ospfInterfaces;
    private Controller controller;
    private OspfAreaImpl ospfArea;
    private OspfInterfaceImpl ospfInterface;
    private OspfInterfaceChannelHandler ospfInterfaceChannelHandler;
    private HashMap<String, OspfNbr> ospfNbrHashMap;
    private OspfNbrImpl ospfNbr;
    private Channel channel;
    private ChannelHandlerContext channelHandlerContext;
    private ChannelStateEvent channelStateEvent;
    private HelloPacket helloPacket;
    private DdPacket ddPacket;
    private ChecksumCalculator checksumCalculator;
    private byte[] byteArray;
    private byte[] checkArray;
    private ChannelBuffer buf;
    private OspfEligibleRouter ospfEligibleRouter;
    private LsUpdate lsUpdate;
    private LsAcknowledge lsAck;
    private LsRequest lsRequest;
    private TopologyForDeviceAndLink topologyForDeviceAndLink;

    @Before
    public void setUp() throws Exception {
        this.addressRanges = new ArrayList<OspfAreaAddressRange>();
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfArea = this.createOspfArea();
        this.ospfInterface = this.createOspfInterface();
        this.ospfNbrHashMap = new HashMap();
        this.topologyForDeviceAndLink = new TopologyForDeviceAndLinkImpl();
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface), this.topologyForDeviceAndLink);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.controller = new Controller();
        this.ospfInterfaceChannelHandler = new OspfInterfaceChannelHandler();
        this.ospfInterfaceChannelHandler = new OspfInterfaceChannelHandler(this.controller, (OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface);
    }

    @After
    public void tearDown() throws Exception {
        this.ospfInterfaceChannelHandler = null;
        this.addressRanges = null;
        this.ospfInterfaces = null;
        this.controller = null;
        this.ospfArea = null;
        this.ospfInterfaceChannelHandler = null;
        this.ospfInterface = null;
        this.ospfNbrHashMap = null;
        this.channel = null;
        this.channelHandlerContext = null;
        this.channelStateEvent = null;
        this.helloPacket = null;
        this.ddPacket = null;
        this.checksumCalculator = null;
        this.byteArray = null;
        this.checkArray = null;
        this.ospfEligibleRouter = null;
        this.lsUpdate = null;
        this.lsAck = null;
        this.lsRequest = null;
    }

    @Test
    public void testInterfaceUp() throws Exception {
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setRouterPriority(0);
        this.ospfInterfaceChannelHandler.interfaceUp();
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInterfaceUp1() throws Exception {
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setRouterPriority(0);
        this.ospfInterfaceChannelHandler.interfaceUp();
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInterfaceUp2() throws Exception {
        this.ospfInterface.setInterfaceType(1);
        this.ospfInterface.setRouterPriority(1);
        this.ospfInterfaceChannelHandler.interfaceUp();
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInterfaceUp3() throws Exception {
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setRouterPriority(1);
        this.ospfInterfaceChannelHandler.interfaceUp();
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testBackupSeen() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfInterface.setState(OspfInterfaceState.WAITING);
        this.ospfInterfaceChannelHandler.backupSeen(this.channel);
        MatcherAssert.assertThat((Object)this.ospfInterface.dr(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testWaitTimer() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfInterface.setState(OspfInterfaceState.WAITING);
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterfaceChannelHandler.waitTimer(this.channel);
        MatcherAssert.assertThat((Object)this.ospfInterface.dr(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testNeighborChange() throws Exception {
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl(), Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)new OspfAreaImpl(), (OspfInterface)new OspfInterfaceImpl()), this.topologyForDeviceAndLink);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfNbrHashMap.put("111.111.111.111", (OspfNbr)this.ospfNbr);
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        this.ospfInterface.setListOfNeighbors(this.ospfNbrHashMap);
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfInterface.setState(OspfInterfaceState.DR);
        this.ospfInterfaceChannelHandler.waitTimer(this.channel);
        MatcherAssert.assertThat((Object)this.ospfInterface.dr(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"0.0.0.0")));
    }

    @Test(expected=Exception.class)
    public void testInterfaceDown() throws Exception {
        this.ospfInterfaceChannelHandler.interfaceDown();
        MatcherAssert.assertThat((Object)this.ospfInterface.state(), (Matcher)CoreMatchers.is((Object)OspfInterfaceState.DOWN));
    }

    @Test(expected=Exception.class)
    public void testChannelConnected() throws Exception {
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.channelStateEvent = (ChannelStateEvent)EasyMock.createMock(ChannelStateEvent.class);
        this.ospfInterfaceChannelHandler.channelConnected(this.channelHandlerContext, this.channelStateEvent);
        MatcherAssert.assertThat((Object)this.ospfInterface.state(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testExceptionCaught() throws Exception {
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        ExceptionEvent exception = (ExceptionEvent)EasyMock.createMock(ExceptionEvent.class);
        this.ospfInterfaceChannelHandler.exceptionCaught(this.channelHandlerContext, exception);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testChannelDisconnected() throws Exception {
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.channelStateEvent = (ChannelStateEvent)EasyMock.createMock(ChannelStateEvent.class);
        this.ospfInterfaceChannelHandler.channelDisconnected(this.channelHandlerContext, this.channelStateEvent);
        MatcherAssert.assertThat((Object)this.ospfInterface.state(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testMessageReceived() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"13.13.13.13"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        MessageEvent messageEvent = new MessageEvent(){

            public Object getMessage() {
                OspfInterfaceChannelHandlerTest.this.helloPacket = new HelloPacket();
                OspfInterfaceChannelHandlerTest.this.helloPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
                OspfInterfaceChannelHandlerTest.this.helloPacket.setRouterId(Ip4Address.valueOf((String)"10.10.10.10"));
                OspfInterfaceChannelHandlerTest.this.helloPacket.setOspfVer(2);
                OspfInterfaceChannelHandlerTest.this.helloPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
                OspfInterfaceChannelHandlerTest.this.helloPacket.setOptions(2);
                OspfInterfaceChannelHandlerTest.this.helloPacket.setAreaId(Ip4Address.valueOf((String)"5.5.5.5"));
                OspfInterfaceChannelHandlerTest.this.helloPacket.setNetworkMask(Ip4Address.valueOf((String)"3.3.3.3"));
                OspfInterfaceChannelHandlerTest.this.helloPacket.setOspftype(1);
                OspfInterfaceChannelHandlerTest.this.helloPacket.setAuthType(0);
                OspfInterfaceChannelHandlerTest.this.helloPacket.setAuthentication(0);
                OspfInterfaceChannelHandlerTest.this.checksumCalculator = new ChecksumCalculator();
                OspfInterfaceChannelHandlerTest.access$202(OspfInterfaceChannelHandlerTest.this, OspfInterfaceChannelHandlerTest.this.helloPacket.asBytes());
                OspfInterfaceChannelHandlerTest.this.helloPacket.setOspfPacLength(OspfInterfaceChannelHandlerTest.this.byteArray.length);
                OspfInterfaceChannelHandlerTest.access$302(OspfInterfaceChannelHandlerTest.this, OspfInterfaceChannelHandlerTest.this.checksumCalculator.calculateOspfCheckSum(OspfInterfaceChannelHandlerTest.this.byteArray, 12, 13));
                OspfInterfaceChannelHandlerTest.this.buf = ChannelBuffers.copiedBuffer((byte[])OspfInterfaceChannelHandlerTest.this.checkArray);
                OspfInterfaceChannelHandlerTest.this.helloPacket.setChecksum(OspfInterfaceChannelHandlerTest.this.buf.readUnsignedShort());
                ArrayList<HelloPacket> messPackets = new ArrayList<HelloPacket>();
                messPackets.add(OspfInterfaceChannelHandlerTest.this.helloPacket);
                return messPackets;
            }

            public SocketAddress getRemoteAddress() {
                return null;
            }

            public Channel getChannel() {
                return null;
            }

            public ChannelFuture getFuture() {
                return null;
            }
        };
        this.ospfInterfaceChannelHandler.messageReceived(this.channelHandlerContext, messageEvent);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessOspfMessage() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"225.225.225.225"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.helloPacket = new HelloPacket();
        this.helloPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.helloPacket.setRouterId(Ip4Address.valueOf((String)"10.10.10.10"));
        this.helloPacket.setOspfVer(2);
        this.helloPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.helloPacket.setOptions(2);
        this.helloPacket.setNetworkMask(Ip4Address.valueOf((String)"3.3.3.3"));
        this.helloPacket.setOspftype(1);
        this.helloPacket.setAuthType(0);
        this.helloPacket.setHelloInterval(60);
        this.helloPacket.setRouterDeadInterval(60);
        this.helloPacket.setAuthentication(0);
        this.checksumCalculator = new ChecksumCalculator();
        this.byteArray = this.helloPacket.asBytes();
        this.helloPacket.setOspfPacLength(this.byteArray.length);
        this.checkArray = this.checksumCalculator.calculateOspfCheckSum(this.byteArray, 12, 13);
        this.checkArray[0] = -53;
        this.checkArray[1] = 37;
        this.buf = ChannelBuffers.copiedBuffer((byte[])this.checkArray);
        this.helloPacket.setChecksum(this.buf.readUnsignedShort());
        HelloPacket message = this.helloPacket;
        this.ospfInterfaceChannelHandler.processOspfMessage((OspfMessage)message, this.channelHandlerContext);
        this.ddPacket = new DdPacket();
        this.ddPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ddPacket.setRouterId(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ddPacket.setOspfVer(2);
        this.ddPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.ddPacket.setOptions(2);
        this.ddPacket.setOspftype(2);
        this.ddPacket.setAuthType(0);
        this.ddPacket.setAuthentication(0);
        this.checksumCalculator = new ChecksumCalculator();
        this.byteArray = this.ddPacket.asBytes();
        this.ddPacket.setOspfPacLength(this.byteArray.length);
        this.checkArray = this.checksumCalculator.calculateOspfCheckSum(this.byteArray, 12, 13);
        this.checkArray[0] = -49;
        this.checkArray[1] = -79;
        this.buf = ChannelBuffers.copiedBuffer((byte[])this.checkArray);
        this.ddPacket.setChecksum(this.buf.readUnsignedShort());
        message = this.ddPacket;
        this.ospfInterfaceChannelHandler.processOspfMessage((OspfMessage)message, this.channelHandlerContext);
        this.lsRequest = new LsRequest();
        this.lsRequest.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.lsRequest.setRouterId(Ip4Address.valueOf((String)"10.10.10.10"));
        this.lsRequest.setOspfVer(2);
        this.lsRequest.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.lsRequest.setOspftype(3);
        this.lsRequest.setAuthType(0);
        this.lsRequest.setAuthentication(0);
        this.checksumCalculator = new ChecksumCalculator();
        this.byteArray = this.lsRequest.asBytes();
        this.lsRequest.setOspfPacLength(this.byteArray.length);
        this.checkArray = this.checksumCalculator.calculateOspfCheckSum(this.byteArray, 12, 13);
        this.checkArray[0] = -33;
        this.checkArray[1] = -58;
        this.buf = ChannelBuffers.copiedBuffer((byte[])this.checkArray);
        this.lsRequest.setChecksum(this.buf.readUnsignedShort());
        message = this.lsRequest;
        this.ospfInterfaceChannelHandler.processOspfMessage((OspfMessage)message, this.channelHandlerContext);
        this.lsUpdate = new LsUpdate();
        this.lsUpdate.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.lsUpdate.setRouterId(Ip4Address.valueOf((String)"10.10.10.10"));
        this.lsUpdate.setOspfVer(2);
        this.lsUpdate.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.lsUpdate.setOspftype(4);
        this.lsUpdate.setAuthType(0);
        this.lsUpdate.setAuthentication(0);
        this.checksumCalculator = new ChecksumCalculator();
        this.byteArray = this.lsUpdate.asBytes();
        this.lsUpdate.setOspfPacLength(this.byteArray.length);
        this.checkArray = this.checksumCalculator.calculateOspfCheckSum(this.byteArray, 12, 13);
        this.checkArray[0] = -47;
        this.checkArray[1] = -77;
        this.buf = ChannelBuffers.copiedBuffer((byte[])this.checkArray);
        this.lsUpdate.setChecksum(this.buf.readUnsignedShort());
        message = this.lsUpdate;
        this.ospfInterfaceChannelHandler.processOspfMessage((OspfMessage)message, this.channelHandlerContext);
        this.lsAck = new LsAcknowledge();
        this.lsAck.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.lsAck.setRouterId(Ip4Address.valueOf((String)"10.10.10.10"));
        this.lsAck.setOspfVer(2);
        this.lsAck.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.lsAck.setOspftype(5);
        this.lsAck.setAuthType(0);
        this.lsAck.setAuthentication(0);
        this.checksumCalculator = new ChecksumCalculator();
        this.byteArray = this.lsAck.asBytes();
        this.lsAck.setOspfPacLength(this.byteArray.length);
        this.checkArray = this.checksumCalculator.calculateOspfCheckSum(this.byteArray, 12, 13);
        this.checkArray[0] = -47;
        this.checkArray[1] = -74;
        this.buf = ChannelBuffers.copiedBuffer((byte[])this.checkArray);
        this.lsAck.setChecksum(this.buf.readUnsignedShort());
        message = this.lsAck;
        this.ospfInterfaceChannelHandler.processOspfMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessHelloMessage() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(1);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"244.244.244.244"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.helloPacket = new HelloPacket();
        this.helloPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.helloPacket.setOspfVer(2);
        this.helloPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.helloPacket.setNetworkMask(Ip4Address.valueOf((String)"244.244.244.244"));
        this.helloPacket.setHelloInterval(10);
        this.helloPacket.setRouterDeadInterval(10);
        this.helloPacket.setDr(Ip4Address.valueOf((String)"10.10.10.10"));
        this.helloPacket.setBdr(Ip4Address.valueOf((String)"11.11.11.11"));
        this.helloPacket.setRouterId(Ip4Address.valueOf((String)"111.111.111.111"));
        HelloPacket message = this.helloPacket;
        this.ospfInterfaceChannelHandler.processHelloMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessHelloMessage1() throws Exception {
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setRouterPriority(1);
        this.ospfInterfaceChannelHandler.interfaceUp();
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setState(OspfInterfaceState.WAITING);
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"244.244.244.244"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.helloPacket = new HelloPacket();
        this.helloPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.helloPacket.setOspfVer(2);
        this.helloPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.helloPacket.setNetworkMask(Ip4Address.valueOf((String)"244.244.244.244"));
        this.helloPacket.setHelloInterval(10);
        this.helloPacket.setRouterDeadInterval(10);
        this.helloPacket.setDr(Ip4Address.valueOf((String)"10.10.10.10"));
        this.helloPacket.setBdr(Ip4Address.valueOf((String)"11.11.11.11"));
        this.helloPacket.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        HelloPacket message = this.helloPacket;
        this.ospfInterfaceChannelHandler.processHelloMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface), this.topologyForDeviceAndLink);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaceChannelHandler.processHelloMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessDdMessage() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.ddPacket = new DdPacket();
        this.ddPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ddPacket.setOspfVer(2);
        this.ddPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.ddPacket.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ddPacket.setIsOpaqueCapable(true);
        this.ddPacket.setIsMore(1);
        this.ddPacket.setIsInitialize(1);
        this.ddPacket.setIsMaster(1);
        this.ddPacket.setSequenceNo(123L);
        DdPacket message = this.ddPacket;
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface), this.topologyForDeviceAndLink);
        this.ospfNbr.setLastDdPacket(this.createDdPacket());
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setState(OspfNeighborState.EXSTART);
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfNbr.setDdSeqNum(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaceChannelHandler.processDdMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessDdMessage3() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.ddPacket = new DdPacket();
        this.ddPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ddPacket.setOspfVer(2);
        this.ddPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.ddPacket.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ddPacket.setIsOpaqueCapable(true);
        this.ddPacket.setIsMore(1);
        this.ddPacket.setIsInitialize(1);
        this.ddPacket.setIsMaster(1);
        this.ddPacket.setSequenceNo(123L);
        DdPacket message = this.ddPacket;
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface), this.topologyForDeviceAndLink);
        this.ospfNbr.setLastDdPacket(this.createDdPacket());
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setState(OspfNeighborState.EXSTART);
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfNbr.setDdSeqNum(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ddPacket.setIsMore(1);
        this.ddPacket.setIsInitialize(0);
        this.ddPacket.setIsMaster(0);
        this.ddPacket.setSequenceNo(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaceChannelHandler.processDdMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessDdMessage1() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.ddPacket = new DdPacket();
        this.ddPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ddPacket.setOspfVer(2);
        this.ddPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.ddPacket.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ddPacket.setIsOpaqueCapable(true);
        this.ddPacket.setIsMore(1);
        this.ddPacket.setIsInitialize(1);
        this.ddPacket.setIsMaster(1);
        this.ddPacket.setSequenceNo(123L);
        DdPacket message = this.ddPacket;
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface), this.topologyForDeviceAndLink);
        this.ospfNbr.setLastDdPacket(this.createDdPacket());
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfNbr.setDdSeqNum(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ddPacket.setIsMore(1);
        this.ddPacket.setIsInitialize(0);
        this.ddPacket.setIsMaster(0);
        this.ddPacket.setSequenceNo(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaceChannelHandler.processDdMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessDdMessage2() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.ddPacket = new DdPacket();
        this.ddPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ddPacket.setOspfVer(2);
        this.ddPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.ddPacket.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ddPacket.setIsOpaqueCapable(true);
        this.ddPacket.setIsMore(1);
        this.ddPacket.setIsInitialize(1);
        this.ddPacket.setIsMaster(1);
        this.ddPacket.setSequenceNo(123L);
        DdPacket message = this.ddPacket;
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface), this.topologyForDeviceAndLink);
        this.ospfNbr.setLastDdPacket(this.createDdPacket());
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setState(OspfNeighborState.LOADING);
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfNbr.setDdSeqNum(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaceChannelHandler.processDdMessage((OspfMessage)message, this.channelHandlerContext);
        this.ddPacket.setIsMore(1);
        this.ddPacket.setIsInitialize(0);
        this.ddPacket.setIsMaster(0);
        this.ddPacket.setSequenceNo(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfNbr.setState(OspfNeighborState.LOADING);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaceChannelHandler.processDdMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessLSRequestMessage() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.lsRequest = new LsRequest();
        this.lsRequest.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.lsRequest.setOspfVer(2);
        this.lsRequest.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.lsRequest.setRouterId(Ip4Address.valueOf((String)"10.226.165.100"));
        ArrayList<LsRequestPacket> lsRequests = new ArrayList<LsRequestPacket>();
        LsRequestPacket lsRequestPacket = new LsRequestPacket();
        lsRequestPacket.setLsType(3);
        lsRequestPacket.setLinkStateId("2.2.2.2");
        lsRequestPacket.setOwnRouterId("2.2.2.2");
        lsRequests.add(lsRequestPacket);
        lsRequests.add(lsRequestPacket);
        this.lsRequest.addLinkStateRequests(new LsRequestPacket());
        this.lsRequest.addLinkStateRequests(new LsRequestPacket());
        LsRequest message = this.lsRequest;
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface(), Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"10.226.165.100"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface1()), this.topologyForDeviceAndLink);
        this.ospfNbr.setLastDdPacket(this.createDdPacket());
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfNbr.setDdSeqNum(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterface.setListOfNeighbors(this.ospfNbrHashMap);
        this.ospfInterfaceChannelHandler.processLsRequestMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessLSUpdateMessage() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.lsUpdate = new LsUpdate();
        this.lsUpdate.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.lsUpdate.setOspfVer(2);
        this.lsUpdate.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.lsUpdate.setRouterId(Ip4Address.valueOf((String)"10.226.165.100"));
        RouterLsa routerLsa = new RouterLsa();
        this.lsUpdate.addLsa((OspfLsa)routerLsa);
        this.lsUpdate.setNumberOfLsa(1);
        LsUpdate message = this.lsUpdate;
        this.ospfNbrHashMap = new HashMap();
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface(), Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"10.226.165.100"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface1()), this.topologyForDeviceAndLink);
        this.ospfNbr.setLastDdPacket(this.createDdPacket());
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfNbr.setDdSeqNum(123L);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        this.ospfInterfaceChannelHandler.processLsUpdateMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testProcessLSAckMessage() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.lsAck = new LsAcknowledge();
        this.lsAck.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.lsAck.setOspfVer(2);
        this.lsAck.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        LsaHeader lsaHeader = new LsaHeader();
        this.lsAck.addLinkStateHeader(lsaHeader);
        LsAcknowledge message = this.lsAck;
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface(), Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"10.226.165.100"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface()), this.topologyForDeviceAndLink);
        this.ospfNbr.setLastDdPacket(this.createDdPacket());
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfNbr.setRouterPriority(0);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"13.13.13.13"));
        this.ospfNbr.setDdSeqNum(123L);
        this.ospfInterfaceChannelHandler.processLsAckMessage((OspfMessage)message, this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testCompareDDPackets() throws Exception {
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"11.11.11.11"));
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setHelloIntervalTime(10);
        this.ospfInterface.setRouterDeadIntervalTime(10);
        this.ospfArea.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.ddPacket = new DdPacket();
        this.ddPacket.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ddPacket.setOspfVer(2);
        this.ddPacket.setIsInitialize(1);
        this.ddPacket.setIsMaster(1);
        this.ddPacket.setIsMore(1);
        this.ddPacket.setOptions(2);
        this.ddPacket.setAreaId(Ip4Address.valueOf((String)"12.12.12.12"));
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler.compareDdPackets(this.ddPacket, this.ddPacket), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=Exception.class)
    public void testCloseChannel() throws Exception {
        this.channelHandlerContext = (ChannelHandlerContext)EasyMock.createMock(ChannelHandlerContext.class);
        this.ospfInterfaceChannelHandler.closeChannel(this.channelHandlerContext);
        MatcherAssert.assertThat((Object)this.ospfInterface.dr(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testElectRouter() throws Exception {
        this.ospfInterface.setDr(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterface.setBdr(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        ChannelConfig channelConfig = (ChannelConfig)EasyMock.createMock(ChannelConfig.class);
        EasyMock.expect((Object)channelConfig.getBufferFactory()).andReturn((Object)new HeapChannelBufferFactory());
        Channel channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfInterfaceChannelHandler.electRouter(channel);
        MatcherAssert.assertThat((Object)this.ospfInterface.dr(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testElectBdr() throws Exception {
        this.ospfEligibleRouter = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(10);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        OspfEligibleRouter ospfEligibleRouter1 = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(10);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        OspfEligibleRouter ospfEligibleRouter2 = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(10);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        ArrayList<OspfEligibleRouter> ospfEligibleRouters = new ArrayList<OspfEligibleRouter>();
        ospfEligibleRouters.add(this.ospfEligibleRouter);
        ospfEligibleRouters.add(ospfEligibleRouter1);
        ospfEligibleRouters.add(ospfEligibleRouter2);
        OspfEligibleRouter eligibleRouter = this.ospfInterfaceChannelHandler.electBdr(ospfEligibleRouters);
        MatcherAssert.assertThat((Object)ospfEligibleRouters.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)eligibleRouter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testElectDR() throws Exception {
        this.ospfEligibleRouter = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(10);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        OspfEligibleRouter ospfEligibleRouter1 = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(10);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        OspfEligibleRouter ospfEligibleRouter2 = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(10);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        ArrayList<OspfEligibleRouter> ospfEligibleRouters = new ArrayList<OspfEligibleRouter>();
        ospfEligibleRouters.add(this.ospfEligibleRouter);
        ospfEligibleRouters.add(ospfEligibleRouter1);
        ospfEligibleRouters.add(ospfEligibleRouter2);
        OspfEligibleRouter eligibleRouter = this.ospfInterfaceChannelHandler.electDr(ospfEligibleRouters, this.ospfEligibleRouter);
        MatcherAssert.assertThat((Object)ospfEligibleRouters.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)eligibleRouter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSelectRouterBasedOnPriority() throws Exception {
        this.ospfEligibleRouter = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(10);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        OspfEligibleRouter ospfEligibleRouter1 = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(11);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        OspfEligibleRouter ospfEligibleRouter2 = new OspfEligibleRouter();
        this.ospfEligibleRouter.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsDr(true);
        this.ospfEligibleRouter.setRouterPriority(12);
        this.ospfEligibleRouter.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfEligibleRouter.setIsBdr(false);
        ArrayList<OspfEligibleRouter> ospfEligibleRouters = new ArrayList<OspfEligibleRouter>();
        ospfEligibleRouters.add(this.ospfEligibleRouter);
        ospfEligibleRouters.add(ospfEligibleRouter1);
        ospfEligibleRouters.add(ospfEligibleRouter2);
        OspfEligibleRouter eligibleRouter = this.ospfInterfaceChannelHandler.selectRouterBasedOnPriority(ospfEligibleRouters);
        MatcherAssert.assertThat((Object)eligibleRouter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testAddDeviceInformation() throws Exception {
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface(), Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"10.226.165.100"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface()), this.topologyForDeviceAndLink);
        this.ospfInterfaceChannelHandler.addDeviceInformation((OspfRouter)new OspfRouterImpl());
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testRemoveDeviceInformation() throws Exception {
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface(), Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"10.226.165.100"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface()), this.topologyForDeviceAndLink);
        this.ospfInterfaceChannelHandler.removeDeviceInformation((OspfRouter)new OspfRouterImpl());
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testaddLinkInformation() throws Exception {
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface(), Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"10.226.165.100"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface()), this.topologyForDeviceAndLink);
        ArrayList<RouterTlv> topTlv = new ArrayList<RouterTlv>();
        topTlv.add(new RouterTlv(new TlvHeader()));
        this.ospfInterfaceChannelHandler.addLinkInformation((OspfRouter)new OspfRouterImpl(), (OspfLinkTed)new OspfLinkTedImpl());
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testRemoveLinkInformation() throws Exception {
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface(), Ip4Address.valueOf((String)"10.10.10.10"), Ip4Address.valueOf((String)"10.226.165.100"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.createOspfInterface()), this.topologyForDeviceAndLink);
        this.ospfInterfaceChannelHandler.removeLinkInformation((OspfNbr)this.ospfNbr);
        MatcherAssert.assertThat((Object)this.ospfInterfaceChannelHandler, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private DdPacket createDdPacket() throws OspfParseException {
        byte[] ddPacket = new byte[]{2, 2, 0, 32, -64, -88, -86, 8, 0, 0, 0, 1, -96, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, -36, 2, 7, 65, 119, -87, 126};
        DdPacket ddPacket1 = new DdPacket();
        ChannelBuffer buf = ChannelBuffers.buffer((int)ddPacket.length);
        buf.writeBytes(ddPacket);
        ddPacket1.readFrom(buf);
        return ddPacket1;
    }

    private OspfInterfaceImpl createOspfInterface() throws UnknownHostException {
        this.ospfInterface = new OspfInterfaceImpl();
        OspfAreaImpl ospfArea = new OspfAreaImpl();
        OspfInterfaceChannelHandler ospfInterfaceChannelHandler = (OspfInterfaceChannelHandler)EasyMock.createMock(OspfInterfaceChannelHandler.class);
        this.ospfNbr = new OspfNbrImpl((OspfArea)ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"10.226.165.164"), Ip4Address.valueOf((String)"1.1.1.1"), 2, ospfInterfaceChannelHandler, this.topologyForDeviceAndLink);
        this.ospfNbr.setState(OspfNeighborState.EXSTART);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"10.226.165.164"));
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setAreaId(2);
        this.ospfInterface.setAuthKey("authKey");
        this.ospfInterface.setAuthType("AuthReq");
        this.ospfInterface.setBdr(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfInterface.setDr(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfInterface.setHelloIntervalTime(20);
        this.ospfInterface.setInterfaceCost(10);
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setReTransmitInterval(2000);
        this.ospfInterface.setMtu(6500);
        this.ospfInterface.setPollInterval(1000);
        this.ospfInterface.setRouterDeadIntervalTime(1000);
        this.ospfInterface.setRouterPriority(1);
        this.ospfInterface.setTransmitDelay(500);
        this.ospfInterface.setInterfaceType(1);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        return this.ospfInterface;
    }

    private OspfInterfaceImpl createOspfInterface1() throws UnknownHostException {
        this.ospfInterface = new OspfInterfaceImpl();
        OspfAreaImpl ospfArea = new OspfAreaImpl();
        OspfInterfaceChannelHandler ospfInterfaceChannelHandler = (OspfInterfaceChannelHandler)EasyMock.createMock(OspfInterfaceChannelHandler.class);
        this.ospfNbr = new OspfNbrImpl((OspfArea)ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"10.226.165.164"), Ip4Address.valueOf((String)"1.1.1.1"), 2, ospfInterfaceChannelHandler, this.topologyForDeviceAndLink);
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"10.226.165.164"));
        this.ospfInterface.setIpNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.ospfInterface.setAreaId(2);
        this.ospfInterface.setAuthKey("authKey");
        this.ospfInterface.setAuthType("AuthReq");
        this.ospfInterface.setBdr(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfInterface.setDr(Ip4Address.valueOf((String)"111.111.111.111"));
        this.ospfInterface.setHelloIntervalTime(20);
        this.ospfInterface.setInterfaceCost(10);
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setReTransmitInterval(2000);
        this.ospfInterface.setMtu(6500);
        this.ospfInterface.setPollInterval(1000);
        this.ospfInterface.setRouterDeadIntervalTime(1000);
        this.ospfInterface.setRouterPriority(1);
        this.ospfInterface.setTransmitDelay(500);
        this.ospfInterface.setInterfaceType(1);
        this.ospfInterface.addNeighbouringRouter((OspfNbr)this.ospfNbr);
        return this.ospfInterface;
    }

    private OspfAreaImpl createOspfArea() throws UnknownHostException {
        OspfAreaAddressRangeImpl ospfAreaAddressRange = this.createOspfAreaAddressRange();
        this.addressRanges.add((OspfAreaAddressRange)ospfAreaAddressRange);
        OspfAreaImpl ospfArea = new OspfAreaImpl();
        ospfArea.setStubCost(10);
        ospfArea.setAreaId(Ip4Address.valueOf((String)"10.226.165.164"));
        ospfArea.setExternalRoutingCapability(true);
        ospfArea.setTransitCapability(true);
        ospfArea.setAddressRanges(this.addressRanges);
        OspfInterfaceImpl ospfInterface = this.createOspfInterface();
        this.ospfInterfaces.add((OspfInterface)ospfInterface);
        ospfArea.setInterfacesLst(this.ospfInterfaces);
        RouterLsa routerLsa = new RouterLsa();
        routerLsa.setLsType(1);
        routerLsa.setLinkStateId("2.2.2.2");
        routerLsa.setAdvertisingRouter(Ip4Address.valueOf((String)"2.2.2.2"));
        try {
            ospfArea.addLsa((OspfLsa)routerLsa, false, (OspfInterface)ospfInterface);
        }
        catch (Exception e) {
            System.out.println("ospfAreaImpl createOspfArea");
        }
        ospfArea.setRouterId(Ip4Address.valueOf((String)"111.111.111.111"));
        return ospfArea;
    }

    private OspfAreaAddressRangeImpl createOspfAreaAddressRange() {
        OspfAreaAddressRangeImpl ospfAreaAddressRange = new OspfAreaAddressRangeImpl();
        ospfAreaAddressRange.setIpAddress(Ip4Address.valueOf((String)"10.226.165.164"));
        ospfAreaAddressRange.setAdvertise(true);
        ospfAreaAddressRange.setMask("mask");
        return ospfAreaAddressRange;
    }

    static /* synthetic */ byte[] access$202(OspfInterfaceChannelHandlerTest x0, byte[] x1) {
        x0.byteArray = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(OspfInterfaceChannelHandlerTest x0, byte[] x1) {
        x0.checkArray = x1;
        return x1;
    }
}

