/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Bandwidth;
import org.onosproject.ospf.controller.impl.OspfLinkTedImpl;

public class OspfLinkTedImplTest {
    private static final Ip4Address LOCAL_ADDRESS = Ip4Address.valueOf((String)"127.0.0.1");
    private OspfLinkTedImpl ospfLinkTed;

    @Before
    public void setUp() throws Exception {
        this.ospfLinkTed = new OspfLinkTedImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.ospfLinkTed = null;
    }

    @Test
    public void testMaximumLink() throws Exception {
        this.ospfLinkTed.setMaximumLink(Bandwidth.bps((long)1234L));
        Assert.assertThat((Object)this.ospfLinkTed.maximumLink(), (Matcher)CoreMatchers.is((Object)Bandwidth.bps((long)1234L)));
    }

    @Test
    public void testSetMaximumLink() throws Exception {
        this.ospfLinkTed.setMaximumLink(Bandwidth.bps((long)1234L));
        Assert.assertThat((Object)this.ospfLinkTed.maximumLink(), (Matcher)CoreMatchers.is((Object)Bandwidth.bps((long)1234L)));
    }

    @Test
    public void testIpv6RemRouterId() throws Exception {
        ArrayList list = new ArrayList();
        this.ospfLinkTed.setIpv6RemRouterId(list);
        Assert.assertThat((Object)this.ospfLinkTed.ipv6RemRouterId().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testSetIpv6RemRouterId() throws Exception {
        ArrayList list = new ArrayList();
        this.ospfLinkTed.setIpv6RemRouterId(list);
        Assert.assertThat((Object)this.ospfLinkTed.ipv6RemRouterId().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testIpv4RemRouterId() throws Exception {
        ArrayList<Ip4Address> list = new ArrayList<Ip4Address>();
        list.add(LOCAL_ADDRESS);
        this.ospfLinkTed.setIpv4RemRouterId(list);
        Assert.assertThat((Object)this.ospfLinkTed.ipv4RemRouterId().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetIpv4RemRouterId() throws Exception {
        ArrayList<Ip4Address> list = new ArrayList<Ip4Address>();
        list.add(LOCAL_ADDRESS);
        this.ospfLinkTed.setIpv4RemRouterId(list);
        Assert.assertThat((Object)this.ospfLinkTed.ipv4RemRouterId().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testIpv6LocRouterId() throws Exception {
        ArrayList list = new ArrayList();
        this.ospfLinkTed.setIpv4LocRouterId(list);
        Assert.assertThat((Object)this.ospfLinkTed.ipv6LocRouterId().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testSetIpv6LocRouterId() throws Exception {
        ArrayList list = new ArrayList();
        this.ospfLinkTed.setIpv4LocRouterId(list);
        Assert.assertThat((Object)this.ospfLinkTed.ipv6LocRouterId().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testIpv4LocRouterId() throws Exception {
        ArrayList<Ip4Address> list = new ArrayList<Ip4Address>();
        list.add(LOCAL_ADDRESS);
        this.ospfLinkTed.setIpv4LocRouterId(list);
        Assert.assertThat((Object)this.ospfLinkTed.ipv4LocRouterId().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetIpv4LocRouterId() throws Exception {
        ArrayList<Ip4Address> list = new ArrayList<Ip4Address>();
        list.add(LOCAL_ADDRESS);
        this.ospfLinkTed.setIpv4LocRouterId(list);
        Assert.assertThat((Object)this.ospfLinkTed.ipv4LocRouterId().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testTeMetric() throws Exception {
        this.ospfLinkTed.setTeMetric(Integer.valueOf(1234));
        Assert.assertThat((Object)this.ospfLinkTed.teMetric(), (Matcher)CoreMatchers.is((Object)1234));
    }

    @Test
    public void testSetTeMetric() throws Exception {
        this.ospfLinkTed.setTeMetric(Integer.valueOf(1234));
        Assert.assertThat((Object)this.ospfLinkTed.teMetric(), (Matcher)CoreMatchers.is((Object)1234));
    }

    @Test
    public void testMaxReserved() throws Exception {
        this.ospfLinkTed.setMaxReserved(Bandwidth.bps((long)1234L));
        Assert.assertThat((Object)this.ospfLinkTed.maxReserved(), (Matcher)CoreMatchers.is((Object)Bandwidth.bps((long)1234L)));
    }

    @Test
    public void testSetMaxReserved() throws Exception {
        this.ospfLinkTed.setMaxReserved(Bandwidth.bps((long)1234L));
        Assert.assertThat((Object)this.ospfLinkTed.maxReserved(), (Matcher)CoreMatchers.is((Object)Bandwidth.bps((long)1234L)));
    }

    @Test
    public void testMaxUnResBandwidth() throws Exception {
        this.ospfLinkTed.setMaxUnResBandwidth(Bandwidth.bps((long)1234L));
        Assert.assertThat((Object)this.ospfLinkTed.maxUnResBandwidth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetMaxUnResBandwidth() throws Exception {
        this.ospfLinkTed.setMaxUnResBandwidth(Bandwidth.bps((double)1234.0));
        Assert.assertThat((Object)this.ospfLinkTed.maxUnResBandwidth(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

