/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.OspfMessageEncoder;
import org.onosproject.ospf.protocol.ospfpacket.types.DdPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.HelloPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.LsAcknowledge;
import org.onosproject.ospf.protocol.ospfpacket.types.LsRequest;
import org.onosproject.ospf.protocol.ospfpacket.types.LsUpdate;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;

public class OspfMessageEncoderTest {
    private final byte[] hpacket = new byte[]{2, 1, 0, 44, -64, -88, -86, 8, 0, 0, 0, 1, 39, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 10, 2, 1, 0, 0, 0, 40, -64, -88, -86, 8, 0, 0, 0, 0};
    private final byte[] dpacket = new byte[]{2, 2, 0, 32, -64, -88, -86, 8, 0, 0, 0, 1, -96, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, -36, 2, 7, 65, 119, -87, 126};
    private final byte[] lrpacket = new byte[]{2, 3, 0, 36, -64, -88, -86, 3, 0, 0, 0, 1, -67, -57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -64, -88, -86, 8, -64, -88, -86, 8};
    private byte[] lAckpacket = new byte[]{2, 5, 0, 44, -64, -88, -86, 8, 0, 0, 0, 1, -30, -12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 16, 2, 1, -64, -88, -86, 2, -64, -88, -86, 2, -128, 0, 0, 1, 74, -114, 0, 48};
    private HelloPacket helloPacket;
    private DdPacket ddPacket;
    private LsAcknowledge lsAcknowledge;
    private LsRequest lsRequest;
    private LsUpdate lsUpdate;
    private ChannelHandlerContext ctx;
    private OspfMessageEncoder ospfMessageEncoder;
    private ChannelBuffer buf;
    private SocketAddress socketAddress;
    private Channel channel;

    @Before
    public void setUp() throws Exception {
        this.ospfMessageEncoder = new OspfMessageEncoder();
        this.helloPacket = new HelloPacket();
        this.ddPacket = new DdPacket();
        this.lsAcknowledge = new LsAcknowledge();
        this.lsRequest = new LsRequest();
        this.lsUpdate = new LsUpdate();
        this.helloPacket.setOspftype(1);
        this.ddPacket.setOspftype(2);
        this.lsAcknowledge.setOspftype(5);
        this.lsRequest.setOspftype(3);
        this.lsUpdate.setOspftype(4);
        OspfInterfaceImpl ospfInterface = new OspfInterfaceImpl();
        ospfInterface.setState(OspfInterfaceState.DROTHER);
        this.ospfMessageEncoder = new OspfMessageEncoder((OspfInterface)ospfInterface);
    }

    @After
    public void tearDown() throws Exception {
        this.helloPacket = null;
        this.ddPacket = null;
        this.lsAcknowledge = null;
        this.lsRequest = null;
        this.lsUpdate = null;
        this.ospfMessageEncoder = null;
        this.buf = null;
    }

    @Test
    public void testEncode() throws Exception {
        this.socketAddress = InetSocketAddress.createUnresolved("127.0.0.1", 8600);
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.helloPacket = new HelloPacket();
        this.helloPacket.setDestinationIp(Ip4Address.valueOf((String)"15.15.15.15"));
        this.buf = ChannelBuffers.buffer((int)this.hpacket.length);
        this.buf.writeBytes(this.hpacket);
        this.helloPacket.readFrom(this.buf);
        this.ospfMessageEncoder.encode(this.ctx, this.channel, (Object)this.helloPacket);
        this.ddPacket = new DdPacket();
        this.ddPacket.setDestinationIp(Ip4Address.valueOf((String)"15.15.15.15"));
        this.buf = ChannelBuffers.buffer((int)this.dpacket.length);
        this.buf.writeBytes(this.dpacket);
        this.ddPacket.readFrom(this.buf);
        this.ospfMessageEncoder.encode(this.ctx, this.channel, (Object)this.ddPacket);
        this.lsRequest = new LsRequest();
        this.lsRequest.setDestinationIp(Ip4Address.valueOf((String)"15.15.15.15"));
        this.buf = ChannelBuffers.buffer((int)this.lrpacket.length);
        this.buf.writeBytes(this.lrpacket);
        this.lsRequest.readFrom(this.buf);
        this.ospfMessageEncoder.encode(this.ctx, this.channel, (Object)this.lsRequest);
        this.lsAcknowledge = new LsAcknowledge();
        this.lsAcknowledge.setDestinationIp(Ip4Address.valueOf((String)"15.15.15.15"));
        this.buf = ChannelBuffers.buffer((int)this.lAckpacket.length);
        this.buf.writeBytes(this.lAckpacket);
        this.lsAcknowledge.readFrom(this.buf);
        this.ospfMessageEncoder.encode(this.ctx, this.channel, (Object)this.lsAcknowledge);
        MatcherAssert.assertThat((Object)this.ospfMessageEncoder, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

