/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.channel.Channel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.LsdbAge;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.OspfNeighborState;
import org.onosproject.ospf.controller.TopologyForDeviceAndLink;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.Controller;
import org.onosproject.ospf.controller.impl.OspfInterfaceChannelHandler;
import org.onosproject.ospf.controller.impl.OspfNbrImpl;
import org.onosproject.ospf.controller.impl.TopologyForDeviceAndLinkImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.controller.lsdb.LsdbAgeImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessage;
import org.onosproject.ospf.protocol.ospfpacket.types.DdPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.HelloPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.LsRequest;
import org.onosproject.ospf.protocol.ospfpacket.types.LsUpdate;
import org.onosproject.ospf.protocol.util.ChecksumCalculator;
import org.onosproject.ospf.protocol.util.OspfUtil;

public class OspfNbrImplTest {
    private OspfNbrImpl ospfNbr;
    private OspfInterfaceImpl ospfInterface;
    private OspfAreaImpl ospfArea;
    private OspfInterfaceImpl ospfInterface1;
    private OspfInterfaceImpl ospfInterface2;
    private List<OspfInterface> ospfInterfaces;
    private List<OspfLsa> ospfLsaList;
    private Channel channel;
    private Channel channel1;
    private Channel channel2;
    private OspfMessage ospfMessage;
    private TopologyForDeviceAndLink topologyForDeviceAndLink;

    @Before
    public void setUp() throws Exception {
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterface.setInterfaceType(2);
        this.ospfInterface.setRouterDeadIntervalTime(30);
        this.ospfInterface.setReTransmitInterval(30);
        this.ospfInterface.setDr(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfArea = new OspfAreaImpl();
        this.ospfInterface1 = new OspfInterfaceImpl();
        this.ospfInterface1.setInterfaceType(2);
        this.ospfInterface1.setRouterDeadIntervalTime(30);
        this.ospfInterface1.setReTransmitInterval(30);
        this.ospfInterface1.setDr(Ip4Address.valueOf((String)"7.7.7.7"));
        this.ospfInterface1.setIpAddress(Ip4Address.valueOf((String)"7.7.7.7"));
        this.ospfInterface2 = new OspfInterfaceImpl();
        this.ospfInterface2.setInterfaceType(2);
        this.ospfInterface2.setRouterDeadIntervalTime(30);
        this.ospfInterface2.setReTransmitInterval(30);
        this.ospfInterface2.setDr(Ip4Address.valueOf((String)"6.6.6.6"));
        this.ospfInterface2.setIpAddress(Ip4Address.valueOf((String)"6.6.6.6"));
        this.ospfInterfaces = new ArrayList<OspfInterface>();
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface1);
        this.ospfInterfaces.add((OspfInterface)this.ospfInterface2);
        this.ospfArea.setInterfacesLst(this.ospfInterfaces);
        this.ospfArea.setRouterId(Ip4Address.valueOf((String)"111.111.111.111"));
        this.topologyForDeviceAndLink = new TopologyForDeviceAndLinkImpl();
        this.ospfNbr = new OspfNbrImpl((OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface, Ip4Address.valueOf((String)"1.1.1.1"), Ip4Address.valueOf((String)"2.2.2.2"), 2, new OspfInterfaceChannelHandler(new Controller(), (OspfArea)this.ospfArea, (OspfInterface)this.ospfInterface), this.topologyForDeviceAndLink);
    }

    @After
    public void tearDown() throws Exception {
        this.ospfNbr = null;
        this.ospfArea = null;
        this.ospfInterface = null;
        this.ospfLsaList = null;
        this.channel = null;
        this.channel1 = null;
        this.channel2 = null;
        this.ospfMessage = null;
    }

    @Test
    public void testNeighborIpAddr() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfNbr.neighborIpAddr(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testIsOpaqueCapable() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfNbr.isOpaqueCapable(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testSetIsOpaqueCapable() throws Exception {
        this.ospfNbr.setIsOpaqueCapable(true);
        MatcherAssert.assertThat((Object)this.ospfNbr.isOpaqueCapable(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testOneWayReceived() throws Exception {
        this.ospfMessage = new HelloPacket();
        this.ospfNbr.setState(OspfNeighborState.ATTEMPT);
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.oneWayReceived(this.ospfMessage, this.channel);
        this.channel1 = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.setState(OspfNeighborState.DOWN);
        this.ospfNbr.oneWayReceived(this.ospfMessage, this.channel1);
        this.channel2 = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.setState(OspfNeighborState.TWOWAY);
        this.ospfNbr.oneWayReceived(this.ospfMessage, this.channel2);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testTwoWayReceived() throws Exception {
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfMessage = new HelloPacket();
        this.ospfNbr.setState(OspfNeighborState.ATTEMPT);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"2.2.2.2"));
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        SocketAddress socketAddress = (SocketAddress)EasyMock.createMock(SocketAddress.class);
        this.channel.bind(socketAddress);
        this.ospfNbr.twoWayReceived(this.ospfMessage, this.channel);
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"3.3.3.3"));
        this.channel1 = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.twoWayReceived(this.ospfMessage, this.channel1);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testNegotiationDone() throws Exception {
        this.ospfLsaList = new ArrayList<OspfLsa>();
        this.ospfLsaList.add((OspfLsa)new RouterLsa());
        this.ospfMessage = new HelloPacket();
        this.ospfNbr.setState(OspfNeighborState.EXSTART);
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.negotiationDone(this.ospfMessage, true, this.ospfLsaList, this.channel);
        this.channel1 = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.negotiationDone(this.ospfMessage, false, this.ospfLsaList, this.channel1);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessLsas() throws Exception {
        this.ospfLsaList = new ArrayList<OspfLsa>();
        RouterLsa routerLsa = new RouterLsa();
        routerLsa.setLsType(1);
        this.ospfLsaList.add((OspfLsa)routerLsa);
        NetworkLsa networkLsa = new NetworkLsa();
        routerLsa.setLsType(2);
        this.ospfLsaList.add((OspfLsa)networkLsa);
        routerLsa.setLsType(3);
        this.ospfLsaList.add((OspfLsa)routerLsa);
        this.ospfNbr.processLsas(this.ospfLsaList);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSeqNumMismatch() throws Exception {
        this.ospfNbr.setState(OspfNeighborState.FULL);
        MatcherAssert.assertThat((Object)this.ospfNbr.seqNumMismatch("samelsa"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testBadLSReq() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.setState(OspfNeighborState.FULL);
        this.ospfNbr.badLSReq(this.channel);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessDdPacket() throws Exception {
        this.ospfArea.addLsa((OspfLsa)new RouterLsa(), false, (OspfInterface)this.ospfInterface);
        this.ospfArea.addLsa((OspfLsa)new RouterLsa(), (OspfInterface)this.ospfInterface);
        this.ospfArea.addLsaToMaxAgeBin("lsa", (LsaWrapper)new LsaWrapperImpl());
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        DdPacket ddPacket = new DdPacket();
        ddPacket.addLsaHeader(new LsaHeader());
        this.ospfNbr.processDdPacket(true, ddPacket, this.channel);
        this.channel1 = (Channel)EasyMock.createMock(Channel.class);
        ddPacket.setIsMore(1);
        this.ospfNbr.processDdPacket(false, ddPacket, this.channel1);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testExchangeDone() throws Exception {
        this.ospfMessage = new HelloPacket();
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        this.ospfNbr.exchangeDone(this.ospfMessage, this.channel);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testExchangeDone1() throws Exception {
        this.ospfMessage = new HelloPacket();
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        this.ospfLsaList = new ArrayList<OspfLsa>();
        RouterLsa routerLsa = new RouterLsa();
        routerLsa.setLsType(1);
        this.ospfLsaList.add((OspfLsa)routerLsa);
        NetworkLsa networkLsa = new NetworkLsa();
        routerLsa.setLsType(2);
        this.ospfLsaList.add((OspfLsa)networkLsa);
        routerLsa.setLsType(3);
        this.ospfLsaList.add((OspfLsa)routerLsa);
        this.ospfNbr.processLsas(this.ospfLsaList);
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        this.ospfNbr.exchangeDone(this.ospfMessage, this.channel);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAdjOk() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfInterface.setIpAddress(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.setState(OspfNeighborState.TWOWAY);
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfNbr.adjOk(this.channel);
        Assert.assertNotNull((Object)this.ospfNbr);
    }

    @Test
    public void testProcessLsUpdate() throws Exception {
        LsUpdate ospfMessage = new LsUpdate();
        ospfMessage.setSourceIp(Ip4Address.valueOf((String)"10.10.10.10"));
        ospfMessage.addLsa((OspfLsa)new RouterLsa());
        ospfMessage.addLsa((OspfLsa)new NetworkLsa());
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        this.ospfNbr.processLsUpdate(ospfMessage, this.channel);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testLoadingDone() throws Exception {
        this.ospfArea.addLsa((OspfLsa)new RouterLsa(), false, (OspfInterface)this.ospfInterface);
        this.ospfArea.addLsa((OspfLsa)new RouterLsa(), (OspfInterface)this.ospfInterface);
        this.ospfArea.addLsaToMaxAgeBin("lsa", (LsaWrapper)new LsaWrapperImpl());
        this.ospfNbr.loadingDone();
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessReceivedLsa() throws Exception {
        LsaWrapperImpl lsaWrapper = new LsaWrapperImpl();
        LsdbAgeImpl lsdbAge = new LsdbAgeImpl((OspfArea)new OspfAreaImpl());
        lsdbAge.ageLsaAndFlood();
        lsaWrapper.setLsdbAge((LsdbAge)lsdbAge);
        lsaWrapper.setLsaHeader((LsaHeader)new NetworkLsa());
        RouterLsa routerlsa = new RouterLsa();
        routerlsa.setLsType(1);
        routerlsa.setOptions(2);
        routerlsa.setAdvertisingRouter(Ip4Address.valueOf((String)"1.1.1.1"));
        routerlsa.setAge(100);
        routerlsa.setLinkStateId("2.2.2.2");
        routerlsa.setLsSequenceNo(1010101L);
        lsaWrapper.setLsaHeader((LsaHeader)new RouterLsa());
        this.ospfArea.addLsa((OspfLsa)routerlsa, false, (OspfInterface)this.ospfInterface);
        lsaWrapper.addLsa(OspfLsaType.ROUTER, (OspfLsa)routerlsa);
        this.ospfArea.addLsa((OspfLsa)routerlsa, (OspfInterface)this.ospfInterface);
        this.ospfArea.addLsaToMaxAgeBin("lsa", (LsaWrapper)new LsaWrapperImpl());
        byte[] res = routerlsa.asBytes();
        routerlsa.setLsPacketLen(res.length);
        res = new ChecksumCalculator().calculateLsaChecksum(routerlsa.asBytes(), 16, 17);
        routerlsa.setLsCheckSum(OspfUtil.byteToInteger((byte[])res));
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        lsdbAge.ageLsaAndFlood();
        MatcherAssert.assertThat((Object)this.ospfNbr.processReceivedLsa(lsaWrapper.lsaHeader(), true, this.channel, Ip4Address.valueOf((String)"10.10.10.10")), (Matcher)CoreMatchers.is((Object)true));
        this.channel1 = (Channel)EasyMock.createMock(Channel.class);
        MatcherAssert.assertThat((Object)this.ospfNbr.processReceivedLsa((LsaHeader)routerlsa, true, this.channel1, Ip4Address.valueOf((String)"10.10.10.10")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsNullorLatest() throws Exception {
        LsaWrapperImpl lsaWrapper = new LsaWrapperImpl();
        LsdbAgeImpl lsdbAge = new LsdbAgeImpl((OspfArea)new OspfAreaImpl());
        lsdbAge.ageLsaAndFlood();
        lsaWrapper.setLsdbAge((LsdbAge)lsdbAge);
        lsaWrapper.setLsaHeader(new LsaHeader());
        lsaWrapper.addLsa(OspfLsaType.ROUTER, (OspfLsa)new RouterLsa());
        MatcherAssert.assertThat((Object)this.ospfNbr.isNullorLatest((LsaWrapper)lsaWrapper, new LsaHeader()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProcessSelfOriginatedLsa() throws Exception {
        this.ospfNbr.processSelfOriginatedLsa();
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSendLsa() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.sendLsa(new LsaHeader(), Ip4Address.valueOf((String)"1.1.1.1"), this.channel);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDirectAcknowledge() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.directAcknowledge(new LsaHeader(), this.channel, Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testNeighborDown() throws Exception {
        this.ospfNbr.neighborDown();
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testStartFloodingTimer() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfNbr.startFloodingTimer(this.channel);
        MatcherAssert.assertThat((Object)this.ospfNbr, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLastDdPacket() throws Exception {
        this.ospfNbr.setLastDdPacket(new DdPacket());
        MatcherAssert.assertThat((Object)this.ospfNbr.lastDdPacket(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetLastDdPacket() throws Exception {
        this.ospfNbr.setLastDdPacket(new DdPacket());
        MatcherAssert.assertThat((Object)this.ospfNbr.lastDdPacket(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testNeighborId() throws Exception {
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfNbr.neighborId(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetNeighborId() throws Exception {
        this.ospfNbr.setNeighborId(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfNbr.neighborId(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testNeighborDr() throws Exception {
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfNbr.neighborDr(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetNeighborDr() throws Exception {
        this.ospfNbr.setNeighborDr(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfNbr.neighborDr(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testNeighborBdr() throws Exception {
        this.ospfNbr.setNeighborBdr(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfNbr.neighborBdr(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetNeighborBdr() throws Exception {
        this.ospfNbr.setNeighborBdr(Ip4Address.valueOf((String)"1.1.1.1"));
        MatcherAssert.assertThat((Object)this.ospfNbr.neighborBdr(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testRouterPriority() throws Exception {
        this.ospfNbr.setRouterPriority(1);
        MatcherAssert.assertThat((Object)this.ospfNbr.routerPriority(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetRouterPriority() throws Exception {
        this.ospfNbr.setRouterPriority(1);
        MatcherAssert.assertThat((Object)this.ospfNbr.routerPriority(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetOptions() throws Exception {
        this.ospfNbr.setOptions(1);
        MatcherAssert.assertThat((Object)this.ospfNbr.options(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetOptions() throws Exception {
        this.ospfNbr.setOptions(1);
        MatcherAssert.assertThat((Object)this.ospfNbr.options(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetDdSeqNum() throws Exception {
        this.ospfNbr.setDdSeqNum(1L);
        MatcherAssert.assertThat((Object)this.ospfNbr.ddSeqNum(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testSetDdSeqNum() throws Exception {
        this.ospfNbr.setDdSeqNum(1L);
        MatcherAssert.assertThat((Object)this.ospfNbr.ddSeqNum(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testIsMaster() throws Exception {
        this.ospfNbr.setIsMaster(1);
        MatcherAssert.assertThat((Object)this.ospfNbr.isMaster(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetLastSentDdPacket() throws Exception {
        this.ospfNbr.setLastDdPacket(new DdPacket());
        MatcherAssert.assertThat((Object)this.ospfNbr.lastDdPacket(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetLastSentDdPacket() throws Exception {
        this.ospfNbr.setLastDdPacket(new DdPacket());
        MatcherAssert.assertThat((Object)this.ospfNbr.lastDdPacket(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLastSentLsrPacket() throws Exception {
        this.ospfNbr.setLastSentLsrPacket(new LsRequest());
        MatcherAssert.assertThat((Object)this.ospfNbr.getLastSentLsrPacket(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetLastSentLsrPacket() throws Exception {
        this.ospfNbr.setLastSentLsrPacket(new LsRequest());
        MatcherAssert.assertThat((Object)this.ospfNbr.getLastSentLsrPacket(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetState() throws Exception {
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        MatcherAssert.assertThat((Object)this.ospfNbr.getState(), (Matcher)CoreMatchers.is((Object)OspfNeighborState.EXCHANGE));
    }

    @Test
    public void testSetState() throws Exception {
        this.ospfNbr.setState(OspfNeighborState.EXCHANGE);
        MatcherAssert.assertThat((Object)this.ospfNbr.getState(), (Matcher)CoreMatchers.is((Object)OspfNeighborState.EXCHANGE));
    }

    @Test
    public void testSetIsMaster() throws Exception {
        this.ospfNbr.setIsMaster(1);
        MatcherAssert.assertThat((Object)this.ospfNbr.isMaster(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetLsReqList() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfNbr.getLsReqList(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetReTxList() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfNbr.getReTxList(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetPendingReTxList() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfNbr.getPendingReTxList(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

