/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.DeviceInformation;
import org.onosproject.ospf.controller.LinkInformation;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.DeviceInformationImpl;
import org.onosproject.ospf.controller.impl.LinkInformationImpl;
import org.onosproject.ospf.controller.impl.TopologyForDeviceAndLinkImpl;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.lsa.TlvHeader;
import org.onosproject.ospf.protocol.lsa.subtypes.OspfLsaLink;
import org.onosproject.ospf.protocol.lsa.tlvtypes.LinkTlv;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa10;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.lsa.types.TopLevelTlv;

public class TopologyForDeviceAndLinkImplTest {
    private final byte[] packet = new byte[]{0, 9, 0, 4, 0, 0, 0, 1, 0, 9, 0, 4, 0, 0, 0, 1, 0, 1, 0, 4, 0, 0, 0, 1, 0, 2, 0, 4, 0, 0, 0, 1, 0, 3, 0, 4, 0, 0, 0, 1, 0, 4, 0, 4, 0, 0, 0, 1, 0, 6, 0, 4, 0, 0, 0, 1, 0, 7, 0, 4, 0, 0, 0, 1, 0, 8, 0, 4, 0, 0, 0, 1};
    private TopologyForDeviceAndLinkImpl topologyForDeviceAndLink;
    private Map result;
    private LinkTlv linkTlv;
    private TlvHeader header;
    private ChannelBuffer channelBuffer;

    @Before
    public void setUp() throws Exception {
        this.topologyForDeviceAndLink = new TopologyForDeviceAndLinkImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.topologyForDeviceAndLink = null;
    }

    @Test
    public void testDeviceInformationMap() throws Exception {
        this.result = this.topologyForDeviceAndLink.deviceInformationMap();
        MatcherAssert.assertThat((Object)this.result.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testSetDeviceInformationMap() throws Exception {
        this.topologyForDeviceAndLink.setDeviceInformationMap("1.1.1.1", (DeviceInformation)new DeviceInformationImpl());
        this.result = this.topologyForDeviceAndLink.deviceInformationMap();
        MatcherAssert.assertThat((Object)this.result.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testDeviceInformation() throws Exception {
        this.topologyForDeviceAndLink.setDeviceInformationMap("1.1.1.1", (DeviceInformation)new DeviceInformationImpl());
        DeviceInformation deviceInformation = this.topologyForDeviceAndLink.deviceInformation("1.1.1.1");
        MatcherAssert.assertThat((Object)deviceInformation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testRemoveDeviceInformationMap() throws Exception {
        this.topologyForDeviceAndLink.setDeviceInformationMap("1.1.1.1", (DeviceInformation)new DeviceInformationImpl());
        this.topologyForDeviceAndLink.deviceInformation("1.1.1.1");
        this.result = this.topologyForDeviceAndLink.deviceInformationMap();
        this.topologyForDeviceAndLink.removeDeviceInformationMap("1.1.1.1");
        MatcherAssert.assertThat((Object)this.result.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testLinkInformationMap() throws Exception {
        this.result = this.topologyForDeviceAndLink.linkInformationMap();
        MatcherAssert.assertThat((Object)this.result.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testSetLinkInformationMap() throws Exception {
        this.topologyForDeviceAndLink.setLinkInformationMap("1.1.1.1", (LinkInformation)new LinkInformationImpl());
        this.result = this.topologyForDeviceAndLink.linkInformationMap();
        MatcherAssert.assertThat((Object)this.result.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testRemoveLinkInformationMap() throws Exception {
        this.topologyForDeviceAndLink.setLinkInformationMap("1.1.1.1", (LinkInformation)new LinkInformationImpl());
        this.topologyForDeviceAndLink.removeLinkInformationMap("1.1.1.1");
        this.result = this.topologyForDeviceAndLink.linkInformationMap();
        MatcherAssert.assertThat((Object)this.result.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testGetOspfLinkTedHashMap() throws Exception {
        OspfLinkTed ospfLinkTed = this.topologyForDeviceAndLink.getOspfLinkTedHashMap("1.1.1.1");
        MatcherAssert.assertThat((Object)ospfLinkTed, (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testAddLocalDevice() throws Exception {
        OspfAreaImpl ospfArea = new OspfAreaImpl();
        ospfArea.setRouterId(Ip4Address.valueOf((String)"5.5.5.5"));
        this.topologyForDeviceAndLink.addLocalDevice(this.createOspfLsa(), (OspfInterface)new OspfInterfaceImpl(), (OspfArea)ospfArea);
        this.topologyForDeviceAndLink.addLocalDevice(this.createOspfLsa1(), (OspfInterface)new OspfInterfaceImpl(), (OspfArea)ospfArea);
        MatcherAssert.assertThat((Object)this.topologyForDeviceAndLink, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAddLocalLink() throws Exception {
        Ip4Address linkData = Ip4Address.valueOf((String)"1.1.1.1");
        Ip4Address linkSrc = Ip4Address.valueOf((String)"2.2.2.2");
        Ip4Address linkDest = Ip4Address.valueOf((String)"3.3.3.3");
        boolean opaqueEnabled = true;
        boolean linkSrcIdNotRouterId = true;
        this.topologyForDeviceAndLink.addLocalLink("10.10.10.10", linkData, linkSrc, linkDest, opaqueEnabled, linkSrcIdNotRouterId);
        MatcherAssert.assertThat((Object)this.topologyForDeviceAndLink, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testRemoveLinks() throws Exception {
        Ip4Address linkData = Ip4Address.valueOf((String)"1.1.1.1");
        Ip4Address linkSrc = Ip4Address.valueOf((String)"2.2.2.2");
        Ip4Address linkDest = Ip4Address.valueOf((String)"3.3.3.3");
        boolean opaqueEnabled = true;
        boolean linkSrcIdNotRouterId = true;
        this.topologyForDeviceAndLink.addLocalLink("10.10.10.10", linkData, linkSrc, linkDest, opaqueEnabled, linkSrcIdNotRouterId);
        this.topologyForDeviceAndLink.removeLinks(Ip4Address.valueOf((String)"10.10.10.10"));
        MatcherAssert.assertThat((Object)this.topologyForDeviceAndLink, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testUpdateLinkInformation() throws Exception {
        OspfAreaImpl ospfArea = new OspfAreaImpl();
        ospfArea.setRouterId(Ip4Address.valueOf((String)"5.5.5.5"));
        this.topologyForDeviceAndLink.updateLinkInformation(this.createOspfLsa(), (OspfArea)ospfArea);
        MatcherAssert.assertThat((Object)this.topologyForDeviceAndLink, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetDeleteRouterInformation() throws Exception {
        OspfAreaImpl ospfArea = new OspfAreaImpl();
        ospfArea.setRouterId(Ip4Address.valueOf((String)"5.5.5.5"));
        this.topologyForDeviceAndLink.updateLinkInformation(this.createOspfLsa(), (OspfArea)ospfArea);
        List list = this.topologyForDeviceAndLink.getDeleteRouterInformation(this.createOspfLsa(), (OspfArea)ospfArea);
        MatcherAssert.assertThat((Object)list, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private OspfLsa createOspfLsa() {
        RouterLsa routerLsa = new RouterLsa();
        routerLsa.setLsType(1);
        routerLsa.setAdvertisingRouter(Ip4Address.valueOf((String)"6.6.6.6"));
        OspfLsaLink ospfLsaLink = new OspfLsaLink();
        ospfLsaLink.setLinkData("192.168.7.77");
        ospfLsaLink.setLinkId("9.9.9.9");
        ospfLsaLink.setLinkType(1);
        OspfLsaLink ospfLsaLink0 = new OspfLsaLink();
        ospfLsaLink0.setLinkData("7.7.7.7");
        ospfLsaLink0.setLinkId("7.7.7.7");
        ospfLsaLink0.setLinkType(2);
        OspfLsaLink ospfLsaLink120 = new OspfLsaLink();
        ospfLsaLink120.setLinkData("192.168.7.77");
        ospfLsaLink120.setLinkId("1.1.1.1");
        ospfLsaLink120.setLinkType(1);
        OspfLsaLink lsaLink = new OspfLsaLink();
        lsaLink.setLinkData("192.168.7.77");
        lsaLink.setLinkId("14.14.14.14");
        lsaLink.setLinkType(2);
        routerLsa.addRouterLink(lsaLink);
        routerLsa.addRouterLink(ospfLsaLink);
        routerLsa.addRouterLink(ospfLsaLink0);
        routerLsa.addRouterLink(ospfLsaLink120);
        return routerLsa;
    }

    private OspfLsa createOspfLsa1() throws Exception {
        OpaqueLsa10 opaqueLsa10 = new OpaqueLsa10(new OpaqueLsaHeader());
        opaqueLsa10.setLsType(10);
        this.header = new TlvHeader();
        this.header.setTlvLength(8);
        this.header.setTlvType(9);
        this.linkTlv = new LinkTlv(this.header);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.linkTlv.readFrom(this.channelBuffer);
        opaqueLsa10.addValue((TopLevelTlv)this.linkTlv);
        return opaqueLsa10;
    }
}

