/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.lsdb.LsaBinImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;

public class LsaBinImplTest {
    private LsaBinImpl lsaBin;
    private LsaHeader ospflsa1;
    private LsaWrapper lsaWrapper;

    @Before
    public void setUp() throws Exception {
        this.ospflsa1 = new LsaHeader();
        this.ospflsa1.setAge(20);
        this.lsaBin = new LsaBinImpl(1);
    }

    @After
    public void tearDown() throws Exception {
        this.ospflsa1 = null;
        this.lsaBin = null;
    }

    @Test
    public void testGetBinNumber() throws Exception {
        this.lsaWrapper = new LsaWrapperImpl();
        this.lsaBin.addOspfLsa("lsa1", this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.lsaBin.binNumber(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testAddOspfLsa() throws Exception {
        LsaWrapperImpl lsaWrapper = new LsaWrapperImpl();
        this.lsaBin.addOspfLsa("lsa1", (LsaWrapper)lsaWrapper);
        MatcherAssert.assertThat((Object)this.lsaBin, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsa() throws Exception {
        this.lsaWrapper = new LsaWrapperImpl();
        this.lsaBin.addOspfLsa("lsa1", this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.lsaBin, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.lsaBin.ospfLsa("lsa1"), (Matcher)CoreMatchers.is((Object)this.lsaWrapper));
    }

    @Test
    public void testRemoveOspfLsa() throws Exception {
        this.lsaWrapper = new LsaWrapperImpl();
        this.lsaBin.addOspfLsa("lsa1", this.lsaWrapper);
        this.lsaBin.removeOspfLsa("lsa1", this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.lsaBin, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetListOfLsa() throws Exception {
        this.lsaWrapper = new LsaWrapperImpl();
        this.lsaBin.addOspfLsa("lsa1", this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.lsaBin.listOfLsa().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.lsaBin.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

