/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.channel.Channel;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.LsdbAge;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.lsdb.LsaQueueConsumer;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.controller.lsdb.LsdbAgeImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;

public class LsaQueueConsumerTest {
    private LsaQueueConsumer lsaQueueConsumer;
    private BlockingQueue<LsaWrapper> blockingQueue;
    private Channel channel;
    private LsaWrapperImpl lsaWrapper;
    private OspfArea ospfArea;
    private RouterLsa routerLsa;
    private OspfInterfaceImpl ospfInterface;
    private LsaHeader lsaHeader;
    private LsdbAgeImpl lsdbAge;

    @Before
    public void setUp() throws Exception {
        this.lsaQueueConsumer = (LsaQueueConsumer)EasyMock.createMock(LsaQueueConsumer.class);
    }

    @After
    public void tearDown() throws Exception {
        this.lsaQueueConsumer = null;
        this.blockingQueue = null;
        this.channel = null;
        this.lsaWrapper = null;
        this.lsdbAge = null;
        this.lsaHeader = null;
        this.ospfInterface = null;
        this.ospfArea = null;
        this.routerLsa = null;
    }

    @Test
    public void testRun() throws Exception {
        this.blockingQueue = new ArrayBlockingQueue<LsaWrapper>(5);
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfArea = new OspfAreaImpl();
        this.lsaWrapper = new LsaWrapperImpl();
        this.lsaWrapper.setLsaProcessing("verifyChecksum");
        this.blockingQueue.add((LsaWrapper)this.lsaWrapper);
        this.lsaQueueConsumer = new LsaQueueConsumer(this.blockingQueue, this.channel, this.ospfArea);
        this.lsaQueueConsumer.run();
        MatcherAssert.assertThat((Object)this.lsaQueueConsumer, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRun1() throws Exception {
        this.blockingQueue = new ArrayBlockingQueue<LsaWrapper>(5);
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfArea = new OspfAreaImpl();
        this.lsaWrapper = new LsaWrapperImpl();
        this.routerLsa = new RouterLsa();
        this.routerLsa.setLsType(1);
        this.lsaWrapper.addLsa(OspfLsaType.ROUTER, (OspfLsa)this.routerLsa);
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterface.setState(OspfInterfaceState.DR);
        this.lsaWrapper.setOspfInterface((OspfInterface)this.ospfInterface);
        this.lsaWrapper.setIsSelfOriginated(true);
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setLsType(1);
        this.lsaWrapper.setLsaHeader(this.lsaHeader);
        this.lsaWrapper.setLsaProcessing("refreshLsa");
        this.lsaWrapper.setLsdbAge((LsdbAge)new LsdbAgeImpl((OspfArea)new OspfAreaImpl()));
        this.blockingQueue.add((LsaWrapper)this.lsaWrapper);
        this.lsaQueueConsumer = new LsaQueueConsumer(this.blockingQueue, this.channel, this.ospfArea);
        this.lsaQueueConsumer.run();
        MatcherAssert.assertThat((Object)this.lsaQueueConsumer, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRun3() throws Exception {
        this.blockingQueue = new ArrayBlockingQueue<LsaWrapper>(5);
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfArea = new OspfAreaImpl();
        this.lsaWrapper = new LsaWrapperImpl();
        this.routerLsa = new RouterLsa();
        this.routerLsa.setLsType(2);
        this.lsaWrapper.addLsa(OspfLsaType.NETWORK, (OspfLsa)this.routerLsa);
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterface.setState(OspfInterfaceState.BDR);
        this.lsaWrapper.setOspfInterface((OspfInterface)this.ospfInterface);
        this.lsaWrapper.setIsSelfOriginated(true);
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setLsType(2);
        this.lsaWrapper.setLsaHeader(this.lsaHeader);
        this.lsaWrapper.setLsaProcessing("refreshLsa");
        this.lsaWrapper.setLsdbAge((LsdbAge)new LsdbAgeImpl((OspfArea)new OspfAreaImpl()));
        this.blockingQueue.add((LsaWrapper)this.lsaWrapper);
        this.lsaQueueConsumer = new LsaQueueConsumer(this.blockingQueue, this.channel, this.ospfArea);
        this.lsaQueueConsumer.run();
        MatcherAssert.assertThat((Object)this.lsaQueueConsumer, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRun5() throws Exception {
        this.blockingQueue = new ArrayBlockingQueue<LsaWrapper>(5);
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.ospfArea = new OspfAreaImpl();
        this.lsaWrapper = new LsaWrapperImpl();
        this.routerLsa = new RouterLsa();
        this.routerLsa.setLsType(2);
        this.lsaWrapper.addLsa(OspfLsaType.NETWORK, (OspfLsa)this.routerLsa);
        this.ospfInterface = new OspfInterfaceImpl();
        this.ospfInterface.setState(OspfInterfaceState.DR);
        this.lsaWrapper.setOspfInterface((OspfInterface)this.ospfInterface);
        this.lsaWrapper.setIsSelfOriginated(true);
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setLsType(2);
        this.lsaWrapper.setLsaHeader(this.lsaHeader);
        this.lsaWrapper.setLsaProcessing("maxAgeLsa");
        this.lsaWrapper.setLsdbAge((LsdbAge)new LsdbAgeImpl((OspfArea)new OspfAreaImpl()));
        this.blockingQueue.add((LsaWrapper)this.lsaWrapper);
        this.lsaQueueConsumer = new LsaQueueConsumer(this.blockingQueue, this.channel, this.ospfArea);
        this.lsaQueueConsumer.run();
        MatcherAssert.assertThat((Object)this.lsaQueueConsumer, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetChannel() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.lsdbAge = new LsdbAgeImpl((OspfArea)new OspfAreaImpl());
        this.lsdbAge.startDbAging();
        this.lsdbAge.setChannel(this.channel);
        MatcherAssert.assertThat((Object)this.lsaQueueConsumer, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

