/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.controller.LsdbAge;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.controller.lsdb.LsdbAgeImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;

public class LsaWrapperImplTest {
    private LsaWrapperImpl lsaWrapper;
    private LsdbAgeImpl lsdbAge;
    private LsaHeader header;
    private OspfInterfaceImpl ospfInterfaceImpl;

    @Before
    public void setUp() throws Exception {
        this.lsaWrapper = new LsaWrapperImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.lsaWrapper = null;
        this.header = null;
        this.lsdbAge = null;
        this.ospfInterfaceImpl = null;
    }

    @Test
    public void testGetLsaType() throws Exception {
        this.lsaWrapper.setLsaType(OspfLsaType.ROUTER);
        MatcherAssert.assertThat((Object)this.lsaWrapper.lsaType(), (Matcher)CoreMatchers.is((Object)OspfLsaType.ROUTER));
    }

    @Test
    public void testSetLsaType() throws Exception {
        this.lsaWrapper.setLsaType(OspfLsaType.ROUTER);
        MatcherAssert.assertThat((Object)this.lsaWrapper.lsaType(), (Matcher)CoreMatchers.is((Object)OspfLsaType.ROUTER));
    }

    @Test
    public void testIsSelfOriginated() throws Exception {
        this.lsaWrapper.setIsSelfOriginated(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isSelfOriginated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetIsSelfOriginated() throws Exception {
        this.lsaWrapper.setIsSelfOriginated(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isSelfOriginated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testAddLsa() throws Exception {
        this.lsaWrapper.addLsa(OspfLsaType.ROUTER, (OspfLsa)new RouterLsa());
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsaAgeReceived() throws Exception {
        this.lsaWrapper.setLsaAgeReceived(10);
        MatcherAssert.assertThat((Object)this.lsaWrapper.lsaAgeReceived(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetLsaAgeReceived() throws Exception {
        this.lsaWrapper.setLsaAgeReceived(10);
        MatcherAssert.assertThat((Object)this.lsaWrapper.lsaAgeReceived(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testGetLsaHeader() throws Exception {
        this.lsdbAge = new LsdbAgeImpl((OspfArea)new OspfAreaImpl());
        this.lsdbAge.ageLsaAndFlood();
        this.lsaWrapper.setLsdbAge((LsdbAge)this.lsdbAge);
        this.header = new LsaHeader();
        this.lsaWrapper.setLsaHeader(this.header);
        MatcherAssert.assertThat((Object)this.lsaWrapper.lsaHeader(), (Matcher)CoreMatchers.instanceOf(LsaHeader.class));
    }

    @Test
    public void testSetLsaHeader() throws Exception {
        this.lsdbAge = new LsdbAgeImpl((OspfArea)new OspfAreaImpl());
        this.lsdbAge.ageLsaAndFlood();
        this.lsaWrapper.setLsdbAge((LsdbAge)this.lsdbAge);
        this.header = new LsaHeader();
        this.lsaWrapper.setLsaHeader(this.header);
        MatcherAssert.assertThat((Object)this.lsaWrapper.lsaHeader(), (Matcher)CoreMatchers.instanceOf(LsaHeader.class));
    }

    @Test
    public void testSetOspfLsa() throws Exception {
        this.lsaWrapper.setOspfLsa((OspfLsa)new RouterLsa());
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetNoReTransmissionLists() throws Exception {
        this.lsaWrapper.setNoReTransmissionLists(10);
        MatcherAssert.assertThat((Object)this.lsaWrapper.noReTransmissionLists(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetNoReTransmissionLists() throws Exception {
        this.lsaWrapper.setNoReTransmissionLists(10);
        MatcherAssert.assertThat((Object)this.lsaWrapper.noReTransmissionLists(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testIsInAnAgeBin() throws Exception {
        this.lsaWrapper.setInAnAgeBin(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isInAnAgeBin(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetInAnAgeBin() throws Exception {
        this.lsaWrapper.setInAnAgeBin(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isInAnAgeBin(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsChangedSinceLastFlood() throws Exception {
        this.lsaWrapper.setChangedSinceLastFlood(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isChangedSinceLastFlood(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetChangedSinceLastFlood() throws Exception {
        this.lsaWrapper.setChangedSinceLastFlood(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isChangedSinceLastFlood(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSequenceRollOver() throws Exception {
        this.lsaWrapper.setIsSequenceRollOver(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isSequenceRollOver(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsSentReplyForOlderLsa() throws Exception {
        this.lsaWrapper.setSentReplyForOlderLsa(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isSentReplyForOlderLsa(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsCheckAge() throws Exception {
        this.lsaWrapper.setCheckAge(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isCheckAge(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetSentReplyForOlderLsa() throws Exception {
        this.lsaWrapper.setSentReplyForOlderLsa(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isSentReplyForOlderLsa(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetCheckAge() throws Exception {
        this.lsaWrapper.setCheckAge(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isCheckAge(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsAging() throws Exception {
        this.lsaWrapper.setIsAging(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isAging(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetIsAging() throws Exception {
        this.lsaWrapper.setIsAging(true);
        MatcherAssert.assertThat((Object)this.lsaWrapper.isAging(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetCurrentAge() throws Exception {
        this.lsdbAge = new LsdbAgeImpl((OspfArea)new OspfAreaImpl());
        this.lsdbAge.ageLsaAndFlood();
        this.lsaWrapper.setLsdbAge((LsdbAge)this.lsdbAge);
        MatcherAssert.assertThat((Object)this.lsaWrapper.currentAge(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetAgeCounterWhenReceived() throws Exception {
        this.lsaWrapper.setAgeCounterWhenReceived(10);
        MatcherAssert.assertThat((Object)this.lsaWrapper.ageCounterWhenReceived(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetAgeCounterWhenReceived() throws Exception {
        this.lsaWrapper.setAgeCounterWhenReceived(10);
        MatcherAssert.assertThat((Object)this.lsaWrapper.ageCounterWhenReceived(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testGetLsaProcessing() throws Exception {
        this.lsaWrapper.setLsaProcessing("router");
        MatcherAssert.assertThat((Object)this.lsaWrapper.lsaProcessing(), (Matcher)CoreMatchers.is((Object)"router"));
    }

    @Test
    public void testSetLsaProcessing() throws Exception {
        this.lsaWrapper.setLsaProcessing("router");
        MatcherAssert.assertThat((Object)this.lsaWrapper.lsaProcessing(), (Matcher)CoreMatchers.is((Object)"router"));
    }

    @Test
    public void testGetBinNumber() throws Exception {
        this.lsaWrapper.setBinNumber(10);
        MatcherAssert.assertThat((Object)this.lsaWrapper.binNumber(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetBinNumber() throws Exception {
        this.lsaWrapper.setBinNumber(10);
        MatcherAssert.assertThat((Object)this.lsaWrapper.binNumber(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testGetOspfInterface() throws Exception {
        this.ospfInterfaceImpl = (OspfInterfaceImpl)EasyMock.createMock(OspfInterfaceImpl.class);
        this.lsaWrapper.setOspfInterface((OspfInterface)this.ospfInterfaceImpl);
        MatcherAssert.assertThat((Object)this.lsaWrapper.ospfInterface(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetOspfInterface() throws Exception {
        this.ospfInterfaceImpl = (OspfInterfaceImpl)EasyMock.createMock(OspfInterfaceImpl.class);
        this.lsaWrapper.setOspfInterface((OspfInterface)this.ospfInterfaceImpl);
        MatcherAssert.assertThat((Object)this.lsaWrapper.ospfInterface(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsdbAge() throws Exception {
        MatcherAssert.assertThat((Object)this.lsaWrapper.getLsdbAge(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.lsaWrapper.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.lsaWrapper.equals((Object)new LsaWrapperImpl()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        int hashCode = this.lsaWrapper.hashCode();
        MatcherAssert.assertThat((Object)hashCode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

