/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.channel.Channel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.controller.LsaBin;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.LsdbAge;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.lsdb.LsaBinImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.controller.lsdb.LsdbAgeImpl;

public class LsdbAgeImplTest {
    private LsdbAgeImpl lsdbAge;
    private OspfAreaImpl ospfAreaImpl;
    private LsaBinImpl lsaBin;
    private LsaBin lsaBin1;
    private LsaWrapperImpl lsaWrapper;
    private OspfArea ospfArea;
    private Channel channel;

    @Before
    public void setUp() throws Exception {
        this.ospfAreaImpl = (OspfAreaImpl)EasyMock.createMock(OspfAreaImpl.class);
        this.lsdbAge = new LsdbAgeImpl((OspfArea)this.ospfAreaImpl);
    }

    @After
    public void tearDown() throws Exception {
        this.lsdbAge = null;
        this.lsaBin = null;
        this.lsaBin1 = null;
        this.ospfAreaImpl = null;
        this.lsaWrapper = null;
        this.channel = null;
        this.ospfArea = null;
    }

    @Test
    public void testGetLsaBin() throws Exception {
        this.lsaBin = new LsaBinImpl(1);
        this.lsdbAge.addLsaBin(Integer.valueOf(1), (LsaBin)this.lsaBin);
        MatcherAssert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.lsaBin1 = this.lsdbAge.getLsaBin(Integer.valueOf(1));
        MatcherAssert.assertThat((Object)this.lsaBin, (Matcher)CoreMatchers.instanceOf(LsaBin.class));
        MatcherAssert.assertThat((Object)this.lsaBin1, (Matcher)CoreMatchers.instanceOf(LsaBin.class));
    }

    @Test
    public void testAddLsaBin() throws Exception {
        this.lsaBin = new LsaBinImpl(1);
        this.lsdbAge.addLsaBin(Integer.valueOf(1), (LsaBin)this.lsaBin);
        MatcherAssert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.lsaBin, (Matcher)CoreMatchers.instanceOf(LsaBin.class));
    }

    @Test
    public void testEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.lsdbAge.equals((Object)this.lsdbAge), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHashCode() throws Exception {
        int hashCode = this.lsdbAge.hashCode();
        MatcherAssert.assertThat((Object)hashCode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAddLsaToMaxAgeBin() throws Exception {
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa1", (LsaWrapper)this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemoveLsaFromBin() throws Exception {
        this.lsaBin = (LsaBinImpl)EasyMock.createMock(LsaBinImpl.class);
        this.lsaWrapper = new LsaWrapperImpl();
        this.lsaWrapper.setBinNumber(-1);
        this.lsaBin.addOspfLsa("1", (LsaWrapper)this.lsaWrapper);
        this.lsdbAge.startDbAging();
        this.lsdbAge.addLsaToMaxAgeBin("3600", (LsaWrapper)this.lsaWrapper);
        this.lsdbAge.addLsaBin(Integer.valueOf(-1), (LsaBin)this.lsaBin);
        this.lsdbAge.removeLsaFromBin((LsaWrapper)this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testStartDbAging() throws Exception {
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa1", (LsaWrapper)this.lsaWrapper);
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa2", (LsaWrapper)this.lsaWrapper);
        this.lsdbAge.startDbAging();
        MatcherAssert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAgeLsaAndFlood() throws Exception {
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa1", (LsaWrapper)this.lsaWrapper);
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa2", (LsaWrapper)this.lsaWrapper);
        this.lsdbAge.startDbAging();
        this.lsdbAge.ageLsaAndFlood();
        Assert.assertNotNull((Object)this.lsdbAge);
    }

    @Test
    public void testMaxageLsa() throws Exception {
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.ospfArea = new OspfAreaImpl();
        this.lsdbAge = new LsdbAgeImpl(this.ospfArea);
        this.lsaWrapper.setLsdbAge((LsdbAge)this.lsdbAge);
        this.lsdbAge.addLsaToMaxAgeBin("lsa1", (LsaWrapper)this.lsaWrapper);
        this.lsaBin = new LsaBinImpl(1);
        this.lsaBin.addOspfLsa("1", (LsaWrapper)this.lsaWrapper);
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa2", (LsaWrapper)this.lsaWrapper);
        this.lsaBin.addOspfLsa("2", (LsaWrapper)this.lsaWrapper);
        this.lsdbAge.startDbAging();
        this.lsdbAge = new LsdbAgeImpl((OspfArea)new OspfAreaImpl());
        this.lsdbAge.ageLsaAndFlood();
        this.lsdbAge.maxAgeLsa();
        MatcherAssert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRefereshLsa() throws Exception {
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsaWrapper.setBinNumber(0);
        this.lsdbAge.addLsaToMaxAgeBin("lsa1", (LsaWrapper)this.lsaWrapper);
        this.lsdbAge.ageLsaAndFlood();
        this.lsaWrapper.setBinNumber(0);
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa2", (LsaWrapper)this.lsaWrapper);
        this.lsdbAge.ageLsaAndFlood();
        this.lsdbAge.startDbAging();
        this.lsaBin = new LsaBinImpl(1809);
        this.lsdbAge.refreshLsa();
        MatcherAssert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testCheckAges() throws Exception {
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa1", (LsaWrapper)this.lsaWrapper);
        this.lsaWrapper = (LsaWrapperImpl)EasyMock.createMock(LsaWrapperImpl.class);
        this.lsdbAge.addLsaToMaxAgeBin("lsa2", (LsaWrapper)this.lsaWrapper);
        this.lsdbAge.startDbAging();
        this.lsdbAge.checkAges();
        MatcherAssert.assertThat((Object)this.lsdbAge, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetChannel() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.lsdbAge.setChannel(this.channel);
        MatcherAssert.assertThat((Object)this.lsdbAge.getChannel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetChannel() throws Exception {
        this.channel = (Channel)EasyMock.createMock(Channel.class);
        this.lsdbAge.setChannel(this.channel);
        MatcherAssert.assertThat((Object)this.lsdbAge.getChannel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetAgeCounter() throws Exception {
        this.lsaBin = new LsaBinImpl(1);
        this.lsdbAge.addLsaBin(Integer.valueOf(1), (LsaBin)this.lsaBin);
        int age = this.lsdbAge.getAgeCounter();
        MatcherAssert.assertThat((Object)age, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetAgeCounterRollOver() throws Exception {
        this.lsaBin = new LsaBinImpl(1);
        this.lsdbAge.addLsaBin(Integer.valueOf(1), (LsaBin)this.lsaBin);
        this.lsdbAge.startDbAging();
        MatcherAssert.assertThat((Object)this.lsdbAge.getAgeCounterRollOver(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetMaxAgeBin() throws Exception {
        this.lsaBin = new LsaBinImpl(1);
        this.lsdbAge.addLsaBin(Integer.valueOf(1), (LsaBin)this.lsaBin);
        this.lsdbAge.startDbAging();
        MatcherAssert.assertThat((Object)this.lsdbAge.getMaxAgeBin(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAge2Bin() throws Exception {
        int age = this.lsdbAge.age2Bin(0);
        MatcherAssert.assertThat((Object)age, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

