/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.lsdb;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.controller.lsdb.OspfLsdbImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.lsa.types.AsbrSummaryLsa;
import org.onosproject.ospf.protocol.lsa.types.ExternalLsa;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa10;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa11;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa9;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.lsa.types.SummaryLsa;

public class OspfLsdbImplTest {
    private OspfLsdbImpl ospfLsdb;
    private RouterLsa routerLsa;
    private NetworkLsa networkLsa;
    private SummaryLsa summaryLsa;
    private AsbrSummaryLsa asbrSummaryLsa;
    private OpaqueLsa9 opaqueLsa9;
    private OpaqueLsa10 opaqueLsa10;
    private OpaqueLsa11 opaqueLsa11;
    private ExternalLsa externalLsa;
    private OpaqueLsaHeader opaqueLsaHeader;
    private LsaWrapperImpl lsaWrapper;
    private OpaqueLsaHeader opaqueLsaHeader1;
    private String key;

    @Before
    public void setUp() throws Exception {
        OspfAreaImpl ospfArea = new OspfAreaImpl();
        this.ospfLsdb = new OspfLsdbImpl((OspfArea)ospfArea);
        this.routerLsa = new RouterLsa();
        this.networkLsa = new NetworkLsa();
        this.summaryLsa = new SummaryLsa(new LsaHeader());
        this.asbrSummaryLsa = new AsbrSummaryLsa(new LsaHeader());
        this.opaqueLsa9 = new OpaqueLsa9(new OpaqueLsaHeader());
        this.opaqueLsa10 = new OpaqueLsa10(new OpaqueLsaHeader());
        this.opaqueLsa11 = new OpaqueLsa11(new OpaqueLsaHeader());
        this.externalLsa = new ExternalLsa(new LsaHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.ospfLsdb = null;
        this.routerLsa = null;
        this.externalLsa = null;
        this.summaryLsa = null;
        this.asbrSummaryLsa = null;
        this.opaqueLsa10 = null;
        this.opaqueLsa11 = null;
        this.opaqueLsa9 = null;
        this.networkLsa = null;
        this.lsaWrapper = null;
        this.opaqueLsaHeader = null;
        this.opaqueLsaHeader1 = null;
        this.key = null;
    }

    @Test
    public void testEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfLsdb.equals((Object)new OspfLsdbImpl((OspfArea)new OspfAreaImpl())), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testHashCode() throws Exception {
        int hashCode = this.ospfLsdb.hashCode();
        MatcherAssert.assertThat((Object)hashCode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInitializeDb() throws Exception {
        this.ospfLsdb.initializeDb();
        MatcherAssert.assertThat((Object)this.ospfLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetAllLsaHeaders() throws Exception {
        this.ospfLsdb.initializeDb();
        this.routerLsa.setLsType(1);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.routerLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.networkLsa.setLsType(2);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.networkLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.summaryLsa.setLsType(3);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.summaryLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.asbrSummaryLsa.setLsType(4);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.asbrSummaryLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.externalLsa.setLsType(5);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.externalLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.ospfLsdb.initializeDb();
        MatcherAssert.assertThat((Object)this.ospfLsdb.getAllLsaHeaders(true, true).size(), (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testGetLsaKey() throws Exception {
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(1);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(2);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(3);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(4);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(5);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(9);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(10);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(11);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testLsaLookup() throws Exception {
        this.ospfLsdb.initializeDb();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.ospfLsdb.addLsa((LsaHeader)this.opaqueLsaHeader, true, (OspfInterface)new OspfInterfaceImpl());
        this.opaqueLsaHeader.setLsType(1);
        String key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        MatcherAssert.assertThat((Object)this.ospfLsdb.lsaLookup((LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFindlsa() throws Exception {
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(1);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsa((LsaHeader)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        this.lsaWrapper = (LsaWrapperImpl)this.ospfLsdb.findLsa(this.opaqueLsaHeader.lsType(), this.key);
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(2);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsa((LsaHeader)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        this.lsaWrapper = (LsaWrapperImpl)this.ospfLsdb.findLsa(this.opaqueLsaHeader.lsType(), this.key);
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(3);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsa((LsaHeader)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        this.lsaWrapper = (LsaWrapperImpl)this.ospfLsdb.findLsa(this.opaqueLsaHeader.lsType(), this.key);
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(4);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsa((LsaHeader)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        this.lsaWrapper = (LsaWrapperImpl)this.ospfLsdb.findLsa(this.opaqueLsaHeader.lsType(), this.key);
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(5);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsa((LsaHeader)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        this.lsaWrapper = (LsaWrapperImpl)this.ospfLsdb.findLsa(this.opaqueLsaHeader.lsType(), this.key);
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(9);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsa((LsaHeader)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        this.lsaWrapper = (LsaWrapperImpl)this.ospfLsdb.findLsa(this.opaqueLsaHeader.lsType(), this.key);
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(10);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsa((LsaHeader)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        this.lsaWrapper = (LsaWrapperImpl)this.ospfLsdb.findLsa(this.opaqueLsaHeader.lsType(), this.key);
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(11);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsa((LsaHeader)new RouterLsa(), false, (OspfInterface)new OspfInterfaceImpl());
        this.lsaWrapper = (LsaWrapperImpl)this.ospfLsdb.findLsa(this.opaqueLsaHeader.lsType(), this.key);
        MatcherAssert.assertThat((Object)this.lsaWrapper, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testAddLsa() throws Exception {
        this.routerLsa.setLsType(1);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.routerLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.networkLsa.setLsType(2);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.networkLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.summaryLsa.setLsType(3);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.summaryLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.asbrSummaryLsa.setLsType(4);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.asbrSummaryLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.externalLsa.setLsType(5);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.externalLsa, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.opaqueLsa9.setLsType(9);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.opaqueLsa9, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.opaqueLsa10.setLsType(10);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.opaqueLsa10, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
        this.opaqueLsa11.setLsType(11);
        MatcherAssert.assertThat((Object)this.ospfLsdb.addLsa((LsaHeader)this.opaqueLsa11, false, (OspfInterface)new OspfInterfaceImpl()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testAddLsaToMaxAgeBin() throws Exception {
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(1);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(2);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(3);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(4);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(5);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(9);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(10);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(11);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.ospfLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testRemoveLsaFromBin() throws Exception {
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(1);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.ospfLsdb.removeLsaFromBin((Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(2);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.ospfLsdb.removeLsaFromBin((Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(3);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.ospfLsdb.removeLsaFromBin((Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(4);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.ospfLsdb.removeLsaFromBin((Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(5);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.ospfLsdb.removeLsaFromBin((Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(9);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.ospfLsdb.removeLsaFromBin((Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(10);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.ospfLsdb.removeLsaFromBin((Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(11);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.ospfLsdb.removeLsaFromBin((Object)this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.ospfLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testIsNewerorSameLsa() throws Exception {
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(1);
        this.key = this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader1);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader1);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        this.lsaWrapper = new LsaWrapperImpl();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.opaqueLsaHeader.setLsType(2);
        this.ospfLsdb.getLsaKey((LsaHeader)this.opaqueLsaHeader);
        this.lsaWrapper.setLsaHeader((LsaHeader)this.opaqueLsaHeader);
        this.ospfLsdb.addLsaToMaxAgeBin(this.key, (Object)this.lsaWrapper);
        MatcherAssert.assertThat((Object)this.ospfLsdb.isNewerOrSameLsa((LsaHeader)this.opaqueLsaHeader1, (LsaHeader)this.opaqueLsaHeader), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospfLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsSequenceNumber() throws Exception {
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsSequenceNumber(OspfLsaType.NETWORK), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsSequenceNumber(OspfLsaType.ROUTER), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testDeleteLsa() throws Exception {
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(1);
        this.ospfLsdb.deleteLsa((LsaHeader)this.opaqueLsaHeader1);
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(2);
        this.ospfLsdb.deleteLsa((LsaHeader)this.opaqueLsaHeader1);
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(3);
        this.ospfLsdb.deleteLsa((LsaHeader)this.opaqueLsaHeader1);
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(4);
        this.ospfLsdb.deleteLsa((LsaHeader)this.opaqueLsaHeader1);
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(5);
        this.ospfLsdb.deleteLsa((LsaHeader)this.opaqueLsaHeader1);
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(9);
        this.ospfLsdb.deleteLsa((LsaHeader)this.opaqueLsaHeader1);
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(10);
        this.ospfLsdb.deleteLsa((LsaHeader)this.opaqueLsaHeader1);
        this.opaqueLsaHeader1 = new OpaqueLsaHeader();
        this.opaqueLsaHeader1.setLsType(11);
        this.ospfLsdb.deleteLsa((LsaHeader)this.opaqueLsaHeader1);
        MatcherAssert.assertThat((Object)this.ospfLsdb, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetRouterLsaSeqNo() throws Exception {
        this.ospfLsdb.setRouterLsaSeqNo(-2147483647L);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsSequenceNumber(OspfLsaType.ROUTER), (Matcher)CoreMatchers.is((Object)-2147483647L));
    }

    @Test
    public void testSetNetworkLsaSeqNo() throws Exception {
        this.ospfLsdb.setNetworkLsaSeqNo(111111L);
        MatcherAssert.assertThat((Object)this.ospfLsdb.getLsSequenceNumber(OspfLsaType.NETWORK), (Matcher)CoreMatchers.is((Object)111111L));
    }
}

