/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.area;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfAreaAddressRange;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.OspfLsdb;
import org.onosproject.ospf.controller.OspfNbr;
import org.onosproject.ospf.controller.OspfNeighborState;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.OspfNbrImpl;
import org.onosproject.ospf.controller.lsdb.OspfLsdbImpl;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.subtypes.OspfLsaLink;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.util.ChecksumCalculator;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;
import org.onosproject.ospf.protocol.util.OspfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfAreaImpl
implements OspfArea {
    private static final Logger log = LoggerFactory.getLogger(OspfAreaImpl.class);
    private List<OspfAreaAddressRange> addressRanges;
    private boolean transitCapability;
    private boolean externalRoutingCapability;
    private int stubCost;
    private List<OspfInterface> interfacesLst;
    private OspfLsdbImpl database = new OspfLsdbImpl(this);
    private Ip4Address areaId;
    private Ip4Address routerId;
    private int options;
    private boolean isOpaqueEnable;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OspfAreaImpl that = (OspfAreaImpl)o;
        return Objects.equal((Object)this.areaId, (Object)that.areaId) && Objects.equal((Object)this.routerId, (Object)that.routerId) && Objects.equal((Object)this.addressRanges.size(), (Object)that.addressRanges.size()) && Objects.equal((Object)this.transitCapability, (Object)that.transitCapability) && Objects.equal((Object)this.externalRoutingCapability, (Object)that.externalRoutingCapability) && Objects.equal((Object)this.stubCost, (Object)that.stubCost) && Objects.equal((Object)this.interfacesLst.size(), (Object)that.interfacesLst.size()) && Objects.equal((Object)this.database, (Object)that.database);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.areaId, this.routerId, this.addressRanges, this.transitCapability, this.externalRoutingCapability, this.stubCost, this.interfacesLst, this.database});
    }

    public Ip4Address routerId() {
        return this.routerId;
    }

    @JsonProperty(value="routerId")
    public void setRouterId(Ip4Address routerId) {
        this.routerId = routerId;
    }

    @JsonProperty(value="isOpaqueEnable")
    public void setIsOpaqueEnabled(boolean isOpaqueEnable) {
        this.isOpaqueEnable = isOpaqueEnable;
    }

    public boolean isOpaqueEnabled() {
        return this.isOpaqueEnable;
    }

    public void initializeDb() {
        this.database.initializeDb();
    }

    public void refreshArea(OspfInterface ospfInterface) {
        OspfInterfaceImpl ospfInterfaceImpl = (OspfInterfaceImpl)ospfInterface;
        log.debug("Inside refreshArea...!!!");
        if (ospfInterfaceImpl.state() == OspfInterfaceState.DR) {
            if (ospfInterface.listOfNeighbors().size() > 0) {
                NetworkLsa networkLsa = null;
                try {
                    networkLsa = this.buildNetworkLsa(ospfInterface.ipAddress(), ospfInterface.ipNetworkMask());
                }
                catch (Exception e) {
                    log.debug("Error while building NetworkLsa {}", (Object)e.getMessage());
                }
                this.database.addLsa((LsaHeader)networkLsa, true, ospfInterface);
                this.addToOtherNeighborLsaTxList((LsaHeader)networkLsa);
            } else {
                log.debug("No Neighbors hence not creating  NetworkLSA...!!!");
            }
        }
        RouterLsa routerLsa = null;
        try {
            routerLsa = this.buildRouterLsa(ospfInterface);
        }
        catch (Exception e) {
            log.debug("Error while building RouterLsa {}", (Object)e.getMessage());
        }
        this.database.addLsa((LsaHeader)routerLsa, true, ospfInterface);
        this.addToOtherNeighborLsaTxList((LsaHeader)routerLsa);
    }

    public NetworkLsa buildNetworkLsa(Ip4Address interfaceIp, Ip4Address mask) throws Exception {
        List<OspfNbr> neighborsInFullState;
        NetworkLsa networkLsa = new NetworkLsa();
        networkLsa.setAdvertisingRouter(this.routerId);
        networkLsa.setLinkStateId(interfaceIp.toString());
        networkLsa.setLsType(OspfLsaType.NETWORK.value());
        networkLsa.setAge(1);
        networkLsa.setOptions(2);
        networkLsa.setNetworkMask(mask);
        networkLsa.addAttachedRouter(this.routerId());
        Iterator<OspfInterface> iter = this.interfacesLst.iterator();
        OspfInterfaceImpl ospfInterface = null;
        while (iter.hasNext() && !(ospfInterface = (OspfInterfaceImpl)iter.next()).ipAddress().equals((Object)interfaceIp)) {
        }
        if (ospfInterface != null && (neighborsInFullState = this.getNeighborsInFullState(ospfInterface)) != null) {
            for (OspfNbr ospfnbr : neighborsInFullState) {
                networkLsa.addAttachedRouter(ospfnbr.neighborId());
                log.debug("Adding attached neighbor:: {}", (Object)ospfnbr.neighborId());
            }
        }
        networkLsa.setLsSequenceNo(this.database.getLsSequenceNumber(OspfLsaType.NETWORK));
        ChecksumCalculator checksum = new ChecksumCalculator();
        byte[] lsaBytes = networkLsa.asBytes();
        networkLsa.setLsPacketLen(lsaBytes.length);
        lsaBytes = networkLsa.asBytes();
        byte[] twoByteChecksum = checksum.calculateLsaChecksum(lsaBytes, 16, 17);
        int checkSumVal = OspfUtil.byteToInteger((byte[])twoByteChecksum);
        networkLsa.setLsCheckSum(checkSumVal);
        return networkLsa;
    }

    public RouterLsa buildRouterLsa(OspfInterface ospfInterface) throws Exception {
        RouterLsa routerLsa = new RouterLsa();
        routerLsa.setAdvertisingRouter(this.routerId);
        routerLsa.setLinkStateId(this.routerId.toString());
        routerLsa.setLsType(OspfLsaType.ROUTER.value());
        routerLsa.setAge(1);
        routerLsa.setOptions(this.options);
        routerLsa.setAreaBorderRouter(false);
        routerLsa.setAsBoundaryRouter(false);
        routerLsa.setVirtualEndPoint(false);
        this.buildLinkForRouterLsa(routerLsa, ospfInterface);
        routerLsa.setLsSequenceNo(this.database.getLsSequenceNumber(OspfLsaType.ROUTER));
        ChecksumCalculator checksum = new ChecksumCalculator();
        byte[] lsaBytes = routerLsa.asBytes();
        routerLsa.setLsPacketLen(lsaBytes.length);
        lsaBytes = routerLsa.asBytes();
        byte[] twoByteChecksum = checksum.calculateLsaChecksum(lsaBytes, 16, 17);
        int checkSumVal = OspfUtil.byteToInteger((byte[])twoByteChecksum);
        routerLsa.setLsCheckSum(checkSumVal);
        return routerLsa;
    }

    private void buildLinkForRouterLsa(RouterLsa routerLsa, OspfInterface ospfInterface) {
        for (OspfInterfaceImpl ospfInterfaceImpl : this.interfacesLst) {
            if (ospfInterfaceImpl.state() == OspfInterfaceState.DOWN) continue;
            if (ospfInterfaceImpl.state() == OspfInterfaceState.LOOPBACK) {
                OspfLsaLink link = new OspfLsaLink();
                link.setLinkData("-1");
                link.setLinkId(ospfInterfaceImpl.ipAddress().toString());
                link.setLinkType(3);
                link.setMetric(0);
                link.setTos(0);
                routerLsa.addRouterLink(link);
                routerLsa.incrementLinkNo();
                continue;
            }
            if (ospfInterfaceImpl.state() == OspfInterfaceState.POINT2POINT) {
                List<OspfNbr> neighborsInFullState = this.getNeighborsInFullState(ospfInterfaceImpl);
                if (neighborsInFullState != null) {
                    log.debug("Adding OspfLsaLink ::neighborsInFullState {}, InterfaceIP: {}", (Object)neighborsInFullState.size(), (Object)ospfInterfaceImpl.ipAddress());
                    for (OspfNbr ospfnbr : neighborsInFullState) {
                        OspfLsaLink link = new OspfLsaLink();
                        link.setLinkData(ospfInterfaceImpl.ipAddress().toString());
                        link.setLinkId(ospfnbr.neighborId().toString());
                        link.setLinkType(1);
                        link.setMetric(0);
                        link.setTos(0);
                        routerLsa.addRouterLink(link);
                        routerLsa.incrementLinkNo();
                        log.debug("Added OspfLsaLink :: {}, neighborIP: {}, routerLinks: {}", new Object[]{ospfnbr.neighborId(), ospfnbr.neighborIpAddr(), routerLsa.noLink()});
                    }
                }
                OspfLsaLink link = new OspfLsaLink();
                link.setLinkData(ospfInterfaceImpl.ipNetworkMask().toString());
                link.setLinkId(ospfInterfaceImpl.ipAddress().toString());
                link.setLinkType(3);
                link.setMetric(0);
                link.setTos(0);
                routerLsa.addRouterLink(link);
                routerLsa.incrementLinkNo();
                continue;
            }
            this.buildLinkForRouterLsaBroadcast(routerLsa, ospfInterfaceImpl);
        }
    }

    private void buildLinkForRouterLsaBroadcast(RouterLsa routerLsa, OspfInterface ospfInterface) {
        OspfInterfaceImpl ospfInterfaceImpl = (OspfInterfaceImpl)ospfInterface;
        if (ospfInterfaceImpl.state() == OspfInterfaceState.WAITING) {
            OspfLsaLink link = new OspfLsaLink();
            link.setLinkData(ospfInterface.ipNetworkMask().toString());
            link.setLinkId(ospfInterface.ipAddress().toString());
            link.setLinkType(3);
            link.setMetric(0);
            link.setTos(0);
            routerLsa.addRouterLink(link);
            routerLsa.incrementLinkNo();
        } else if (ospfInterfaceImpl.state() == OspfInterfaceState.DR) {
            OspfLsaLink link = new OspfLsaLink();
            link.setLinkData(ospfInterface.ipAddress().toString());
            link.setLinkId(ospfInterface.ipAddress().toString());
            link.setLinkType(2);
            link.setMetric(0);
            link.setTos(0);
            routerLsa.addRouterLink(link);
            routerLsa.incrementLinkNo();
        } else if (ospfInterfaceImpl.state() == OspfInterfaceState.BDR || ospfInterfaceImpl.state() == OspfInterfaceState.DROTHER) {
            OspfLsaLink link = new OspfLsaLink();
            link.setLinkData(ospfInterface.ipAddress().toString());
            link.setLinkId(ospfInterface.dr().toString());
            link.setLinkType(2);
            link.setMetric(0);
            link.setTos(0);
            routerLsa.addRouterLink(link);
            routerLsa.incrementLinkNo();
        }
    }

    public Ip4Address areaId() {
        return this.areaId;
    }

    @JsonProperty(value="areaId")
    public void setAreaId(Ip4Address areaId) {
        this.areaId = areaId;
    }

    public List<OspfAreaAddressRange> addressRanges() {
        return this.addressRanges;
    }

    @JsonProperty(value="addressRange")
    public void setAddressRanges(List<OspfAreaAddressRange> addressRanges) {
        this.addressRanges = addressRanges;
    }

    public boolean isTransitCapability() {
        return this.transitCapability;
    }

    @JsonProperty(value="transitCapability")
    public void setTransitCapability(boolean transitCapability) {
        this.transitCapability = transitCapability;
    }

    public boolean isExternalRoutingCapability() {
        return this.externalRoutingCapability;
    }

    @JsonProperty(value="externalRoutingCapability")
    public void setExternalRoutingCapability(boolean externalRoutingCapability) {
        this.externalRoutingCapability = externalRoutingCapability;
    }

    public int stubCost() {
        return this.stubCost;
    }

    @JsonProperty(value="stubCost")
    public void setStubCost(int stubCost) {
        this.stubCost = stubCost;
    }

    public List<OspfInterface> getInterfacesLst() {
        return this.interfacesLst;
    }

    @JsonProperty(value="interface")
    public void setInterfacesLst(List<OspfInterface> interfacesLst) {
        this.interfacesLst = interfacesLst;
    }

    public boolean noNeighborInLsaExchangeProcess() {
        for (OspfInterfaceImpl ospfInterfaceImpl : this.interfacesLst) {
            Iterator<OspfNbr> neighbors = ospfInterfaceImpl.listOfNeighbors().values().iterator();
            while (neighbors.hasNext()) {
                OspfNeighborState nextNeighborState = ((OspfNbrImpl)neighbors.next()).getState();
                if (nextNeighborState != OspfNeighborState.EXCHANGE && nextNeighborState != OspfNeighborState.LOADING) continue;
                return false;
            }
        }
        return true;
    }

    public List getLsaHeaders(boolean excludeMaxAgeLsa, boolean isOpaquecapable) {
        return this.database.getAllLsaHeaders(excludeMaxAgeLsa, isOpaquecapable);
    }

    public LsaWrapper getLsa(int lsType, String linkStateID, String advertisingRouter) throws Exception {
        String lsaKey = lsType + "-" + linkStateID + "-" + advertisingRouter;
        if (lsType == 9 || lsType == 10 || lsType == 11) {
            byte[] linkStateAsBytes = InetAddress.getByName(linkStateID).getAddress();
            byte opaqueType = linkStateAsBytes[0];
            int opaqueId = OspfUtil.byteToInteger((byte[])Arrays.copyOfRange(linkStateAsBytes, 1, linkStateAsBytes.length));
            lsaKey = lsType + "-" + opaqueType + opaqueId + "-" + advertisingRouter;
        }
        return this.database.findLsa(lsType, lsaKey);
    }

    public LsaWrapper lsaLookup(OspfLsa lookupLsa) {
        return this.database.lsaLookup((LsaHeader)lookupLsa);
    }

    public String isNewerOrSameLsa(OspfLsa lsa1, OspfLsa lsa2) {
        return this.database.isNewerOrSameLsa((LsaHeader)lsa1, (LsaHeader)lsa2);
    }

    public void addLsa(OspfLsa ospfLsa, OspfInterface ospfInterface) throws Exception {
        this.database.addLsa((LsaHeader)ospfLsa, false, ospfInterface);
    }

    public void addLsa(OspfLsa ospfLsa, boolean isSelfOriginated, OspfInterface ospfInterface) throws Exception {
        this.database.addLsa((LsaHeader)ospfLsa, isSelfOriginated, ospfInterface);
    }

    public void addLsaToMaxAgeBin(String key, LsaWrapper wrapper) {
        this.database.addLsaToMaxAgeBin(key, wrapper);
    }

    public void setDbRouterSequenceNumber(long newSequenceNumber) {
        this.database.setRouterLsaSeqNo(newSequenceNumber);
    }

    public void deleteLsa(LsaHeader ospfLsa) {
        this.database.deleteLsa(ospfLsa);
    }

    public void removeLsaFromBin(LsaWrapper lsaWrapper) {
        this.database.removeLsaFromBin(lsaWrapper);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("areaID", (Object)this.areaId).add("stubCost", this.stubCost).add("addressRanges", this.addressRanges).add("interfacesLst", this.interfacesLst).add("transitCapability", this.transitCapability).add("externalRoutingCapability", this.externalRoutingCapability).toString();
    }

    public List<OspfNbr> getNeighborsInFullState(OspfInterface ospfInterface) {
        ArrayList<OspfNbrImpl> listEligibleNeighbors = null;
        OspfNbrImpl ospfNeighbor2 = null;
        for (OspfNbrImpl ospfNeighbor2 : ospfInterface.listOfNeighbors().values()) {
            OspfNeighborState nextNeighborState = ospfNeighbor2.getState();
            if (nextNeighborState.getValue() != OspfNeighborState.FULL.getValue()) continue;
            if (listEligibleNeighbors == null) {
                listEligibleNeighbors = new ArrayList<OspfNbrImpl>();
                listEligibleNeighbors.add(ospfNeighbor2);
                continue;
            }
            listEligibleNeighbors.add(ospfNeighbor2);
        }
        return listEligibleNeighbors;
    }

    public String getLsaKey(LsaHeader lsaHeader) {
        return this.database.getLsaKey(lsaHeader);
    }

    public void addToOtherNeighborLsaTxList(LsaHeader recLsa) {
        log.debug("OspfAreaImpl: addToOtherNeighborLsaTxList");
        List<OspfInterface> ospfInterfaces = this.getInterfacesLst();
        for (OspfInterface ospfInterfaceFromArea : ospfInterfaces) {
            HashMap neighbors = ospfInterfaceFromArea.listOfNeighbors();
            for (Object neighborIP : neighbors.keySet()) {
                LsaWrapper lsWrapper;
                OspfNbrImpl nbr = (OspfNbrImpl)neighbors.get(neighborIP);
                if (nbr.getState().getValue() < OspfNeighborState.EXCHANGE.getValue()) continue;
                String key = this.database.getLsaKey(recLsa);
                if ((nbr.getState() == OspfNeighborState.EXCHANGE || nbr.getState() == OspfNeighborState.LOADING) && nbr.getLsReqList().containsKey(key) && (lsWrapper = this.lsaLookup((OspfLsa)recLsa)) != null) {
                    LsaHeader ownLsa = (LsaHeader)lsWrapper.ospfLsa();
                    String status = this.isNewerOrSameLsa((OspfLsa)recLsa, (OspfLsa)ownLsa);
                    if (status.equals("old")) continue;
                    if (status.equals("same")) {
                        log.debug("OspfAreaImpl: addToOtherNeighborLsaTxList: Removing lsa from reTxtList {}", (Object)key);
                        nbr.getLsReqList().remove(key);
                        continue;
                    }
                    log.debug("OspfAreaImpl: addToOtherNeighborLsaTxList: Removing lsa from reTxtList {}", (Object)key);
                    nbr.getLsReqList().remove(key);
                }
                if (recLsa.advertisingRouter().equals((Object)((String)neighborIP))) continue;
                if (recLsa.lsType() == 9 || recLsa.lsType() == 10) {
                    if (!nbr.isOpaqueCapable()) continue;
                    log.debug("OspfAreaImpl: addToOtherNeighborLsaTxList: Adding lsa to reTxtList {}", (Object)recLsa);
                    nbr.getReTxList().put(key, recLsa);
                    continue;
                }
                log.debug("OspfAreaImpl: addToOtherNeighborLsaTxList: Adding lsa to reTxtList {}", (Object)recLsa);
                nbr.getReTxList().put(key, recLsa);
            }
        }
    }

    public int options() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public int opaqueEnabledOptions() {
        return Integer.parseInt("01000010", 2);
    }

    public OspfLsdb database() {
        return this.database;
    }
}

