/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.area;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfNbr;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfInterfaceImpl
implements OspfInterface {
    private static final Logger log = LoggerFactory.getLogger(OspfInterfaceImpl.class);
    private Ip4Address ipAddress;
    private Ip4Address ipNetworkMask;
    private int areaId;
    private int helloIntervalTime;
    private int routerDeadIntervalTime;
    private int transmitDelay;
    private int routerPriority;
    private int systemInterfaceType;
    private int interfaceType;
    private int interfaceCost;
    private String authType;
    private String authKey;
    private int pollInterval;
    private int mtu;
    private int reTransmitInterval;
    private Ip4Address dr;
    private Ip4Address bdr;
    private OspfInterfaceState state;
    private List<LsaHeader> linkStateHeaders = new ArrayList<LsaHeader>();
    private HashMap<String, OspfNbr> listOfNeighbors = new HashMap();
    private HashMap<String, LsaHeader> listOfNeighborMap = new HashMap();

    public OspfInterfaceState state() {
        return this.state;
    }

    public void setState(OspfInterfaceState ospfInterfaceState) {
        this.state = ospfInterfaceState;
    }

    public List<LsaHeader> linkStateHeaders() {
        Set<String> key = this.listOfNeighborMap.keySet();
        for (String keys : key) {
            LsaHeader lsaHeader = this.listOfNeighborMap.get(keys);
            this.linkStateHeaders.add(lsaHeader);
        }
        return this.linkStateHeaders;
    }

    public Ip4Address ipNetworkMask() {
        return this.ipNetworkMask;
    }

    public void setIpNetworkMask(Ip4Address ipNetworkMask) {
        this.ipNetworkMask = ipNetworkMask;
    }

    public void addNeighbouringRouter(OspfNbr ospfNbr) {
        this.listOfNeighbors.put(ospfNbr.neighborId().toString(), ospfNbr);
    }

    public OspfNbr neighbouringRouter(String neighborId) {
        return this.listOfNeighbors.get(neighborId);
    }

    public void addLsaHeaderForDelayAck(LsaHeader lsaHeader) {
        String key = lsaHeader.lsType() + "-" + lsaHeader.linkStateId() + "-" + lsaHeader.advertisingRouter();
        if (lsaHeader.lsType() == 9 || lsaHeader.lsType() == 10 || lsaHeader.lsType() == 11) {
            OpaqueLsaHeader header = (OpaqueLsaHeader)lsaHeader;
            key = lsaHeader.lsType() + "-" + header.opaqueType() + header.opaqueId() + "-" + lsaHeader.advertisingRouter();
        }
        log.debug("Adding LSA key {} for delayed Ack", (Object)key);
        this.listOfNeighborMap.put(key, lsaHeader);
    }

    public void removeLsaFromNeighborMap(String lsaKey) {
        this.listOfNeighborMap.remove(lsaKey);
    }

    public boolean isNeighborInList(String neighborId) {
        return this.listOfNeighbors.containsKey(neighborId);
    }

    public HashMap<String, OspfNbr> listOfNeighbors() {
        return this.listOfNeighbors;
    }

    public void setListOfNeighbors(HashMap<String, OspfNbr> listOfNeighbors) {
        this.listOfNeighbors = listOfNeighbors;
    }

    public Ip4Address ipAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(Ip4Address ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int routerPriority() {
        return this.routerPriority;
    }

    public void setRouterPriority(int routerPriority) {
        this.routerPriority = routerPriority;
    }

    public int areaId() {
        return this.areaId;
    }

    public void setAreaId(int areaId) {
        this.areaId = areaId;
    }

    public int helloIntervalTime() {
        return this.helloIntervalTime;
    }

    public void setHelloIntervalTime(int helloIntervalTime) {
        this.helloIntervalTime = helloIntervalTime;
    }

    public int routerDeadIntervalTime() {
        return this.routerDeadIntervalTime;
    }

    public void setRouterDeadIntervalTime(int routerDeadIntervalTime) {
        this.routerDeadIntervalTime = routerDeadIntervalTime;
    }

    public int interfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(int interfaceType) {
        this.interfaceType = interfaceType;
    }

    public int interfaceCost() {
        return this.interfaceCost;
    }

    public void setInterfaceCost(int interfaceCost) {
        this.interfaceCost = interfaceCost;
    }

    public String authType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String authKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public int pollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public int mtu() {
        return this.mtu;
    }

    public void setMtu(int mtu) {
        this.mtu = mtu;
    }

    public int reTransmitInterval() {
        return this.reTransmitInterval;
    }

    public void setReTransmitInterval(int reTransmitInterval) {
        this.reTransmitInterval = reTransmitInterval;
    }

    public Ip4Address dr() {
        return this.dr;
    }

    public void setDr(Ip4Address dr) {
        this.dr = dr;
    }

    public Ip4Address bdr() {
        return this.bdr;
    }

    public void setBdr(Ip4Address bdr) {
        this.bdr = bdr;
    }

    public int transmitDelay() {
        return this.transmitDelay;
    }

    public void setTransmitDelay(int transmitDelay) {
        this.transmitDelay = transmitDelay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OspfInterfaceImpl that = (OspfInterfaceImpl)o;
        return Objects.equal((Object)this.areaId, (Object)that.areaId) && Objects.equal((Object)this.helloIntervalTime, (Object)that.helloIntervalTime) && Objects.equal((Object)this.routerDeadIntervalTime, (Object)that.routerDeadIntervalTime) && Objects.equal((Object)this.transmitDelay, (Object)that.transmitDelay) && Objects.equal((Object)this.routerPriority, (Object)that.routerPriority) && Objects.equal((Object)this.systemInterfaceType, (Object)that.systemInterfaceType) && Objects.equal((Object)this.interfaceType, (Object)that.interfaceType) && Objects.equal((Object)this.interfaceCost, (Object)that.interfaceCost) && Objects.equal((Object)this.pollInterval, (Object)that.pollInterval) && Objects.equal((Object)this.mtu, (Object)that.mtu) && Objects.equal((Object)this.reTransmitInterval, (Object)that.reTransmitInterval) && Objects.equal((Object)this.ipAddress, (Object)that.ipAddress) && Objects.equal((Object)this.ipNetworkMask, (Object)that.ipNetworkMask) && Objects.equal(this.listOfNeighbors, that.listOfNeighbors) && Objects.equal((Object)this.authType, (Object)that.authType) && Objects.equal((Object)this.authKey, (Object)that.authKey) && Objects.equal((Object)this.dr, (Object)that.dr) && Objects.equal((Object)this.bdr, (Object)that.bdr);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ipAddress, this.ipNetworkMask, this.areaId, this.helloIntervalTime, this.routerDeadIntervalTime, this.transmitDelay, this.routerPriority, this.listOfNeighbors, this.systemInterfaceType, this.interfaceType, this.interfaceCost, this.authType, this.authKey, this.pollInterval, this.mtu, this.reTransmitInterval, this.dr, this.bdr});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("ipAddress", (Object)this.ipAddress).add("routerPriority", this.routerPriority).add("areaID", this.areaId).add("helloIntervalTime", this.helloIntervalTime).add("routerDeadIntervalTime", this.routerDeadIntervalTime).add("interfaceType", this.interfaceType).add("interfaceCost", this.interfaceCost).add("authType", (Object)this.authType).add("authKey", (Object)this.authKey).add("pollInterval", this.pollInterval).add("mtu", this.mtu).add("reTransmitInterval", this.reTransmitInterval).add("dr", (Object)this.dr).add("bdr", (Object)this.bdr).add("transmitDelay", this.transmitDelay).toString();
    }
}

