/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictor;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.onosproject.net.driver.DriverService;
import org.onosproject.ospf.controller.OspfAgent;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfProcess;
import org.onosproject.ospf.controller.OspfRouter;
import org.onosproject.ospf.controller.impl.OspfPipelineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    protected static final Logger log = LoggerFactory.getLogger(Controller.class);
    protected static final int BUFFER_SIZE = 0x400000;
    private static final String PROCESS = "process";
    private static final String AREA = "area";
    private static final String INTERFACE = "interface";
    protected int ospfPort = 7000;
    protected int workerThreads = 16;
    protected long systemStartTime;
    private DriverService driverService;
    private OspfAgent agent;
    private List<ChannelGroup> cgList = new ArrayList<ChannelGroup>();
    private List<NioServerSocketChannelFactory> execFactoryLst = new ArrayList<NioServerSocketChannelFactory>();
    private List<OspfProcess> processes;

    public List<OspfProcess> getAllConfiguredProcesses() {
        return this.processes;
    }

    public void addDeviceDetails(OspfRouter ospfRouter) {
        this.agent.addConnectedRouter(ospfRouter);
    }

    public void removeDeviceDetails(OspfRouter ospfRouter) {
        this.agent.removeConnectedRouter(ospfRouter);
    }

    public void addLinkDetails(OspfRouter ospfRouter, OspfLinkTed ospfLinkTed) {
        this.agent.addLink(ospfRouter, ospfLinkTed);
    }

    public void removeLinkDetails(OspfRouter ospfRouter) {
        this.agent.deleteLink(ospfRouter);
    }

    private ServerBootstrap createServerBootStrap() {
        NioServerSocketChannelFactory executerFactory;
        ExecutorService bossPool = Executors.newCachedThreadPool();
        ExecutorService workerPool = Executors.newCachedThreadPool();
        if (this.workerThreads == 0) {
            executerFactory = new NioServerSocketChannelFactory((Executor)bossPool, (Executor)workerPool);
            this.execFactoryLst.add(executerFactory);
        } else {
            executerFactory = new NioServerSocketChannelFactory((Executor)bossPool, (Executor)workerPool, this.workerThreads);
            this.execFactoryLst.add(executerFactory);
        }
        return new ServerBootstrap((ChannelFactory)executerFactory);
    }

    public void init() {
        this.systemStartTime = System.currentTimeMillis();
    }

    public void start(OspfAgent ag, DriverService driverService) {
        log.info("Starting OSPF Controller...!!!");
        this.agent = ag;
        this.driverService = driverService;
        this.init();
    }

    public void stop() {
        log.info("Stopping OSPF Controller...!!!");
        for (ChannelGroup cg : this.cgList) {
            cg.close();
        }
        for (NioServerSocketChannelFactory execFactory : this.execFactoryLst) {
            execFactory.shutdown();
        }
        this.processes.clear();
    }

    public boolean deleteInterfaceFromArea(String processId, String areaId, String interfaceToDelete) {
        for (OspfProcess process : this.processes) {
            if (!processId.equalsIgnoreCase(process.processId())) continue;
            for (OspfArea area : process.areas()) {
                Iterator ospfIntrItr = area.getInterfacesLst().iterator();
                if (!area.areaId().toString().equalsIgnoreCase(areaId)) continue;
                while (ospfIntrItr.hasNext()) {
                    OspfInterface ospfIntr = (OspfInterface)ospfIntrItr.next();
                    if (!interfaceToDelete.equalsIgnoreCase(ospfIntr.ipAddress().toString())) continue;
                    ospfIntrItr.remove();
                    log.debug("Interface With Id {} is removed from Area {}", (Object)ospfIntr.ipAddress(), (Object)ospfIntr.areaId());
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkArea(String processId, String areaId) {
        for (OspfProcess process : this.processes) {
            if (!processId.equalsIgnoreCase(process.processId())) continue;
            for (OspfArea area : process.areas()) {
                if (!area.areaId().toString().equalsIgnoreCase(areaId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkProcess(String processId) {
        log.debug("CheckProcess,Process Id ={} processes={}", (Object)processId, this.processes);
        for (OspfProcess process : this.processes) {
            if (!processId.equalsIgnoreCase(process.processId())) continue;
            return true;
        }
        return false;
    }

    public boolean checkInterface(String processId, String areaId, String interfaceIp) {
        for (OspfProcess process : this.processes) {
            if (!processId.equalsIgnoreCase(process.processId())) continue;
            for (OspfArea area : process.areas()) {
                if (!area.areaId().toString().equalsIgnoreCase(areaId)) continue;
                for (OspfInterface ospfInterface : area.getInterfacesLst()) {
                    if (!ospfInterface.ipAddress().toString().equalsIgnoreCase(interfaceIp)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void createProcessWhenNoProcessesExists(List<OspfProcess> ospfProcesses) {
        HashSet<String> interfaceIpList = new HashSet<String>();
        HashSet<String> areaIdList = new HashSet<String>();
        if (this.processes != null) {
            if (this.processes.size() == 0) {
                this.processes.addAll(ospfProcesses);
                for (OspfProcess process : ospfProcesses) {
                    for (OspfArea area : process.areas()) {
                        areaIdList.add(area.areaId().toString());
                        for (OspfInterface intrfc : area.getInterfacesLst()) {
                            interfaceIpList.add(intrfc.ipAddress().toString());
                        }
                    }
                }
                this.createBootStrapForCreatedInterface(interfaceIpList, areaIdList);
            }
        } else {
            this.processes = new ArrayList<OspfProcess>();
            this.processes.addAll(ospfProcesses);
            for (OspfProcess process : ospfProcesses) {
                for (OspfArea area : process.areas()) {
                    areaIdList.add(area.areaId().toString());
                    for (OspfInterface intrfc : area.getInterfacesLst()) {
                        interfaceIpList.add(intrfc.ipAddress().toString());
                    }
                }
            }
            this.createBootStrapForCreatedInterface(interfaceIpList, areaIdList);
        }
    }

    private void createProcessWhenProcessesExists(List<OspfProcess> ospfProcesses) {
        if (ospfProcesses != null) {
            for (OspfProcess process : ospfProcesses) {
                if (!this.checkProcess(process.processId())) {
                    this.createNewProcess(process.processId(), process);
                    continue;
                }
                List areas = process.areas();
                for (OspfArea area : areas) {
                    if (!this.checkArea(process.processId(), area.areaId().toString())) {
                        this.createAreaInProcess(process.processId(), area.areaId().toString(), area);
                        continue;
                    }
                    this.updateAreaInProcess(process.processId(), area.areaId().toString(), area);
                    for (OspfInterface interfc : area.getInterfacesLst()) {
                        if (!this.checkInterface(process.processId(), area.areaId().toString(), interfc.ipAddress().toString())) {
                            this.createInterfaceInAreaInProcess(process.processId(), area.areaId().toString(), interfc);
                            continue;
                        }
                        this.updateInterfaceParameters(process.processId(), area.areaId().toString(), interfc.ipAddress().toString(), interfc);
                    }
                }
            }
        }
    }

    public void updateAreaInProcess(String processId, String areaId, OspfArea areaFrmConfig) {
        if (this.processes != null) {
            for (OspfProcess process : this.processes) {
                if (!processId.equalsIgnoreCase(process.processId())) continue;
                for (OspfArea ospfArea : process.areas()) {
                    if (!areaId.equalsIgnoreCase(ospfArea.areaId().toString())) continue;
                    ospfArea.setAddressRanges(areaFrmConfig.addressRanges());
                    ospfArea.setRouterId(areaFrmConfig.routerId());
                    ospfArea.setTransitCapability(areaFrmConfig.isTransitCapability());
                    ospfArea.setExternalRoutingCapability(areaFrmConfig.isExternalRoutingCapability());
                    ospfArea.setStubCost(areaFrmConfig.stubCost());
                    ospfArea.setOptions(areaFrmConfig.options());
                    ospfArea.setIsOpaqueEnabled(areaFrmConfig.isOpaqueEnabled());
                    log.debug("updateAreaInProcess::Process Id::{}::Ospf Area with Id::{}::is updated", (Object)processId, (Object)areaId);
                }
            }
        }
    }

    public void updateConfig(List<OspfProcess> ospfProcesses) {
        log.info("Controller::UpdateConfig called");
        if (this.processes != null) {
            if (this.processes.size() == 0) {
                this.createProcessWhenNoProcessesExists(ospfProcesses);
            } else {
                this.createProcessWhenProcessesExists(ospfProcesses);
            }
        } else {
            this.createProcessWhenNoProcessesExists(ospfProcesses);
        }
    }

    public void deleteConfig(List<OspfProcess> ospfProcesses, String attribute) {
        log.info("Controller::UpdateConfig called");
        if (this.processes != null) {
            if (this.processes.size() == 0) {
                log.debug("DeleteConfig:: No process exists");
            } else {
                this.deleteProcessWhenExists(ospfProcesses, attribute);
            }
        } else {
            log.debug("DeleteConfig:: No process exists");
        }
    }

    private void createNewProcess(String processId, OspfProcess process) {
        HashSet<String> interfaceIpList = new HashSet<String>();
        HashSet<String> areaIdList = new HashSet<String>();
        this.processes.add(process);
        for (OspfArea area : process.areas()) {
            areaIdList.add(area.areaId().toString());
            for (OspfInterface interfc : area.getInterfacesLst()) {
                interfaceIpList.add(interfc.ipAddress().toString());
            }
        }
        log.debug("createNewProcess::List of areas in process::{} areas::{}", (Object)processId, areaIdList);
        this.createBootStrapForCreatedInterface(interfaceIpList, areaIdList);
        log.debug("createNewProcess:: all processes::{}", this.processes);
    }

    private void createAreaInProcess(String processId, String areaId, OspfArea area) {
        HashSet<String> interfaceIpList = new HashSet<String>();
        HashSet<String> areaIdList = new HashSet<String>();
        for (OspfProcess process : this.processes) {
            List areasInProcess = process.areas();
            if (!processId.equalsIgnoreCase(process.processId())) continue;
            areasInProcess.add(area);
            for (OspfInterface intrfc : area.getInterfacesLst()) {
                interfaceIpList.add(intrfc.ipAddress().toString());
            }
            areaIdList.add(area.areaId().toString());
            log.debug("createAreaInProcess::List of areas in process Id::{} AreaId ::{} update process::{}", new Object[]{processId, areaId, process});
        }
        this.createBootStrapForCreatedInterface(interfaceIpList, areaIdList);
        log.debug("createAreaInProcess:: all processes::{}", this.processes);
    }

    private void createInterfaceInAreaInProcess(String processId, String areaId, OspfInterface ospfInterface) {
        HashSet<String> interfaceIpList = new HashSet<String>();
        HashSet<String> areaIdList = new HashSet<String>();
        for (OspfProcess process : this.processes) {
            List areasInProcess = process.areas();
            if (!processId.equalsIgnoreCase(process.processId())) continue;
            for (OspfArea area : areasInProcess) {
                if (!areaId.equalsIgnoreCase(area.areaId().toString())) continue;
                area.getInterfacesLst().add(ospfInterface);
                interfaceIpList.add(ospfInterface.ipAddress().toString());
                log.debug("createInterfaceInAreaInProcess::Interface updated in process Id::{} AreaId ::{} Interface List{}", new Object[]{processId, areaId, area.getInterfacesLst()});
            }
        }
        this.createBootStrapForCreatedInterface(interfaceIpList, areaIdList);
        log.debug("createInterfaceInAreaInProcess:: all processes::{}", this.processes);
    }

    private void updateInterfaceParameters(String processId, String areaId, String interfaceId, OspfInterface ospfInterface) {
        for (OspfProcess process : this.processes) {
            if (!processId.equalsIgnoreCase(process.processId())) continue;
            for (OspfArea area : process.areas()) {
                if (!area.areaId().toString().equalsIgnoreCase(areaId)) continue;
                Iterator intfcList = area.getInterfacesLst().iterator();
                while (intfcList.hasNext()) {
                    OspfInterface intrfcObj = (OspfInterface)intfcList.next();
                    if (!interfaceId.equalsIgnoreCase(intrfcObj.ipAddress().toString())) continue;
                    intrfcObj.setPollInterval(ospfInterface.pollInterval());
                    intrfcObj.setTransmitDelay(ospfInterface.transmitDelay());
                    intrfcObj.setBdr(ospfInterface.bdr());
                    intrfcObj.setDr(ospfInterface.dr());
                    intrfcObj.setAuthKey(ospfInterface.authKey());
                    intrfcObj.setAuthType(ospfInterface.authType());
                    intrfcObj.setHelloIntervalTime(ospfInterface.helloIntervalTime());
                    intrfcObj.setReTransmitInterval(ospfInterface.reTransmitInterval());
                    intrfcObj.setMtu(ospfInterface.mtu());
                    intrfcObj.setInterfaceCost(ospfInterface.interfaceCost());
                    intrfcObj.setInterfaceType(ospfInterface.interfaceType());
                    intrfcObj.setRouterDeadIntervalTime(ospfInterface.routerDeadIntervalTime());
                    intrfcObj.setRouterPriority(ospfInterface.routerPriority());
                    intrfcObj.setIpNetworkMask(ospfInterface.ipNetworkMask());
                    log.debug("updateInterfaceParameters::Interface updated in process Id::{} AreaId ::{} Interface Id:{} Updated Interface List: {}", new Object[]{processId, areaId, interfaceId, intfcList});
                }
            }
        }
        log.debug("updateInterfaceParameters:: all processes::{}", this.processes);
    }

    private void createBootStrapForCreatedInterface(Set<String> interfaceIPs, Set<String> areaIds) {
        log.debug("createBootStrapForCreatedInterface:: List of new Interfaces::{}, List of new areas::{}", interfaceIPs, areaIds);
        ArrayList<String> networkInterfaces = new ArrayList<String>();
        Enumeration<NetworkInterface> nets = null;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netInt : Collections.list(nets)) {
                if (!netInt.isUp() && !netInt.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = netInt.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    String ipAddress = inetAddress.getHostAddress();
                    networkInterfaces.add(ipAddress);
                }
            }
            for (OspfProcess process : this.processes) {
                for (OspfArea area : process.areas()) {
                    for (OspfInterface ospfIf : area.getInterfacesLst()) {
                        String ipFromConfig = ospfIf.ipAddress().toString();
                        if (interfaceIPs.contains(ipFromConfig)) {
                            log.debug("Ip address::{} for area {} is newly created" + ipFromConfig);
                            if (!networkInterfaces.contains(ipFromConfig)) continue;
                            log.debug("Both Config and Interface have ipAddress {} for area {}", (Object)ipFromConfig, (Object)area.areaId());
                            try {
                                log.debug("Creating ServerBootstrap for {} @ {}", (Object)ipFromConfig, (Object)this.ospfPort);
                                ServerBootstrap bootstrap = this.createServerBootStrap();
                                bootstrap.setOption("receiveBufferSize", (Object)0x400000);
                                bootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(0x400000));
                                bootstrap.setOption("reuseAddress", (Object)true);
                                bootstrap.setOption("tcpNoDelay", (Object)true);
                                bootstrap.setOption("keepAlive", (Object)true);
                                bootstrap.setOption("child.receiveBufferSize", (Object)0x400000);
                                bootstrap.setOption("child.receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(0x400000));
                                bootstrap.setOption("child.reuseAddress", (Object)true);
                                bootstrap.setOption("child.tcpNoDelay", (Object)true);
                                bootstrap.setOption("child.keepAlive", (Object)true);
                                bootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(0x400000));
                                bootstrap.setOption("receiveBufferSizePredictor", (Object)new AdaptiveReceiveBufferSizePredictor(64, 1024, 65536));
                                OspfPipelineFactory pfact = new OspfPipelineFactory(this, area, ospfIf);
                                bootstrap.setPipelineFactory((ChannelPipelineFactory)pfact);
                                InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName(ipFromConfig), this.ospfPort);
                                DefaultChannelGroup cg = new DefaultChannelGroup();
                                cg.add((Object)bootstrap.bind((SocketAddress)sa));
                                this.cgList.add((ChannelGroup)cg);
                                log.debug("Listening for connections on {}", (Object)sa);
                                continue;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        log.debug("Ip address::{} for area {} is not newly created" + ipFromConfig);
                    }
                    if (!areaIds.contains(area.areaId().toString())) continue;
                    area.initializeDb();
                }
            }
        }
        catch (SocketException e) {
            log.error("Error occured due to SocketException::Class::{},Line::{},Method::{}", new Object[]{e.getStackTrace()[0].getFileName(), e.getStackTrace()[0].getLineNumber(), e.getStackTrace()[0].getMethodName()});
        }
    }

    public void deleteProcessWhenExists(List<OspfProcess> ospfProcesses, String attribute) {
        if (ospfProcesses != null) {
            for (OspfProcess process : ospfProcesses) {
                if (!this.checkProcess(process.processId())) continue;
                if (PROCESS.equalsIgnoreCase(attribute)) {
                    this.deleteProcess(process.processId(), process);
                    continue;
                }
                List areas = process.areas();
                for (OspfArea area : areas) {
                    if (!this.checkArea(process.processId(), area.areaId().toString())) continue;
                    if (AREA.equalsIgnoreCase(attribute)) {
                        this.deleteAreaFromProcess(process.processId(), area.areaId().toString(), area);
                        continue;
                    }
                    for (OspfInterface interfc : area.getInterfacesLst()) {
                        if (!this.checkInterface(process.processId(), area.areaId().toString(), interfc.ipAddress().toString()) || !INTERFACE.equalsIgnoreCase(attribute)) continue;
                        this.deleteInterfaceFromAreaProcess(process.processId(), area.areaId().toString(), interfc);
                    }
                }
            }
        }
    }

    private void deleteProcess(String processId, OspfProcess process) {
        if (this.processes != null) {
            Iterator<OspfProcess> itrProcess = this.processes.iterator();
            while (itrProcess.hasNext()) {
                OspfProcess ospfPrs = itrProcess.next();
                if (!processId.equalsIgnoreCase(ospfPrs.processId())) continue;
                itrProcess.remove();
            }
        }
    }

    private void deleteAreaFromProcess(String processId, String areaId, OspfArea area) {
        if (this.processes != null) {
            for (OspfProcess ospfPrs : this.processes) {
                if (!processId.equalsIgnoreCase(ospfPrs.processId()) || ospfPrs.areas() == null) continue;
                Iterator itrArea = ospfPrs.areas().iterator();
                while (itrArea.hasNext()) {
                    OspfArea ospfArea = (OspfArea)itrArea.next();
                    if (!areaId.equalsIgnoreCase(ospfArea.areaId().toString())) continue;
                    itrArea.remove();
                }
            }
        }
    }

    private void deleteInterfaceFromAreaProcess(String processId, String areaId, OspfInterface interfaceToDelete) {
        if (this.processes != null) {
            for (OspfProcess ospfPrs : this.processes) {
                if (!processId.equalsIgnoreCase(ospfPrs.processId()) || ospfPrs.areas() == null) continue;
                for (OspfArea ospfArea : ospfPrs.areas()) {
                    if (!areaId.equalsIgnoreCase(ospfArea.areaId().toString()) || ospfArea.getInterfacesLst() == null) continue;
                    Iterator intrfcList = ospfArea.getInterfacesLst().iterator();
                    while (intrfcList.hasNext()) {
                        OspfInterface ospfItrfc = (OspfInterface)intrfcList.next();
                        if (!interfaceToDelete.ipAddress().equals((Object)ospfItrfc.ipAddress())) continue;
                        intrfcList.remove();
                    }
                }
            }
        }
    }
}

