/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.driver.DriverService;
import org.onosproject.ospf.controller.OspfAgent;
import org.onosproject.ospf.controller.OspfController;
import org.onosproject.ospf.controller.OspfLinkListener;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfProcess;
import org.onosproject.ospf.controller.OspfRouter;
import org.onosproject.ospf.controller.OspfRouterListener;
import org.onosproject.ospf.controller.impl.Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OspfControllerImpl
implements OspfController {
    protected static final Logger log = LoggerFactory.getLogger(OspfControllerImpl.class);
    private final Controller ctrl = new Controller();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    protected Set<OspfRouterListener> ospfRouterListener = new HashSet<OspfRouterListener>();
    protected Set<OspfLinkListener> ospfLinkListener = Sets.newHashSet();
    protected OspfAgent agent = new InternalDeviceConfig();

    @Activate
    public void activate() {
        log.info("OSPFControllerImpl activate...!!!");
        this.ctrl.start(this.agent, this.driverService);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.ctrl.stop();
        log.info("Stopped");
    }

    public void addRouterListener(OspfRouterListener listener) {
        if (!this.ospfRouterListener.contains(listener)) {
            this.ospfRouterListener.add(listener);
        }
    }

    public void removeRouterListener(OspfRouterListener listener) {
        this.ospfRouterListener.remove(listener);
    }

    public void addLinkListener(OspfLinkListener listener) {
        this.ospfLinkListener.add(listener);
    }

    public void removeLinkListener(OspfLinkListener listener) {
        this.ospfLinkListener.remove(listener);
    }

    public Set<OspfRouterListener> listener() {
        return this.ospfRouterListener;
    }

    public Set<OspfLinkListener> linkListener() {
        return this.ospfLinkListener;
    }

    public List<OspfProcess> getAllConfiguredProcesses() {
        List<OspfProcess> processes = this.ctrl.getAllConfiguredProcesses();
        return processes;
    }

    public void updateConfig(List processes) {
        ArrayList<OspfProcess> ospfProcesses = new ArrayList<OspfProcess>();
        if (processes != null) {
            for (Object process : processes) {
                ospfProcesses.add((OspfProcess)process);
            }
        }
        log.debug("updateConfig::OspfList::processes::{}", ospfProcesses);
        this.ctrl.updateConfig(ospfProcesses);
    }

    public void deleteConfig(List<OspfProcess> processes, String attribute) {
        ArrayList<OspfProcess> ospfProcesses = new ArrayList<OspfProcess>();
        if (processes != null) {
            for (OspfProcess process : processes) {
                ospfProcesses.add(process);
            }
        }
        log.debug("deleteConfig::OspfList::processes::{}", ospfProcesses);
        this.ctrl.deleteConfig(ospfProcesses, attribute);
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    private class InternalDeviceConfig
    implements OspfAgent {
        private InternalDeviceConfig() {
        }

        public boolean addConnectedRouter(OspfRouter ospfRouter) {
            for (OspfRouterListener l : OspfControllerImpl.this.listener()) {
                l.routerAdded(ospfRouter);
            }
            return true;
        }

        public void removeConnectedRouter(OspfRouter ospfRouter) {
            for (OspfRouterListener l : OspfControllerImpl.this.listener()) {
                l.routerRemoved(ospfRouter);
            }
        }

        public void addLink(OspfRouter ospfRouter, OspfLinkTed ospfLinkTed) {
            for (OspfLinkListener l : OspfControllerImpl.this.linkListener()) {
                l.addLink(ospfRouter, ospfLinkTed);
            }
        }

        public void deleteLink(OspfRouter ospfRouter) {
            for (OspfLinkListener l : OspfControllerImpl.this.linkListener()) {
                l.deleteLink(ospfRouter);
            }
        }
    }
}

