/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfNbr;
import org.onosproject.ospf.controller.OspfNeighborState;
import org.onosproject.ospf.controller.OspfRouter;
import org.onosproject.ospf.controller.TopologyForDeviceAndLink;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.Controller;
import org.onosproject.ospf.controller.impl.OspfDeviceTedImpl;
import org.onosproject.ospf.controller.impl.OspfNbrImpl;
import org.onosproject.ospf.controller.impl.OspfRouterImpl;
import org.onosproject.ospf.controller.impl.TopologyForDeviceAndLinkImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.controller.lsdb.OspfLsdbImpl;
import org.onosproject.ospf.controller.util.OspfEligibleRouter;
import org.onosproject.ospf.controller.util.OspfInterfaceType;
import org.onosproject.ospf.exceptions.OspfParseException;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessage;
import org.onosproject.ospf.protocol.ospfpacket.OspfPacketHeader;
import org.onosproject.ospf.protocol.ospfpacket.subtype.LsRequestPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.DdPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.HelloPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.LsAcknowledge;
import org.onosproject.ospf.protocol.ospfpacket.types.LsRequest;
import org.onosproject.ospf.protocol.ospfpacket.types.LsUpdate;
import org.onosproject.ospf.protocol.util.ChecksumCalculator;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;
import org.onosproject.ospf.protocol.util.OspfPacketType;
import org.onosproject.ospf.protocol.util.OspfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfInterfaceChannelHandler
extends IdleStateAwareChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(OspfInterfaceChannelHandler.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private OspfInterface ospfInterface;
    private OspfArea ospfArea;
    private boolean isClosed = false;
    private Controller controller;
    private Channel channel;
    private long delay = 0L;
    private InternalHelloTimer helloTimerTask;
    private InternalWaitTimer waitTimerTask;
    private InternalDelayedAckTimer delayedAckTimerTask;
    private ScheduledExecutorService exServiceHello;
    private ScheduledExecutorService exServiceWait;
    private ScheduledExecutorService exServiceDelayedAck;
    private boolean isDelayedAckTimerScheduled = false;
    private int delayedAckTimerInterval = 2500;
    private TopologyForDeviceAndLink topologyForDeviceAndLink;

    public OspfInterfaceChannelHandler() {
    }

    public OspfInterfaceChannelHandler(Controller controller, OspfArea ospfArea, OspfInterface ospfInterface) {
        this.ospfArea = ospfArea;
        this.ospfInterface = ospfInterface;
        this.controller = controller;
        ((OspfInterfaceImpl)ospfInterface).setState(OspfInterfaceState.DOWN);
        this.ospfInterface.setDr(Ip4Address.valueOf((String)"0.0.0.0"));
        this.ospfInterface.setBdr(Ip4Address.valueOf((String)"0.0.0.0"));
        this.topologyForDeviceAndLink = new TopologyForDeviceAndLinkImpl();
    }

    public void interfaceUp() throws Exception {
        log.debug("OSPFInterfaceChannelHandler::interfaceUp...!!!");
        if (this.ospfInterface.interfaceType() == OspfInterfaceType.POINT_TO_POINT.value()) {
            ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.POINT2POINT);
            log.debug("OSPFInterfaceChannelHandler::InterfaceType {} state {} ", (Object)this.ospfInterface.interfaceType(), (Object)((OspfInterfaceImpl)this.ospfInterface).state());
        } else if (this.ospfInterface.interfaceType() == OspfInterfaceType.BROADCAST.value()) {
            if (this.ospfInterface.routerPriority() == 0) {
                ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.DROTHER);
            } else {
                log.debug("OSPFInterfaceChannelHandler::InterfaceType {} state {} RouterPriority {}", new Object[]{this.ospfInterface.interfaceType(), ((OspfInterfaceImpl)this.ospfInterface).state(), this.ospfInterface.routerPriority()});
                ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.WAITING);
                this.startWaitTimer();
            }
        }
        this.startHelloTimer(this.ospfInterface.helloIntervalTime());
        this.ospfArea.refreshArea(this.ospfInterface);
    }

    public void backupSeen(Channel ch) throws Exception {
        log.debug("OSPFInterfaceChannelHandler::backupSeen ");
        if (((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.WAITING) {
            this.electRouter(ch);
        }
    }

    public void waitTimer(Channel ch) throws Exception {
        log.debug("OSPFInterfaceChannelHandler::waitTimer ");
        if (((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.WAITING) {
            this.electRouter(ch);
        }
    }

    public void neighborChange() throws Exception {
        log.debug("OSPFInterfaceChannelHandler::neighborChange ");
        if (((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.DR || ((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.BDR || ((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.DROTHER) {
            this.electRouter(this.channel);
        }
    }

    public void interfaceDown() {
        log.debug("OSPFInterfaceChannelHandler::interfaceDown ");
        this.stopHelloTimer();
        this.ospfInterface.listOfNeighbors().clear();
        ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.DOWN);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
        log.info("OSPF channelConnected from {}", (Object)evt.getChannel().getRemoteAddress());
        this.channel = evt.getChannel();
        this.interfaceUp();
        this.startDelayedAckTimer();
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent evt) {
        this.interfaceDown();
        this.stopDelayedAckTimer();
        log.debug("OspfChannelHandler::channelDisconnected...!!!");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.info("[exceptionCaught]: " + e.toString());
        if (e.getCause() instanceof ReadTimeoutException) {
            log.error("Disconnecting device {} due to read timeout", (Object)e.getChannel().getRemoteAddress());
            return;
        }
        if (e.getCause() instanceof ClosedChannelException) {
            log.debug("Channel for OSPF {} already closed", (Object)e.getChannel().getRemoteAddress());
        } else if (e.getCause() instanceof IOException) {
            log.error("Disconnecting OSPF {} due to IO Error: {}", (Object)e.getChannel().getRemoteAddress(), (Object)e.getCause().getMessage());
            if (log.isDebugEnabled()) {
                log.debug("StackTrace for previous Exception: {}", e.getCause());
            }
        } else if (e.getCause() instanceof OspfParseException) {
            OspfParseException errMsg = (OspfParseException)e.getCause();
            byte errorCode = errMsg.errorCode();
            byte errorSubCode = errMsg.errorSubCode();
            log.error("Error while parsing message from OSPF {}, ErrorCode {}", (Object)e.getChannel().getRemoteAddress(), (Object)errorCode);
        } else if (e.getCause() instanceof RejectedExecutionException) {
            log.warn("Could not process message: queue full");
        } else {
            log.error("Error while processing message from OSPF {}, state {}", (Object)e.getChannel().getRemoteAddress(), (Object)((OspfInterfaceImpl)this.ospfInterface).state());
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        log.debug("OspfChannelHandler::messageReceived...!!!");
        Object message = e.getMessage();
        if (message instanceof List) {
            List ospfMessageList = (List)message;
            log.debug("OspfChannelHandler::List of OspfMessages Size {}", (Object)ospfMessageList.size());
            if (ospfMessageList != null) {
                for (OspfMessage ospfMessage : ospfMessageList) {
                    this.processOspfMessage(ospfMessage, ctx);
                }
            } else {
                log.debug("OspfChannelHandler::OspfMessages Null List...!!");
            }
        }
        if (message instanceof OspfMessage) {
            OspfMessage ospfMessage = (OspfMessage)message;
            log.debug("OspfChannelHandler::OspfMessages received...!!");
            this.processOspfMessage(ospfMessage, ctx);
        }
    }

    public void processOspfMessage(OspfMessage ospfMessage, ChannelHandlerContext ctx) throws Exception {
        log.debug("OspfChannelHandler::processOspfMessage...!!!");
        if (!this.validateMessage(ospfMessage)) {
            return;
        }
        switch (ospfMessage.ospfMessageType().value()) {
            case 1: {
                this.processHelloMessage(ospfMessage, ctx);
                break;
            }
            case 2: {
                this.processDdMessage(ospfMessage, ctx);
                break;
            }
            case 3: {
                this.processLsRequestMessage(ospfMessage, ctx);
                break;
            }
            case 4: {
                this.processLsUpdateMessage(ospfMessage, ctx);
                break;
            }
            case 5: {
                this.processLsAckMessage(ospfMessage, ctx);
                break;
            }
            default: {
                log.debug("Unknown packet to process...!!!");
            }
        }
    }

    private boolean validateMessage(OspfMessage ospfMessage) throws Exception {
        boolean isValid = true;
        OspfPacketHeader header = (OspfPacketHeader)ospfMessage;
        if (!header.sourceIp().equals((Object)this.ospfInterface.ipAddress()) && !header.routerId().equals((Object)this.ospfArea.routerId())) {
            ChecksumCalculator checksum = new ChecksumCalculator();
            if (!checksum.isValidOspfCheckSum(ospfMessage, 12, 13)) {
                log.debug("Checksum mismatch. Received packet type {} ", (Object)ospfMessage.ospfMessageType());
                return false;
            }
            if (((OspfPacketHeader)ospfMessage).ospfVersion() != 2) {
                log.debug("Received osfpMessage Version should match with Interface Version ");
                return false;
            }
            if (!((OspfPacketHeader)ospfMessage).areaId().equals((Object)this.ospfArea.areaId())) {
                log.debug("Received ospf packets are from different area than our Area ID. Received Area ID {}, Our AreaId {} ", (Object)((OspfPacketHeader)ospfMessage).areaId(), (Object)this.ospfArea.areaId());
                return false;
            }
            if (((OspfPacketHeader)ospfMessage).areaId().equals((Object)Ip4Address.valueOf((String)"0.0.0.0"))) {
                log.debug("ABR should receive packets from backbone 0.0.0.0 as we are not acting as ABR we are rejecting the ospf packet");
                return false;
            }
            if (this.ospfInterface.interfaceType() == OspfInterfaceType.BROADCAST.value() && !OspfUtil.sameNetwork((Ip4Address)((OspfPacketHeader)ospfMessage).sourceIp(), (Ip4Address)this.ospfInterface.ipAddress(), (Ip4Address)this.ospfInterface.ipNetworkMask())) {
                log.debug("Received packets from different subnets. Discarding...!!!");
                return false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    void processHelloMessage(OspfMessage ospfMessage, ChannelHandlerContext ctx) throws Exception {
        log.debug("OspfChannelHandler::processHelloMessage...!!!");
        HelloPacket helloPacket = (HelloPacket)ospfMessage;
        log.debug("OspfChannelHandler::processHelloMessage::Interface Type {} OSPFInterfaceState {} ", (Object)this.ospfInterface.interfaceType(), (Object)((OspfInterfaceImpl)this.ospfInterface).state());
        if (this.ospfInterface.interfaceType() != OspfInterfaceType.POINT_TO_POINT.value() && !helloPacket.networkMask().equals((Object)this.ospfInterface.ipNetworkMask())) {
            log.debug("OspfChannelHandler::processHelloMessage::Hello Packet Received does not match the same network mask as the configure Interface");
            return;
        }
        if (helloPacket.helloInterval() != this.ospfInterface.helloIntervalTime()) {
            log.debug("OspfChannelHandler::processHelloMessage::Hello Packet Received have the same hello interval as configured Interface");
            return;
        }
        if (helloPacket.routerDeadInterval() != this.ospfInterface.routerDeadIntervalTime()) {
            log.debug("OspfChannelHandler::processHelloMessage::Hello Packet Received have the same Router Dead interval as configured Interface");
            return;
        }
        if (this.ospfInterface.interfaceType() == OspfInterfaceType.POINT_TO_POINT.value()) {
            OspfNbr nbr;
            if (!this.ospfInterface.isNeighborInList(helloPacket.routerId().toString())) {
                nbr = new OspfNbrImpl(this.ospfArea, this.ospfInterface, helloPacket.sourceIp(), helloPacket.routerId(), helloPacket.options(), this, this.topologyForDeviceAndLink);
                this.ospfInterface.addNeighbouringRouter(nbr);
            } else {
                nbr = this.ospfInterface.neighbouringRouter(helloPacket.routerId().toString());
                nbr.setRouterPriority(helloPacket.routerPriority());
            }
            if (!helloPacket.containsNeighbour(this.ospfArea.routerId())) {
                ((OspfNbrImpl)nbr).oneWayReceived((OspfMessage)helloPacket, this.channel);
            } else {
                ((OspfNbrImpl)nbr).twoWayReceived((OspfMessage)helloPacket, ctx.getChannel());
            }
        } else if (this.ospfInterface.interfaceType() == OspfInterfaceType.BROADCAST.value()) {
            if (((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.WAITING) {
                OspfNbr nbr;
                if (!helloPacket.dr().equals((Object)Ip4Address.valueOf((String)"0.0.0.0")) && !helloPacket.bdr().equals((Object)Ip4Address.valueOf((String)"0.0.0.0"))) {
                    this.stopWaitTimer();
                    this.ospfInterface.setDr(helloPacket.dr());
                    this.ospfInterface.setBdr(helloPacket.bdr());
                    if (helloPacket.dr().equals((Object)this.ospfInterface.ipAddress())) {
                        ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.DR);
                        this.ospfArea.refreshArea(this.ospfInterface);
                    } else if (helloPacket.bdr().equals((Object)this.ospfInterface.ipAddress())) {
                        ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.BDR);
                        this.ospfArea.refreshArea(this.ospfInterface);
                    } else {
                        ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.DROTHER);
                        this.ospfArea.refreshArea(this.ospfInterface);
                    }
                } else if (!helloPacket.dr().equals((Object)Ip4Address.valueOf((String)"0.0.0.0")) || !helloPacket.bdr().equals((Object)Ip4Address.valueOf((String)"0.0.0.0"))) {
                    this.ospfInterface.setDr(helloPacket.dr());
                    this.ospfInterface.setBdr(helloPacket.bdr());
                }
                Ip4Address sourceIp = helloPacket.sourceIp();
                if (!this.ospfInterface.isNeighborInList(helloPacket.routerId().toString())) {
                    nbr = new OspfNbrImpl(this.ospfArea, this.ospfInterface, sourceIp, helloPacket.routerId(), helloPacket.options(), this, this.topologyForDeviceAndLink);
                    nbr.setNeighborId(helloPacket.routerId());
                    nbr.setNeighborBdr(helloPacket.bdr());
                    nbr.setNeighborDr(helloPacket.dr());
                    nbr.setRouterPriority(helloPacket.routerPriority());
                    this.ospfInterface.addNeighbouringRouter(nbr);
                } else {
                    nbr = this.ospfInterface.neighbouringRouter(helloPacket.routerId().toString());
                    nbr.setRouterPriority(helloPacket.routerPriority());
                }
                if (!helloPacket.containsNeighbour(this.ospfArea.routerId())) {
                    ((OspfNbrImpl)nbr).oneWayReceived((OspfMessage)helloPacket, this.channel);
                } else {
                    ((OspfNbrImpl)nbr).twoWayReceived((OspfMessage)helloPacket, ctx.getChannel());
                }
                if (helloPacket.dr().equals((Object)sourceIp) && helloPacket.bdr().equals((Object)Ip4Address.valueOf((String)"0.0.0.0"))) {
                    this.stopWaitTimer();
                    this.backupSeen(ctx.getChannel());
                }
                if (helloPacket.bdr().equals((Object)sourceIp)) {
                    this.stopWaitTimer();
                    this.backupSeen(ctx.getChannel());
                }
            } else {
                if (!(helloPacket.dr().equals((Object)Ip4Address.valueOf((String)"0.0.0.0")) && helloPacket.bdr().equals((Object)Ip4Address.valueOf((String)"0.0.0.0")) || this.ospfInterface.routerPriority() != 0)) {
                    this.ospfInterface.setDr(helloPacket.dr());
                    this.ospfInterface.setBdr(helloPacket.bdr());
                }
                Ip4Address sourceIp = helloPacket.sourceIp();
                if (!this.ospfInterface.isNeighborInList(helloPacket.routerId().toString())) {
                    OspfNbrImpl nbr = new OspfNbrImpl(this.ospfArea, this.ospfInterface, sourceIp, helloPacket.routerId(), helloPacket.options(), this, this.topologyForDeviceAndLink);
                    nbr.setNeighborId(helloPacket.routerId());
                    nbr.setNeighborBdr(helloPacket.bdr());
                    nbr.setNeighborDr(helloPacket.dr());
                    nbr.setRouterPriority(helloPacket.routerPriority());
                    this.ospfInterface.addNeighbouringRouter((OspfNbr)nbr);
                    nbr.oneWayReceived((OspfMessage)helloPacket, this.channel);
                } else {
                    log.debug("OspfChannelHandler::NeighborInList::helloPacket.bdr(): {}, helloPacket.dr(): {}", (Object)helloPacket.bdr(), (Object)helloPacket.dr());
                    OspfNbr nbr = this.ospfInterface.neighbouringRouter(helloPacket.routerId().toString());
                    nbr.setRouterPriority(helloPacket.routerPriority());
                    if (!helloPacket.containsNeighbour(this.ospfArea.routerId())) {
                        ((OspfNbrImpl)nbr).oneWayReceived((OspfMessage)helloPacket, this.channel);
                    } else {
                        ((OspfNbrImpl)nbr).twoWayReceived((OspfMessage)helloPacket, ctx.getChannel());
                    }
                    if (nbr.routerPriority() != helloPacket.routerPriority()) {
                        nbr.setNeighborBdr(helloPacket.bdr());
                        nbr.setNeighborDr(helloPacket.dr());
                        this.neighborChange();
                    }
                    if (nbr.neighborIpAddr().equals((Object)helloPacket.dr()) && !nbr.neighborIpAddr().equals((Object)nbr.neighborDr())) {
                        nbr.setNeighborBdr(helloPacket.bdr());
                        nbr.setNeighborDr(helloPacket.dr());
                        this.neighborChange();
                    }
                    if (!nbr.neighborIpAddr().equals((Object)helloPacket.dr()) && nbr.neighborIpAddr().equals((Object)nbr.neighborDr())) {
                        nbr.setNeighborBdr(helloPacket.bdr());
                        nbr.setNeighborDr(helloPacket.dr());
                        this.neighborChange();
                    }
                    if (nbr.neighborIpAddr().equals((Object)helloPacket.bdr()) && !nbr.neighborIpAddr().equals((Object)nbr.neighborBdr())) {
                        nbr.setNeighborBdr(helloPacket.bdr());
                        nbr.setNeighborDr(helloPacket.dr());
                        this.neighborChange();
                    }
                    if (!nbr.neighborIpAddr().equals((Object)helloPacket.bdr()) && nbr.neighborIpAddr().equals((Object)nbr.neighborBdr())) {
                        nbr.setNeighborBdr(helloPacket.bdr());
                        nbr.setNeighborDr(helloPacket.dr());
                        this.neighborChange();
                    }
                    nbr.setNeighborBdr(helloPacket.bdr());
                    nbr.setNeighborDr(helloPacket.dr());
                }
            }
        }
    }

    void processDdMessage(OspfMessage ospfMessage, ChannelHandlerContext ctx) throws Exception {
        log.debug("OspfChannelHandler::processDdMessage...!!!");
        DdPacket ddPacket = (DdPacket)ospfMessage;
        log.debug("Got DD packet from {}", (Object)ddPacket.sourceIp());
        Ip4Address neighbourId = ddPacket.routerId();
        OspfNbr nbr = this.ospfInterface.neighbouringRouter(neighbourId.toString());
        if (nbr != null) {
            log.debug("OspfChannelHandler::processDdMessage:: OSPFNeighborState {}", (Object)nbr.getState());
            nbr.setIsOpaqueCapable(ddPacket.isOpaqueCapable());
            if (ddPacket.imtu() > this.ospfInterface.mtu()) {
                log.debug("the MTU size is greater than the interface MTU");
                return;
            }
            if (nbr.getState() == OspfNeighborState.DOWN) {
                return;
            }
            if (nbr.getState() == OspfNeighborState.ATTEMPT) {
                return;
            }
            if (nbr.getState() == OspfNeighborState.TWOWAY) {
                nbr.adjOk(this.channel);
                return;
            }
            if (nbr.getState() == OspfNeighborState.INIT) {
                ((OspfNbrImpl)nbr).twoWayReceived((OspfMessage)ddPacket, ctx.getChannel());
            } else if (nbr.getState() == OspfNeighborState.EXSTART) {
                int initialize = ddPacket.isInitialize();
                int more = ddPacket.isMore();
                int masterOrSlave = ddPacket.isMaster();
                int options = ddPacket.options();
                nbr.setOptions(options);
                if (initialize == 1 && more == 1 && masterOrSlave == 1 && ddPacket.getLsaHeaderList().isEmpty() && OspfUtil.ipAddressToLong((String)ddPacket.routerId().toString()) > OspfUtil.ipAddressToLong((String)this.ospfArea.routerId().toString())) {
                    nbr.setIsMaster(1);
                    ((OspfNbrImpl)nbr).setLastDdPacket(ddPacket);
                    nbr.setDdSeqNum(ddPacket.sequenceNo());
                    nbr.setOptions(ddPacket.options());
                    ((OspfNbrImpl)nbr).negotiationDone((OspfMessage)ddPacket, true, ddPacket.getLsaHeaderList(), ctx.getChannel());
                }
                if (initialize == 0 && masterOrSlave == 0 && nbr.ddSeqNum() == ddPacket.sequenceNo() && OspfUtil.ipAddressToLong((String)ddPacket.routerId().toString()) < OspfUtil.ipAddressToLong((String)this.ospfArea.routerId().toString())) {
                    ((OspfNbrImpl)nbr).setLastDdPacket(ddPacket);
                    nbr.setOptions(ddPacket.options());
                    nbr.setDdSeqNum(nbr.ddSeqNum() + 1L);
                    ((OspfNbrImpl)nbr).negotiationDone((OspfMessage)ddPacket, false, ddPacket.getLsaHeaderList(), ctx.getChannel());
                }
            } else if (nbr.getState() == OspfNeighborState.EXCHANGE) {
                log.debug("Neighbor state:: EXCHANGE");
                boolean isDuplicateDDPacket = this.compareDdPackets(ddPacket, ((OspfNbrImpl)nbr).lastDdPacket());
                int initialize = ddPacket.isInitialize();
                int more = ddPacket.isMore();
                int masterOrSlave = ddPacket.isMaster();
                int options = ddPacket.options();
                if (!isDuplicateDDPacket) {
                    if (nbr.isMaster() != masterOrSlave) {
                        DdPacket newResPacket = (DdPacket)((OspfNbrImpl)nbr).seqNumMismatch("Master/Slave Inconsistency");
                        newResPacket.setDestinationIp(ddPacket.sourceIp());
                        log.debug("Sending back DDPacket to {}", (Object)ddPacket.sourceIp());
                        ctx.getChannel().write((Object)newResPacket);
                    } else if (initialize == 1) {
                        DdPacket newResPacket = (DdPacket)((OspfNbrImpl)nbr).seqNumMismatch("Initialize bit inconsistency");
                        newResPacket.setDestinationIp(ddPacket.sourceIp());
                        log.debug("Sending back DDPacket to {}", (Object)ddPacket.sourceIp());
                        ctx.getChannel().write((Object)newResPacket);
                    } else if (masterOrSlave == 0) {
                        if (ddPacket.sequenceNo() == nbr.ddSeqNum()) {
                            ((OspfNbrImpl)nbr).processDdPacket(false, ddPacket, ctx.getChannel());
                            log.debug("Received DD Packet");
                        } else {
                            DdPacket newResPacket = (DdPacket)((OspfNbrImpl)nbr).seqNumMismatch("Sequence Number Mismatch");
                            newResPacket.setDestinationIp(ddPacket.sourceIp());
                            log.debug("Sending back DDPacket to {}", (Object)ddPacket.sourceIp());
                            ctx.getChannel().write((Object)newResPacket);
                        }
                    } else if (ddPacket.sequenceNo() == nbr.ddSeqNum() + 1L) {
                        ((OspfNbrImpl)nbr).setLastDdPacket(ddPacket);
                        ((OspfNbrImpl)nbr).processDdPacket(true, ddPacket, ctx.getChannel());
                        log.debug("Process DD Packet");
                    } else {
                        DdPacket newResPacket = (DdPacket)((OspfNbrImpl)nbr).seqNumMismatch("options inconsistency");
                        newResPacket.setDestinationIp(ddPacket.sourceIp());
                        log.debug("Sending back DDPacket to {}", (Object)ddPacket.sourceIp());
                        ctx.getChannel().write((Object)newResPacket);
                    }
                } else {
                    if (masterOrSlave == 0) {
                        return;
                    }
                    DdPacket newResPacket = ((OspfNbrImpl)nbr).lastSentDdPacket();
                    log.debug("Sending back DDPacket to {}", (Object)ddPacket.sourceIp());
                    ctx.getChannel().write((Object)newResPacket);
                }
            } else if (nbr.getState() == OspfNeighborState.LOADING || nbr.getState() == OspfNeighborState.FULL) {
                OspfMessage newResPacket;
                int options = ddPacket.options();
                if (nbr.options() != options) {
                    newResPacket = ((OspfNbrImpl)nbr).seqNumMismatch("Initialize bit inconsistency");
                    newResPacket.setDestinationIp(ddPacket.sourceIp());
                    ctx.getChannel().write((Object)newResPacket);
                } else if (ddPacket.isInitialize() == 1) {
                    newResPacket = ((OspfNbrImpl)nbr).seqNumMismatch("Initialize bit inconsistency");
                    newResPacket.setDestinationIp(ddPacket.sourceIp());
                    ctx.getChannel().write((Object)newResPacket);
                }
                boolean isDuplicate = this.compareDdPackets(ddPacket, ((OspfNbrImpl)nbr).lastDdPacket());
                if (nbr.isMaster() != 1) {
                    if (isDuplicate) {
                        log.debug("received a duplicate DD packet");
                    }
                } else if (isDuplicate) {
                    ddPacket.setDestinationIp(ddPacket.sourceIp());
                    ctx.getChannel().write((Object)((OspfNbrImpl)nbr).lastSentDdPacket());
                    log.debug("Sending back the duplicate packet ");
                }
            }
        }
    }

    void processLsRequestMessage(OspfMessage ospfMessage, ChannelHandlerContext ctx) throws Exception {
        log.debug("OspfChannelHandler::processLsRequestMessage...!!!");
        LsRequest lsrPacket = (LsRequest)ospfMessage;
        OspfNbr nbr = this.ospfInterface.neighbouringRouter(lsrPacket.routerId().toString());
        if (nbr.getState() == OspfNeighborState.EXCHANGE || nbr.getState() == OspfNeighborState.LOADING || nbr.getState() == OspfNeighborState.FULL) {
            LsRequest reqMsg = (LsRequest)ospfMessage;
            if (reqMsg.getLinkStateRequests().isEmpty()) {
                log.debug("Received Link State Request Vector is Empty ");
                return;
            }
            ListIterator listItr = reqMsg.getLinkStateRequests().listIterator();
            while (listItr.hasNext()) {
                LsUpdate lsupdate = new LsUpdate();
                lsupdate.setOspfVer(2);
                lsupdate.setOspftype(OspfPacketType.LSUPDATE.value());
                lsupdate.setRouterId(this.ospfArea.routerId());
                lsupdate.setAreaId(this.ospfArea.areaId());
                lsupdate.setAuthType(0);
                lsupdate.setAuthentication(0);
                lsupdate.setOspfPacLength(0);
                lsupdate.setChecksum(0);
                int currentLength = 28;
                int maxSize = this.ospfInterface.mtu() - 20;
                int noLsa = 0;
                while (listItr.hasNext()) {
                    LsRequestPacket lsRequest = (LsRequestPacket)listItr.next();
                    LsaWrapper wrapper = this.ospfArea.getLsa(lsRequest.lsType(), lsRequest.linkStateId(), lsRequest.ownRouterId());
                    OspfLsa ospflsa = wrapper.ospfLsa();
                    if (currentLength + ((LsaWrapperImpl)wrapper).lsaHeader().lsPacketLen() >= maxSize) {
                        listItr.previous();
                        break;
                    }
                    if (ospflsa != null) {
                        lsupdate.addLsa(ospflsa);
                        ++noLsa;
                        currentLength += ((LsaWrapperImpl)wrapper).lsaHeader().lsPacketLen();
                        continue;
                    }
                    nbr.badLSReq(this.channel);
                }
                lsupdate.setNumberOfLsa(noLsa);
                if (((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.DR || ((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.BDR || ((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.POINT2POINT) {
                    lsupdate.setDestinationIp(OspfUtil.ALL_SPF_ROUTERS);
                } else if (((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.DROTHER) {
                    lsupdate.setDestinationIp(OspfUtil.ALL_DROUTERS);
                }
                ctx.getChannel().write((Object)lsupdate);
            }
        }
    }

    void processLsUpdateMessage(OspfMessage ospfMessage, ChannelHandlerContext ctx) throws Exception {
        log.debug("OspfChannelHandler::processLsUpdateMessage");
        LsUpdate lsUpdate = (LsUpdate)ospfMessage;
        String neighbourId = lsUpdate.routerId().toString();
        if (this.ospfInterface.isNeighborInList(neighbourId)) {
            OspfNbrImpl nbr = (OspfNbrImpl)this.ospfInterface.neighbouringRouter(neighbourId);
            if (nbr.getState() == OspfNeighborState.EXCHANGE || nbr.getState() == OspfNeighborState.LOADING) {
                nbr.processLsUpdate(lsUpdate, ctx.getChannel());
            } else if (nbr.getState() == OspfNeighborState.FULL) {
                if (lsUpdate.noLsa() != 0) {
                    List list = lsUpdate.getLsaList();
                    for (LsaHeader lsa : list) {
                        nbr.processReceivedLsa(lsa, true, ctx.getChannel(), lsUpdate.sourceIp());
                    }
                } else {
                    return;
                }
            }
        }
    }

    void processLsAckMessage(OspfMessage ospfMessage, ChannelHandlerContext ctx) throws Exception {
        log.debug("OspfChannelHandler::processLsAckMessage");
        LsAcknowledge lsAckPacket = (LsAcknowledge)ospfMessage;
        OspfNbrImpl nbr = (OspfNbrImpl)this.ospfInterface.neighbouringRouter(lsAckPacket.routerId().toString());
        if (nbr != null) {
            if (nbr.getState().getValue() < OspfNeighborState.EXCHANGE.getValue()) {
                return;
            }
            for (LsaHeader lsRequest : lsAckPacket.getLinkStateHeaders()) {
                String isSame;
                OspfLsa ospfLsa = nbr.getPendingReTxList().get(((OspfAreaImpl)this.ospfArea).getLsaKey(lsRequest));
                if (lsRequest == null || ospfLsa == null || !(isSame = ((OspfLsdbImpl)this.ospfArea.database()).isNewerOrSameLsa(lsRequest, (LsaHeader)ospfLsa)).equals("same")) continue;
                nbr.getPendingReTxList().remove(((OspfAreaImpl)this.ospfArea).getLsaKey(lsRequest));
            }
        }
    }

    public boolean compareDdPackets(DdPacket receivedDPacket, DdPacket lastDdPacket) {
        return receivedDPacket.isInitialize() == lastDdPacket.isInitialize() && receivedDPacket.isMaster() == lastDdPacket.isMaster() && receivedDPacket.isMore() == lastDdPacket.isMore() && receivedDPacket.options() == lastDdPacket.options() && receivedDPacket.sequenceNo() == lastDdPacket.sequenceNo();
    }

    void closeChannel(ChannelHandlerContext ctx) {
        log.debug("OspfChannelHandler::closeChannel");
        this.isClosed = true;
        ctx.getChannel().close();
    }

    private void startHelloTimer(long period) {
        log.debug("OSPFInterfaceChannelHandler::startHelloTimer");
        this.exServiceHello = Executors.newSingleThreadScheduledExecutor();
        this.helloTimerTask = new InternalHelloTimer();
        ScheduledFuture<?> helloHandle = this.exServiceHello.scheduleAtFixedRate(this.helloTimerTask, this.delay, period, TimeUnit.SECONDS);
    }

    private void stopHelloTimer() {
        log.debug("OSPFInterfaceChannelHandler::stopHelloTimer ");
        this.exServiceHello.shutdown();
    }

    private void startWaitTimer() {
        log.debug("OSPFNbr::startWaitTimer");
        this.exServiceWait = Executors.newSingleThreadScheduledExecutor();
        this.waitTimerTask = new InternalWaitTimer();
        ScheduledFuture<?> waitTimerHandle = this.exServiceWait.schedule(this.waitTimerTask, (long)this.ospfInterface.routerDeadIntervalTime(), TimeUnit.SECONDS);
    }

    private void stopWaitTimer() {
        log.debug("OSPFNbr::stopWaitTimer ");
        this.exServiceWait.shutdown();
    }

    private void startDelayedAckTimer() {
        if (!this.isDelayedAckTimerScheduled) {
            log.debug("Started DelayedAckTimer...!!!");
            this.exServiceDelayedAck = Executors.newSingleThreadScheduledExecutor();
            this.delayedAckTimerTask = new InternalDelayedAckTimer();
            ScheduledFuture<?> delayAckHandle = this.exServiceDelayedAck.scheduleAtFixedRate(this.delayedAckTimerTask, this.delayedAckTimerInterval, this.delayedAckTimerInterval, TimeUnit.MILLISECONDS);
            this.isDelayedAckTimerScheduled = true;
        }
    }

    private void stopDelayedAckTimer() {
        if (this.isDelayedAckTimerScheduled) {
            log.debug("Stopped DelayedAckTimer...!!!");
            this.isDelayedAckTimerScheduled = false;
            this.exServiceDelayedAck.shutdown();
        }
    }

    public void electRouter(Channel ch) throws Exception {
        Ip4Address currentDr = this.ospfInterface.dr();
        Ip4Address currentBdr = this.ospfInterface.bdr();
        OspfInterfaceState oldState = ((OspfInterfaceImpl)this.ospfInterface).state();
        log.debug("OSPFInterfaceChannelHandler::electRouter -> currentDr: {}, currentBdr: {}", (Object)currentDr, (Object)currentBdr);
        List<OspfEligibleRouter> eligibleRouters = this.calculateListOfEligibleRouters(new OspfEligibleRouter());
        log.debug("OSPFInterfaceChannelHandler::electRouter -> eligibleRouters: {}", eligibleRouters);
        OspfEligibleRouter electedBdr = this.electBdr(eligibleRouters);
        OspfEligibleRouter electedDr = this.electDr(eligibleRouters, electedBdr);
        this.ospfInterface.setBdr(electedBdr.getIpAddress());
        this.ospfInterface.setDr(electedDr.getIpAddress());
        if (electedBdr.getIpAddress().equals((Object)this.ospfInterface.ipAddress()) && !electedBdr.getIpAddress().equals((Object)currentBdr)) {
            ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.BDR);
        }
        if (electedDr.getIpAddress().equals((Object)this.ospfInterface.ipAddress()) && !electedDr.getIpAddress().equals((Object)currentDr)) {
            ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.DR);
        }
        if (((OspfInterfaceImpl)this.ospfInterface).state() != oldState && (((OspfInterfaceImpl)this.ospfInterface).state() != OspfInterfaceState.DROTHER || oldState.value() >= OspfInterfaceState.DROTHER.value())) {
            log.debug("Recalculating as the State is changed ");
            log.debug("OSPFInterfaceChannelHandler::electRouter -> currentDr: {}, currentBdr: {}", (Object)currentDr, (Object)currentBdr);
            eligibleRouters = this.calculateListOfEligibleRouters(new OspfEligibleRouter());
            log.debug("OSPFInterfaceChannelHandler::electRouter -> eligibleRouters: {}", eligibleRouters);
            electedBdr = this.electBdr(eligibleRouters);
            electedDr = this.electDr(eligibleRouters, electedBdr);
            this.ospfInterface.setBdr(electedBdr.getIpAddress());
            this.ospfInterface.setDr(electedDr.getIpAddress());
        }
        if (electedBdr.getIpAddress().equals((Object)this.ospfInterface.ipAddress()) && !electedBdr.getIpAddress().equals((Object)currentBdr)) {
            ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.BDR);
            this.ospfArea.refreshArea(this.ospfInterface);
        }
        if (electedDr.getIpAddress().equals((Object)this.ospfInterface.ipAddress()) && !electedDr.getIpAddress().equals((Object)currentDr)) {
            ((OspfInterfaceImpl)this.ospfInterface).setState(OspfInterfaceState.DR);
            this.ospfArea.refreshArea(this.ospfInterface);
        }
        if (currentDr != electedDr.getIpAddress() || currentBdr != electedBdr.getIpAddress()) {
            Set negibhorIdList = this.ospfInterface.listOfNeighbors().keySet();
            for (String routerid : negibhorIdList) {
                OspfNbrImpl nbr = (OspfNbrImpl)this.ospfInterface.neighbouringRouter(routerid);
                if (nbr.getState().getValue() < OspfNeighborState.TWOWAY.getValue()) continue;
                nbr.adjOk(ch);
            }
        }
        log.debug("OSPFInterfaceChannelHandler::electRouter -> ElectedDR: {}, ElectedBDR: {}", (Object)electedDr.getIpAddress(), (Object)electedBdr.getIpAddress());
    }

    public List<OspfEligibleRouter> calculateListOfEligibleRouters(OspfEligibleRouter electedDr) {
        log.debug("OSPFNbr::calculateListOfEligibleRouters ");
        ArrayList<OspfEligibleRouter> eligibleRouters = new ArrayList<OspfEligibleRouter>();
        Set neighborIdList = this.ospfInterface.listOfNeighbors().keySet();
        for (String routerId : neighborIdList) {
            OspfNbrImpl nbr = (OspfNbrImpl)this.ospfInterface.neighbouringRouter(routerId);
            if (nbr.getState().getValue() < OspfNeighborState.TWOWAY.getValue() || nbr.routerPriority() <= 0) continue;
            OspfEligibleRouter router = new OspfEligibleRouter();
            router.setIpAddress(nbr.neighborIpAddr());
            router.setRouterId(nbr.neighborId());
            router.setRouterPriority(nbr.routerPriority());
            if (nbr.neighborDr().equals((Object)nbr.neighborIpAddr()) || electedDr.getIpAddress().equals((Object)nbr.neighborIpAddr())) {
                router.setIsDr(true);
            } else if (nbr.neighborBdr().equals((Object)nbr.neighborIpAddr())) {
                router.setIsBdr(true);
            }
            eligibleRouters.add(router);
        }
        if (this.ospfInterface.routerPriority() > 0) {
            OspfEligibleRouter router = new OspfEligibleRouter();
            router.setIpAddress(this.ospfInterface.ipAddress());
            router.setRouterId(this.ospfArea.routerId());
            router.setRouterPriority(this.ospfInterface.routerPriority());
            if (this.ospfInterface.dr().equals((Object)this.ospfInterface.ipAddress()) || electedDr.getIpAddress().equals((Object)this.ospfInterface.ipAddress())) {
                router.setIsDr(true);
            } else if (this.ospfInterface.bdr().equals((Object)this.ospfInterface.ipAddress()) && !this.ospfInterface.dr().equals((Object)this.ospfInterface.ipAddress())) {
                router.setIsBdr(true);
            }
            eligibleRouters.add(router);
        }
        return eligibleRouters;
    }

    public OspfEligibleRouter electBdr(List<OspfEligibleRouter> eligibleRouters) {
        log.debug("OSPFInterfaceChannelHandler::electBdr -> eligibleRouters: {}", eligibleRouters);
        ArrayList<OspfEligibleRouter> declaredAsBdr = new ArrayList<OspfEligibleRouter>();
        ArrayList<OspfEligibleRouter> notDrAndBdr = new ArrayList<OspfEligibleRouter>();
        for (OspfEligibleRouter router : eligibleRouters) {
            if (router.isBdr()) {
                declaredAsBdr.add(router);
            }
            if (router.isBdr() || router.isDr()) continue;
            notDrAndBdr.add(router);
        }
        OspfEligibleRouter electedBdr = new OspfEligibleRouter();
        if (!declaredAsBdr.isEmpty()) {
            if (declaredAsBdr.size() == 1) {
                electedBdr = (OspfEligibleRouter)declaredAsBdr.get(0);
            } else if (declaredAsBdr.size() > 1) {
                electedBdr = this.selectRouterBasedOnPriority(declaredAsBdr);
            }
        } else if (notDrAndBdr.size() == 1) {
            electedBdr = (OspfEligibleRouter)notDrAndBdr.get(0);
        } else if (notDrAndBdr.size() > 1) {
            electedBdr = this.selectRouterBasedOnPriority(notDrAndBdr);
        }
        electedBdr.setIsBdr(true);
        electedBdr.setIsDr(false);
        return electedBdr;
    }

    public OspfEligibleRouter electDr(List<OspfEligibleRouter> eligibleRouters, OspfEligibleRouter electedBdr) {
        ArrayList<OspfEligibleRouter> declaredAsDr = new ArrayList<OspfEligibleRouter>();
        for (OspfEligibleRouter router : eligibleRouters) {
            if (!router.isDr()) continue;
            declaredAsDr.add(router);
        }
        OspfEligibleRouter electedDr = new OspfEligibleRouter();
        if (!declaredAsDr.isEmpty()) {
            if (declaredAsDr.size() == 1) {
                electedDr = (OspfEligibleRouter)declaredAsDr.get(0);
            } else if (eligibleRouters.size() > 1) {
                electedDr = this.selectRouterBasedOnPriority(declaredAsDr);
            }
        } else {
            electedDr = electedBdr;
            electedDr.setIsDr(true);
            electedDr.setIsBdr(false);
        }
        return electedDr;
    }

    public OspfEligibleRouter selectRouterBasedOnPriority(List<OspfEligibleRouter> routersList) {
        OspfEligibleRouter initialRouter = routersList.get(0);
        for (int i = 1; i < routersList.size(); ++i) {
            OspfEligibleRouter router = routersList.get(i);
            if (router.getRouterPriority() > initialRouter.getRouterPriority()) {
                initialRouter = router;
                continue;
            }
            if (router.getRouterPriority() != initialRouter.getRouterPriority()) continue;
            try {
                if (OspfUtil.ipAddressToLong((String)router.getIpAddress().toString()) <= OspfUtil.ipAddressToLong((String)initialRouter.getIpAddress().toString())) continue;
                initialRouter = router;
                continue;
            }
            catch (Exception e) {
                log.debug("OSPFInterfaceChannelHandler::selectRouterBasedOnPriority -> eligibleRouters: {}", (Object)initialRouter);
            }
        }
        return initialRouter;
    }

    public void addDeviceInformation(OspfRouter ospfRouter) {
        this.controller.addDeviceDetails(ospfRouter);
    }

    public void removeDeviceInformation(OspfRouter ospfRouter) {
        this.controller.removeDeviceDetails(ospfRouter);
    }

    public void addLinkInformation(OspfRouter ospfRouter, OspfLinkTed ospfLinkTed) {
        this.controller.addLinkDetails(ospfRouter, ospfLinkTed);
    }

    public void removeLinkInformation(OspfNbr ospfNbr) {
        this.controller.removeLinkDetails(this.buildOspfRouterDetails(ospfNbr));
    }

    private OspfRouter buildOspfRouterDetails(OspfNbr ospfNbr) {
        OspfRouterImpl ospfRouter = new OspfRouterImpl();
        ospfRouter.setRouterIp(ospfNbr.neighborId());
        ospfRouter.setInterfaceId(this.ospfInterface.ipAddress());
        ospfRouter.setAreaIdOfInterface(this.ospfArea.areaId());
        ospfRouter.setDeviceTed(new OspfDeviceTedImpl());
        return ospfRouter;
    }

    private class InternalDelayedAckTimer
    implements Runnable {
        Channel ch;

        InternalDelayedAckTimer() {
            this.ch = OspfInterfaceChannelHandler.this.channel;
        }

        @Override
        public void run() {
            if (!((OspfInterfaceImpl)OspfInterfaceChannelHandler.this.ospfInterface).linkStateHeaders().isEmpty()) {
                OspfInterfaceChannelHandler.this.isDelayedAckTimerScheduled = true;
                if (this.ch != null && this.ch.isConnected()) {
                    ArrayList<LsaHeader> listOfLsaHeadersAcknowledged = new ArrayList<LsaHeader>();
                    List<LsaHeader> listOfLsaHeaders = ((OspfInterfaceImpl)OspfInterfaceChannelHandler.this.ospfInterface).linkStateHeaders();
                    log.debug("Delayed Ack, Number of Lsa's to Ack {}", (Object)listOfLsaHeaders.size());
                    Iterator<LsaHeader> itr = listOfLsaHeaders.iterator();
                    while (itr.hasNext()) {
                        LsAcknowledge ackContent = new LsAcknowledge();
                        ackContent.setOspfVer(2);
                        ackContent.setOspftype(OspfPacketType.LSAACK.value());
                        ackContent.setRouterId(OspfInterfaceChannelHandler.this.ospfArea.routerId());
                        ackContent.setAreaId(OspfInterfaceChannelHandler.this.ospfArea.areaId());
                        ackContent.setAuthType(0);
                        ackContent.setAuthentication(0);
                        ackContent.setOspfPacLength(0);
                        ackContent.setChecksum(0);
                        int currentLength = 24;
                        int maxSize = OspfInterfaceChannelHandler.this.ospfInterface.mtu() - 20;
                        while (itr.hasNext() && currentLength + 20 < maxSize) {
                            LsaHeader lsaHeader = itr.next();
                            ackContent.addLinkStateHeader(lsaHeader);
                            currentLength += 20;
                            listOfLsaHeadersAcknowledged.add(lsaHeader);
                            log.debug("Delayed Ack, Added Lsa's to Ack {}", (Object)lsaHeader);
                        }
                        log.debug("Delayed Ack, Number of Lsa's in LsAck packet {}", (Object)ackContent.getLinkStateHeaders().size());
                        if (((OspfInterfaceImpl)OspfInterfaceChannelHandler.this.ospfInterface).state() == OspfInterfaceState.DR || ((OspfInterfaceImpl)OspfInterfaceChannelHandler.this.ospfInterface).state() == OspfInterfaceState.BDR || ((OspfInterfaceImpl)OspfInterfaceChannelHandler.this.ospfInterface).state() == OspfInterfaceState.POINT2POINT) {
                            ackContent.setDestinationIp(OspfUtil.ALL_SPF_ROUTERS);
                        } else if (((OspfInterfaceImpl)OspfInterfaceChannelHandler.this.ospfInterface).state() == OspfInterfaceState.DROTHER) {
                            ackContent.setDestinationIp(OspfUtil.ALL_DROUTERS);
                        }
                        this.ch.write((Object)ackContent);
                        for (LsaHeader lsa : listOfLsaHeadersAcknowledged) {
                            ((OspfInterfaceImpl)OspfInterfaceChannelHandler.this.ospfInterface).linkStateHeaders().remove(lsa);
                            OspfInterfaceChannelHandler.this.ospfInterface.removeLsaFromNeighborMap(((OspfAreaImpl)OspfInterfaceChannelHandler.this.ospfArea).getLsaKey(lsa));
                        }
                    }
                }
            }
        }
    }

    private class InternalWaitTimer
    implements Runnable {
        Channel ch;

        InternalWaitTimer() {
            this.ch = OspfInterfaceChannelHandler.this.channel;
        }

        @Override
        public void run() {
            log.debug("Wait timer expires...");
            if (this.ch != null && this.ch.isConnected()) {
                try {
                    OspfInterfaceChannelHandler.this.waitTimer(this.ch);
                }
                catch (Exception e) {
                    log.debug("Exception at wait timer ...!!!");
                }
            }
        }
    }

    private class InternalHelloTimer
    implements Runnable {
        InternalHelloTimer() {
        }

        @Override
        public void run() {
            if (!OspfInterfaceChannelHandler.this.isClosed && OspfInterfaceChannelHandler.this.channel != null && OspfInterfaceChannelHandler.this.channel.isOpen() && OspfInterfaceChannelHandler.this.channel.isConnected()) {
                HelloPacket hellopacket = new HelloPacket();
                hellopacket.setOspfVer(2);
                hellopacket.setOspftype(OspfPacketType.HELLO.value());
                hellopacket.setOspfPacLength(0);
                hellopacket.setRouterId(OspfInterfaceChannelHandler.this.ospfArea.routerId());
                hellopacket.setAreaId(OspfInterfaceChannelHandler.this.ospfArea.areaId());
                hellopacket.setChecksum(0);
                hellopacket.setAuthType(Integer.parseInt(OspfInterfaceChannelHandler.this.ospfInterface.authType()));
                hellopacket.setAuthentication(Integer.parseInt(OspfInterfaceChannelHandler.this.ospfInterface.authKey()));
                hellopacket.setNetworkMask(OspfInterfaceChannelHandler.this.ospfInterface.ipNetworkMask());
                hellopacket.setOptions(OspfInterfaceChannelHandler.this.ospfArea.options());
                hellopacket.setHelloInterval(OspfInterfaceChannelHandler.this.ospfInterface.helloIntervalTime());
                hellopacket.setRouterPriority(OspfInterfaceChannelHandler.this.ospfInterface.routerPriority());
                hellopacket.setRouterDeadInterval(OspfInterfaceChannelHandler.this.ospfInterface.routerDeadIntervalTime());
                hellopacket.setDr(OspfInterfaceChannelHandler.this.ospfInterface.dr());
                hellopacket.setBdr(OspfInterfaceChannelHandler.this.ospfInterface.bdr());
                HashMap listOfNeighbors = OspfInterfaceChannelHandler.this.ospfInterface.listOfNeighbors();
                Set keys = listOfNeighbors.keySet();
                for (String nbrKey : keys) {
                    OspfNbrImpl nbr = (OspfNbrImpl)listOfNeighbors.get(nbrKey);
                    if (nbr.getState() == OspfNeighborState.DOWN) continue;
                    hellopacket.addNeighbor(Ip4Address.valueOf((String)nbrKey));
                }
                if (OspfInterfaceChannelHandler.this.channel == null || !OspfInterfaceChannelHandler.this.channel.isOpen() || !OspfInterfaceChannelHandler.this.channel.isConnected()) {
                    log.debug("Hello Packet not sent !!.. Channel Issue...");
                    return;
                }
                hellopacket.setDestinationIp(OspfUtil.ALL_SPF_ROUTERS);
                ChannelFuture future = OspfInterfaceChannelHandler.this.channel.write((Object)hellopacket);
                if (future.isSuccess()) {
                    log.debug("Hello Packet successfully sent !!");
                } else {
                    future.awaitUninterruptibly();
                }
            }
        }
    }
}

