/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessage;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfMessageDecoder
extends FrameDecoder {
    private static final Logger log = LoggerFactory.getLogger(OspfMessageDecoder.class);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer channelBuffer) throws Exception {
        log.debug("OspfMessageDecoder::Message received <:> length {}", (Object)channelBuffer.readableBytes());
        log.debug("channelBuffer.readableBytes - decode {}", (Object)channelBuffer.readableBytes());
        if (!channel.isConnected()) {
            log.info("Channel is not connected.");
            return null;
        }
        OspfMessageReader messageReader = new OspfMessageReader();
        LinkedList<OspfMessage> ospfMessageList = new LinkedList<OspfMessage>();
        while (channelBuffer.readableBytes() > 0) {
            OspfMessage message = messageReader.readFromBuffer(channelBuffer);
            if (message == null) continue;
            ospfMessageList.add(message);
        }
        return ospfMessageList;
    }
}

