/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessage;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessageWriter;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;
import org.onosproject.ospf.protocol.util.OspfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfMessageEncoder
extends OneToOneEncoder {
    private static final Logger log = LoggerFactory.getLogger(OspfMessageEncoder.class);
    private OspfInterface ospfInterface;

    OspfMessageEncoder() {
    }

    OspfMessageEncoder(OspfInterface ospfInterface) {
        this.ospfInterface = ospfInterface;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        log.debug("Encoding ospfMessage...!!!");
        if (!(msg instanceof OspfMessage)) {
            log.debug("Invalid msg.");
            return msg;
        }
        OspfMessage ospfMessage = (OspfMessage)msg;
        OspfMessageWriter messageWriter = new OspfMessageWriter();
        if (((OspfInterfaceImpl)this.ospfInterface).state().equals((Object)OspfInterfaceState.POINT2POINT)) {
            ospfMessage.setDestinationIp(OspfUtil.ALL_SPF_ROUTERS);
        }
        ChannelBuffer buf = messageWriter.writeToBuffer(ospfMessage, ((OspfInterfaceImpl)this.ospfInterface).state().value(), this.ospfInterface.interfaceType());
        log.info("OspfMessageEncoder sending packet of lenght {}", (Object)buf.readableBytes());
        log.debug("OspfMessageEncoder sending packet of lenght {}", (Object)buf.readableBytes());
        log.debug("Sending {} Message to {}, Length :: {}, <=> {}", new Object[]{ospfMessage.ospfMessageType(), ospfMessage.destinationIp(), buf.readableBytes(), buf.array()});
        return buf;
    }
}

