/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Bandwidth;
import org.onosproject.ospf.controller.DeviceInformation;
import org.onosproject.ospf.controller.LinkInformation;
import org.onosproject.ospf.controller.LsaWrapper;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.OspfLinkTed;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.controller.OspfLsdb;
import org.onosproject.ospf.controller.OspfNbr;
import org.onosproject.ospf.controller.OspfNeighborState;
import org.onosproject.ospf.controller.TopologyForDeviceAndLink;
import org.onosproject.ospf.controller.area.OspfAreaImpl;
import org.onosproject.ospf.controller.area.OspfInterfaceImpl;
import org.onosproject.ospf.controller.impl.OspfDeviceTedImpl;
import org.onosproject.ospf.controller.impl.OspfInterfaceChannelHandler;
import org.onosproject.ospf.controller.impl.OspfLinkTedImpl;
import org.onosproject.ospf.controller.impl.OspfRouterImpl;
import org.onosproject.ospf.controller.lsdb.LsaWrapperImpl;
import org.onosproject.ospf.controller.util.OspfInterfaceType;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa10;
import org.onosproject.ospf.protocol.lsa.types.TopLevelTlv;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessage;
import org.onosproject.ospf.protocol.ospfpacket.OspfPacketHeader;
import org.onosproject.ospf.protocol.ospfpacket.subtype.LsRequestPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.DdPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.LsAcknowledge;
import org.onosproject.ospf.protocol.ospfpacket.types.LsRequest;
import org.onosproject.ospf.protocol.ospfpacket.types.LsUpdate;
import org.onosproject.ospf.protocol.util.ChecksumCalculator;
import org.onosproject.ospf.protocol.util.OspfInterfaceState;
import org.onosproject.ospf.protocol.util.OspfPacketType;
import org.onosproject.ospf.protocol.util.OspfUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfNbrImpl
implements OspfNbr {
    private static final Logger log = LoggerFactory.getLogger(OspfNbrImpl.class);
    private OspfNeighborState state;
    private InternalRxmtDdPacket rxmtDdPacketTask;
    private InternalInactivityTimeCheck inActivityTimeCheckTask;
    private InternalFloodingTask floodingTask;
    private InternalRxmtLsrPacket rxmtLsrPacketTask;
    private ScheduledExecutorService exServiceRxmtLsr;
    private ScheduledExecutorService exServiceFlooding;
    private ScheduledExecutorService exServiceRxmtDDPacket;
    private ScheduledExecutorService exServiceInActivity;
    private boolean floodingTimerScheduled = false;
    private boolean rxmtLsrTimerScheduled = false;
    private boolean rxmtDdPacketTimerScheduled = false;
    private boolean inActivityTimerScheduled = false;
    private int isMaster;
    private long ddSeqNum;
    private DdPacket lastDdPacket;
    private DdPacket lastSentDdPacket;
    private LsRequest lastSentLsrPacket;
    private Ip4Address neighborId;
    private Ip4Address neighborIpAddr;
    private Ip4Address neighborDr;
    private Ip4Address neighborBdr;
    private int routerPriority;
    private int routerDeadInterval;
    private Map<String, OspfLsa> reTxList = new LinkedHashMap<String, OspfLsa>();
    private Map<String, OspfLsa> pendingReTxList = new LinkedHashMap<String, OspfLsa>();
    private Map failedTxList = new HashMap();
    private List<LsaHeader> ddSummaryList = new CopyOnWriteArrayList<LsaHeader>();
    private Hashtable lsReqList = new Hashtable();
    private int options;
    private boolean isOpaqueCapable;
    private OspfInterface ospfInterface;
    private OspfArea ospfArea;
    private OspfInterfaceChannelHandler handler;
    private List<TopLevelTlv> topLevelTlvs = new ArrayList<TopLevelTlv>();
    private List<DeviceInformation> deviceInformationList = new ArrayList<DeviceInformation>();
    private TopologyForDeviceAndLink topologyForDeviceAndLink;

    public OspfNbrImpl(OspfArea paramOspfArea, OspfInterface paramOspfInterface, Ip4Address ipAddr, Ip4Address routerId, int options, OspfInterfaceChannelHandler handler, TopologyForDeviceAndLink topologyForDeviceAndLinkCommon) {
        this.ospfArea = paramOspfArea;
        this.ospfInterface = paramOspfInterface;
        this.state = OspfNeighborState.DOWN;
        this.isMaster = 0;
        this.ddSeqNum = OspfUtil.createRandomNumber();
        this.neighborIpAddr = ipAddr;
        this.neighborId = routerId;
        this.options = options;
        this.lastDdPacket = new DdPacket();
        this.routerDeadInterval = paramOspfInterface.routerDeadIntervalTime();
        this.handler = handler;
        this.topologyForDeviceAndLink = topologyForDeviceAndLinkCommon;
    }

    public Ip4Address neighborIpAddr() {
        return this.neighborIpAddr;
    }

    public boolean isOpaqueCapable() {
        return this.isOpaqueCapable;
    }

    public void setIsOpaqueCapable(boolean isOpaqueCapable) {
        this.isOpaqueCapable = isOpaqueCapable;
    }

    public void oneWayReceived(OspfMessage ospfHello, Channel channel) {
        log.debug("OSPFNbr::oneWayReceived...!!!");
        this.stopInactivityTimeCheck();
        this.startInactivityTimeCheck();
        if (this.state == OspfNeighborState.ATTEMPT) {
            this.state = OspfNeighborState.INIT;
        } else if (this.state == OspfNeighborState.DOWN) {
            this.state = OspfNeighborState.INIT;
        }
        if (this.state.getValue() >= OspfNeighborState.TWOWAY.getValue()) {
            this.state = OspfNeighborState.INIT;
            this.failedTxList.clear();
            this.ddSummaryList.clear();
            this.lsReqList.clear();
        }
    }

    public void twoWayReceived(OspfMessage ospfMessage, Channel channel) throws Exception {
        log.debug("OSPFNbr::twoWayReceived...!!!");
        this.stopInactivityTimeCheck();
        this.startInactivityTimeCheck();
        this.startFloodingTimer(channel);
        OspfPacketHeader packet = (OspfPacketHeader)ospfMessage;
        if (this.state.getValue() <= OspfNeighborState.TWOWAY.getValue()) {
            if (this.formAdjacencyOrNot()) {
                this.state = OspfNeighborState.EXSTART;
                ++this.ddSeqNum;
                DdPacket ddPacket = new DdPacket();
                ddPacket.setOspfVer(2);
                ddPacket.setOspftype(OspfPacketType.DD.value());
                ddPacket.setRouterId(this.ospfArea.routerId());
                ddPacket.setAreaId(this.ospfArea.areaId());
                ddPacket.setAuthType(0);
                ddPacket.setAuthentication(0);
                ddPacket.setOspfPacLength(0);
                ddPacket.setChecksum(0);
                boolean isOpaqueEnabled = this.ospfArea.isOpaqueEnabled();
                if (isOpaqueEnabled) {
                    ddPacket.setOptions(this.ospfArea.opaqueEnabledOptions());
                } else {
                    ddPacket.setOptions(this.ospfArea.options());
                }
                ddPacket.setIsInitialize(1);
                ddPacket.setIsMore(1);
                ddPacket.setIsMaster(1);
                ddPacket.setImtu(this.ospfInterface.mtu());
                ddPacket.setSequenceNo(this.ddSeqNum);
                this.setLastSentDdPacket(ddPacket);
                this.rxmtDdPacketTask = new InternalRxmtDdPacket(channel);
                this.startRxMtDdTimer(channel);
                ddPacket.setDestinationIp(packet.sourceIp());
                channel.write((Object)ddPacket);
            } else {
                this.state = OspfNeighborState.TWOWAY;
            }
        }
    }

    private boolean formAdjacencyOrNot() {
        boolean formAdjacency = false;
        if (this.ospfInterface.interfaceType() == OspfInterfaceType.POINT_TO_POINT.value()) {
            formAdjacency = true;
        } else if (this.ospfInterface.interfaceType() == OspfInterfaceType.BROADCAST.value()) {
            if (this.ospfInterface.ipAddress().equals((Object)this.neighborDr) || this.ospfInterface.ipAddress().equals((Object)this.neighborBdr)) {
                formAdjacency = true;
            } else if (this.neighborBdr.equals((Object)this.neighborIpAddr) || this.neighborDr.equals((Object)this.neighborIpAddr)) {
                formAdjacency = true;
            }
        }
        log.debug("FormAdjacencyOrNot - neighborDR: {}, neighborBDR: {}, neighborIPAddr: {}, formAdjacencyOrNot {}", new Object[]{this.neighborDr, this.neighborBdr, this.neighborIpAddr, formAdjacency});
        return formAdjacency;
    }

    public void negotiationDone(OspfMessage ospfMessage, boolean neighborIsMaster, List payload, Channel ch) throws Exception {
        this.stopRxMtDdTimer();
        OspfPacketHeader packet = (OspfPacketHeader)ospfMessage;
        DdPacket ddPacketForCheck = (DdPacket)packet;
        if (ddPacketForCheck.isOpaqueCapable()) {
            OspfLsdb database = this.ospfArea.database();
            List opaqueLsas = database.getAllLsaHeaders(true, true);
            for (OspfLsa ospfLsa : opaqueLsas) {
                if (ospfLsa.getOspfLsaType() != OspfLsaType.AREA_LOCAL_OPAQUE_LSA) continue;
                OpaqueLsa10 opaqueLsa10 = (OpaqueLsa10)ospfLsa;
                this.topLevelTlvs = opaqueLsa10.topLevelValues();
            }
        }
        if (this.state == OspfNeighborState.EXSTART) {
            DdPacket ddPacket;
            this.state = OspfNeighborState.EXCHANGE;
            boolean excludeMaxAgeLsa = true;
            this.ddSummaryList = (CopyOnWriteArrayList)this.ospfArea.getLsaHeaders(excludeMaxAgeLsa, this.isOpaqueCapable);
            if (neighborIsMaster) {
                this.processLsas(payload);
                ddPacket = new DdPacket();
                ddPacket.setOspfVer(2);
                ddPacket.setOspftype(OspfPacketType.DD.value());
                ddPacket.setRouterId(this.ospfArea.routerId());
                ddPacket.setAreaId(this.ospfArea.areaId());
                ddPacket.setAuthType(0);
                ddPacket.setAuthentication(0);
                ddPacket.setOspfPacLength(0);
                ddPacket.setChecksum(0);
                boolean isOpaqueEnabled = this.ospfArea.isOpaqueEnabled();
                if (isOpaqueEnabled && this.isOpaqueCapable) {
                    ddPacket.setOptions(this.ospfArea.opaqueEnabledOptions());
                } else {
                    ddPacket.setOptions(this.ospfArea.options());
                }
                ddPacket.setIsInitialize(0);
                ddPacket.setIsMore(0);
                ddPacket.setIsMaster(0);
                ddPacket.setImtu(this.ospfInterface.mtu());
                ddPacket.setSequenceNo(this.ddSeqNum);
                ddPacket.setDestinationIp(packet.sourceIp());
                this.setLastSentDdPacket(ddPacket);
                this.getIsMoreBit();
                ch.write((Object)this.lastSentDdPacket());
            } else {
                this.processLsas(payload);
                ddPacket = new DdPacket();
                ddPacket.setOspfVer(2);
                ddPacket.setOspftype(OspfPacketType.DD.value());
                ddPacket.setRouterId(this.ospfArea.routerId());
                ddPacket.setAreaId(this.ospfArea.areaId());
                ddPacket.setAuthType(0);
                ddPacket.setAuthentication(0);
                ddPacket.setOspfPacLength(0);
                ddPacket.setChecksum(0);
                boolean isOpaqueEnabled = this.ospfArea.isOpaqueEnabled();
                if (isOpaqueEnabled && this.isOpaqueCapable) {
                    ddPacket.setOptions(this.ospfArea.opaqueEnabledOptions());
                } else {
                    ddPacket.setOptions(this.ospfArea.options());
                }
                ddPacket.setIsInitialize(0);
                ddPacket.setIsMore(0);
                ddPacket.setIsMaster(1);
                ddPacket.setImtu(this.ospfInterface.mtu());
                ddPacket.setSequenceNo(this.ddSeqNum);
                this.setLastSentDdPacket(ddPacket);
                this.getIsMoreBit();
                ddPacket.setDestinationIp(packet.sourceIp());
                ch.write((Object)this.lastSentDdPacket());
                this.startRxMtDdTimer(ch);
            }
        }
    }

    public void processLsas(List ddPayload) throws Exception {
        log.debug("OSPFNbr::processLsas...!!!");
        for (OspfLsa nextLsa : ddPayload) {
            if (nextLsa.getOspfLsaType().value() > OspfLsaType.EXTERNAL_LSA.value() && nextLsa.getOspfLsaType().value() < OspfLsaType.LINK_LOCAL_OPAQUE_LSA.value() || nextLsa.getOspfLsaType().value() > OspfLsaType.AS_OPAQUE_LSA.value()) {
                this.seqNumMismatch("LS Type found was unknown.");
                return;
            }
            if (nextLsa.getOspfLsaType() == OspfLsaType.EXTERNAL_LSA && !this.ospfArea.isExternalRoutingCapability()) {
                this.seqNumMismatch("External LSA found although area is stub.");
                return;
            }
            LsaWrapper lsaHasInstance = this.ospfArea.lsaLookup(nextLsa);
            if (lsaHasInstance == null) {
                this.lsReqList.put(((OspfAreaImpl)this.ospfArea).getLsaKey((LsaHeader)nextLsa), nextLsa);
                continue;
            }
            String isNew = ((OspfAreaImpl)this.ospfArea).isNewerOrSameLsa(nextLsa, lsaHasInstance.ospfLsa());
            if (!isNew.equals("latest")) continue;
            this.lsReqList.put(((OspfAreaImpl)this.ospfArea).getLsaKey((LsaHeader)nextLsa), nextLsa);
        }
    }

    public OspfMessage seqNumMismatch(String reason) throws Exception {
        log.debug("OSPFNbr::seqNumMismatch...{} ", (Object)reason);
        this.stopRxMtDdTimer();
        if (this.state.getValue() >= OspfNeighborState.EXCHANGE.getValue()) {
            this.state = OspfNeighborState.EXSTART;
            this.lsReqList.clear();
            this.ddSummaryList.clear();
            ++this.ddSeqNum;
            DdPacket ddPacket = new DdPacket();
            ddPacket.setOspfVer(2);
            ddPacket.setOspftype(OspfPacketType.DD.value());
            ddPacket.setRouterId(this.ospfArea.routerId());
            ddPacket.setAreaId(this.ospfArea.areaId());
            ddPacket.setAuthType(0);
            ddPacket.setAuthentication(0);
            ddPacket.setOspfPacLength(0);
            ddPacket.setChecksum(0);
            boolean isOpaqueEnabled = this.ospfArea.isOpaqueEnabled();
            if (isOpaqueEnabled) {
                ddPacket.setOptions(this.ospfArea.opaqueEnabledOptions());
            } else {
                ddPacket.setOptions(this.ospfArea.options());
            }
            ddPacket.setIsInitialize(1);
            ddPacket.setIsMore(1);
            ddPacket.setIsMaster(1);
            ddPacket.setImtu(this.ospfInterface.mtu());
            ddPacket.setSequenceNo(this.ddSeqNum);
            this.setLastSentDdPacket(ddPacket);
            ddPacket.setDestinationIp(this.neighborIpAddr());
            this.setLastSentDdPacket(ddPacket);
            return ddPacket;
        }
        return null;
    }

    public void badLSReq(Channel ch) throws Exception {
        log.debug("OSPFNbr::badLSReq...!!!");
        if (this.state.getValue() >= OspfNeighborState.EXCHANGE.getValue()) {
            if (this.state == OspfNeighborState.FULL) {
                this.ospfArea.refreshArea(this.ospfInterface);
            }
            this.stopRxMtDdTimer();
            this.state = OspfNeighborState.EXSTART;
            this.lsReqList.clear();
            this.ddSummaryList.clear();
            this.reTxList.clear();
            this.isMaster = 1;
            ++this.ddSeqNum;
            DdPacket ddPacket = new DdPacket();
            ddPacket.setOspfVer(2);
            ddPacket.setOspftype(OspfPacketType.DD.value());
            ddPacket.setRouterId(this.ospfArea.routerId());
            ddPacket.setAreaId(this.ospfArea.areaId());
            ddPacket.setAuthType(0);
            ddPacket.setAuthentication(0);
            ddPacket.setOspfPacLength(0);
            ddPacket.setChecksum(0);
            boolean isOpaqueEnabled = this.ospfArea.isOpaqueEnabled();
            if (isOpaqueEnabled && this.isOpaqueCapable) {
                ddPacket.setOptions(this.ospfArea.opaqueEnabledOptions());
            } else {
                ddPacket.setOptions(this.ospfArea.options());
            }
            ddPacket.setIsInitialize(1);
            ddPacket.setIsMore(1);
            ddPacket.setIsMaster(1);
            ddPacket.setImtu(this.ospfInterface.mtu());
            ddPacket.setSequenceNo(this.ddSeqNum);
            this.rxmtDdPacketTask = new InternalRxmtDdPacket(ch);
            this.startRxMtDdTimer(ch);
            ddPacket.setDestinationIp(this.neighborIpAddr());
            this.setLastSentDdPacket(ddPacket);
            ch.write((Object)ddPacket);
        }
    }

    public void processDdPacket(boolean neighborIsMaster, DdPacket dataDescPkt, Channel ch) throws Exception {
        log.debug("OSPFNbr::neighborIsMaster.{}", (Object)neighborIsMaster);
        if (!neighborIsMaster) {
            this.stopRxMtDdTimer();
            ++this.ddSeqNum;
            this.processLsas(dataDescPkt.getLsaHeaderList());
            if (this.ddSummaryList.isEmpty() && dataDescPkt.isMore() == 0) {
                log.debug("OSPFNbr::ddSummaryList is empty and dataDescPkt.isMore is zero..!!!");
                this.exchangeDone((OspfMessage)dataDescPkt, ch);
            } else {
                log.debug("OSPFNbr::ddSummaryList is present...!!!");
                DdPacket ddPacket = new DdPacket();
                ddPacket.setOspfVer(2);
                ddPacket.setOspftype(OspfPacketType.DD.value());
                ddPacket.setRouterId(this.ospfArea.routerId());
                ddPacket.setAreaId(this.ospfArea.areaId());
                ddPacket.setAuthType(0);
                ddPacket.setAuthentication(0);
                ddPacket.setOspfPacLength(0);
                ddPacket.setChecksum(0);
                boolean isOpaqueEnabled = this.ospfArea.isOpaqueEnabled();
                if (isOpaqueEnabled && this.isOpaqueCapable) {
                    ddPacket.setOptions(this.ospfArea.opaqueEnabledOptions());
                } else {
                    ddPacket.setOptions(this.ospfArea.options());
                }
                ddPacket.setIsInitialize(0);
                ddPacket.setIsMore(0);
                ddPacket.setIsMaster(1);
                ddPacket.setImtu(this.ospfInterface.mtu());
                ddPacket.setSequenceNo(this.ddSeqNum);
                this.setLastSentDdPacket(ddPacket);
                this.getIsMoreBit();
                ddPacket.setDestinationIp(dataDescPkt.sourceIp());
                ch.write((Object)this.lastSentDdPacket());
                this.startRxMtDdTimer(ch);
            }
        } else {
            log.debug("OSPFNbr::neighborIsMaster is master...!!!");
            this.ddSeqNum = dataDescPkt.sequenceNo();
            this.processLsas(dataDescPkt.getLsaHeaderList());
            DdPacket ddPacket = new DdPacket();
            ddPacket.setOspfVer(2);
            ddPacket.setOspftype(OspfPacketType.DD.value());
            ddPacket.setRouterId(this.ospfArea.routerId());
            ddPacket.setAreaId(this.ospfArea.areaId());
            ddPacket.setAuthType(0);
            ddPacket.setAuthentication(0);
            ddPacket.setOspfPacLength(0);
            ddPacket.setChecksum(0);
            boolean isOpaqueEnabled = this.ospfArea.isOpaqueEnabled();
            if (isOpaqueEnabled && this.isOpaqueCapable) {
                ddPacket.setOptions(this.ospfArea.opaqueEnabledOptions());
            } else {
                ddPacket.setOptions(this.ospfArea.options());
            }
            ddPacket.setIsInitialize(0);
            ddPacket.setIsMore(0);
            ddPacket.setIsMaster(0);
            ddPacket.setImtu(this.ospfInterface.mtu());
            ddPacket.setSequenceNo(this.ddSeqNum);
            this.setLastSentDdPacket(ddPacket);
            this.getIsMoreBit();
            if (ddPacket.isMore() == 0 && dataDescPkt.isMore() == 0) {
                this.exchangeDone((OspfMessage)dataDescPkt, ch);
            }
            ddPacket.setDestinationIp(dataDescPkt.sourceIp());
            ch.write((Object)ddPacket);
        }
    }

    private void getIsMoreBit() {
        DdPacket ddPacket = this.lastSentDdPacket();
        int count = this.ddSummaryList.size();
        if (!this.ddSummaryList.isEmpty()) {
            Iterator<LsaHeader> itr = this.ddSummaryList.iterator();
            int currentLength = 32;
            int maxSize = this.ospfInterface.mtu() - 20;
            while (itr.hasNext() && currentLength + 20 <= maxSize) {
                LsaHeader lsaHeader = itr.next();
                ddPacket.addLsaHeader(lsaHeader);
                currentLength += 20;
                this.ddSummaryList.remove(lsaHeader);
                --count;
            }
            if (count > 0) {
                ddPacket.setIsMore(1);
            } else {
                ddPacket.setIsMore(0);
            }
        }
        this.setLastSentDdPacket(ddPacket);
    }

    public void exchangeDone(OspfMessage message, Channel ch) {
        log.debug("OSPFNbr::exchangeDone...!!!");
        this.stopRxMtDdTimer();
        OspfPacketHeader header = (OspfPacketHeader)message;
        if (this.state == OspfNeighborState.EXCHANGE) {
            if (this.lsReqList.isEmpty()) {
                this.state = OspfNeighborState.FULL;
            } else {
                this.state = OspfNeighborState.LOADING;
                LsRequest lsRequest = this.buildLsRequest();
                lsRequest.setDestinationIp(header.sourceIp());
                ch.write((Object)lsRequest);
                this.setLastSentLsrPacket(lsRequest);
                this.startRxMtLsrTimer(ch);
            }
        }
    }

    private LsRequest buildLsRequest() {
        LsRequest lsRequest = new LsRequest();
        lsRequest.setOspfVer(2);
        lsRequest.setOspftype(OspfPacketType.LSREQUEST.value());
        lsRequest.setRouterId(this.ospfArea.routerId());
        lsRequest.setAreaId(this.ospfArea.areaId());
        lsRequest.setAuthType(0);
        lsRequest.setAuthentication(0);
        lsRequest.setOspfPacLength(0);
        lsRequest.setChecksum(0);
        Set lsaKeys = this.lsReqList.keySet();
        Iterator itr = lsaKeys.iterator();
        int currentLength = 24;
        int maxSize = this.ospfInterface.mtu() - 20;
        while (itr.hasNext() && currentLength + 12 < maxSize) {
            LsRequestPacket lsRequestPacket = new LsRequestPacket();
            String key = (String)itr.next();
            String[] lsaKey = key.split("-");
            OspfLsa lsa = (OspfLsa)this.lsReqList.get(key);
            lsRequestPacket.setLsType(Integer.valueOf(lsaKey[0]).intValue());
            lsRequestPacket.setOwnRouterId(lsaKey[2]);
            if (lsa.getOspfLsaType().value() == OspfLsaType.AREA_LOCAL_OPAQUE_LSA.value() || lsa.getOspfLsaType().value() == OspfLsaType.LINK_LOCAL_OPAQUE_LSA.value() || lsa.getOspfLsaType().value() == OspfLsaType.AS_OPAQUE_LSA.value()) {
                OpaqueLsaHeader header = (OpaqueLsaHeader)lsa;
                byte[] opaqueIdBytes = OspfUtil.convertToTwoBytes((int)header.opaqueId());
                lsRequestPacket.setLinkStateId(header.opaqueType() + "." + "0" + "." + opaqueIdBytes[0] + "." + opaqueIdBytes[1]);
            } else {
                lsRequestPacket.setLinkStateId(lsaKey[1]);
            }
            lsRequest.addLinkStateRequests(lsRequestPacket);
            currentLength += 12;
        }
        return lsRequest;
    }

    public void adjOk(Channel ch) {
        log.debug("OSPFNbr::adjOk...!!!");
        if (this.ospfInterface.interfaceType() != OspfInterfaceType.POINT_TO_POINT.value()) {
            if (this.state == OspfNeighborState.TWOWAY) {
                if (this.formAdjacencyOrNot()) {
                    this.state = OspfNeighborState.EXSTART;
                    ++this.ddSeqNum;
                    DdPacket ddPacket = new DdPacket();
                    ddPacket.setOspfVer(2);
                    ddPacket.setOspftype(OspfPacketType.DD.value());
                    ddPacket.setRouterId(this.ospfArea.routerId());
                    ddPacket.setAreaId(this.ospfArea.areaId());
                    ddPacket.setAuthType(0);
                    ddPacket.setAuthentication(0);
                    ddPacket.setOspfPacLength(0);
                    ddPacket.setChecksum(0);
                    boolean isOpaqueEnabled = this.ospfArea.isOpaqueEnabled();
                    if (isOpaqueEnabled && this.isOpaqueCapable) {
                        ddPacket.setOptions(this.ospfArea.opaqueEnabledOptions());
                    } else {
                        ddPacket.setOptions(this.ospfArea.options());
                    }
                    ddPacket.setIsInitialize(1);
                    ddPacket.setIsMore(1);
                    ddPacket.setIsMaster(1);
                    ddPacket.setImtu(this.ospfInterface.mtu());
                    ddPacket.setSequenceNo(this.ddSeqNum);
                    this.rxmtDdPacketTask = new InternalRxmtDdPacket(ch);
                    this.startRxMtDdTimer(ch);
                    ddPacket.setDestinationIp(this.neighborIpAddr());
                    this.setLastSentDdPacket(ddPacket);
                    ch.write((Object)ddPacket);
                }
            } else if (this.state.getValue() >= OspfNeighborState.EXSTART.getValue() && !this.formAdjacencyOrNot()) {
                this.state = OspfNeighborState.TWOWAY;
                this.lsReqList.clear();
                this.ddSummaryList.clear();
                this.reTxList.clear();
            }
        }
    }

    public void processLsUpdate(LsUpdate lsUpdPkt, Channel ch) throws Exception {
        this.stopRxMtLsrTimer();
        log.debug("OSPFNbr::processLsUpdate...!!!");
        List lsaList = lsUpdPkt.getLsaList();
        if (!lsaList.isEmpty()) {
            for (LsaHeader lsaHeader : lsaList) {
                String key = ((OspfAreaImpl)this.ospfArea).getLsaKey(lsaHeader);
                if (this.lsReqList.containsKey(key)) {
                    boolean removeIt = this.processReceivedLsa(lsaHeader, false, ch, lsUpdPkt.sourceIp());
                    if (!removeIt) continue;
                    this.lsReqList.remove(key);
                    continue;
                }
                this.processReceivedLsa(lsaHeader, true, ch, lsUpdPkt.sourceIp());
            }
            if (this.lsReqList.isEmpty() && this.state == OspfNeighborState.LOADING) {
                this.loadingDone();
            } else {
                this.stopRxMtLsrTimer();
                LsRequest lsRequest = this.buildLsRequest();
                lsRequest.setDestinationIp(lsUpdPkt.sourceIp());
                this.setLastSentLsrPacket(lsRequest);
                this.startRxMtLsrTimer(ch);
            }
        }
    }

    public void loadingDone() throws Exception {
        this.stopRxMtLsrTimer();
        this.stopRxMtDdTimer();
        log.debug("OSPFNbr::loadingDone...!!!");
        this.state = OspfNeighborState.FULL;
        this.ospfArea.refreshArea(this.ospfInterface);
    }

    private void callDeviceAndLinkAdding(TopologyForDeviceAndLink topologyForDeviceAndLink) {
        Map deviceInformationMap = topologyForDeviceAndLink.deviceInformationMap();
        Map linkInformationMap = topologyForDeviceAndLink.linkInformationMap();
        OspfRouterImpl ospfRouter = new OspfRouterImpl();
        log.debug("Device Information in list format along with size {}", (Object)deviceInformationMap.size());
        for (String string : deviceInformationMap.keySet()) {
            DeviceInformation value = (DeviceInformation)deviceInformationMap.get(string);
            ospfRouter.setRouterIp(value.routerId());
            ospfRouter.setAreaIdOfInterface(this.ospfArea.areaId());
            ospfRouter.setNeighborRouterId(value.deviceId());
            OspfDeviceTedImpl ospfDeviceTed = new OspfDeviceTedImpl();
            List ip4Addresses = value.interfaceId();
            ospfDeviceTed.setIpv4RouterIds(ip4Addresses);
            ospfRouter.setDeviceTed(ospfDeviceTed);
            ospfRouter.setOpaque(this.ospfArea.isOpaqueEnabled());
            if (value.isDr()) {
                ospfRouter.setDr(value.isDr());
            } else {
                ospfRouter.setDr(false);
            }
            int size = value.interfaceId().size();
            for (int i = 0; i < size; ++i) {
                ospfRouter.setInterfaceId((Ip4Address)value.interfaceId().get(i));
            }
            if (value.isAlreadyCreated()) {
                this.removeDeviceDetails(value.routerId());
                OspfRouterImpl ospfRouter1 = new OspfRouterImpl();
                ospfRouter1.setRouterIp(value.routerId());
                ospfRouter1.setInterfaceId(this.ospfInterface.ipAddress());
                ospfRouter1.setAreaIdOfInterface(this.ospfArea.areaId());
                ospfRouter1.setDeviceTed(new OspfDeviceTedImpl());
                topologyForDeviceAndLink.removeLinks(value.routerId());
                this.handler.removeDeviceInformation(ospfRouter1);
            }
            this.handler.addDeviceInformation(ospfRouter);
        }
        for (Map.Entry entry : linkInformationMap.entrySet()) {
            String key = (String)entry.getKey();
            LinkInformation value = (LinkInformation)entry.getValue();
            OspfRouterImpl ospfRouterForLink = new OspfRouterImpl();
            ospfRouterForLink.setInterfaceId(value.interfaceIp());
            ospfRouterForLink.setAreaIdOfInterface(this.ospfArea.areaId());
            ospfRouterForLink.setOpaque(this.ospfArea.isOpaqueEnabled());
            OspfLinkTed ospfLinkTed = topologyForDeviceAndLink.getOspfLinkTedHashMap(value.linkDestinationId().toString());
            if (ospfLinkTed == null) {
                ospfLinkTed = new OspfLinkTedImpl();
                ospfLinkTed.setMaximumLink(Bandwidth.bps((long)0L));
                ospfLinkTed.setMaxReserved(Bandwidth.bps((long)0L));
                ospfLinkTed.setTeMetric(Integer.valueOf(0));
            }
            if (value.isLinkSrcIdNotRouterId()) continue;
            ospfRouterForLink.setRouterIp(value.linkSourceId());
            ospfRouterForLink.setNeighborRouterId(value.linkDestinationId());
            try {
                this.handler.addLinkInformation(ospfRouterForLink, ospfLinkTed);
                log.debug("LinkId, LinkSrc , LinkDest , LinkInterface values are : " + value.linkId() + " , " + value.linkSourceId() + "  , " + value.linkDestinationId() + " , " + value.interfaceIp());
            }
            catch (Exception e) {
                log.debug("Got Exception : {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean processReceivedLsa(LsaHeader recLsa, boolean receivedViaFlooding, Channel ch, Ip4Address sourceIp) throws Exception {
        log.debug("OSPFNbr::processReceivedLsa(recLsa, recievedViaFlooding, ch)...!!!");
        ChecksumCalculator checkSum = new ChecksumCalculator();
        if (!checkSum.isValidLsaCheckSum((OspfLsa)recLsa, recLsa.getOspfLsaType().value(), 16, 17)) {
            log.debug("Checksum mismatch. Received LSA packet type {} ", (Object)recLsa.lsType());
            return true;
        }
        if (recLsa.getOspfLsaType().value() > OspfLsaType.EXTERNAL_LSA.value()) {
            if (recLsa.getOspfLsaType().value() < OspfLsaType.LINK_LOCAL_OPAQUE_LSA.value()) return true;
        }
        if (recLsa.getOspfLsaType().value() > OspfLsaType.AS_OPAQUE_LSA.value()) {
            return true;
        }
        if (recLsa.getOspfLsaType() == OspfLsaType.EXTERNAL_LSA && !this.ospfArea.isExternalRoutingCapability()) {
            return true;
        }
        if (recLsa.age() == 3600 && this.ospfArea.lsaLookup((OspfLsa)recLsa) == null && this.ospfArea.noNeighborInLsaExchangeProcess()) {
            this.directAcknowledge(recLsa, ch, sourceIp);
            return true;
        }
        String key = ((OspfAreaImpl)this.ospfArea).getLsaKey(recLsa);
        LsaWrapper lsWrapper = this.ospfArea.lsaLookup((OspfLsa)recLsa);
        String status = this.isNullorLatest(lsWrapper, recLsa);
        if (status.equals("isNullorLatest")) {
            if (recLsa.lsType() == OspfLsaType.ROUTER.value() && recLsa.advertisingRouter().equals((Object)this.ospfArea.routerId())) {
                if (recLsa.lsSequenceNo() > ((LsaWrapperImpl)lsWrapper).lsaHeader().lsSequenceNo()) {
                    this.ospfArea.setDbRouterSequenceNumber(recLsa.lsSequenceNo() + 1L);
                    this.processSelfOriginatedLsa();
                }
                if (recLsa.age() != 3600) return true;
                ((LsaWrapperImpl)lsWrapper).lsaHeader().setAge(3600);
                this.ospfArea.addLsaToMaxAgeBin(((OspfAreaImpl)this.ospfArea).getLsaKey(((LsaWrapperImpl)lsWrapper).lsaHeader()), lsWrapper);
                this.ospfArea.removeLsaFromBin(lsWrapper);
                return true;
            }
            if (recLsa.lsType() == OspfLsaType.NETWORK.value() && this.isLinkStateMatchesOwnRouterId(recLsa.linkStateId())) {
                if (((OspfInterfaceImpl)this.ospfInterface).state() == OspfInterfaceState.DR) {
                    if (recLsa.advertisingRouter().equals((Object)this.ospfArea.routerId())) return true;
                }
                if (lsWrapper != null) {
                    ((LsaWrapperImpl)lsWrapper).lsaHeader().setAge(3600);
                    this.ospfArea.addLsaToMaxAgeBin(((OspfAreaImpl)this.ospfArea).getLsaKey(((LsaWrapperImpl)lsWrapper).lsaHeader()), lsWrapper);
                    this.ospfArea.removeLsaFromBin(lsWrapper);
                    return true;
                }
                recLsa.setAge(3600);
                ((OspfAreaImpl)this.ospfArea).addToOtherNeighborLsaTxList(recLsa);
                return true;
            }
            if (recLsa.age() == 3600) {
                ((OspfInterfaceImpl)this.ospfInterface).addLsaHeaderForDelayAck(recLsa);
                if (lsWrapper != null) {
                    lsWrapper.setLsaAgeReceived(3600);
                    this.ospfArea.addLsaToMaxAgeBin(((OspfAreaImpl)this.ospfArea).getLsaKey(((LsaWrapperImpl)lsWrapper).lsaHeader()), lsWrapper);
                    this.ospfArea.removeLsaFromBin(lsWrapper);
                    return true;
                }
                ((OspfAreaImpl)this.ospfArea).addToOtherNeighborLsaTxList(recLsa);
                return true;
            }
            this.ospfArea.addLsa((OspfLsa)recLsa, this.ospfInterface);
            log.debug("Inside addLsaMethod");
            this.topologyForDeviceAndLink.addLocalDevice((OspfLsa)recLsa, this.ospfInterface, this.ospfArea);
            this.callDeviceAndLinkAdding(this.topologyForDeviceAndLink);
            log.debug("Adding to lsdb interface State {}", (Object)((OspfInterfaceImpl)this.ospfInterface).state().value());
            if (((OspfInterfaceImpl)this.ospfInterface).state().value() == OspfInterfaceState.BDR.value()) {
                if (this.neighborDr.equals((Object)sourceIp)) {
                    log.debug("Adding for delayed ack {}", (Object)recLsa);
                    ((OspfInterfaceImpl)this.ospfInterface).addLsaHeaderForDelayAck(recLsa);
                }
            } else {
                log.debug("Adding for delayed ack {}", (Object)recLsa);
                ((OspfInterfaceImpl)this.ospfInterface).addLsaHeaderForDelayAck(recLsa);
            }
            if (((OspfInterfaceImpl)this.ospfInterface).state().value() == OspfInterfaceState.DR.value() || ((OspfInterfaceImpl)this.ospfInterface).state().value() == OspfInterfaceState.POINT2POINT.value()) {
                ((OspfAreaImpl)this.ospfArea).addToOtherNeighborLsaTxList(recLsa);
            }
        }
        if (this.lsReqList.contains(key)) {
            this.badLSReq(ch);
        }
        if (status.equals("same")) {
            if (!this.pendingReTxList.containsKey(key)) {
                this.directAcknowledge(recLsa, ch, sourceIp);
                return true;
            }
            this.pendingReTxList.remove(key);
            if (((OspfInterfaceImpl)this.ospfInterface).state().value() == OspfInterfaceState.BDR.value() && this.neighborDr.equals((Object)recLsa.advertisingRouter())) {
                ((OspfInterfaceImpl)this.ospfInterface).addLsaHeaderForDelayAck(recLsa);
            }
        } else if (status.equals("old")) {
            if (recLsa.lsSequenceNo() == Integer.MAX_VALUE && recLsa.age() == 3600) {
                return true;
            }
            int diff = Math.abs(lsWrapper.lsaAgeReceived() - recLsa.age());
            if (diff > 1) {
                this.sendLsa(((LsaWrapperImpl)lsWrapper).lsaHeader(), sourceIp, ch);
            }
        }
        this.callDeviceAndLinkAdding(this.topologyForDeviceAndLink);
        return true;
    }

    private boolean isLinkStateMatchesOwnRouterId(String linkStateId) {
        boolean isLinkStateMatches = false;
        List interfaceLst = this.ospfArea.getInterfacesLst();
        for (OspfInterface ospfInterface : interfaceLst) {
            if (!ospfInterface.ipAddress().toString().equals(linkStateId)) continue;
            isLinkStateMatches = true;
            break;
        }
        return isLinkStateMatches;
    }

    public String isNullorLatest(LsaWrapper lsWrapper, LsaHeader recLsa) {
        if (lsWrapper != null) {
            LsaHeader ownLsa = (LsaHeader)lsWrapper.ospfLsa();
            String status = this.ospfArea.isNewerOrSameLsa((OspfLsa)recLsa, (OspfLsa)ownLsa);
            if (status.equals("latest")) {
                return "isNullorLatest";
            }
            return status;
        }
        return "isNullorLatest";
    }

    public void processSelfOriginatedLsa() throws Exception {
        this.ospfArea.refreshArea(this.ospfInterface);
    }

    public void sendLsa(LsaHeader lsa, Ip4Address destination, Channel ch) {
        if (lsa == null) {
            return;
        }
        LsUpdate responseLsUpdate = new LsUpdate();
        responseLsUpdate.setOspfVer(2);
        responseLsUpdate.setOspftype(OspfPacketType.LSUPDATE.value());
        responseLsUpdate.setRouterId(this.ospfArea.routerId());
        responseLsUpdate.setAreaId(this.ospfArea.areaId());
        responseLsUpdate.setAuthType(0);
        responseLsUpdate.setAuthentication(0);
        responseLsUpdate.setOspfPacLength(0);
        responseLsUpdate.setChecksum(0);
        responseLsUpdate.setNumberOfLsa(1);
        responseLsUpdate.addLsa((OspfLsa)lsa);
        responseLsUpdate.setDestinationIp(destination);
        ch.write((Object)responseLsUpdate);
    }

    public void directAcknowledge(LsaHeader ackLsa, Channel ch, Ip4Address sourceIp) {
        log.debug("OSPFNbr::directAcknowledge...!!!");
        LsAcknowledge ackContent = new LsAcknowledge();
        ackContent.setOspfVer(2);
        ackContent.setOspftype(OspfPacketType.LSAACK.value());
        ackContent.setRouterId(this.ospfArea.routerId());
        ackContent.setAreaId(this.ospfArea.areaId());
        ackContent.setAuthType(0);
        ackContent.setAuthentication(0);
        ackContent.setOspfPacLength(0);
        ackContent.setChecksum(0);
        ackContent.addLinkStateHeader(ackLsa);
        ackContent.setDestinationIp(sourceIp);
        ch.write((Object)ackContent);
    }

    public void neighborDown() throws Exception {
        log.debug("Neighbor Down {} and NeighborId {}", (Object)this.neighborIpAddr, (Object)this.neighborId);
        this.stopInactivityTimeCheck();
        this.stopRxMtDdTimer();
        this.stopRxMtLsrTimer();
        if (this.floodingTimerScheduled) {
            this.stopFloodingTimer();
            this.floodingTimerScheduled = false;
        }
        this.state = OspfNeighborState.DOWN;
        this.ospfArea.refreshArea(this.ospfInterface);
        this.lsReqList.clear();
        this.ddSummaryList.clear();
        if (this.neighborIpAddr.equals((Object)this.neighborBdr) || this.neighborIpAddr.equals((Object)this.neighborDr)) {
            this.handler.neighborChange();
        }
        log.debug("Neighbor Went Down : " + this.neighborIpAddr + " , " + this.neighborId);
        this.removeDeviceDetails(this.neighborId);
        OspfRouterImpl ospfRouter = new OspfRouterImpl();
        ospfRouter.setRouterIp(this.neighborId());
        ospfRouter.setInterfaceId(this.ospfInterface.ipAddress());
        ospfRouter.setAreaIdOfInterface(this.ospfArea.areaId());
        ospfRouter.setDeviceTed(new OspfDeviceTedImpl());
        this.handler.removeDeviceInformation(ospfRouter);
        this.removeDeviceDetails(this.neighborIpAddr);
        OspfRouterImpl ospfRouter1 = new OspfRouterImpl();
        ospfRouter1.setRouterIp(this.neighborIpAddr);
        ospfRouter1.setInterfaceId(this.ospfInterface.ipAddress());
        ospfRouter1.setAreaIdOfInterface(this.ospfArea.areaId());
        ospfRouter1.setDeviceTed(new OspfDeviceTedImpl());
        this.handler.removeDeviceInformation(ospfRouter1);
        this.handler.removeLinkInformation(this);
        this.callDeviceAndLinkAdding(this.topologyForDeviceAndLink);
    }

    private void removeDeviceDetails(Ip4Address routerId) {
        String key = "device:" + routerId;
        this.topologyForDeviceAndLink.removeDeviceInformationMap(key);
        this.topologyForDeviceAndLink.removeLinks(routerId);
    }

    private void startInactivityTimeCheck() {
        if (!this.inActivityTimerScheduled) {
            log.debug("OSPFNbr::startInactivityTimeCheck");
            this.inActivityTimeCheckTask = new InternalInactivityTimeCheck();
            this.exServiceInActivity = Executors.newSingleThreadScheduledExecutor();
            this.exServiceInActivity.scheduleAtFixedRate(this.inActivityTimeCheckTask, this.routerDeadInterval, this.routerDeadInterval, TimeUnit.SECONDS);
            this.inActivityTimerScheduled = true;
        }
    }

    private void stopInactivityTimeCheck() {
        if (this.inActivityTimerScheduled) {
            log.debug("OSPFNbr::stopInactivityTimeCheck ");
            this.exServiceInActivity.shutdown();
            this.inActivityTimerScheduled = false;
        }
    }

    public void startFloodingTimer(Channel channel) {
        if (!this.floodingTimerScheduled) {
            log.debug("OSPFNbr::startFloodingTimer");
            this.floodingTask = new InternalFloodingTask(channel);
            this.exServiceFlooding = Executors.newSingleThreadScheduledExecutor();
            this.exServiceFlooding.scheduleAtFixedRate(this.floodingTask, 0L, 5L, TimeUnit.SECONDS);
            this.floodingTimerScheduled = true;
        }
    }

    private void stopFloodingTimer() {
        if (this.floodingTimerScheduled) {
            log.debug("OSPFNbr::stopFloodingTimer ");
            this.exServiceFlooding.shutdown();
            this.floodingTimerScheduled = false;
        }
    }

    private void startRxMtDdTimer(Channel ch) {
        if (!this.rxmtDdPacketTimerScheduled) {
            long retransmitInterval = this.ospfInterface.reTransmitInterval();
            this.rxmtDdPacketTask = new InternalRxmtDdPacket(ch);
            this.exServiceRxmtDDPacket = Executors.newSingleThreadScheduledExecutor();
            this.exServiceRxmtDDPacket.scheduleAtFixedRate(this.rxmtDdPacketTask, retransmitInterval, retransmitInterval, TimeUnit.SECONDS);
            this.rxmtDdPacketTimerScheduled = true;
        }
    }

    private void stopRxMtDdTimer() {
        if (this.rxmtDdPacketTimerScheduled) {
            this.exServiceRxmtDDPacket.shutdown();
            this.rxmtDdPacketTimerScheduled = false;
        }
    }

    private void startRxMtLsrTimer(Channel ch) {
        if (!this.rxmtLsrTimerScheduled) {
            log.debug("OSPFNbr::startRxMtLsrTimer...!!!");
            long retransmitIntrvl = this.ospfInterface.reTransmitInterval();
            this.rxmtLsrPacketTask = new InternalRxmtLsrPacket(ch);
            this.exServiceRxmtLsr = Executors.newSingleThreadScheduledExecutor();
            this.exServiceRxmtLsr.scheduleAtFixedRate(this.rxmtLsrPacketTask, retransmitIntrvl, retransmitIntrvl, TimeUnit.SECONDS);
            this.rxmtLsrTimerScheduled = true;
        }
    }

    private void stopRxMtLsrTimer() {
        if (this.rxmtLsrTimerScheduled) {
            this.exServiceRxmtLsr.shutdown();
            this.rxmtLsrTimerScheduled = false;
        }
    }

    public DdPacket lastDdPacket() {
        return this.lastDdPacket;
    }

    public void setLastDdPacket(DdPacket lastDdPacket) {
        this.lastDdPacket = lastDdPacket;
    }

    public Ip4Address neighborId() {
        return this.neighborId;
    }

    public void setNeighborId(Ip4Address neighborId) {
        this.neighborId = neighborId;
    }

    public Ip4Address neighborDr() {
        return this.neighborDr;
    }

    public void setNeighborDr(Ip4Address neighborDr) {
        this.neighborDr = neighborDr;
    }

    public Ip4Address neighborBdr() {
        return this.neighborBdr;
    }

    public void setNeighborBdr(Ip4Address neighborBdr) {
        this.neighborBdr = neighborBdr;
    }

    public int routerPriority() {
        return this.routerPriority;
    }

    public void setRouterPriority(int routerPriority) {
        this.routerPriority = routerPriority;
    }

    public int options() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public long ddSeqNum() {
        return this.ddSeqNum;
    }

    public void setDdSeqNum(long ddSeqNum) {
        this.ddSeqNum = ddSeqNum;
    }

    public int isMaster() {
        return this.isMaster;
    }

    public DdPacket lastSentDdPacket() {
        return this.lastSentDdPacket;
    }

    public void setLastSentDdPacket(DdPacket lastSentDdPacket) {
        this.lastSentDdPacket = lastSentDdPacket;
    }

    public LsRequest getLastSentLsrPacket() {
        return this.lastSentLsrPacket;
    }

    public void setLastSentLsrPacket(LsRequest lastSentLsrPacket) {
        this.lastSentLsrPacket = lastSentLsrPacket;
    }

    public OspfNeighborState getState() {
        return this.state;
    }

    public void setState(OspfNeighborState state) {
        this.state = state;
    }

    public void setIsMaster(int isMaster) {
        this.isMaster = isMaster;
    }

    public Hashtable getLsReqList() {
        return this.lsReqList;
    }

    public Map getReTxList() {
        return this.reTxList;
    }

    public Map<String, OspfLsa> getPendingReTxList() {
        return this.pendingReTxList;
    }

    private class InternalFloodingTask
    implements Runnable {
        Channel channel;

        InternalFloodingTask(Channel ch) {
            this.channel = ch;
        }

        @Override
        public void run() {
            if (this.channel != null && this.channel.isConnected()) {
                List lsUpdateList;
                if (OspfNbrImpl.this.pendingReTxList != null && OspfNbrImpl.this.pendingReTxList.size() > 0) {
                    lsUpdateList = this.buildLsUpdate(OspfNbrImpl.this.pendingReTxList);
                    for (LsUpdate lsupdate : lsUpdateList) {
                        lsupdate.setDestinationIp(OspfNbrImpl.this.neighborIpAddr);
                        this.channel.write((Object)lsupdate);
                    }
                }
                if (OspfNbrImpl.this.reTxList != null && OspfNbrImpl.this.reTxList.size() > 0) {
                    lsUpdateList = this.buildLsUpdate(OspfNbrImpl.this.reTxList);
                    for (LsUpdate lsupdate : lsUpdateList) {
                        if (((OspfInterfaceImpl)OspfNbrImpl.this.ospfInterface).state() == OspfInterfaceState.DR || ((OspfInterfaceImpl)OspfNbrImpl.this.ospfInterface).state() == OspfInterfaceState.POINT2POINT) {
                            lsupdate.setDestinationIp(OspfUtil.ALL_SPF_ROUTERS);
                        } else if (((OspfInterfaceImpl)OspfNbrImpl.this.ospfInterface).state() == OspfInterfaceState.DROTHER || ((OspfInterfaceImpl)OspfNbrImpl.this.ospfInterface).state() == OspfInterfaceState.BDR) {
                            lsupdate.setDestinationIp(OspfNbrImpl.this.neighborDr);
                        }
                        this.channel.write((Object)lsupdate);
                    }
                }
            }
        }

        private List buildLsUpdate(Map<String, OspfLsa> txList) {
            ArrayList<LsUpdate> lsUpdateList = new ArrayList<LsUpdate>();
            ListIterator<String> itr = new ArrayList<String>(txList.keySet()).listIterator();
            while (itr.hasNext()) {
                LsUpdate lsupdate = new LsUpdate();
                lsupdate.setOspfVer(2);
                lsupdate.setOspftype(OspfPacketType.LSUPDATE.value());
                lsupdate.setRouterId(OspfNbrImpl.this.ospfArea.routerId());
                lsupdate.setAreaId(OspfNbrImpl.this.ospfArea.areaId());
                lsupdate.setAuthType(0);
                lsupdate.setAuthentication(0);
                lsupdate.setOspfPacLength(0);
                lsupdate.setChecksum(0);
                int currentLength = 28;
                int maxSize = OspfNbrImpl.this.ospfInterface.mtu() - 20;
                int noLsa = 0;
                while (itr.hasNext()) {
                    String key = itr.next();
                    OspfLsa lsa = txList.get(key);
                    if (lsa.age() + 1 >= 3600) {
                        ((LsaHeader)lsa.lsaHeader()).setAge(3600);
                    } else {
                        ((LsaHeader)lsa.lsaHeader()).setAge(lsa.age() + 1);
                    }
                    if (currentLength + ((LsaHeader)lsa.lsaHeader()).lsPacketLen() >= maxSize) {
                        itr.previous();
                        break;
                    }
                    log.debug("FloodingTimer::LSA Type::{}, Header: {}, LSA: {}", new Object[]{lsa.getOspfLsaType(), lsa.lsaHeader(), lsa});
                    if (lsa != null) {
                        lsupdate.addLsa(lsa);
                        ++noLsa;
                        currentLength += ((LsaHeader)lsa.lsaHeader()).lsPacketLen();
                    }
                    log.debug("FloodingTimer::Removing key {}", (Object)key);
                    if (!txList.equals(OspfNbrImpl.this.reTxList)) continue;
                    OspfNbrImpl.this.reTxList.remove(key);
                    OspfNbrImpl.this.pendingReTxList.put(key, lsa);
                }
                lsupdate.setNumberOfLsa(noLsa);
                lsUpdateList.add(lsupdate);
            }
            return lsUpdateList;
        }
    }

    private class InternalRxmtLsrPacket
    implements Runnable {
        Channel ch;

        InternalRxmtLsrPacket(Channel ch) {
            this.ch = ch;
        }

        @Override
        public void run() {
            if (this.ch != null && this.ch.isConnected()) {
                LsRequest lsrPacket = OspfNbrImpl.this.getLastSentLsrPacket();
                this.ch.write((Object)lsrPacket);
                log.debug("Re-Transmit LSRequest Packet .");
            } else {
                log.debug("Re-Transmit LSRequest failed. Channel not connected..");
            }
        }
    }

    private class InternalRxmtDdPacket
    implements Runnable {
        Channel ch;

        InternalRxmtDdPacket(Channel ch) {
            this.ch = ch;
        }

        @Override
        public void run() {
            if (this.ch != null && this.ch.isConnected()) {
                DdPacket ddPacket = OspfNbrImpl.this.lastSentDdPacket();
                this.ch.write((Object)ddPacket);
                log.debug("Re-Transmit DD Packet .");
            } else {
                log.debug("Re-Transmit DD Packet failed. Channel not connected..");
            }
        }
    }

    private class InternalInactivityTimeCheck
    implements Runnable {
        InternalInactivityTimeCheck() {
        }

        @Override
        public void run() {
            try {
                log.debug("Neighbor Not Heard till the past router dead interval .");
                OspfNbrImpl.this.neighborDown();
            }
            catch (Exception e) {
                log.debug("Exception at inactivity time check...!!!");
            }
        }
    }
}

