/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller.impl;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.onosproject.ospf.controller.OspfArea;
import org.onosproject.ospf.controller.OspfInterface;
import org.onosproject.ospf.controller.impl.Controller;
import org.onosproject.ospf.controller.impl.OspfInterfaceChannelHandler;
import org.onosproject.ospf.controller.impl.OspfMessageDecoder;
import org.onosproject.ospf.controller.impl.OspfMessageEncoder;

public class OspfPipelineFactory
implements ChannelPipelineFactory,
ExternalResourceReleasable {
    private static final Timer TIMER = new HashedWheelTimer();
    private Controller controller;
    private ReadTimeoutHandler readTimeoutHandler;
    private OspfArea ospfArea;
    private OspfInterface ospfInterface;
    private int holdTime = 120000;

    public OspfPipelineFactory(Controller controller, OspfArea ospfArea, OspfInterface ospfInterface) {
        this.controller = controller;
        this.ospfArea = ospfArea;
        this.ospfInterface = ospfInterface;
        this.readTimeoutHandler = new ReadTimeoutHandler(TIMER, this.holdTime);
    }

    public ChannelPipeline getPipeline() throws Exception {
        OspfInterfaceChannelHandler interfaceHandler = new OspfInterfaceChannelHandler(this.controller, this.ospfArea, this.ospfInterface);
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("encoder", (ChannelHandler)new OspfMessageEncoder(this.ospfInterface));
        pipeline.addLast("decoder", (ChannelHandler)new OspfMessageDecoder());
        pipeline.addLast("holdTime", (ChannelHandler)this.readTimeoutHandler);
        pipeline.addLast("interfacehandler", (ChannelHandler)interfaceHandler);
        return pipeline;
    }

    public void releaseExternalResources() {
        TIMER.stop();
    }
}

